/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMemberStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stub.JavaStubImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiMethodImpl
extends JavaStubPsiElement<PsiMethodStub>
implements PsiMethod,
Queryable {
    private SoftReference<PsiType> myCachedType;

    public PsiMethodImpl(PsiMethodStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.METHOD);
    }

    protected PsiMethodImpl(PsiMethodStub stub, IStubElementType type2) {
        super(stub, type2);
    }

    public PsiMethodImpl(ASTNode node) {
        super(node);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.dropCached();
    }

    protected void dropCached() {
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiMethodImpl clone = (PsiMethodImpl)((Object)super.clone());
        clone.dropCached();
        return clone;
    }

    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, PsiSyntheticClass.class);
    }

    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    public PsiIdentifier getNameIdentifier() {
        return (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(this);
        if (psiMethodArray == null) {
            PsiMethodImpl.$$$reportNull$$$0(0);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
        if (psiMethodArray == null) {
            PsiMethodImpl.$$$reportNull$$$0(1);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
        if (psiMethodArray == null) {
            PsiMethodImpl.$$$reportNull$$$0(2);
        }
        return psiMethodArray;
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List<MethodSignatureBackedByPsiMethod> list = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic(this, checkAccess);
        if (list == null) {
            PsiMethodImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod(this);
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findDeepestSuperMethods(this);
        if (psiMethodArray == null) {
            PsiMethodImpl.$$$reportNull$$$0(4);
        }
        return psiMethodArray;
    }

    @NotNull
    public String getName() {
        PsiIdentifier nameIdentifier;
        PsiMethodStub stub = (PsiMethodStub)this.getGreenStub();
        String name2 = stub != null ? stub.getName() : ((nameIdentifier = this.getNameIdentifier()) == null ? null : nameIdentifier.getText());
        String string = name2 != null ? name2 : "<unnamed>";
        if (string == null) {
            PsiMethodImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(this);
        if (hierarchicalMethodSignature == null) {
            PsiMethodImpl.$$$reportNull$$$0(6);
        }
        return hierarchicalMethodSignature;
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        PsiIdentifier identifier;
        if (name2 == null) {
            PsiMethodImpl.$$$reportNull$$$0(7);
        }
        if ((identifier = this.getNameIdentifier()) == null) {
            throw new IncorrectOperationException("Empty name: " + (Object)((Object)this));
        }
        PsiImplUtil.setName((PsiElement)identifier, name2);
        return this;
    }

    public PsiTypeElement getReturnTypeElement() {
        if (this.isConstructor()) {
            return null;
        }
        return (PsiTypeElement)this.getNode().findChildByRoleAsPsiElement(10);
    }

    public PsiTypeParameterList getTypeParameterList() {
        return (PsiTypeParameterList)this.getRequiredStubOrPsiChild((IStubElementType)JavaStubElementTypes.TYPE_PARAMETER_LIST);
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
        if (psiTypeParameterArray == null) {
            PsiMethodImpl.$$$reportNull$$$0(8);
        }
        return psiTypeParameterArray;
    }

    public PsiType getReturnType() {
        if (this.isConstructor()) {
            return null;
        }
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            PsiType type2 = (PsiType)SoftReference.dereference(this.myCachedType);
            if (type2 == null) {
                String typeText = TypeInfo.createTypeText(stub.getReturnTypeText(false));
                assert (typeText != null) : stub;
                type2 = JavaPsiFacade.getInstance((Project)this.getProject()).getParserFacade().createTypeFromText(typeText, (PsiElement)this);
                type2 = JavaSharedImplUtil.applyAnnotations(type2, this.getModifierList());
                this.myCachedType = new SoftReference((Object)type2);
            }
            return type2;
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getReturnTypeElement();
        return typeElement != null ? JavaSharedImplUtil.getType(typeElement, (PsiElement)this.getParameterList()) : null;
    }

    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = (PsiModifierList)this.getRequiredStubOrPsiChild((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
        if (psiModifierList == null) {
            PsiMethodImpl.$$$reportNull$$$0(9);
        }
        return psiModifierList;
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            PsiMethodImpl.$$$reportNull$$$0(10);
        }
        return this.getModifierList().hasModifierProperty(name2);
    }

    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = (PsiParameterList)this.getRequiredStubOrPsiChild((IStubElementType)JavaStubElementTypes.PARAMETER_LIST);
        if (psiParameterList == null) {
            PsiMethodImpl.$$$reportNull$$$0(11);
        }
        return psiParameterList;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList child = (PsiReferenceList)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.THROWS_LIST);
        if (child != null) {
            PsiReferenceList psiReferenceList = child;
            if (psiReferenceList == null) {
                PsiMethodImpl.$$$reportNull$$$0(12);
            }
            return psiReferenceList;
        }
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        Stream<String> children = stub != null ? stub.getChildrenStubs().stream().map(s -> s.getClass().getSimpleName() + " : " + s.getStubType()) : Stream.of(this.getChildren()).map(e -> e.getClass().getSimpleName() + " : " + e.getNode().getElementType());
        throw new AssertionError((Object)("Missing throws list, file=" + this.getContainingFile() + " children:\n" + children.collect(Collectors.joining("\n"))));
    }

    public PsiCodeBlock getBody() {
        return (PsiCodeBlock)this.getNode().findChildByRoleAsPsiElement(17);
    }

    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            PsiMethodImpl.$$$reportNull$$$0(13);
        }
        return compositeElement;
    }

    public boolean isDeprecated() {
        return JavaStubImplUtil.isMemberDeprecated(this, (PsiMemberStub)this.getGreenStub());
    }

    public PsiDocComment getDocComment() {
        PsiMethodStub stub = (PsiMethodStub)this.getGreenStub();
        if (stub != null && !stub.hasDocComment()) {
            return null;
        }
        return (PsiDocComment)this.getNode().findChildByRoleAsPsiElement(7);
    }

    public boolean isConstructor() {
        PsiMethodStub stub = (PsiMethodStub)this.getGreenStub();
        if (stub != null) {
            return stub.isConstructor();
        }
        return this.getNode().findChildByRole(10) == null;
    }

    public boolean isVarArgs() {
        PsiMethodStub stub = (PsiMethodStub)this.getGreenStub();
        if (stub != null) {
            return stub.isVarArgs();
        }
        return PsiImplUtil.isVarArgs(this);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiMethodImpl.$$$reportNull$$$0(14);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethod((PsiMethod)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiMethod:" + this.getName();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiMethodImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            PsiMethodImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            PsiMethodImpl.$$$reportNull$$$0(17);
        }
        return PsiImplUtil.processDeclarationsInMethod(this, processor, state, lastParent, place);
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            PsiMethodImpl.$$$reportNull$$$0(18);
        }
        if (substitutor == PsiSubstitutor.EMPTY) {
            MethodSignature methodSignature = (MethodSignature)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
                MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                return CachedValueProvider.Result.create((Object)signature, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            });
            if (methodSignature == null) {
                PsiMethodImpl.$$$reportNull$$$0(19);
            }
            return methodSignature;
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor);
        if (methodSignatureBackedByPsiMethod == null) {
            PsiMethodImpl.$$$reportNull$$$0(20);
        }
        return methodSignatureBackedByPsiMethod;
    }

    public PsiElement getOriginalElement() {
        PsiMethod originalMethod;
        PsiElement original;
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null && (original = containingClass.getOriginalElement()) != containingClass && (originalMethod = ((PsiClass)original).findMethodBySignature((PsiMethod)this, false)) != null) {
            return originalMethod;
        }
        return this;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, methodIcon, ElementPresentationUtil.getFlags((PsiModifierListOwner)this, false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = (SearchScope)ReadAction.compute(() -> PsiImplUtil.getMemberUseScope((PsiMember)this));
        if (searchScope == null) {
            PsiMethodImpl.$$$reportNull$$$0(21);
        }
        return searchScope;
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            PsiMethodImpl.$$$reportNull$$$0(22);
        }
        info.put("methodName", this.getName());
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiMethodImpl";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperMethods";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperMethodSignaturesIncludingStatic";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeepestSuperMethods";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchicalMethodSignature";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiMethodImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowsList";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

