/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.HashSetQueue;
import com.intellij.util.containers.Predicate;
import gnu.trove.THashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

class LazyConcurrentCollection<T, V>
implements Iterable<V> {
    private final HashSetQueue<T> subClasses;
    private final Object lock;
    @NotNull
    private final Function<? super T, ? extends V> myAnchorToValueConvertor;
    @NotNull
    private final MoreElementsGenerator<? extends T, ? super V> myGenerator;
    @NotNull
    private final Predicate<? super V> myApplicableForGenerationFilter;
    private final Semaphore currentlyProcessingClasses;
    private final HashSetQueue.PositionalIterator<T> candidatesToFindSubclassesIterator;
    private final Set<T> classesBeingProcessed;
    private final Set<T> classesProcessed;

    LazyConcurrentCollection(@NotNull T seedElement, @NotNull Function<? super T, ? extends V> convertor, @NotNull Predicate<? super V> applicableForGenerationFilter, @NotNull MoreElementsGenerator<? extends T, ? super V> generator) {
        if (seedElement == null) {
            LazyConcurrentCollection.$$$reportNull$$$0(0);
        }
        if (convertor == null) {
            LazyConcurrentCollection.$$$reportNull$$$0(1);
        }
        if (applicableForGenerationFilter == null) {
            LazyConcurrentCollection.$$$reportNull$$$0(2);
        }
        if (generator == null) {
            LazyConcurrentCollection.$$$reportNull$$$0(3);
        }
        this.lock = new Object();
        this.currentlyProcessingClasses = new Semaphore();
        this.classesBeingProcessed = new THashSet();
        this.classesProcessed = new THashSet();
        this.subClasses = new HashSetQueue();
        this.subClasses.add(seedElement);
        this.myAnchorToValueConvertor = convertor;
        this.myGenerator = generator;
        this.myApplicableForGenerationFilter = applicableForGenerationFilter;
        this.candidatesToFindSubclassesIterator = this.subClasses.iterator();
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        Iterator iterator = new Iterator<V>(){
            private final Iterator<T> subClassIterator;
            {
                this.subClassIterator = LazyConcurrentCollection.this.subClasses.iterator();
                Object object = LazyConcurrentCollection.this.lock;
                synchronized (object) {
                    this.subClassIterator.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                Object object = LazyConcurrentCollection.this.lock;
                synchronized (object) {
                    if (this.subClassIterator.hasNext()) {
                        return true;
                    }
                }
                LazyConcurrentCollection.this.processMoreSubclasses(this.subClassIterator);
                object = LazyConcurrentCollection.this.lock;
                synchronized (object) {
                    return this.subClassIterator.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V next() {
                Object next;
                Object object = LazyConcurrentCollection.this.lock;
                synchronized (object) {
                    next = this.subClassIterator.next();
                }
                return LazyConcurrentCollection.this.myAnchorToValueConvertor.fun(next);
            }
        };
        if (iterator == null) {
            LazyConcurrentCollection.$$$reportNull$$$0(4);
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMoreSubclasses(@NotNull Iterator<T> subClassIterator) {
        if (subClassIterator == null) {
            LazyConcurrentCollection.$$$reportNull$$$0(5);
        }
        while (true) {
            ProgressManager.checkCanceled();
            Pair.NonNull pair2 = (Pair.NonNull)ReadAction.compute(() -> {
                ProgressManager.checkCanceled();
                Object object = this.lock;
                synchronized (object) {
                    Pair.NonNull<T, V> next;
                    HashSetQueue.PositionalIterator.IteratorPosition startPosition = this.candidatesToFindSubclassesIterator.position().next();
                    Pair.NonNull<T, V> nonNull = next = startPosition == null ? null : this.findNextClassInQueue(startPosition);
                    if (next != null) {
                        this.currentlyProcessingClasses.down();
                        this.classesBeingProcessed.add(next.getFirst());
                    }
                    return next;
                }
            });
            if (pair2 == null) {
                Object object = this.lock;
                synchronized (object) {
                    this.advanceIteratorOnSuccess();
                    if (subClassIterator.hasNext()) {
                        return;
                    }
                }
                boolean producedSomething = this.waitForOtherThreadsToFinishProcessing(subClassIterator);
                if (producedSomething) {
                    return;
                }
                Object object2 = this.lock;
                synchronized (object2) {
                    this.advanceIteratorOnSuccess();
                    if (!this.candidatesToFindSubclassesIterator.hasNext()) {
                        return;
                    }
                }
            }
            Object candidate = pair2.getSecond();
            Object anchor = pair2.getFirst();
            try {
                this.myGenerator.generateMoreElementsFor(candidate, generatedElement -> {
                    ProgressManager.checkCanceled();
                    Object object = this.lock;
                    synchronized (object) {
                        this.subClasses.add(generatedElement);
                    }
                });
                Object object = this.lock;
                synchronized (object) {
                    block29: {
                        this.classesProcessed.add(anchor);
                        this.advanceIteratorOnSuccess();
                        if (!subClassIterator.hasNext()) break block29;
                        return;
                    }
                    continue;
                }
            }
            finally {
                Object object = this.lock;
                synchronized (object) {
                    this.classesBeingProcessed.remove(anchor);
                    this.currentlyProcessingClasses.up();
                }
                continue;
            }
            break;
        }
    }

    private boolean waitForOtherThreadsToFinishProcessing(final @NotNull Iterator<T> subClassIterator) {
        if (subClassIterator == null) {
            LazyConcurrentCollection.$$$reportNull$$$0(6);
        }
        final AtomicBoolean hasNext = new AtomicBoolean();
        try {
            ForkJoinPool.managedBlock(new ForkJoinPool.ManagedBlocker(){

                @Override
                public boolean block() {
                    while (!LazyConcurrentCollection.this.currentlyProcessingClasses.isUp()) {
                        ProgressManager.checkCanceled();
                        LazyConcurrentCollection.this.currentlyProcessingClasses.waitFor(1L);
                    }
                    return this.isReleasable();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean isReleasable() {
                    Object object = LazyConcurrentCollection.this.lock;
                    synchronized (object) {
                        boolean producedSomething = subClassIterator.hasNext();
                        hasNext.set(producedSomething);
                        return producedSomething || !LazyConcurrentCollection.this.candidatesToFindSubclassesIterator.hasNext() || LazyConcurrentCollection.this.classesBeingProcessed.isEmpty();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return hasNext.get();
    }

    private Pair.NonNull<T, V> findNextClassInQueue(@NotNull HashSetQueue.PositionalIterator.IteratorPosition<? extends T> position) {
        if (position == null) {
            LazyConcurrentCollection.$$$reportNull$$$0(7);
        }
        while (position != null) {
            ProgressManager.checkCanceled();
            Object anchor = position.peek();
            if (!this.classesProcessed.contains(anchor) && !this.classesBeingProcessed.contains(anchor)) {
                boolean isAccepted;
                Object value2 = this.myAnchorToValueConvertor.fun(anchor);
                boolean bl = isAccepted = value2 != null && this.myApplicableForGenerationFilter.apply(value2);
                if (isAccepted) {
                    return Pair.createNonNull((Object)anchor, (Object)value2);
                }
                this.classesProcessed.add(anchor);
            }
            position = position.next();
        }
        return null;
    }

    private void advanceIteratorOnSuccess() {
        while (this.candidatesToFindSubclassesIterator.hasNext()) {
            ProgressManager.checkCanceled();
            Object next = this.candidatesToFindSubclassesIterator.position().next().peek();
            boolean removed = this.classesProcessed.remove(next);
            if (!removed) break;
            this.candidatesToFindSubclassesIterator.next();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seedElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableForGenerationFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/LazyConcurrentCollection";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClassIterator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/LazyConcurrentCollection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processMoreSubclasses";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "waitForOtherThreadsToFinishProcessing";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findNextClassInQueue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    static interface MoreElementsGenerator<T, V> {
        public void generateMoreElementsFor(@NotNull V var1, @NotNull Consumer<? super T> var2);
    }
}

