/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.java.FunExprOccurrence;
import com.intellij.psi.impl.java.JavaFunctionalExpressionIndex;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionKey;
import com.intellij.psi.impl.java.stubs.index.JavaMethodParameterTypesIndex;
import com.intellij.psi.impl.search.ApproximateResolver;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFunctionalExpressionSearcher
extends QueryExecutorBase<PsiFunctionalExpression, FunctionalExpressionSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.JavaFunctionalExpressionSearcher");
    public static final int SMART_SEARCH_THRESHOLD = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQuery(@NotNull FunctionalExpressionSearch.SearchParameters p, @NotNull Processor<? super PsiFunctionalExpression> consumer) {
        if (p == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(1);
        }
        List<SamDescriptor> descriptors = JavaFunctionalExpressionSearcher.calcDescriptors(p);
        Project project = PsiUtilCore.getProjectInReadAction((PsiElement)p.getElementToSearch());
        SearchScope searchScope = (SearchScope)ReadAction.compute(() -> p.getEffectiveSearchScope());
        if (searchScope instanceof GlobalSearchScope && !JavaFunctionalExpressionSearcher.performSearchUsingCompilerIndices(descriptors, (GlobalSearchScope)searchScope, project, consumer)) {
            return;
        }
        AtomicInteger exprCount = new AtomicInteger();
        AtomicInteger fileCount = new AtomicInteger();
        PsiManager manager = (PsiManager)ReadAction.compute(() -> p.getElementToSearch().getManager());
        manager.startBatchFilesProcessingMode();
        try {
            JavaFunctionalExpressionSearcher.processOffsets(descriptors, project, (PairProcessor<? super VirtualFile, ? super Set<FunExprOccurrence>>)((PairProcessor)(file, occurrences) -> {
                fileCount.incrementAndGet();
                exprCount.addAndGet(occurrences.size());
                return JavaFunctionalExpressionSearcher.processFile(consumer, descriptors, file, occurrences);
            }));
        }
        finally {
            manager.finishBatchFilesProcessingMode();
        }
        if (exprCount.get() > 0 && LOG.isDebugEnabled()) {
            LOG.debug("Loaded " + exprCount.get() + " fun-expressions in " + fileCount.get() + " files");
        }
    }

    public static Set<VirtualFile> getFilesToSearchInPsi(@NotNull PsiClass samClass) {
        if (samClass == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(2);
        }
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        JavaFunctionalExpressionSearcher.processOffsets(JavaFunctionalExpressionSearcher.calcDescriptors(new FunctionalExpressionSearch.SearchParameters(samClass, samClass.getUseScope())), samClass.getProject(), (PairProcessor<? super VirtualFile, ? super Set<FunExprOccurrence>>)((PairProcessor)(file, offsets) -> result.add((VirtualFile)file)));
        return result;
    }

    @NotNull
    private static List<SamDescriptor> calcDescriptors(@NotNull FunctionalExpressionSearch.SearchParameters queryParameters) {
        if (queryParameters == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(3);
        }
        ArrayList<SamDescriptor> descriptors = new ArrayList<SamDescriptor>();
        ReadAction.run(() -> {
            PsiClass aClass = queryParameters.getElementToSearch();
            if (!aClass.isValid() || !aClass.isInterface()) {
                return;
            }
            Project project = aClass.getProject();
            if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(aClass.getContainingFile()) || !JavaFunctionalExpressionSearcher.hasJava8Modules(project)) {
                return;
            }
            HashSet visited = new HashSet();
            JavaFunctionalExpressionSearcher.processSubInterfaces(aClass, visited);
            for (PsiClass samClass : visited) {
                PsiMethod saMethod;
                PsiType samType;
                if (!LambdaUtil.isFunctionalClass((PsiClass)samClass) || (samType = (saMethod = (PsiMethod)ObjectUtils.assertNotNull((Object)LambdaUtil.getFunctionalInterfaceMethod((PsiClass)samClass))).getReturnType()) == null) continue;
                SearchScope scope = samClass.getUseScope().intersectWith(queryParameters.getEffectiveSearchScope());
                descriptors.add(new SamDescriptor(samClass, saMethod, samType, GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)scope, (Project)project)));
            }
        });
        ArrayList<SamDescriptor> arrayList = descriptors;
        if (arrayList == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static Set<VirtualFile> getLikelyFiles(@NotNull List<? extends SamDescriptor> descriptors, @NotNull Collection<? extends VirtualFile> candidateFiles, @NotNull Project project) {
        if (descriptors == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(5);
        }
        if (candidateFiles == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(6);
        }
        if (project == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(7);
        }
        GlobalSearchScope candidateFilesScope = GlobalSearchScope.filesScope((Project)project, candidateFiles);
        Set set = JBIterable.from(descriptors).flatMap(descriptor -> ((SamDescriptor)descriptor).getMostLikelyFiles(candidateFilesScope)).toSet();
        if (set == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    private static MultiMap<VirtualFile, FunExprOccurrence> getAllOccurrences(@NotNull List<? extends SamDescriptor> descriptors) {
        if (descriptors == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(9);
        }
        MultiMap result = MultiMap.createLinkedSet();
        descriptors.get((int)0).dumbService.runReadActionInSmartMode(() -> JavaFunctionalExpressionSearcher.processIndexValues(descriptors, null, (FileBasedIndex.ValueProcessor<? super Map<Integer, FunExprOccurrence>>)((FileBasedIndex.ValueProcessor)(file, infos) -> {
            result.putValues((Object)file, infos.values());
            return true;
        })));
        LOG.debug("Found " + result.values().size() + " fun-expressions in " + result.keySet().size() + " files");
        MultiMap multiMap = result;
        if (multiMap == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(10);
        }
        return multiMap;
    }

    private static void processIndexValues(@NotNull List<? extends SamDescriptor> descriptors, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<? super Map<Integer, FunExprOccurrence>> processor) {
        if (descriptors == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(12);
        }
        for (SamDescriptor samDescriptor : descriptors) {
            JavaSourceFilterScope scope = new JavaSourceFilterScope(samDescriptor.effectiveUseScope);
            for (FunctionalExpressionKey key2 : samDescriptor.keys) {
                FileBasedIndex.getInstance().processValues(JavaFunctionalExpressionIndex.INDEX_ID, (Object)key2, inFile, processor, (GlobalSearchScope)scope);
            }
        }
    }

    private static void processOffsets(@NotNull List<? extends SamDescriptor> descriptors, @NotNull Project project, @NotNull PairProcessor<? super VirtualFile, ? super Set<FunExprOccurrence>> processor) {
        if (descriptors == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(13);
        }
        if (project == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(15);
        }
        if (descriptors.isEmpty()) {
            return;
        }
        List samClasses = ContainerUtil.map(descriptors, d -> d.samClass);
        MultiMap<VirtualFile, FunExprOccurrence> allCandidates = JavaFunctionalExpressionSearcher.getAllOccurrences(descriptors);
        if (allCandidates.isEmpty()) {
            return;
        }
        Set allFiles = allCandidates.keySet();
        Set<VirtualFile> filesFirst = JavaFunctionalExpressionSearcher.getLikelyFiles(descriptors, allFiles, project);
        Processor vFileProcessor = vFile -> {
            Set<FunExprOccurrence> toLoad = JavaFunctionalExpressionSearcher.filterInapplicable(samClasses, vFile, allCandidates.get(vFile), project);
            if (!toLoad.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("To load " + vFile.getPath() + " with values: " + toLoad);
                }
                return processor.process(vFile, toLoad);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<VirtualFile>(filesFirst), ProgressIndicatorProvider.getGlobalProgressIndicator(), vFileProcessor)) {
            return;
        }
        allFiles.removeAll(filesFirst);
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(allFiles), ProgressIndicatorProvider.getGlobalProgressIndicator(), vFileProcessor);
    }

    @NotNull
    private static Set<FunExprOccurrence> filterInapplicable(@NotNull List<? extends PsiClass> samClasses, @NotNull VirtualFile vFile, @NotNull Collection<? extends FunExprOccurrence> occurrences, @NotNull Project project) {
        if (samClasses == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(16);
        }
        if (vFile == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(17);
        }
        if (occurrences == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(18);
        }
        if (project == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(19);
        }
        Set set = (Set)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> new HashSet(ContainerUtil.filter((Collection)occurrences, it -> it.canHaveType(samClasses, vFile))));
        if (set == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(20);
        }
        return set;
    }

    private static boolean processFile(@NotNull Processor<? super PsiFunctionalExpression> consumer, @NotNull List<? extends SamDescriptor> descriptors, @NotNull VirtualFile vFile, @NotNull Set<? extends FunExprOccurrence> occurrences) {
        if (consumer == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(21);
        }
        if (descriptors == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(22);
        }
        if (vFile == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(23);
        }
        if (occurrences == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(24);
        }
        return (Boolean)descriptors.get((int)0).dumbService.runReadActionInSmartMode(() -> {
            PsiFile file = ((SamDescriptor)descriptors.get((int)0)).samClass.getManager().findFile(vFile);
            if (!(file instanceof PsiJavaFile)) {
                LOG.error("Non-java file " + file + "; " + vFile);
                return true;
            }
            TIntArrayList offsets = JavaFunctionalExpressionSearcher.getOccurrenceOffsets(descriptors, vFile, occurrences);
            for (int i = 0; i < offsets.size(); ++i) {
                int offset = offsets.get(i);
                PsiFunctionalExpression expression2 = (PsiFunctionalExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiFunctionalExpression.class, (boolean)false);
                if (expression2 == null || expression2.getTextRange().getStartOffset() != offset) {
                    LOG.error("Fun expression not found in " + file + " at " + offset);
                    continue;
                }
                if (!JavaFunctionalExpressionSearcher.hasType(descriptors, expression2) || consumer.process((Object)expression2)) continue;
                return false;
            }
            return true;
        });
    }

    @NotNull
    private static TIntArrayList getOccurrenceOffsets(@NotNull List<? extends SamDescriptor> descriptors, @NotNull VirtualFile vFile, @NotNull Set<? extends FunExprOccurrence> occurrences) {
        if (descriptors == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(25);
        }
        if (vFile == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(26);
        }
        if (occurrences == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(27);
        }
        TIntArrayList offsets = new TIntArrayList();
        JavaFunctionalExpressionSearcher.processIndexValues(descriptors, vFile, (FileBasedIndex.ValueProcessor<? super Map<Integer, FunExprOccurrence>>)((FileBasedIndex.ValueProcessor)(__, infos) -> {
            for (Map.Entry entry : infos.entrySet()) {
                if (!occurrences.contains(entry.getValue())) continue;
                offsets.add(((Integer)entry.getKey()).intValue());
            }
            return true;
        }));
        TIntArrayList tIntArrayList = offsets;
        if (tIntArrayList == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(28);
        }
        return tIntArrayList;
    }

    private static boolean hasType(@NotNull List<? extends SamDescriptor> descriptors, @NotNull PsiFunctionalExpression expression2) {
        if (descriptors == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(29);
        }
        if (expression2 == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(30);
        }
        if (!JavaFunctionalExpressionSearcher.canHaveType(expression2, ContainerUtil.map(descriptors, d -> d.samClass))) {
            return false;
        }
        PsiClass actualClass = LambdaUtil.resolveFunctionalInterfaceClass((PsiFunctionalExpression)expression2);
        return ContainerUtil.exists(descriptors, d -> InheritanceUtil.isInheritorOrSelf((PsiClass)actualClass, (PsiClass)d.samClass, (boolean)true));
    }

    private static boolean canHaveType(@NotNull PsiFunctionalExpression expression2, @NotNull List<? extends PsiClass> samClasses) {
        PsiElement parent;
        if (expression2 == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(31);
        }
        if (samClasses == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(32);
        }
        if ((parent = expression2.getParent()) instanceof PsiExpressionList && parent.getParent() instanceof PsiMethodCallExpression) {
            PsiExpression[] args = ((PsiExpressionList)parent).getExpressions();
            int argIndex = Arrays.asList(args).indexOf(expression2);
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)parent.getParent()).getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            String methodName = methodExpression.getReferenceName();
            if (qualifier != null && methodName != null && argIndex >= 0) {
                Set<PsiClass> approximateTypes = ApproximateResolver.getPossibleTypes(qualifier, 10);
                List<PsiMethod> methods = approximateTypes == null ? null : ApproximateResolver.getPossibleMethods(approximateTypes, methodName, args.length);
                return methods == null || ContainerUtil.exists(methods, m -> FunExprOccurrence.hasCompatibleParameter(m, argIndex, samClasses));
            }
        }
        return true;
    }

    private static boolean hasJava8Modules(@NotNull Project project) {
        if (project == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(33);
        }
        boolean projectLevelIsHigh = PsiUtil.getLanguageLevel((Project)project).isAtLeast(LanguageLevel.JDK_1_8);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            LanguageLevel level;
            LanguageLevelModuleExtension extension = (LanguageLevelModuleExtension)ModuleRootManager.getInstance((Module)module).getModuleExtension(LanguageLevelModuleExtension.class);
            if (extension == null || !((level = extension.getLanguageLevel()) == null ? projectLevelIsHigh : level.isAtLeast(LanguageLevel.JDK_1_8))) continue;
            return true;
        }
        return false;
    }

    private static void processSubInterfaces(@NotNull PsiClass base, @NotNull Set<? super PsiClass> visited) {
        if (base == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(34);
        }
        if (visited == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(35);
        }
        if (!visited.add((PsiClass)base)) {
            return;
        }
        DirectClassInheritorsSearch.search((PsiClass)base).forEach(candidate -> {
            if (candidate.isInterface()) {
                JavaFunctionalExpressionSearcher.processSubInterfaces(candidate, visited);
            }
            return true;
        });
    }

    private static boolean performSearchUsingCompilerIndices(@NotNull List<? extends SamDescriptor> descriptors, @NotNull GlobalSearchScope searchScope, @NotNull Project project, @NotNull Processor<? super PsiFunctionalExpression> consumer) {
        CompilerReferenceService compilerReferenceService;
        if (descriptors == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(36);
        }
        if (searchScope == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(37);
        }
        if (project == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(38);
        }
        if (consumer == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(39);
        }
        if ((compilerReferenceService = CompilerReferenceService.getInstance(project)) == null) {
            return true;
        }
        for (SamDescriptor samDescriptor : descriptors) {
            CompilerDirectHierarchyInfo info = compilerReferenceService.getFunExpressions((PsiNamedElement)samDescriptor.samClass, searchScope, (FileType)JavaFileType.INSTANCE);
            if (info == null || JavaFunctionalExpressionSearcher.processFunctionalExpressions(info, samDescriptor, consumer)) continue;
            return false;
        }
        return true;
    }

    private static boolean processFunctionalExpressions(@NotNull CompilerDirectHierarchyInfo funExprInfo, @NotNull SamDescriptor descriptor, @NotNull Processor<? super PsiFunctionalExpression> consumer) {
        if (funExprInfo == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(40);
        }
        if (descriptor == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(41);
        }
        if (consumer == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(42);
        }
        if (!ContainerUtil.process(funExprInfo.getHierarchyChildren().iterator(), fe -> consumer.process((Object)((PsiFunctionalExpression)fe)))) {
            return false;
        }
        GlobalSearchScope dirtyScope = funExprInfo.getDirtyScope();
        descriptor.effectiveUseScope = descriptor.effectiveUseScope.intersectWith(dirtyScope);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 20: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 20: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: 
            case 21: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 22: 
            case 25: 
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFiles";
                break;
            }
            case 7: 
            case 14: 
            case 19: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samClasses";
                break;
            }
            case 17: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 18: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funExprInfo";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDescriptors";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLikelyFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOccurrences";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "filterInapplicable";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrenceOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processQuery";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToSearchInPsi";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcDescriptors";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 20: 
            case 28: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLikelyFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllOccurrences";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processIndexValues";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processOffsets";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filterInapplicable";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceOffsets";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasType";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "canHaveType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "hasJava8Modules";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processSubInterfaces";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "performSearchUsingCompilerIndices";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processFunctionalExpressions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 20: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SamDescriptor {
        final PsiClass samClass;
        final int samParamCount;
        final boolean booleanCompatible;
        final boolean isVoid;
        final DumbService dumbService;
        final List<FunctionalExpressionKey> keys;
        GlobalSearchScope effectiveUseScope;

        SamDescriptor(@NotNull PsiClass samClass, @NotNull PsiMethod samMethod, @NotNull PsiType samType, @NotNull GlobalSearchScope useScope) {
            if (samClass == null) {
                SamDescriptor.$$$reportNull$$$0(0);
            }
            if (samMethod == null) {
                SamDescriptor.$$$reportNull$$$0(1);
            }
            if (samType == null) {
                SamDescriptor.$$$reportNull$$$0(2);
            }
            if (useScope == null) {
                SamDescriptor.$$$reportNull$$$0(3);
            }
            this.samClass = samClass;
            this.effectiveUseScope = useScope;
            this.samParamCount = samMethod.getParameterList().getParametersCount();
            this.booleanCompatible = FunctionalExpressionKey.isBooleanCompatible(samType);
            this.isVoid = PsiType.VOID.equals((Object)samType);
            this.dumbService = DumbService.getInstance((Project)samClass.getProject());
            this.keys = this.generateKeys();
        }

        @NotNull
        private List<FunctionalExpressionKey> generateKeys() {
            String name2;
            String string = name2 = this.samClass.isValid() ? this.samClass.getName() : null;
            if (name2 == null) {
                List<FunctionalExpressionKey> list = Collections.emptyList();
                if (list == null) {
                    SamDescriptor.$$$reportNull$$$0(4);
                }
                return list;
            }
            ArrayList<FunctionalExpressionKey> result = new ArrayList<FunctionalExpressionKey>();
            for (String lambdaType : new String[]{(String)ObjectUtils.assertNotNull((Object)name2), ""}) {
                for (int lambdaParamCount : new int[]{-1, this.samParamCount}) {
                    result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.UNKNOWN, lambdaType));
                    if (this.isVoid) {
                        result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.VOID, lambdaType));
                        continue;
                    }
                    if (this.booleanCompatible) {
                        result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.BOOLEAN, lambdaType));
                    }
                    result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.NON_VOID, lambdaType));
                }
            }
            ArrayList<FunctionalExpressionKey> arrayList = result;
            if (arrayList == null) {
                SamDescriptor.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        @NotNull
        private Set<VirtualFile> getMostLikelyFiles(@NotNull GlobalSearchScope searchScope) {
            if (searchScope == null) {
                SamDescriptor.$$$reportNull$$$0(6);
            }
            LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
            this.dumbService.runReadActionInSmartMode(() -> {
                if (!this.samClass.isValid()) {
                    return;
                }
                String className2 = this.samClass.getName();
                Project project = this.samClass.getProject();
                if (className2 == null) {
                    return;
                }
                LinkedHashSet likelyNames = ContainerUtil.newLinkedHashSet((Object[])new String[]{className2});
                StubIndex.getInstance().processElements(JavaMethodParameterTypesIndex.getInstance().getKey(), (Object)className2, project, this.effectiveUseScope, PsiMethod.class, method -> {
                    ProgressManager.checkCanceled();
                    likelyNames.add(method.getName());
                    return true;
                });
                PsiSearchHelperImpl helper = (PsiSearchHelperImpl)PsiSearchHelper.getInstance((Project)project);
                Processor processor = Processors.cancelableCollectProcessor((Collection)files);
                for (String word : likelyNames) {
                    helper.processFilesWithText(searchScope, (short)1, true, word, processor);
                }
            });
            LinkedHashSet<VirtualFile> linkedHashSet = files;
            if (linkedHashSet == null) {
                SamDescriptor.$$$reportNull$$$0(7);
            }
            return linkedHashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "samClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "samMethod";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "samType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "useScope";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher$SamDescriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher$SamDescriptor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateKeys";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMostLikelyFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getMostLikelyFiles";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

