/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.impl.search.JavaFilesSearchScope;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

class ConstructorReferencesSearchHelper {
    private final PsiManager myManager;

    ConstructorReferencesSearchHelper(@NotNull PsiManager manager) {
        if (manager == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(0);
        }
        this.myManager = manager;
    }

    boolean processConstructorReferences(@NotNull Processor<? super PsiReference> processor, @NotNull PsiMethod constructor, @NotNull PsiClass containingClass, @NotNull SearchScope searchScope, @NotNull Project project, boolean ignoreAccessScope, boolean isStrictSignatureSearch, @NotNull SearchRequestCollector collector) {
        if (processor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(1);
        }
        if (constructor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(2);
        }
        if (containingClass == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(5);
        }
        if (collector == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(6);
        }
        boolean[] constructorCanBeCalledImplicitly = new boolean[1];
        boolean[] isEnum = new boolean[1];
        boolean[] isUnder18 = new boolean[1];
        DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            PsiParameter[] parameters2 = constructor.getParameterList().getParameters();
            boolean bl = constructorCanBeCalledImplicitly[0] = parameters2.length == 0;
            if (!constructorCanBeCalledImplicitly[0]) {
                constructorCanBeCalledImplicitly[0] = parameters2.length == 1 && parameters2[0].isVarArgs();
            }
            isEnum[0] = containingClass.isEnum();
            isUnder18[0] = PsiUtil.getLanguageLevel((PsiElement)containingClass).isAtLeast(LanguageLevel.JDK_1_8);
            return null;
        });
        if (isEnum[0] && !ConstructorReferencesSearchHelper.processEnumReferences(processor, constructor, project, containingClass)) {
            return false;
        }
        PairProcessor processor1 = (reference, collector1) -> {
            PsiMethod constructor1;
            PsiElement parent = reference.getElement().getParent();
            if (parent instanceof PsiAnonymousClass) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiNewExpression && (constructor1 = ((PsiNewExpression)parent).resolveConstructor()) != null && (isStrictSignatureSearch ? this.myManager.areElementsEquivalent((PsiElement)constructor, (PsiElement)constructor1) : this.myManager.areElementsEquivalent((PsiElement)containingClass, (PsiElement)constructor1.getContainingClass()))) {
                return processor.process(reference);
            }
            return true;
        };
        SearchScope restrictedScope = searchScope instanceof GlobalSearchScope ? ((GlobalSearchScope)searchScope).intersectWith((GlobalSearchScope)new JavaFilesSearchScope(project)) : searchScope;
        ReferencesSearch.searchOptimized((PsiElement)containingClass, (SearchScope)restrictedScope, (boolean)ignoreAccessScope, (SearchRequestCollector)collector, (boolean)true, (PairProcessor)processor1);
        if (isUnder18[0] && !ConstructorReferencesSearchHelper.process18MethodPointers(processor, constructor, project, containingClass, restrictedScope)) {
            return false;
        }
        if (!((Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> this.processSuperOrThis(containingClass, constructor, constructorCanBeCalledImplicitly[0], searchScope, project, isStrictSignatureSearch, "this", "super", processor))).booleanValue()) {
            return false;
        }
        Processor processor2 = inheritor -> {
            PsiElement navigationElement = inheritor.getNavigationElement();
            if (navigationElement instanceof PsiClass) {
                return this.processSuperOrThis((PsiClass)navigationElement, constructor, constructorCanBeCalledImplicitly[0], searchScope, project, isStrictSignatureSearch, "super", "this", processor);
            }
            return true;
        };
        return ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)searchScope, (boolean)false).allowParallelProcessing().forEach(processor2);
    }

    private static boolean processEnumReferences(@NotNull Processor<? super PsiReference> processor, @NotNull PsiMethod constructor, @NotNull Project project, @NotNull PsiClass aClass) {
        if (processor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(7);
        }
        if (constructor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(8);
        }
        if (project == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(9);
        }
        if (aClass == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(10);
        }
        return (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            for (PsiField field : aClass.getFields()) {
                PsiReference reference;
                if (!(field instanceof PsiEnumConstant) || (reference = field.getReference()) == null || !reference.isReferenceTo((PsiElement)constructor) || processor.process((Object)reference)) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean process18MethodPointers(@NotNull Processor<? super PsiReference> processor, @NotNull PsiMethod constructor, @NotNull Project project, @NotNull PsiClass aClass, SearchScope searchScope) {
        if (processor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(11);
        }
        if (constructor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(12);
        }
        if (project == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(13);
        }
        if (aClass == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(14);
        }
        return ReferencesSearch.search((PsiElement)aClass, (SearchScope)searchScope).forEach(reference -> {
            PsiElement element = reference.getElement();
            if (element != null) {
                return (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                    PsiElement parent = element.getParent();
                    if (parent instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)parent).getReferenceNameElement() instanceof PsiKeyword && ((PsiMethodReferenceExpression)parent).isReferenceTo((PsiElement)constructor) && !processor.process((Object)((PsiReference)parent))) {
                        return false;
                    }
                    return true;
                });
            }
            return true;
        });
    }

    private boolean processSuperOrThis(@NotNull PsiClass inheritor, @NotNull PsiMethod constructor, boolean constructorCanBeCalledImplicitly, @NotNull SearchScope searchScope, @NotNull Project project, boolean isStrictSignatureSearch, @NotNull String superOrThisKeyword, @NotNull String thisOrSuperKeyword, @NotNull Processor<? super PsiReference> processor) {
        PsiMethod[] constructors;
        if (inheritor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(15);
        }
        if (constructor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(16);
        }
        if (searchScope == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(17);
        }
        if (project == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(18);
        }
        if (superOrThisKeyword == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(19);
        }
        if (thisOrSuperKeyword == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(21);
        }
        if ((constructors = inheritor.getConstructors()).length == 0 && constructorCanBeCalledImplicitly && !this.processImplicitConstructorCall((PsiMember)inheritor, processor, constructor, project, inheritor)) {
            return false;
        }
        for (PsiMethod method : constructors) {
            PsiReferenceExpression refExpr;
            PsiExpression expr;
            PsiStatement statement;
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null || method == constructor && isStrictSignatureSearch) continue;
            PsiStatement[] statements = body2.getStatements();
            if (statements.length != 0 && (statement = statements[0]) instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statement).getExpression()) instanceof PsiMethodCallExpression && PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)(refExpr = ((PsiMethodCallExpression)expr).getMethodExpression()))) {
                if (refExpr.textMatches((CharSequence)superOrThisKeyword)) {
                    boolean match;
                    PsiElement referencedElement = refExpr.resolve();
                    if (!(referencedElement instanceof PsiMethod)) continue;
                    PsiMethod constructor1 = (PsiMethod)referencedElement;
                    boolean bl = match = isStrictSignatureSearch ? this.myManager.areElementsEquivalent((PsiElement)constructor1, (PsiElement)constructor) : this.myManager.areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)constructor1.getContainingClass());
                    if (!match || processor.process((Object)refExpr)) continue;
                    return false;
                }
                if (refExpr.textMatches((CharSequence)thisOrSuperKeyword)) continue;
            }
            if (!constructorCanBeCalledImplicitly || !PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)method) || this.processImplicitConstructorCall((PsiMember)method, processor, constructor, project, inheritor)) continue;
            return false;
        }
        return true;
    }

    private boolean processImplicitConstructorCall(final @NotNull PsiMember usage, @NotNull Processor<? super PsiReference> processor, @NotNull PsiMethod constructor, @NotNull Project project, @NotNull PsiClass containingClass) {
        if (usage == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(22);
        }
        if (processor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(23);
        }
        if (constructor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(24);
        }
        if (project == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(25);
        }
        if (containingClass == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(26);
        }
        if (containingClass instanceof PsiAnonymousClass) {
            return true;
        }
        PsiClass ctrClass = constructor.getContainingClass();
        if (ctrClass == null) {
            return true;
        }
        boolean isImplicitSuper = (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> this.myManager.areElementsEquivalent((PsiElement)ctrClass, (PsiElement)containingClass.getSuperClass()));
        if (!isImplicitSuper) {
            return true;
        }
        PsiElement resolved = JavaResolveUtil.resolveImaginarySuperCallInThisPlace(usage, project, ctrClass);
        boolean resolvesToThisConstructor = (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> this.myManager.areElementsEquivalent((PsiElement)constructor, resolved));
        if (!resolvesToThisConstructor) {
            return true;
        }
        return processor.process((Object)new LightMemberReference(this.myManager, usage, PsiSubstitutor.EMPTY){

            @Override
            @NotNull
            public PsiElement getElement() {
                PsiMember psiMember = usage;
                if (psiMember == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiMember;
            }

            @Override
            @NotNull
            public TextRange getRangeInElement() {
                PsiElement identifier;
                if (usage instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)usage).getNameIdentifier()) != null) {
                    int startOffsetInParent = identifier.getStartOffsetInParent();
                    if (startOffsetInParent >= 0) {
                        TextRange textRange = TextRange.from((int)startOffsetInParent, (int)identifier.getTextLength());
                        if (textRange == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return textRange;
                    }
                    UnfairTextRange unfairTextRange = new UnfairTextRange(-1, -1);
                    if (unfairTextRange == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return unfairTextRange;
                }
                TextRange textRange = super.getRangeInElement();
                if (textRange == null) {
                    1.$$$reportNull$$$0(3);
                }
                return textRange;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElement";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeInElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 3: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superOrThisKeyword";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisOrSuperKeyword";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processConstructorReferences";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processEnumReferences";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "process18MethodPointers";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "processSuperOrThis";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "processImplicitConstructorCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

