/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleNameIndex
extends StringStubIndexExtension<PsiJavaModule> {
    private static final JavaModuleNameIndex ourInstance = new JavaModuleNameIndex();

    public static JavaModuleNameIndex getInstance() {
        return ourInstance;
    }

    public int getVersion() {
        return super.getVersion() + 2;
    }

    @NotNull
    public StubIndexKey<String, PsiJavaModule> getKey() {
        StubIndexKey<String, PsiJavaModule> stubIndexKey = JavaStubIndexKeys.MODULE_NAMES;
        if (stubIndexKey == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(0);
        }
        return stubIndexKey;
    }

    public Collection<PsiJavaModule> get(@NotNull String name2, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        Collection<PsiJavaModule> modules;
        if (name2 == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(1);
        }
        if (project == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(3);
        }
        if ((modules = StubIndex.getElements(this.getKey(), (Object)name2, (Project)project, (GlobalSearchScope)new JavaSourceFilterScope(scope, true), PsiJavaModule.class)).size() > 1) {
            modules = JavaModuleNameIndex.filterVersions(project, modules);
        }
        return modules;
    }

    private static Collection<PsiJavaModule> filterVersions(Project project, Collection<PsiJavaModule> modules) {
        HashSet<VirtualFile> filter = new HashSet<VirtualFile>();
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
        for (PsiJavaModule module : modules) {
            VirtualFile root = index.getClassRootForFile(module.getContainingFile().getVirtualFile());
            if (root == null) continue;
            List<VirtualFile> files = JavaModuleNameIndex.descriptorFiles(root, false, false);
            VirtualFile main = (VirtualFile)ContainerUtil.getFirstItem(files);
            if (main != null && !root.equals(main.getParent()) && JavaModuleNameIndex.version(main.getParent()) < 9) {
                filter.add(main);
            }
            for (int i = 1; i < files.size(); ++i) {
                filter.add(files.get(i));
            }
        }
        if (!filter.isEmpty()) {
            modules = ContainerUtil.filter(modules, m -> !filter.contains(m.getContainingFile().getVirtualFile()));
        }
        return modules;
    }

    public boolean traceKeyHashToVirtualFileMapping() {
        return true;
    }

    @Nullable
    public static VirtualFile descriptorFile(@NotNull VirtualFile root) {
        VirtualFile result;
        if (root == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(4);
        }
        if ((result = root.findChild("module-info.class")) == null) {
            result = (VirtualFile)ContainerUtil.getFirstItem(JavaModuleNameIndex.descriptorFiles(root, true, true));
        }
        return result;
    }

    private static List<VirtualFile> descriptorFiles(VirtualFile root, boolean checkAttribute, boolean filter) {
        List results = ContainerUtil.newSmartList();
        ContainerUtil.addIfNotNull((Collection)results, (Object)root.findChild("module-info.class"));
        VirtualFile versionsDir = root.findFileByRelativePath("META-INF/versions");
        if (versionsDir != null && (!checkAttribute || JavaModuleNameIndex.isMultiReleaseJar(root))) {
            VirtualFile[] versions = versionsDir.getChildren();
            if (filter) {
                versions = (VirtualFile[])Stream.of(versions).filter(d -> JavaModuleNameIndex.version(d) >= 9).toArray(VirtualFile[]::new);
            }
            Arrays.sort(versions, JavaModuleNameIndex::compareVersions);
            for (VirtualFile version : versions) {
                ContainerUtil.addIfNotNull((Collection)results, (Object)version.findChild("module-info.class"));
            }
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isMultiReleaseJar(VirtualFile root) {
        VirtualFile manifest = root.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifest == null) return false;
        try (InputStream stream = manifest.getInputStream();){
            boolean bl = Boolean.valueOf(new Manifest(stream).getMainAttributes().getValue(new Attributes.Name("Multi-Release")));
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static int version(VirtualFile dir) {
        try {
            return Integer.valueOf(dir.getName());
        }
        catch (RuntimeException ignore) {
            return Integer.MIN_VALUE;
        }
    }

    private static int compareVersions(VirtualFile dir1, VirtualFile dir2) {
        int v1 = JavaModuleNameIndex.version(dir1);
        int v2 = JavaModuleNameIndex.version(dir2);
        if (v1 < 9 && v2 < 9) {
            return 0;
        }
        if (v1 < 9) {
            return 1;
        }
        if (v2 < 9) {
            return -1;
        }
        return v1 - v2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/index/JavaModuleNameIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/index/JavaModuleNameIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "descriptorFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

