/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.source.JavaFileElementType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentFileContent;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class JavaBinaryPlusExpressionIndex
extends FileBasedIndexExtension<Boolean, PlusOffsets>
implements PsiDependentIndex {
    public static final ID<Boolean, PlusOffsets> INDEX_ID = ID.create((String)"java.binary.plus.expression");

    @NotNull
    public ID<Boolean, PlusOffsets> getName() {
        ID<Boolean, PlusOffsets> iD = INDEX_ID;
        if (iD == null) {
            JavaBinaryPlusExpressionIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Boolean, PlusOffsets, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            CharSequence text2 = inputData.getContentAsText();
            int[] offsets = new StringSearcher("+", true, true).findAllOccurrences(text2);
            if (offsets.length == 0) {
                return Collections.emptyMap();
            }
            LighterAST tree = ((PsiDependentFileContent)inputData).getLighterAST();
            TIntArrayList result = new TIntArrayList(offsets.length);
            HashMap stringConcatenations = new HashMap();
            LightTreeUtil.processLeavesAtOffsets((int[])offsets, (LighterAST)tree, (leaf, offset) -> {
                LighterASTNode element;
                LighterASTNode lighterASTNode = element = leaf == null ? null : tree.getParent((LighterASTNode)leaf);
                if (element == null) {
                    return;
                }
                if (!(element.getTokenType() != JavaElementType.BINARY_EXPRESSION && element.getTokenType() != JavaElementType.POLYADIC_EXPRESSION || stringConcatenations.computeIfAbsent(element, __ -> JavaBinaryPlusExpressionIndex.isStringConcatenation(element, tree)).booleanValue())) {
                    result.add(offset.intValue());
                }
            });
            THashMap resultMap = new THashMap();
            resultMap.put((Object)Boolean.TRUE, (Object)new PlusOffsets(result.toNativeArray()));
            return resultMap;
        };
        if (dataIndexer == null) {
            JavaBinaryPlusExpressionIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<Boolean> getKeyDescriptor() {
        BooleanDataDescriptor booleanDataDescriptor = BooleanDataDescriptor.INSTANCE;
        if (booleanDataDescriptor == null) {
            JavaBinaryPlusExpressionIndex.$$$reportNull$$$0(2);
        }
        return booleanDataDescriptor;
    }

    @NotNull
    public DataExternalizer<PlusOffsets> getValueExternalizer() {
        DataExternalizer<PlusOffsets> dataExternalizer = new DataExternalizer<PlusOffsets>(){

            public void save(@NotNull DataOutput out, PlusOffsets value2) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                int[] offsets = value2.getOffsets();
                DataInputOutputUtil.writeINT((DataOutput)out, (int)offsets.length);
                for (int i : offsets) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)i);
                }
            }

            public PlusOffsets read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    1.$$$reportNull$$$0(1);
                }
                int[] result = new int[DataInputOutputUtil.readINT((DataInput)in)];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = DataInputOutputUtil.readINT((DataInput)in);
                }
                return new PlusOffsets(result);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/java/JavaBinaryPlusExpressionIndex$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (dataExternalizer == null) {
            JavaBinaryPlusExpressionIndex.$$$reportNull$$$0(3);
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return 1;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return super.acceptInput(file) && JavaFileElementType.isInSourceContent(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/java/JavaBinaryPlusExpressionIndex$2", "acceptInput"));
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            JavaBinaryPlusExpressionIndex.$$$reportNull$$$0(4);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static boolean isStringConcatenation(@NotNull LighterASTNode concatExpr, @NotNull LighterAST tree) {
        if (concatExpr == null) {
            JavaBinaryPlusExpressionIndex.$$$reportNull$$$0(5);
        }
        if (tree == null) {
            JavaBinaryPlusExpressionIndex.$$$reportNull$$$0(6);
        }
        return LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)concatExpr, (TokenSet)ElementType.EXPRESSION_BIT_SET).stream().allMatch(e -> e.getTokenType() == JavaElementType.LITERAL_EXPRESSION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/JavaBinaryPlusExpressionIndex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "concatExpr";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/JavaBinaryPlusExpressionIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isStringConcatenation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PlusOffsets {
        private final int[] offsets;

        PlusOffsets(int[] offsets) {
            this.offsets = offsets;
        }

        public int[] getOffsets() {
            return this.offsets;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlusOffsets offsets1 = (PlusOffsets)o;
            return Arrays.equals(this.offsets, offsets1.offsets);
        }

        public int hashCode() {
            return Arrays.hashCode(this.offsets);
        }
    }
}

