/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.java.stubs.index.JavaAutoModuleNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaFullClassNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class JavaFileManagerImpl
implements JavaFileManager,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.impl.JavaFileManagerImpl");
    private final PsiManagerEx myManager;
    private volatile Set<String> myNontrivialPackagePrefixes;
    private boolean myDisposed;
    private final PackageIndex myPackageIndex;

    public JavaFileManagerImpl(Project project) {
        this.myManager = PsiManagerEx.getInstanceEx((Project)project);
        this.myPackageIndex = PackageIndex.getInstance((Project)this.myManager.getProject());
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                JavaFileManagerImpl.this.myNontrivialPackagePrefixes = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl$1", "rootsChanged"));
            }
        });
    }

    public void dispose() {
        this.myDisposed = true;
    }

    @Override
    @Nullable
    public PsiPackage findPackage(@NotNull String packageName) {
        Query dirs;
        if (packageName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(0);
        }
        if ((dirs = this.myPackageIndex.getDirsByPackageName(packageName, true)).findFirst() == null) {
            return null;
        }
        return new PsiPackageImpl((PsiManager)this.myManager, packageName);
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        List<Pair<PsiClass, VirtualFile>> result;
        int count;
        if (qName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(2);
        }
        if ((count = (result = this.doFindClasses(qName, scope)).size()) == 0) {
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaFileManagerImpl.$$$reportNull$$$0(3);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (count == 1) {
            PsiClass[] psiClassArray = new PsiClass[]{(PsiClass)result.get(0).getFirst()};
            if (psiClassArray == null) {
                JavaFileManagerImpl.$$$reportNull$$$0(4);
            }
            return psiClassArray;
        }
        ContainerUtil.quickSort(result, (o1, o2) -> scope.compare((VirtualFile)o2.getSecond(), (VirtualFile)o1.getSecond()));
        PsiClass[] psiClassArray = (PsiClass[])result.stream().map(p -> (PsiClass)p.getFirst()).toArray(PsiClass[]::new);
        if (psiClassArray == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    @NotNull
    private List<Pair<PsiClass, VirtualFile>> doFindClasses(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        Collection<PsiClass> classes2;
        if (qName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(7);
        }
        if ((classes2 = JavaFullClassNameIndex.getInstance().get(qName.hashCode(), this.myManager.getProject(), scope)).isEmpty()) {
            List<Pair<PsiClass, VirtualFile>> list = Collections.emptyList();
            if (list == null) {
                JavaFileManagerImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList<Pair<PsiClass, VirtualFile>> result = new ArrayList<Pair<PsiClass, VirtualFile>>(classes2.size());
        for (PsiClass aClass : classes2) {
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.equals(qName)) continue;
            PsiFile file = aClass.getContainingFile();
            if (file == null) {
                throw new AssertionError((Object)("No file for class: " + aClass + " of " + aClass.getClass()));
            }
            boolean valid = file.isValid();
            VirtualFile vFile = file.getVirtualFile();
            if (!valid) {
                LOG.error("Invalid file " + file + "; virtualFile:" + vFile + (vFile != null && !vFile.isValid() ? " (invalid)" : "") + "; id=" + (vFile == null ? 0 : ((VirtualFileWithId)vFile).getId()), (Throwable)new PsiInvalidElementAccessException((PsiElement)aClass));
                continue;
            }
            if (!this.hasAcceptablePackage(vFile)) continue;
            result.add((Pair<PsiClass, VirtualFile>)Pair.create((Object)aClass, (Object)vFile));
        }
        ArrayList<Pair<PsiClass, VirtualFile>> arrayList = result;
        if (arrayList == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(11);
        }
        LOG.assertTrue(!this.myDisposed);
        VirtualFile bestFile = null;
        PsiClass bestClass = null;
        List<Pair<PsiClass, VirtualFile>> result = this.doFindClasses(qName, scope);
        for (int i = 0; i < result.size(); ++i) {
            Pair<PsiClass, VirtualFile> pair2 = result.get(i);
            VirtualFile vFile = (VirtualFile)pair2.getSecond();
            if (bestFile != null && scope.compare(vFile, bestFile) <= 0) continue;
            bestFile = vFile;
            bestClass = (PsiClass)pair2.getFirst();
        }
        return bestClass;
    }

    private boolean hasAcceptablePackage(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(12);
        }
        if (vFile.getFileType() == JavaClassFileType.INSTANCE) {
            VirtualFile root = ProjectRootManager.getInstance((Project)this.myManager.getProject()).getFileIndex().getClassRootForFile(vFile);
            PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)this.myManager.getProject());
            for (VirtualFile parent = vFile.getParent(); parent != null && !Comparing.equal((Object)parent, (Object)root); parent = parent.getParent()) {
                if (nameHelper.isIdentifier(parent.getName())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<String> getNonTrivialPackagePrefixes() {
        Set<String> names = this.myNontrivialPackagePrefixes;
        if (names == null) {
            names = new HashSet<String>();
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)this.myManager.getProject());
            List sourceRoots = rootManager.getModuleSourceRoots(JavaModuleSourceRootTypes.SOURCES);
            ProjectFileIndex fileIndex = rootManager.getFileIndex();
            for (VirtualFile sourceRoot : sourceRoots) {
                String packageName;
                if (!sourceRoot.isDirectory() || (packageName = fileIndex.getPackageNameByDirectory(sourceRoot)) == null || packageName.isEmpty()) continue;
                names.add(packageName);
            }
            this.myNontrivialPackagePrefixes = names;
        }
        Set<String> set = names;
        if (set == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(13);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<PsiJavaModule> findModules(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        if (moduleName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(15);
        }
        LibSrcExcludingScope excludingScope = new LibSrcExcludingScope(scope);
        ArrayList<PsiJavaModule> results = new ArrayList<PsiJavaModule>(JavaModuleNameIndex.getInstance().get(moduleName, this.myManager.getProject(), (GlobalSearchScope)excludingScope));
        Collection<VirtualFile> jars = JavaAutoModuleNameIndex.getFilesByKey(moduleName, (GlobalSearchScope)excludingScope);
        if (!jars.isEmpty()) {
            jars.stream().map(f -> LightJavaModule.getModule((PsiManager)this.myManager, f)).forEach(results::add);
        }
        Collection<PsiJavaModule> collection = JavaFileManagerImpl.upgradeModules(JavaFileManagerImpl.sortModules(results, scope), moduleName, scope);
        if (collection == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(16);
        }
        return collection;
    }

    private static Collection<PsiJavaModule> sortModules(Collection<PsiJavaModule> modules, GlobalSearchScope scope) {
        if (modules.size() > 1) {
            ArrayList<PsiJavaModule> list = new ArrayList<PsiJavaModule>(modules);
            list.sort((m1, m2) -> scope.compare(PsiImplUtil.getModuleVirtualFile(m2), PsiImplUtil.getModuleVirtualFile(m1)));
            modules = list;
        }
        return modules;
    }

    private static Collection<PsiJavaModule> upgradeModules(Collection<PsiJavaModule> modules, String moduleName, GlobalSearchScope scope) {
        if (modules.size() > 1 && PsiJavaModule.UPGRADEABLE.contains(moduleName) && scope instanceof ModuleWithDependenciesScope) {
            Module module = ((ModuleWithDependenciesScope)scope).getModule();
            boolean isModular = Stream.of(ModuleRootManager.getInstance((Module)module).getSourceRoots(true)).filter(arg_0 -> ((GlobalSearchScope)scope).contains(arg_0)).anyMatch(root -> root.findChild("module-info.java") != null);
            if (isModular) {
                List<PsiJavaModule> list = new ArrayList<PsiJavaModule>(modules);
                ModuleFileIndex index = ModuleRootManager.getInstance((Module)module).getFileIndex();
                ListIterator i = list.listIterator();
                while (i.hasNext()) {
                    PsiJavaModule candidate = (PsiJavaModule)i.next();
                    if (!(index.getOrderEntryForFile(PsiImplUtil.getModuleVirtualFile(candidate)) instanceof JdkOrderEntry)) continue;
                    if (i.previousIndex() > 0) {
                        i.remove();
                        continue;
                    }
                    list = Collections.singletonList(candidate);
                    break;
                }
                if (list.size() != modules.size()) {
                    modules = list;
                }
            }
        }
        return modules;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/impl/JavaFileManagerImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/impl/JavaFileManagerImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindClasses";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonTrivialPackagePrefixes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doFindClasses";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasAcceptablePackage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LibSrcExcludingScope
    extends DelegatingGlobalSearchScope {
        private final ProjectFileIndex myIndex;

        private LibSrcExcludingScope(@NotNull GlobalSearchScope baseScope) {
            if (baseScope == null) {
                LibSrcExcludingScope.$$$reportNull$$$0(0);
            }
            super(baseScope);
            this.myIndex = ProjectFileIndex.getInstance((Project)Objects.requireNonNull(baseScope.getProject()));
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                LibSrcExcludingScope.$$$reportNull$$$0(1);
            }
            return super.contains(file) && (!this.myIndex.isInLibrarySource(file) || this.myIndex.isInLibraryClasses(file));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseScope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/file/impl/JavaFileManagerImpl$LibSrcExcludingScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

