/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsEnumConstantImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.ClsMemberImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.MethodsProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsClassImpl
extends ClsMemberImpl<PsiClassStub<?>>
implements PsiExtensibleClass,
Queryable {
    public static final Key<PsiClass> DELEGATE_KEY = Key.create((String)"DELEGATE");
    private final ClassInnerStuffCache myInnersCache = new ClassInnerStuffCache(this);

    public ClsClassImpl(PsiClassStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        ArrayList children = new ArrayList();
        ContainerUtil.addAll(children, (Object[])this.getChildren(new PsiElement[]{this.getDocComment(), this.getModifierListInternal(), this.getNameIdentifier(), this.getExtendsList(), this.getImplementsList()}));
        ContainerUtil.addAll(children, this.getOwnFields());
        ContainerUtil.addAll(children, this.getOwnMethods());
        ContainerUtil.addAll(children, this.getOwnInnerClasses());
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(children);
        if (psiElementArray == null) {
            ClsClassImpl.$$$reportNull$$$0(0);
        }
        return psiElementArray;
    }

    @NotNull
    public PsiTypeParameterList getTypeParameterList() {
        PsiTypeParameterList psiTypeParameterList = (PsiTypeParameterList)((PsiTypeParameterListStub)ObjectUtils.assertNotNull((Object)((PsiClassStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.TYPE_PARAMETER_LIST))).getPsi();
        if (psiTypeParameterList == null) {
            ClsClassImpl.$$$reportNull$$$0(1);
        }
        return psiTypeParameterList;
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    @Nullable
    public String getQualifiedName() {
        return ((PsiClassStub)this.getStub()).getQualifiedName();
    }

    private boolean isLocalClass() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        return stub instanceof PsiClassStubImpl && ((PsiClassStubImpl)stub).isLocalClassInner();
    }

    private boolean isAnonymousClass() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        return stub instanceof PsiClassStubImpl && ((PsiClassStubImpl)stub).isAnonymousInner();
    }

    private boolean isAnonymousOrLocalClass() {
        return this.isAnonymousClass() || this.isLocalClass();
    }

    @Nullable
    public PsiModifierList getModifierList() {
        if (this.isAnonymousClass()) {
            return null;
        }
        return this.getModifierListInternal();
    }

    private PsiModifierList getModifierListInternal() {
        return (PsiModifierList)((PsiModifierListStub)ObjectUtils.assertNotNull((Object)((PsiClassStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST))).getPsi();
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            ClsClassImpl.$$$reportNull$$$0(2);
        }
        return this.getModifierListInternal().hasModifierProperty(name2);
    }

    @NotNull
    public PsiReferenceList getExtendsList() {
        PsiReferenceList psiReferenceList = (PsiReferenceList)((PsiClassReferenceListStub)ObjectUtils.assertNotNull((Object)((PsiClassStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.EXTENDS_LIST))).getPsi();
        if (psiReferenceList == null) {
            ClsClassImpl.$$$reportNull$$$0(3);
        }
        return psiReferenceList;
    }

    @NotNull
    public PsiReferenceList getImplementsList() {
        PsiReferenceList psiReferenceList = (PsiReferenceList)((PsiClassReferenceListStub)ObjectUtils.assertNotNull((Object)((PsiClassStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.IMPLEMENTS_LIST))).getPsi();
        if (psiReferenceList == null) {
            ClsClassImpl.$$$reportNull$$$0(4);
        }
        return psiReferenceList;
    }

    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getExtendsListTypes(this);
        if (psiClassTypeArray == null) {
            ClsClassImpl.$$$reportNull$$$0(5);
        }
        return psiClassTypeArray;
    }

    @NotNull
    public PsiClassType[] getImplementsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getImplementsListTypes(this);
        if (psiClassTypeArray == null) {
            ClsClassImpl.$$$reportNull$$$0(6);
        }
        return psiClassTypeArray;
    }

    public PsiClass getSuperClass() {
        return PsiClassImplUtil.getSuperClass(this);
    }

    @NotNull
    public PsiClass[] getInterfaces() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getInterfaces(this);
        if (psiClassArray == null) {
            ClsClassImpl.$$$reportNull$$$0(7);
        }
        return psiClassArray;
    }

    @NotNull
    public PsiClass[] getSupers() {
        if ("java.lang.Object".equals(this.getQualifiedName())) {
            if (PsiClass.EMPTY_ARRAY == null) {
                ClsClassImpl.$$$reportNull$$$0(8);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = PsiClassImplUtil.getSupers(this);
        if (psiClassArray == null) {
            ClsClassImpl.$$$reportNull$$$0(9);
        }
        return psiClassArray;
    }

    @NotNull
    public PsiClassType[] getSuperTypes() {
        if ("java.lang.Object".equals(this.getQualifiedName())) {
            if (PsiClassType.EMPTY_ARRAY == null) {
                ClsClassImpl.$$$reportNull$$$0(10);
            }
            return PsiClassType.EMPTY_ARRAY;
        }
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getSuperTypes(this);
        if (psiClassTypeArray == null) {
            ClsClassImpl.$$$reportNull$$$0(11);
        }
        return psiClassTypeArray;
    }

    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : null;
    }

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        Collection<HierarchicalMethodSignature> collection = PsiSuperMethodImplUtil.getVisibleSignatures(this);
        if (collection == null) {
            ClsClassImpl.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = this.myInnersCache.getFields();
        if (psiFieldArray == null) {
            ClsClassImpl.$$$reportNull$$$0(13);
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getMethods();
        if (psiMethodArray == null) {
            ClsClassImpl.$$$reportNull$$$0(14);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getConstructors();
        if (psiMethodArray == null) {
            ClsClassImpl.$$$reportNull$$$0(15);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = this.myInnersCache.getInnerClasses();
        if (psiClassArray == null) {
            ClsClassImpl.$$$reportNull$$$0(16);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public List<PsiField> getOwnFields() {
        List<PsiElement> list = Arrays.asList(((PsiClassStub)this.getStub()).getChildrenByType(Constants.FIELD_BIT_SET, PsiField.ARRAY_FACTORY));
        if (list == null) {
            ClsClassImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiMethod> getOwnMethods() {
        List<PsiElement> list = Arrays.asList(((PsiClassStub)this.getStub()).getChildrenByType(Constants.METHOD_BIT_SET, PsiMethod.ARRAY_FACTORY));
        if (list == null) {
            ClsClassImpl.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiClass> getOwnInnerClasses() {
        PsiClass[] classes2 = (PsiClass[])((PsiClassStub)this.getStub()).getChildrenByType((IElementType)JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
        if (classes2.length == 0) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                ClsClassImpl.$$$reportNull$$$0(19);
            }
            return list;
        }
        int anonymousOrLocalClassesCount = 0;
        for (PsiClass aClass : classes2) {
            if (!(aClass instanceof ClsClassImpl) || !((ClsClassImpl)aClass).isAnonymousOrLocalClass()) continue;
            ++anonymousOrLocalClassesCount;
        }
        if (anonymousOrLocalClassesCount == 0) {
            List<PsiClass> list = Arrays.asList(classes2);
            if (list == null) {
                ClsClassImpl.$$$reportNull$$$0(20);
            }
            return list;
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(classes2.length - anonymousOrLocalClassesCount);
        for (PsiClass aClass : classes2) {
            if (aClass instanceof ClsClassImpl && ((ClsClassImpl)aClass).isAnonymousOrLocalClass()) continue;
            result.add(aClass);
        }
        ArrayList<PsiClass> arrayList = result;
        if (arrayList == null) {
            ClsClassImpl.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @NotNull
    public PsiClassInitializer[] getInitializers() {
        if (PsiClassInitializer.EMPTY_ARRAY == null) {
            ClsClassImpl.$$$reportNull$$$0(22);
        }
        return PsiClassInitializer.EMPTY_ARRAY;
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
        if (psiTypeParameterArray == null) {
            ClsClassImpl.$$$reportNull$$$0(23);
        }
        return psiTypeParameterArray;
    }

    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            ClsClassImpl.$$$reportNull$$$0(24);
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            ClsClassImpl.$$$reportNull$$$0(25);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses(this);
        if (psiClassArray == null) {
            ClsClassImpl.$$$reportNull$$$0(26);
        }
        return psiClassArray;
    }

    public PsiField findFieldByName(String name2, boolean checkBases) {
        return this.myInnersCache.findFieldByName(name2, checkBases);
    }

    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    @NotNull
    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
        if (psiMethodArray == null) {
            ClsClassImpl.$$$reportNull$$$0(27);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findMethodsByName(String name2, boolean checkBases) {
        PsiMethod[] psiMethodArray = this.myInnersCache.findMethodsByName(name2, checkBases);
        if (psiMethodArray == null) {
            ClsClassImpl.$$$reportNull$$$0(28);
        }
        return psiMethodArray;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name2, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> list = PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name2, checkBases);
        if (list == null) {
            ClsClassImpl.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        List<Pair<PsiMethod, PsiSubstitutor>> list = PsiClassImplUtil.getAllWithSubstitutorsByMap(this, PsiClassImplUtil.MemberType.METHOD);
        if (list == null) {
            ClsClassImpl.$$$reportNull$$$0(30);
        }
        return list;
    }

    public PsiClass findInnerClassByName(String name2, boolean checkBases) {
        return this.myInnersCache.findInnerClassByName(name2, checkBases);
    }

    public boolean isDeprecated() {
        return ((PsiClassStub)this.getStub()).isDeprecated() || PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    public String getSourceFileName() {
        String sfn = ((PsiClassStub)this.getStub()).getSourceFileName();
        return sfn != null ? sfn : this.obtainSourceFileNameFromClassFileName();
    }

    @NonNls
    private String obtainSourceFileNameFromClassFileName() {
        String name2 = this.getContainingFile().getName();
        int i = name2.indexOf(36);
        if (i < 0 && (i = name2.indexOf(46)) < 0) {
            i = name2.length();
        }
        return name2.substring(0, i) + ".java";
    }

    public PsiJavaToken getLBrace() {
        return null;
    }

    public PsiJavaToken getRBrace() {
        return null;
    }

    public boolean isInterface() {
        return ((PsiClassStub)this.getStub()).isInterface();
    }

    public boolean isAnnotationType() {
        return ((PsiClassStub)this.getStub()).isAnnotationType();
    }

    public boolean isEnum() {
        return ((PsiClassStub)this.getStub()).isEnum();
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull @NonNls StringBuilder buffer) {
        int i;
        if (buffer == null) {
            ClsClassImpl.$$$reportNull$$$0(31);
        }
        ClsClassImpl.appendText((PsiElement)this.getDocComment(), indentLevel, buffer, "go_to_next_line_and_indent");
        ClsClassImpl.appendText((PsiElement)this.getModifierListInternal(), indentLevel, buffer);
        buffer.append(this.isEnum() ? "enum " : (this.isAnnotationType() ? "@interface " : (this.isInterface() ? "interface " : "class ")));
        ClsClassImpl.appendText((PsiElement)this.getNameIdentifier(), indentLevel, buffer, " ");
        ClsClassImpl.appendText((PsiElement)this.getTypeParameterList(), indentLevel, buffer, " ");
        ClsClassImpl.appendText((PsiElement)this.getExtendsList(), indentLevel, buffer, " ");
        ClsClassImpl.appendText((PsiElement)this.getImplementsList(), indentLevel, buffer, " ");
        buffer.append('{');
        int newIndentLevel = indentLevel + this.getIndentSize();
        List<PsiField> fields = this.getOwnFields();
        List<PsiMethod> methods = this.getOwnMethods();
        List<PsiClass> classes2 = this.getOwnInnerClasses();
        if (!fields.isEmpty()) {
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (i = 0; i < fields.size(); ++i) {
                PsiField field = fields.get(i);
                ClsClassImpl.appendText((PsiElement)field, newIndentLevel, buffer);
                if (field instanceof ClsEnumConstantImpl) {
                    if (i < fields.size() - 1 && fields.get(i + 1) instanceof ClsEnumConstantImpl) {
                        buffer.append(", ");
                        continue;
                    }
                    buffer.append(';');
                    if (i >= fields.size() - 1) continue;
                    buffer.append('\n');
                    ClsClassImpl.goNextLine(newIndentLevel, buffer);
                    continue;
                }
                if (i >= fields.size() - 1) continue;
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        } else if (this.isEnum() && methods.size() + classes2.size() > 0) {
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            buffer.append(";");
        }
        if (!methods.isEmpty()) {
            if (this.isEnum() || !fields.isEmpty()) {
                buffer.append('\n');
            }
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (i = 0; i < methods.size(); ++i) {
                ClsClassImpl.appendText((PsiElement)methods.get(i), newIndentLevel, buffer);
                if (i >= methods.size() - 1) continue;
                buffer.append('\n');
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        }
        if (!classes2.isEmpty()) {
            if (fields.size() + methods.size() > 0) {
                buffer.append('\n');
            }
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (i = 0; i < classes2.size(); ++i) {
                ClsClassImpl.appendText((PsiElement)classes2.get(i), newIndentLevel, buffer);
                if (i >= classes2.size() - 1) continue;
                buffer.append('\n');
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        }
        ClsClassImpl.goNextLine(indentLevel, buffer);
        buffer.append('}');
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            ClsClassImpl.$$$reportNull$$$0(32);
        }
        this.setMirrorCheckingType(element, null);
        PsiClass mirror = (PsiClass)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)element);
        ClsClassImpl.setMirrorIfPresent(this.getDocComment(), mirror.getDocComment());
        PsiModifierList modifierList = this.getModifierList();
        if (modifierList != null) {
            ClsClassImpl.setMirror(modifierList, mirror.getModifierList());
        }
        ClsClassImpl.setMirror(this.getNameIdentifier(), mirror.getNameIdentifier());
        ClsClassImpl.setMirror(this.getTypeParameterList(), mirror.getTypeParameterList());
        ClsClassImpl.setMirror(this.getExtendsList(), mirror.getExtendsList());
        ClsClassImpl.setMirror(this.getImplementsList(), mirror.getImplementsList());
        if (mirror instanceof PsiExtensibleClass) {
            PsiExtensibleClass extMirror = (PsiExtensibleClass)mirror;
            ClsClassImpl.setMirrors(this.getOwnFields(), extMirror.getOwnFields());
            ClsClassImpl.setMirrors(this.getOwnMethods(), extMirror.getOwnMethods());
            ClsClassImpl.setMirrors(this.getOwnInnerClasses(), extMirror.getOwnInnerClasses());
        } else {
            ClsClassImpl.setMirrors(this.getOwnFields(), Arrays.asList(mirror.getFields()));
            ClsClassImpl.setMirrors(this.getOwnMethods(), Arrays.asList(mirror.getMethods()));
            ClsClassImpl.setMirrors(this.getOwnInnerClasses(), Arrays.asList(mirror.getInnerClasses()));
        }
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            ClsClassImpl.$$$reportNull$$$0(33);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitClass((PsiClass)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NonNls
    public String toString() {
        return "PsiClass:" + this.getName();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            ClsClassImpl.$$$reportNull$$$0(34);
        }
        if (state == null) {
            ClsClassImpl.$$$reportNull$$$0(35);
        }
        if (place == null) {
            ClsClassImpl.$$$reportNull$$$0(36);
        }
        if (this.isEnum() && !PsiClassImplUtil.processDeclarationsInEnum(processor, state, this.myInnersCache)) {
            return false;
        }
        LanguageLevel level = processor instanceof MethodsProcessor ? ((MethodsProcessor)processor).getLanguageLevel() : PsiUtil.getLanguageLevel((PsiElement)place);
        return PsiClassImplUtil.processDeclarationsInClass(this, processor, state, null, lastParent, place, level, false);
    }

    public PsiElement getScope() {
        return this.getParent();
    }

    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep(this, baseClass, classToByPass);
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            ClsClassImpl.$$$reportNull$$$0(37);
        }
        return InheritanceImplUtil.isInheritor(this, baseClass, checkDeep);
    }

    @Nullable
    public PsiClass getSourceMirrorClass() {
        PsiClass delegate = (PsiClass)this.getUserData(DELEGATE_KEY);
        if (delegate instanceof ClsClassImpl) {
            return ((ClsClassImpl)delegate).getSourceMirrorClass();
        }
        String name2 = this.getName();
        PsiElement parent = this.getParent();
        if (parent instanceof PsiFile) {
            if (!(parent instanceof PsiClassOwner)) {
                return null;
            }
            PsiClassOwner fileNavigationElement = (PsiClassOwner)parent.getNavigationElement();
            if (fileNavigationElement == parent) {
                return null;
            }
            for (PsiClass aClass : fileNavigationElement.getClasses()) {
                if (!name2.equals(aClass.getName())) continue;
                return aClass;
            }
        } else if (parent != null) {
            PsiClass[] innerClasses;
            ClsClassImpl parentClass = (ClsClassImpl)parent;
            PsiClass parentSourceMirror = parentClass.getSourceMirrorClass();
            if (parentSourceMirror == null) {
                return null;
            }
            for (PsiClass innerClass : innerClasses = parentSourceMirror.getInnerClasses()) {
                if (!name2.equals(innerClass.getName())) continue;
                return innerClass;
            }
        } else {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return null;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        block11: {
            PsiElement psiElement;
            block10: {
                for (ClsCustomNavigationPolicy navigationPolicy : ClsCustomNavigationPolicy.EP_NAME.getExtensionList()) {
                    PsiElement psiElement2;
                    try {
                        PsiElement navigationElement = navigationPolicy.getNavigationElement(this);
                        if (navigationElement == null) continue;
                        psiElement2 = navigationElement;
                    }
                    catch (IndexNotReadyException navigationElement) {
                        continue;
                    }
                    if (psiElement2 == null) {
                        ClsClassImpl.$$$reportNull$$$0(38);
                    }
                    return psiElement2;
                }
                PsiClass aClass = this.getSourceMirrorClass();
                if (aClass == null) break block10;
                PsiElement psiElement3 = aClass.getNavigationElement();
                if (psiElement3 == null) {
                    ClsClassImpl.$$$reportNull$$$0(39);
                }
                return psiElement3;
            }
            try {
                PsiElement sourceFile;
                PsiElement parent;
                if (!"package-info".equals(this.getName()) || !((parent = this.getParent()) instanceof ClsFileImpl) || !((sourceFile = parent.getNavigationElement()) instanceof PsiJavaFile)) break block11;
                psiElement = sourceFile;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (psiElement == null) {
                ClsClassImpl.$$$reportNull$$$0(40);
            }
            return psiElement;
        }
        ClsClassImpl clsClassImpl = this;
        if (clsClassImpl == null) {
            ClsClassImpl.$$$reportNull$$$0(41);
        }
        return clsClassImpl;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public Icon getElementIcon(int flags) {
        return PsiClassImplUtil.getClassIcon(flags, this);
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo(this, another);
    }

    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiClassImplUtil.getClassUseScope(this);
        if (searchScope == null) {
            ClsClassImpl.$$$reportNull$$$0(42);
        }
        return searchScope;
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            ClsClassImpl.$$$reportNull$$$0(43);
        }
        PsiClassImpl.putInfo(this, info);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 43: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 43: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClsClassImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterList";
                break;
            }
            case 2: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClsClassImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsListTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsListTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaces";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleSignatures";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnFields";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnMethods";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnInnerClasses";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializers";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInnerClasses";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsBySignature";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsAndTheirSubstitutorsByName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethodsAndTheirSubstitutors";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "appendMirrorText";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 43: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

