/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.ThreadLocalTypes;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiImplUtil");
    private static final Key<Boolean> TYPE_ANNO_MARK = Key.create((String)"type.annotation.mark");

    private PsiImplUtil() {
    }

    @NotNull
    public static PsiMethod[] getConstructors(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiImplUtil.$$$reportNull$$$0(0);
        }
        List result = null;
        for (PsiMethod method : aClass.getMethods()) {
            if (!method.isConstructor() || !method.getName().equals(aClass.getName())) continue;
            if (result == null) {
                result = ContainerUtil.newSmartList();
            }
            result.add(method);
        }
        PsiMethod[] psiMethodArray = result == null ? PsiMethod.EMPTY_ARRAY : result.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            PsiImplUtil.$$$reportNull$$$0(1);
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiAnnotationMemberValue findDeclaredAttributeValue(@NotNull PsiAnnotation annotation, @NonNls @Nullable String attributeName) {
        PsiNameValuePair attribute;
        if (annotation == null) {
            PsiImplUtil.$$$reportNull$$$0(2);
        }
        return (attribute = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)attributeName)) == null ? null : attribute.getValue();
    }

    @Nullable
    public static PsiAnnotationMemberValue findAttributeValue(@NotNull PsiAnnotation annotation, @Nullable @NonNls String attributeName) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement referenceElement;
        PsiAnnotationMemberValue value2;
        if (annotation == null) {
            PsiImplUtil.$$$reportNull$$$0(3);
        }
        if ((value2 = PsiImplUtil.findDeclaredAttributeValue(annotation, attributeName)) != null) {
            return value2;
        }
        if (attributeName == null) {
            attributeName = "value";
        }
        if ((referenceElement = annotation.getNameReferenceElement()) != null && (resolved = referenceElement.resolve()) != null) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = ((PsiClass)resolved).findMethodsByName(attributeName, false)) {
                if (!PsiUtil.isAnnotationMethod((PsiElement)method)) continue;
                return ((PsiAnnotationMethod)method).getDefaultValue();
            }
        }
        return null;
    }

    @NotNull
    public static PsiTypeParameter[] getTypeParameters(@NotNull PsiTypeParameterListOwner owner2) {
        PsiTypeParameterList typeParameterList;
        if (owner2 == null) {
            PsiImplUtil.$$$reportNull$$$0(4);
        }
        if ((typeParameterList = owner2.getTypeParameterList()) != null) {
            PsiTypeParameter[] psiTypeParameterArray = typeParameterList.getTypeParameters();
            if (psiTypeParameterArray == null) {
                PsiImplUtil.$$$reportNull$$$0(5);
            }
            return psiTypeParameterArray;
        }
        if (PsiTypeParameter.EMPTY_ARRAY == null) {
            PsiImplUtil.$$$reportNull$$$0(6);
        }
        return PsiTypeParameter.EMPTY_ARRAY;
    }

    @NotNull
    public static PsiJavaCodeReferenceElement[] namesToPackageReferences(@NotNull PsiManager manager, @NotNull String[] names) {
        if (manager == null) {
            PsiImplUtil.$$$reportNull$$$0(7);
        }
        if (names == null) {
            PsiImplUtil.$$$reportNull$$$0(8);
        }
        PsiJavaCodeReferenceElement[] refs = new PsiJavaCodeReferenceElement[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name2 = names[i];
            try {
                refs[i] = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createPackageReferenceElement(name2);
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (refs == null) {
            PsiImplUtil.$$$reportNull$$$0(9);
        }
        return refs;
    }

    public static int getParameterIndex(@NotNull PsiParameter parameter2, @NotNull PsiParameterList parameterList) {
        int i;
        if (parameter2 == null) {
            PsiImplUtil.$$$reportNull$$$0(10);
        }
        if (parameterList == null) {
            PsiImplUtil.$$$reportNull$$$0(11);
        }
        PsiElement parameterParent = parameter2.getParent();
        assert (parameterParent == parameterList) : parameterList + "; " + parameterParent;
        PsiParameter[] parameters2 = parameterList.getParameters();
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            PsiParameter paramInList = parameters2[i2];
            if (!parameter2.equals(paramInList)) continue;
            return i2;
        }
        String name2 = parameter2.getName();
        PsiParameter suspect = null;
        for (i = parameters2.length - 1; i >= 0; --i) {
            PsiParameter paramInList = parameters2[i];
            if (!Comparing.equal((String)name2, (String)paramInList.getName())) continue;
            suspect = paramInList;
            break;
        }
        String message2 = parameter2 + ":" + parameter2.getClass() + " not found among parameters: " + Arrays.asList(parameters2) + ". parameterList' parent: " + parameterList.getParent() + "; parameter.isValid()=" + parameter2.isValid() + "; parameterList.isValid()= " + parameterList.isValid() + "; parameterList stub: " + (parameterList instanceof StubBasedPsiElement ? ((StubBasedPsiElement)parameterList).getStub() : "---") + ";  parameter stub: " + (parameter2 instanceof StubBasedPsiElement ? ((StubBasedPsiElement)parameter2).getStub() : "---") + "; suspect: " + suspect + " (index=" + i + "); " + (suspect == null ? null : suspect.getClass()) + " suspect stub: " + (suspect instanceof StubBasedPsiElement ? ((StubBasedPsiElement)suspect).getStub() : (suspect == null ? "-null-" : "---" + suspect.getClass())) + "; parameter.equals(suspect) = " + parameter2.equals(suspect) + ";  parameter.getNode() == suspect.getNode():  " + (parameter2.getNode() == (suspect == null ? null : suspect.getNode())) + "; .";
        LOG.error(message2);
        return i;
    }

    public static int getTypeParameterIndex(@NotNull PsiTypeParameter typeParameter, @NotNull PsiTypeParameterList typeParameterList) {
        if (typeParameter == null) {
            PsiImplUtil.$$$reportNull$$$0(12);
        }
        if (typeParameterList == null) {
            PsiImplUtil.$$$reportNull$$$0(13);
        }
        PsiTypeParameter[] typeParameters = typeParameterList.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!typeParameter.equals(typeParameters[i])) continue;
            return i;
        }
        LOG.error(typeParameter + " in " + typeParameterList);
        return -1;
    }

    @NotNull
    public static Object[] getReferenceVariantsByFilter(@NotNull PsiJavaCodeReferenceElement reference, @NotNull ElementFilter filter) {
        if (reference == null) {
            PsiImplUtil.$$$reportNull$$$0(14);
        }
        if (filter == null) {
            PsiImplUtil.$$$reportNull$$$0(15);
        }
        FilterScopeProcessor processor = new FilterScopeProcessor(filter);
        PsiScopesUtil.resolveAndWalk(processor, reference, null, true);
        Object[] objectArray = processor.getResults().toArray();
        if (objectArray == null) {
            PsiImplUtil.$$$reportNull$$$0(16);
        }
        return objectArray;
    }

    public static boolean processDeclarationsInMethod(@NotNull PsiMethod method, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (method == null) {
            PsiImplUtil.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            PsiImplUtil.$$$reportNull$$$0(18);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(19);
        }
        if (place == null) {
            PsiImplUtil.$$$reportNull$$$0(20);
        }
        if (lastParent instanceof DummyHolder) {
            lastParent = lastParent.getFirstChild();
        }
        boolean fromBody = lastParent instanceof PsiCodeBlock;
        PsiTypeParameterList typeParameterList = method.getTypeParameterList();
        return PsiImplUtil.processDeclarationsInMethodLike((PsiParameterListOwner)method, processor, state, place, fromBody, typeParameterList);
    }

    public static boolean processDeclarationsInLambda(@NotNull PsiLambdaExpression lambda2, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (lambda2 == null) {
            PsiImplUtil.$$$reportNull$$$0(21);
        }
        if (processor == null) {
            PsiImplUtil.$$$reportNull$$$0(22);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(23);
        }
        if (place == null) {
            PsiImplUtil.$$$reportNull$$$0(24);
        }
        boolean fromBody = lastParent != null && lastParent == lambda2.getBody();
        return PsiImplUtil.processDeclarationsInMethodLike((PsiParameterListOwner)lambda2, processor, state, place, fromBody, null);
    }

    private static boolean processDeclarationsInMethodLike(@NotNull PsiParameterListOwner element, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, boolean fromBody, @Nullable PsiTypeParameterList typeParameterList) {
        ElementClassHint hint;
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(25);
        }
        if (processor == null) {
            PsiImplUtil.$$$reportNull$$$0(26);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(27);
        }
        if (place == null) {
            PsiImplUtil.$$$reportNull$$$0(28);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)element);
        if (typeParameterList != null && ((hint = (ElementClassHint)processor.getHint(ElementClassHint.KEY)) == null || hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && !typeParameterList.processDeclarations(processor, state, null, place)) {
            return false;
        }
        if (fromBody) {
            PsiParameter[] parameters2;
            for (PsiParameter parameter2 : parameters2 = element.getParameterList().getParameters()) {
                if (processor.execute((PsiElement)parameter2, state)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean processDeclarationsInResourceList(@NotNull PsiResourceList resourceList, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent) {
        PsiResourceListElement resource;
        ElementClassHint hint;
        if (resourceList == null) {
            PsiImplUtil.$$$reportNull$$$0(29);
        }
        if (processor == null) {
            PsiImplUtil.$$$reportNull$$$0(30);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(31);
        }
        if ((hint = (ElementClassHint)processor.getHint(ElementClassHint.KEY)) != null && !hint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        Iterator iterator = resourceList.iterator();
        while (iterator.hasNext() && (resource = (PsiResourceListElement)iterator.next()) != lastParent) {
            if (!(resource instanceof PsiResourceVariable) || processor.execute((PsiElement)resource, state)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasTypeParameters(@NotNull PsiTypeParameterListOwner owner2) {
        PsiTypeParameterList typeParameterList;
        if (owner2 == null) {
            PsiImplUtil.$$$reportNull$$$0(32);
        }
        return (typeParameterList = owner2.getTypeParameterList()) != null && typeParameterList.getTypeParameters().length != 0;
    }

    @NotNull
    public static PsiType[] typesByReferenceParameterList(@NotNull PsiReferenceParameterList parameterList) {
        if (parameterList == null) {
            PsiImplUtil.$$$reportNull$$$0(33);
        }
        PsiTypeElement[] typeElements = parameterList.getTypeParameterElements();
        PsiType[] psiTypeArray = PsiImplUtil.typesByTypeElements(typeElements);
        if (psiTypeArray == null) {
            PsiImplUtil.$$$reportNull$$$0(34);
        }
        return psiTypeArray;
    }

    @NotNull
    public static PsiType[] typesByTypeElements(@NotNull PsiTypeElement[] typeElements) {
        if (typeElements == null) {
            PsiImplUtil.$$$reportNull$$$0(35);
        }
        PsiType[] types = PsiType.createArray((int)typeElements.length);
        for (int i = 0; i < types.length; ++i) {
            types[i] = typeElements[i].getType();
        }
        if (types.length == 1 && types[0] instanceof PsiDiamondType) {
            PsiType[] psiTypeArray = ((PsiDiamondType)types[0]).resolveInferredTypes().getTypes();
            if (psiTypeArray == null) {
                PsiImplUtil.$$$reportNull$$$0(36);
            }
            return psiTypeArray;
        }
        if (types == null) {
            PsiImplUtil.$$$reportNull$$$0(37);
        }
        return types;
    }

    @NotNull
    public static PsiType getType(@NotNull PsiClassObjectAccessExpression classAccessExpression) {
        PsiTypeParameter[] typeParameters;
        if (classAccessExpression == null) {
            PsiImplUtil.$$$reportNull$$$0(38);
        }
        GlobalSearchScope resolveScope = classAccessExpression.getResolveScope();
        PsiManager manager = classAccessExpression.getManager();
        PsiClass classClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Class", resolveScope);
        if (classClass == null) {
            PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType(new LightClassReference(manager, "Class", "java.lang.Class", resolveScope), null);
            if (psiClassReferenceType == null) {
                PsiImplUtil.$$$reportNull$$$0(39);
            }
            return psiClassReferenceType;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)classAccessExpression)) {
            PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createType(classClass);
            if (psiClassType == null) {
                PsiImplUtil.$$$reportNull$$$0(40);
            }
            return psiClassType;
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiType operandType = classAccessExpression.getOperand().getType();
        if (operandType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)operandType)) {
            operandType = PsiType.VOID.equals((Object)operandType) ? JavaPsiFacade.getElementFactory((Project)manager.getProject()).createTypeByFQClassName("java.lang.Void", classAccessExpression.getResolveScope()) : ((PsiPrimitiveType)operandType).getBoxedType((PsiElement)classAccessExpression);
        }
        if ((typeParameters = classClass.getTypeParameters()).length == 1) {
            substitutor = substitutor.put(typeParameters[0], operandType);
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(classClass, substitutor);
        if (psiImmediateClassType == null) {
            PsiImplUtil.$$$reportNull$$$0(41);
        }
        return psiImmediateClassType;
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiAnnotationOwner annotationOwner, @NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiImplUtil.$$$reportNull$$$0(42);
        }
        if (annotationOwner == null) {
            return null;
        }
        PsiAnnotation[] annotations2 = annotationOwner.getAnnotations();
        if (annotations2.length == 0) {
            return null;
        }
        String shortName = StringUtil.getShortName((String)qualifiedName);
        for (PsiAnnotation annotation : annotations2) {
            PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
            if (referenceElement == null || !shortName.equals(referenceElement.getReferenceName()) || !qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @Deprecated
    public static PsiAnnotation.TargetType findApplicableTarget(@NotNull PsiAnnotation annotation, PsiAnnotation.TargetType ... types) {
        if (annotation == null) {
            PsiImplUtil.$$$reportNull$$$0(43);
        }
        if (types == null) {
            PsiImplUtil.$$$reportNull$$$0(44);
        }
        return AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])types);
    }

    @Deprecated
    public static PsiAnnotation.TargetType findApplicableTarget(@NotNull PsiClass annotationType, PsiAnnotation.TargetType ... types) {
        if (annotationType == null) {
            PsiImplUtil.$$$reportNull$$$0(45);
        }
        if (types == null) {
            PsiImplUtil.$$$reportNull$$$0(46);
        }
        return AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationType, (PsiAnnotation.TargetType[])types);
    }

    @Deprecated
    @NotNull
    public static PsiAnnotation.TargetType[] getTargetsForLocation(@Nullable PsiAnnotationOwner owner2) {
        PsiAnnotation.TargetType[] targetTypeArray = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)owner2);
        if (targetTypeArray == null) {
            PsiImplUtil.$$$reportNull$$$0(47);
        }
        return targetTypeArray;
    }

    @Nullable
    public static ASTNode findDocComment(@NotNull CompositeElement element) {
        TreeElement node;
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(48);
        }
        for (node = element.getFirstChildNode(); node != null && PsiImplUtil.isWhitespaceOrComment((ASTNode)node) && !(node.getPsi() instanceof PsiDocComment); node = node.getTreeNext()) {
        }
        return node == null || node.getElementType() != JavaDocElementType.DOC_COMMENT ? null : node;
    }

    @Deprecated
    public static PsiType normalizeWildcardTypeByPosition(@NotNull PsiType type2, @NotNull PsiExpression expression2) {
        PsiExpression topLevel;
        if (type2 == null) {
            PsiImplUtil.$$$reportNull$$$0(49);
        }
        if (expression2 == null) {
            PsiImplUtil.$$$reportNull$$$0(50);
        }
        PsiUtilCore.ensureValid((PsiElement)expression2);
        PsiUtil.ensureValidType((PsiType)type2);
        for (topLevel = expression2; topLevel.getParent() instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)topLevel.getParent()).getArrayExpression() == topLevel; topLevel = (PsiExpression)topLevel.getParent()) {
        }
        if (topLevel instanceof PsiArrayAccessExpression && !PsiUtil.isAccessedForWriting((PsiExpression)topLevel)) {
            return PsiUtil.captureToplevelWildcards((PsiType)type2, (PsiElement)expression2);
        }
        PsiType normalized = PsiImplUtil.doNormalizeWildcardByPosition(type2, expression2, topLevel);
        LOG.assertTrue(normalized.isValid(), (Object)type2);
        if (normalized instanceof PsiClassType && !PsiUtil.isAccessedForWriting((PsiExpression)topLevel)) {
            return PsiUtil.captureToplevelWildcards((PsiType)normalized, (PsiElement)expression2);
        }
        return normalized;
    }

    private static PsiType doNormalizeWildcardByPosition(PsiType type2, @NotNull PsiExpression expression2, @NotNull PsiExpression topLevel) {
        PsiType componentType;
        PsiType normalizedComponentType;
        if (expression2 == null) {
            PsiImplUtil.$$$reportNull$$$0(51);
        }
        if (topLevel == null) {
            PsiImplUtil.$$$reportNull$$$0(52);
        }
        if (type2 instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)type2;
            if (PsiUtil.isAccessedForWriting((PsiExpression)topLevel)) {
                return wildcardType.isSuper() ? wildcardType.getBound() : PsiCapturedWildcardType.create((PsiWildcardType)wildcardType, (PsiElement)expression2);
            }
            if (wildcardType.isExtends()) {
                return wildcardType.getBound();
            }
            return PsiType.getJavaLangObject((PsiManager)expression2.getManager(), (GlobalSearchScope)expression2.getResolveScope());
        }
        if (type2 instanceof PsiArrayType && (normalizedComponentType = PsiImplUtil.doNormalizeWildcardByPosition(componentType = ((PsiArrayType)type2).getComponentType(), expression2, topLevel)) != componentType) {
            return normalizedComponentType.createArrayType();
        }
        return type2;
    }

    @NotNull
    public static SearchScope getMemberUseScope(@NotNull PsiMember member) {
        PsiPackage aPackage;
        int accessLevel;
        PsiFile file;
        if (member == null) {
            PsiImplUtil.$$$reportNull$$$0(53);
        }
        PsiMember topElement = (file = member.getContainingFile()) == null ? member : file;
        Project project = topElement.getProject();
        GlobalSearchScope maximalUseScope = ResolveScopeManager.getInstance((Project)project).getUseScope((PsiElement)topElement);
        if (PsiImplUtil.isInServerPage((PsiElement)file)) {
            GlobalSearchScope globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) {
                PsiImplUtil.$$$reportNull$$$0(54);
            }
            return globalSearchScope;
        }
        PsiClass aClass = member.getContainingClass();
        if (!(!(aClass instanceof PsiAnonymousClass) || aClass instanceof PsiEnumConstantInitializer && member instanceof PsiMethod && member.hasModifierProperty("public") && ((PsiMethod)member).findSuperMethods().length > 0)) {
            PsiElement methodCallExpr = PsiUtil.isLanguageLevel8OrHigher((PsiElement)aClass) ? PsiTreeUtil.getTopmostParentOfType((PsiElement)aClass, PsiStatement.class) : PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiMethodCallExpression.class);
            LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)(methodCallExpr != null ? methodCallExpr : aClass));
            if (localSearchScope == null) {
                PsiImplUtil.$$$reportNull$$$0(55);
            }
            return localSearchScope;
        }
        PsiModifierList modifierList = member.getModifierList();
        int n = accessLevel = modifierList == null ? 4 : PsiUtil.getAccessLevel((PsiModifierList)modifierList);
        if (accessLevel == 4 || accessLevel == 3) {
            PsiClass containingClass;
            if (member instanceof PsiMethod && ((PsiMethod)member).isConstructor() && (containingClass = member.getContainingClass()) != null) {
                SearchScope searchScope = containingClass.getUseScope();
                if (searchScope == null) {
                    PsiImplUtil.$$$reportNull$$$0(56);
                }
                return searchScope;
            }
            GlobalSearchScope globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) {
                PsiImplUtil.$$$reportNull$$$0(57);
            }
            return globalSearchScope;
        }
        if (accessLevel == 1) {
            PsiClass topClass = PsiUtil.getTopLevelClass((PsiElement)member);
            Object object = topClass != null ? new LocalSearchScope((PsiElement)topClass) : (file == null ? maximalUseScope : new LocalSearchScope((PsiElement)file));
            if (object == null) {
                PsiImplUtil.$$$reportNull$$$0(58);
            }
            return object;
        }
        if (file instanceof PsiJavaFile && (aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(((PsiJavaFile)file).getPackageName())) != null) {
            GlobalSearchScope scope = PackageScope.packageScope((PsiPackage)aPackage, (boolean)false);
            SearchScope searchScope = scope.intersectWith((SearchScope)maximalUseScope);
            if (searchScope == null) {
                PsiImplUtil.$$$reportNull$$$0(59);
            }
            return searchScope;
        }
        GlobalSearchScope globalSearchScope = maximalUseScope;
        if (globalSearchScope == null) {
            PsiImplUtil.$$$reportNull$$$0(60);
        }
        return globalSearchScope;
    }

    public static boolean isInServerPage(@Nullable PsiElement element) {
        return PsiImplUtil.getServerPageFile(element) != null;
    }

    @Nullable
    private static ServerPageFile getServerPageFile(PsiElement element) {
        PsiFile psiFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)element);
        return psiFile instanceof ServerPageFile ? (ServerPageFile)psiFile : null;
    }

    public static PsiElement setName(@NotNull PsiElement element, @NotNull String name2) throws IncorrectOperationException {
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(61);
        }
        if (name2 == null) {
            PsiImplUtil.$$$reportNull$$$0(62);
        }
        PsiManager manager = element.getManager();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        PsiIdentifier newNameIdentifier = factory.createIdentifier(name2);
        return element.replace((PsiElement)newNameIdentifier);
    }

    public static boolean isDeprecatedByAnnotation(@NotNull PsiModifierListOwner owner2) {
        if (owner2 == null) {
            PsiImplUtil.$$$reportNull$$$0(63);
        }
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)owner2, (String[])new String[]{"java.lang.Deprecated"}) != null;
    }

    public static boolean isDeprecatedByDocTag(@NotNull PsiJavaDocumentedElement owner2) {
        PsiDocComment docComment;
        if (owner2 == null) {
            PsiImplUtil.$$$reportNull$$$0(64);
        }
        return (docComment = owner2.getDocComment()) != null && docComment.findTagByName("deprecated") != null;
    }

    public static boolean isDeprecated(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PsiImplUtil.$$$reportNull$$$0(65);
        }
        if (psiElement instanceof PsiDocCommentOwner) {
            return ((PsiDocCommentOwner)psiElement).isDeprecated();
        }
        if (psiElement instanceof PsiModifierListOwner && PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)psiElement)) {
            return true;
        }
        if (psiElement instanceof PsiJavaDocumentedElement) {
            return PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)psiElement);
        }
        return false;
    }

    @Nullable
    public static PsiJavaDocumentedElement findDocCommentOwner(@NotNull PsiDocComment comment) {
        PsiJavaDocumentedElement owner2;
        PsiElement parent;
        if (comment == null) {
            PsiImplUtil.$$$reportNull$$$0(66);
        }
        if ((parent = comment.getParent()) instanceof PsiJavaDocumentedElement && (owner2 = (PsiJavaDocumentedElement)parent).getDocComment() == comment) {
            return owner2;
        }
        return null;
    }

    @Nullable
    public static PsiAnnotationMemberValue setDeclaredAttributeValue(@NotNull PsiAnnotation psiAnnotation, @Nullable String attributeName, @Nullable PsiAnnotationMemberValue value2, @NotNull PairFunction<? super Project, ? super String, ? extends PsiAnnotation> annotationCreator) {
        if (psiAnnotation == null) {
            PsiImplUtil.$$$reportNull$$$0(67);
        }
        if (annotationCreator == null) {
            PsiImplUtil.$$$reportNull$$$0(68);
        }
        PsiAnnotationMemberValue existing = psiAnnotation.findDeclaredAttributeValue(attributeName);
        if (value2 == null) {
            if (existing == null) {
                return null;
            }
            existing.getParent().delete();
        } else if (existing != null) {
            ((PsiNameValuePair)existing.getParent()).setValue(value2);
        } else {
            PsiNameValuePair attribute;
            PsiNameValuePair[] attributes = psiAnnotation.getParameterList().getAttributes();
            if (attributes.length == 1 && (attribute = attributes[0]).getName() == null) {
                PsiAnnotationMemberValue defValue = attribute.getValue();
                assert (defValue != null) : attribute;
                attribute.replace((PsiElement)PsiImplUtil.createNameValuePair(defValue, "value=", annotationCreator));
            }
            boolean allowNoName = attributes.length == 0 && ("value".equals(attributeName) || null == attributeName);
            String namePrefix = allowNoName ? "" : attributeName + "=";
            psiAnnotation.getParameterList().addBefore((PsiElement)PsiImplUtil.createNameValuePair(value2, namePrefix, annotationCreator), null);
        }
        return psiAnnotation.findDeclaredAttributeValue(attributeName);
    }

    private static PsiNameValuePair createNameValuePair(@NotNull PsiAnnotationMemberValue value2, @NotNull String namePrefix, @NotNull PairFunction<? super Project, ? super String, ? extends PsiAnnotation> annotationCreator) {
        if (value2 == null) {
            PsiImplUtil.$$$reportNull$$$0(69);
        }
        if (namePrefix == null) {
            PsiImplUtil.$$$reportNull$$$0(70);
        }
        if (annotationCreator == null) {
            PsiImplUtil.$$$reportNull$$$0(71);
        }
        return ((PsiAnnotation)annotationCreator.fun((Object)value2.getProject(), (Object)("@A(" + namePrefix + value2.getText() + ")"))).getParameterList().getAttributes()[0];
    }

    @Nullable
    public static ASTNode skipWhitespaceAndComments(ASTNode node) {
        return TreeUtil.skipWhitespaceAndComments((ASTNode)node, (boolean)true);
    }

    @Nullable
    public static ASTNode skipWhitespaceCommentsAndTokens(ASTNode node, @NotNull TokenSet alsoSkip) {
        if (alsoSkip == null) {
            PsiImplUtil.$$$reportNull$$$0(72);
        }
        return TreeUtil.skipWhitespaceCommentsAndTokens((ASTNode)node, (TokenSet)alsoSkip, (boolean)true);
    }

    public static boolean isWhitespaceOrComment(ASTNode element) {
        return TreeUtil.isWhitespaceOrComment((ASTNode)element);
    }

    @Nullable
    public static ASTNode skipWhitespaceAndCommentsBack(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (!PsiImplUtil.isWhitespaceOrComment(node)) {
            return node;
        }
        ASTNode parent = node.getTreeParent();
        ASTNode prev = node;
        while (prev instanceof CompositeElement) {
            if (!PsiImplUtil.isWhitespaceOrComment(prev)) {
                return prev;
            }
            prev = prev.getTreePrev();
        }
        if (prev == null) {
            return null;
        }
        ASTNode lastRelevant = null;
        for (ASTNode firstChildNode = parent.getFirstChildNode(); firstChildNode != prev; firstChildNode = firstChildNode.getTreeNext()) {
            if (PsiImplUtil.isWhitespaceOrComment(firstChildNode)) continue;
            lastRelevant = firstChildNode;
        }
        return lastRelevant;
    }

    @Nullable
    public static ASTNode findStatementChild(@NotNull CompositePsiElement statement) {
        if (statement == null) {
            PsiImplUtil.$$$reportNull$$$0(73);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (TreeElement element = statement.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (!(element.getPsi() instanceof PsiStatement)) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public static PsiStatement[] getChildStatements(@NotNull CompositeElement psiCodeBlock) {
        if (psiCodeBlock == null) {
            PsiImplUtil.$$$reportNull$$$0(74);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = 0;
        for (TreeElement child1 = psiCodeBlock.getFirstChildNode(); child1 != null; child1 = child1.getTreeNext()) {
            if (!(child1.getPsi() instanceof PsiStatement)) continue;
            ++count;
        }
        PsiStatement[] result = (PsiStatement[])PsiStatement.ARRAY_FACTORY.create(count);
        if (count == 0) {
            if (result == null) {
                PsiImplUtil.$$$reportNull$$$0(75);
            }
            return result;
        }
        int idx = 0;
        for (TreeElement child = psiCodeBlock.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            PsiElement element = child.getPsi();
            if (!(element instanceof PsiStatement)) continue;
            result[idx++] = (PsiStatement)element;
        }
        if (result == null) {
            PsiImplUtil.$$$reportNull$$$0(76);
        }
        return result;
    }

    public static boolean isVarArgs(@NotNull PsiMethod method) {
        PsiParameter[] parameters2;
        if (method == null) {
            PsiImplUtil.$$$reportNull$$$0(77);
        }
        return (parameters2 = method.getParameterList().getParameters()).length > 0 && parameters2[parameters2.length - 1].isVarArgs();
    }

    public static PsiElement handleMirror(PsiElement element) {
        return element instanceof PsiMirrorElement ? ((PsiMirrorElement)element).getPrototype() : element;
    }

    @Nullable
    public static PsiModifierList findNeighbourModifierList(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement grandParent;
        PsiElement parent;
        if (ref == null) {
            PsiImplUtil.$$$reportNull$$$0(78);
        }
        if ((parent = PsiTreeUtil.skipParentsOfType((PsiElement)ref, (Class[])new Class[]{PsiJavaCodeReferenceElement.class})) instanceof PsiTypeElement && (grandParent = parent.getParent()) instanceof PsiModifierListOwner) {
            return ((PsiModifierListOwner)grandParent).getModifierList();
        }
        return null;
    }

    public static boolean isTypeAnnotation(@Nullable PsiElement element) {
        return element instanceof PsiAnnotation && AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)((PsiAnnotation)element));
    }

    public static void collectTypeUseAnnotations(@NotNull PsiModifierList modifierList, @NotNull List<? super PsiAnnotation> annotations2) {
        if (modifierList == null) {
            PsiImplUtil.$$$reportNull$$$0(79);
        }
        if (annotations2 == null) {
            PsiImplUtil.$$$reportNull$$$0(80);
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            if (!AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)annotation)) continue;
            annotations2.add((PsiAnnotation)annotation);
        }
    }

    public static void markTypeAnnotations(@NotNull PsiTypeElement typeElement) {
        PsiElement left;
        if (typeElement == null) {
            PsiImplUtil.$$$reportNull$$$0(81);
        }
        if ((left = PsiTreeUtil.skipSiblingsBackward((PsiElement)typeElement, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class})) instanceof PsiModifierList) {
            for (PsiAnnotation annotation : ((PsiModifierList)left).getAnnotations()) {
                if (!AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)annotation)) continue;
                annotation.putUserData(TYPE_ANNO_MARK, (Object)Boolean.TRUE);
            }
        }
    }

    public static void deleteTypeAnnotations(@NotNull PsiTypeElement typeElement) {
        PsiElement left;
        if (typeElement == null) {
            PsiImplUtil.$$$reportNull$$$0(82);
        }
        if ((left = PsiTreeUtil.skipSiblingsBackward((PsiElement)typeElement, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class})) instanceof PsiModifierList) {
            for (PsiAnnotation annotation : ((PsiModifierList)left).getAnnotations()) {
                if (TYPE_ANNO_MARK.get((UserDataHolder)annotation) != Boolean.TRUE) continue;
                annotation.delete();
            }
        }
    }

    @Contract(value="null -> false")
    public static boolean isUnqualifiedReference(@Nullable PsiExpression expression2) {
        return expression2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression2).getQualifierExpression() == null;
    }

    @Nullable
    public static PsiLoopStatement findEnclosingLoop(@NotNull PsiElement start) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(83);
        }
        PsiElement e = start;
        while (!PsiImplUtil.isCodeBoundary(e)) {
            if (e instanceof PsiLoopStatement) {
                return (PsiLoopStatement)e;
            }
            e = e.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement findEnclosingSwitchOrLoop(@NotNull PsiElement start) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(84);
        }
        PsiElement e = start;
        while (!PsiImplUtil.isCodeBoundary(e)) {
            if (e instanceof PsiSwitchBlock || e instanceof PsiLoopStatement) {
                return e;
            }
            e = e.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiLabeledStatement findEnclosingLabeledStatement(@NotNull PsiElement start, @NotNull String label) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(85);
        }
        if (label == null) {
            PsiImplUtil.$$$reportNull$$$0(86);
        }
        PsiElement e = start;
        while (!PsiImplUtil.isCodeBoundary(e)) {
            if (e instanceof PsiLabeledStatement && label.equals(((PsiLabeledStatement)e).getName())) {
                return (PsiLabeledStatement)e;
            }
            e = e.getParent();
        }
        return null;
    }

    @NotNull
    public static List<String> findAllEnclosingLabels(@NotNull PsiElement start) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(87);
        }
        SmartList result = new SmartList();
        PsiElement context = start;
        while (!PsiImplUtil.isCodeBoundary(context)) {
            if (context instanceof PsiLabeledStatement) {
                result.add(((PsiLabeledStatement)context).getName());
            }
            context = context.getContext();
        }
        SmartList smartList = result;
        if (smartList == null) {
            PsiImplUtil.$$$reportNull$$$0(88);
        }
        return smartList;
    }

    private static boolean isCodeBoundary(@Nullable PsiElement e) {
        return e == null || e instanceof PsiMethod || e instanceof PsiClassInitializer || e instanceof PsiLambdaExpression;
    }

    @Nullable
    public static PsiSwitchLabelStatementBase getSwitchLabel(@NotNull PsiExpression expression2) {
        PsiElement grand;
        PsiElement parent;
        if (expression2 == null) {
            PsiImplUtil.$$$reportNull$$$0(89);
        }
        if ((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent())) instanceof PsiExpressionList && (grand = parent.getParent()) instanceof PsiSwitchLabelStatementBase) {
            return (PsiSwitchLabelStatementBase)grand;
        }
        return null;
    }

    public static boolean isLeafElementOfType(@Nullable PsiElement element, @NotNull IElementType type2) {
        if (type2 == null) {
            PsiImplUtil.$$$reportNull$$$0(90);
        }
        return element instanceof LeafElement && ((LeafElement)element).getElementType() == type2;
    }

    public static boolean isLeafElementOfType(PsiElement element, @NotNull TokenSet tokenSet) {
        if (tokenSet == null) {
            PsiImplUtil.$$$reportNull$$$0(91);
        }
        return element instanceof LeafElement && tokenSet.contains(((LeafElement)element).getElementType());
    }

    public static PsiType buildTypeFromTypeString(@NotNull String typeName, @NotNull PsiElement context, @NotNull PsiFile psiFile) {
        Object resultType;
        PsiClass aClass;
        if (typeName == null) {
            PsiImplUtil.$$$reportNull$$$0(92);
        }
        if (context == null) {
            PsiImplUtil.$$$reportNull$$$0(93);
        }
        if (psiFile == null) {
            PsiImplUtil.$$$reportNull$$$0(94);
        }
        PsiManager psiManager = psiFile.getManager();
        if (typeName.indexOf(60) != -1 || typeName.indexOf(91) != -1 || typeName.indexOf(46) == -1) {
            try {
                return JavaPsiFacade.getElementFactory((Project)psiManager.getProject()).createTypeFromText(typeName, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((aClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(typeName, context.getResolveScope())) == null) {
            LightClassReference ref = new LightClassReference(psiManager, PsiNameHelper.getShortClassName((String)typeName), typeName, PsiSubstitutor.EMPTY, (PsiElement)psiFile);
            resultType = new PsiClassReferenceType(ref, null);
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiManager.getProject());
            PsiSubstitutor substitutor = factory.createRawSubstitutor((PsiTypeParameterListOwner)aClass);
            resultType = factory.createType(aClass, substitutor);
        }
        return resultType;
    }

    @NotNull
    public static <T extends PsiJavaCodeReferenceElement> JavaResolveResult[] multiResolveImpl(@NotNull T element, boolean incompleteCode, @NotNull ResolveCache.PolyVariantContextResolver<? super T> resolver) {
        PsiManager manager;
        FileASTNode fileElement;
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(95);
        }
        if (resolver == null) {
            PsiImplUtil.$$$reportNull$$$0(96);
        }
        if ((fileElement = SharedImplUtil.findFileElement((ASTNode)element.getNode())) == null) {
            PsiUtilCore.ensureValid(element);
            LOG.error("fileElement == null!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiImplUtil.$$$reportNull$$$0(97);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiFile psiFile = SharedImplUtil.getContainingFile((ASTNode)fileElement);
        PsiManager psiManager = manager = psiFile == null ? null : psiFile.getManager();
        if (manager == null) {
            PsiUtilCore.ensureValid(element);
            LOG.error("getManager() == null!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiImplUtil.$$$reportNull$$$0(98);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        boolean valid = psiFile.isValid();
        if (!valid) {
            PsiUtilCore.ensureValid(element);
            LOG.error("psiFile.isValid() == false!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiImplUtil.$$$reportNull$$$0(99);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        if (element instanceof PsiMethodReferenceExpression && ThreadLocalTypes.hasBindingFor(element)) {
            JavaResolveResult[] javaResolveResultArray = (JavaResolveResult[])resolver.resolve(element, psiFile, incompleteCode);
            if (javaResolveResultArray == null) {
                PsiImplUtil.$$$reportNull$$$0(100);
            }
            return javaResolveResultArray;
        }
        JavaResolveResult[] javaResolveResultArray = PsiImplUtil.multiResolveImpl(manager.getProject(), psiFile, element, incompleteCode, resolver);
        if (javaResolveResultArray == null) {
            PsiImplUtil.$$$reportNull$$$0(101);
        }
        return javaResolveResultArray;
    }

    @NotNull
    public static <T extends PsiJavaCodeReferenceElement> JavaResolveResult[] multiResolveImpl(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull T element, boolean incompleteCode, @NotNull ResolveCache.PolyVariantContextResolver<? super T> resolver) {
        ResolveResult[] results;
        if (project == null) {
            PsiImplUtil.$$$reportNull$$$0(102);
        }
        if (psiFile == null) {
            PsiImplUtil.$$$reportNull$$$0(103);
        }
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(104);
        }
        if (resolver == null) {
            PsiImplUtil.$$$reportNull$$$0(105);
        }
        JavaResolveResult[] javaResolveResultArray = (results = ResolveCache.getInstance((Project)project).resolveWithCaching(element, resolver, true, incompleteCode, psiFile)).length == 0 ? JavaResolveResult.EMPTY_ARRAY : (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            PsiImplUtil.$$$reportNull$$$0(106);
        }
        return javaResolveResultArray;
    }

    public static VirtualFile getModuleVirtualFile(@NotNull PsiJavaModule module) {
        if (module == null) {
            PsiImplUtil.$$$reportNull$$$0(107);
        }
        return module instanceof LightJavaModule ? ((LightJavaModule)module).getRootVirtualFile() : module.getContainingFile().getVirtualFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 75: 
            case 76: 
            case 88: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 106: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 75: 
            case 76: 
            case 88: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 106: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 75: 
            case 76: 
            case 88: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiImplUtil";
                break;
            }
            case 2: 
            case 3: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 4: 
            case 32: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 11: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 17: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 18: 
            case 22: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: 
            case 23: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 20: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
            case 25: 
            case 48: 
            case 61: 
            case 95: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceList";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElements";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classAccessExpression";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationType";
                break;
            }
            case 49: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 50: 
            case 51: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevel";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationCreator";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePrefix";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alsoSkip";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiCodeBlock";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 94: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 96: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiImplUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "namesToPackageReferences";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceVariantsByFilter";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "typesByReferenceParameterList";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "typesByTypeElements";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsForLocation";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberUseScope";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildStatements";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllEnclosingLabels";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConstructors";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 75: 
            case 76: 
            case 88: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 106: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredAttributeValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAttributeValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameters";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "namesToPackageReferences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParameterIndex";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterIndex";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceVariantsByFilter";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInMethod";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInLambda";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInMethodLike";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInResourceList";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeParameters";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "typesByReferenceParameterList";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "typesByTypeElements";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findApplicableTarget";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "normalizeWildcardTypeByPosition";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "doNormalizeWildcardByPosition";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getMemberUseScope";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecatedByAnnotation";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecatedByDocTag";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecated";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findDocCommentOwner";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "setDeclaredAttributeValue";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "createNameValuePair";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceCommentsAndTokens";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "findStatementChild";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getChildStatements";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isVarArgs";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "findNeighbourModifierList";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "collectTypeUseAnnotations";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "markTypeAnnotations";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "deleteTypeAnnotations";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingLoop";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingSwitchOrLoop";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingLabeledStatement";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "findAllEnclosingLabels";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchLabel";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "isLeafElementOfType";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromTypeString";
                break;
            }
            case 95: 
            case 96: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveImpl";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getModuleVirtualFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 75: 
            case 76: 
            case 88: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 106: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

