/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSectionDetector;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementParseInfo;
import com.intellij.psi.codeStyle.arrangement.JavaElementArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.JavaSectionArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaArrangementVisitor
extends JavaRecursiveElementVisitor {
    private static final String NULL_CONTENT = "no content";
    private static final Map<String, ArrangementSettingsToken> MODIFIERS = new HashMap<String, ArrangementSettingsToken>();
    private static final ArrangementSettingsToken ANON_CLASS_PARAMETER_LIST;
    private static final ArrangementSettingsToken ANONYMOUS_CLASS_BODY;
    @NotNull
    private final Stack<JavaElementArrangementEntry> myStack;
    @NotNull
    private final Map<PsiElement, JavaElementArrangementEntry> myEntries;
    @NotNull
    private final JavaArrangementParseInfo myInfo;
    @NotNull
    private final Collection<? extends TextRange> myRanges;
    @NotNull
    private final Set<ArrangementSettingsToken> myGroupingRules;
    @NotNull
    private final MethodBodyProcessor myMethodBodyProcessor;
    private final boolean myCheckDeep;
    @NotNull
    private final ArrangementSectionDetector mySectionDetector;
    @Nullable
    private final Document myDocument;
    @NotNull
    private final HashMap<PsiClass, Set<PsiField>> myCachedClassFields;
    @NotNull
    private final Set<PsiComment> myProcessedSectionsComments;

    JavaArrangementVisitor(@NotNull JavaArrangementParseInfo infoHolder, @Nullable Document document, @NotNull Collection<? extends TextRange> ranges, @NotNull ArrangementSettings settings, boolean checkDeep) {
        if (infoHolder == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(0);
        }
        if (ranges == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(2);
        }
        this.myStack = new Stack();
        this.myEntries = new HashMap<PsiElement, JavaElementArrangementEntry>();
        this.myCachedClassFields = new HashMap();
        this.myProcessedSectionsComments = new HashSet<PsiComment>();
        this.myInfo = infoHolder;
        this.myDocument = document;
        this.myRanges = ranges;
        this.myGroupingRules = JavaArrangementVisitor.getGroupingRules(settings);
        this.myMethodBodyProcessor = new MethodBodyProcessor(infoHolder);
        this.myCheckDeep = checkDeep;
        this.mySectionDetector = new ArrangementSectionDetector(document, settings, data -> {
            TextRange range = data.getTextRange();
            JavaSectionArrangementEntry entry = new JavaSectionArrangementEntry((ArrangementEntry)this.getCurrent(), data.getToken(), range, data.getText(), true);
            this.registerEntry(data.getElement(), entry);
        });
    }

    public void visitComment(PsiComment comment) {
        if (this.myProcessedSectionsComments.contains(comment)) {
            return;
        }
        this.mySectionDetector.processComment(comment);
    }

    @NotNull
    private static Set<ArrangementSettingsToken> getGroupingRules(@NotNull ArrangementSettings settings) {
        if (settings == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(3);
        }
        HashSet<ArrangementSettingsToken> groupingRules = new HashSet<ArrangementSettingsToken>();
        for (ArrangementGroupingRule rule : settings.getGroupings()) {
            groupingRules.add(rule.getGroupingType());
        }
        HashSet<ArrangementSettingsToken> hashSet = groupingRules;
        if (hashSet == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private void createAndProcessAnonymousClassBodyEntry(@NotNull PsiAnonymousClass aClass) {
        if (aClass == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(5);
        }
        PsiElement lBrace = aClass.getLBrace();
        PsiElement rBrace = aClass.getRBrace();
        if (lBrace == null || rBrace == null) {
            return;
        }
        TextRange codeBlockRange = new TextRange(lBrace.getTextRange().getStartOffset(), rBrace.getTextRange().getEndOffset());
        JavaElementArrangementEntry entry = this.createNewEntry(lBrace, codeBlockRange, ANONYMOUS_CLASS_BODY, aClass.getName(), true);
        if (entry == null) {
            return;
        }
        this.processChildrenWithinEntryScope(entry, () -> {
            PsiElement current = lBrace;
            while (current != rBrace && (current = current.getNextSibling()) != null) {
                current.accept((PsiElementVisitor)this);
            }
        });
    }

    public void visitClass(PsiClass aClass) {
        boolean isSectionCommentsDetected = this.registerSectionComments((PsiElement)aClass);
        TextRange range = isSectionCommentsDetected ? JavaArrangementVisitor.getElementRangeWithoutComments((PsiElement)aClass) : aClass.getTextRange();
        ArrangementSettingsToken type2 = StdArrangementTokens.EntryType.CLASS;
        if (aClass.isEnum()) {
            type2 = StdArrangementTokens.EntryType.ENUM;
        } else if (aClass.isInterface()) {
            type2 = StdArrangementTokens.EntryType.INTERFACE;
        }
        JavaElementArrangementEntry entry = this.createNewEntry((PsiElement)aClass, range, type2, aClass.getName(), true);
        this.processEntry(entry, (PsiModifierListOwner)aClass, (PsiElement)aClass);
    }

    public void visitTypeParameter(PsiTypeParameter parameter2) {
    }

    public void visitAnonymousClass(PsiAnonymousClass aClass) {
        JavaElementArrangementEntry entry = this.createNewEntry((PsiElement)aClass, aClass.getTextRange(), StdArrangementTokens.EntryType.ANONYMOUS_CLASS, aClass.getName(), true);
        if (entry == null) {
            return;
        }
        this.processChildrenWithinEntryScope(entry, () -> {
            PsiExpressionList list = aClass.getArgumentList();
            if (list != null && list.getTextLength() > 0) {
                JavaElementArrangementEntry listEntry = this.createNewEntry((PsiElement)list, list.getTextRange(), ANON_CLASS_PARAMETER_LIST, aClass.getName(), true);
                this.processEntry(listEntry, null, (PsiElement)list);
            }
            this.createAndProcessAnonymousClassBodyEntry(aClass);
        });
    }

    public void visitField(PsiField field) {
        JavaElementArrangementEntry entry;
        boolean isSectionCommentsDetected = this.registerSectionComments((PsiElement)field);
        PsiElement fieldPrev = JavaArrangementVisitor.getPreviousNonWsComment(field.getPrevSibling(), 0);
        if (PsiUtil.isJavaToken((PsiElement)fieldPrev, (IElementType)JavaTokenType.COMMA)) {
            return;
        }
        TextRange range = isSectionCommentsDetected ? JavaArrangementVisitor.getElementRangeWithoutComments((PsiElement)field) : field.getTextRange();
        PsiElement child = field.getLastChild();
        boolean needSpecialProcessing = true;
        if (JavaArrangementVisitor.isSemicolon(child)) {
            needSpecialProcessing = false;
        } else if (child instanceof PsiComment) {
            PsiElement prev = JavaArrangementVisitor.getPreviousNonWsComment(child, range.getStartOffset());
            boolean bl = needSpecialProcessing = prev != null && !JavaArrangementVisitor.isSemicolon(prev);
        }
        if (needSpecialProcessing) {
            for (PsiElement e = field.getNextSibling(); e != null; e = e.getNextSibling()) {
                if (e instanceof PsiWhiteSpace || e instanceof PsiComment) continue;
                if (e instanceof PsiJavaToken) {
                    if (((PsiJavaToken)e).getTokenType() != JavaTokenType.COMMA) break;
                    continue;
                }
                if (!(e instanceof PsiField)) break;
                PsiElement c = e.getLastChild();
                if (c != null) {
                    c = JavaArrangementVisitor.getPreviousNonWsComment(c, range.getStartOffset());
                }
                if (!(c instanceof PsiErrorElement) && !PsiUtil.isJavaToken((PsiElement)c, (IElementType)JavaTokenType.SEMICOLON)) continue;
                range = TextRange.create((int)range.getStartOffset(), (int)this.expandToCommentIfPossible(c));
                break;
            }
        }
        if ((entry = this.createNewEntry((PsiElement)field, range, StdArrangementTokens.EntryType.FIELD, field.getName(), true)) == null) {
            return;
        }
        this.processEntry(entry, (PsiModifierListOwner)field, (PsiElement)field.getInitializer());
        this.myInfo.onFieldEntryCreated(field, entry);
        List<PsiField> referencedFields = this.getReferencedFields(field);
        for (PsiField referencedField : referencedFields) {
            this.myInfo.registerFieldInitializationDependency(field, referencedField);
        }
    }

    @NotNull
    private List<PsiField> getReferencedFields(final @NotNull PsiField field) {
        if (field == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(6);
        }
        final ArrayList<PsiField> referencedElements = new ArrayList<PsiField>();
        PsiExpression fieldInitializer = field.getInitializer();
        PsiClass containingClass = field.getContainingClass();
        if (fieldInitializer == null || containingClass == null) {
            ArrayList<PsiField> arrayList = referencedElements;
            if (arrayList == null) {
                JavaArrangementVisitor.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        Set classFields = this.myCachedClassFields.get(containingClass);
        if (classFields == null) {
            classFields = ContainerUtil.map2Set((Object[])containingClass.getFields(), (Function)Functions.id());
            this.myCachedClassFields.put(containingClass, classFields);
        }
        final Set containingClassFields = classFields;
        fieldInitializer.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){
            int myCurrentMethodLookupDepth;
            private static final int MAX_METHOD_LOOKUP_DEPTH = 3;

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                PsiElement ref = expression2.resolve();
                if (ref instanceof PsiField && containingClassFields.contains(ref) && JavaArrangementVisitor.hasSameStaticModifier(field, (PsiField)ref)) {
                    referencedElements.add((PsiField)ref);
                } else if (ref instanceof PsiMethod && this.myCurrentMethodLookupDepth < 3) {
                    ++this.myCurrentMethodLookupDepth;
                    this.visitMethod((PsiMethod)ref);
                    --this.myCurrentMethodLookupDepth;
                }
                super.visitReferenceExpression(expression2);
            }
        });
        ArrayList<PsiField> arrayList = referencedElements;
        if (arrayList == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static boolean hasSameStaticModifier(@NotNull PsiField first, @NotNull PsiField second) {
        if (first == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(9);
        }
        if (second == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(10);
        }
        boolean isSecondFieldStatic = second.hasModifierProperty("static");
        return first.hasModifierProperty("static") == isSecondFieldStatic;
    }

    @Nullable
    private static PsiElement getPreviousNonWsComment(@Nullable PsiElement element, int minOffset) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element; e != null && e.getTextRange().getStartOffset() >= minOffset; e = e.getPrevSibling()) {
            if (e instanceof PsiWhiteSpace || e instanceof PsiComment) continue;
            return e;
        }
        return null;
    }

    private int expandToCommentIfPossible(@NotNull PsiElement element) {
        if (element == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(11);
        }
        if (this.myDocument == null) {
            return element.getTextRange().getEndOffset();
        }
        CharSequence text2 = this.myDocument.getCharsSequence();
        for (PsiElement e = element.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (e instanceof PsiWhiteSpace) {
                if (!JavaArrangementVisitor.hasLineBreak(text2, e.getTextRange())) continue;
                return element.getTextRange().getEndOffset();
            }
            if (e instanceof PsiComment) {
                if (JavaArrangementVisitor.hasLineBreak(text2, e.getTextRange())) continue;
                return e.getTextRange().getEndOffset();
            }
            return element.getTextRange().getEndOffset();
        }
        return element.getTextRange().getEndOffset();
    }

    private static boolean hasLineBreak(@NotNull CharSequence text2, @NotNull TextRange range) {
        if (text2 == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(12);
        }
        if (range == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(13);
        }
        int end = range.getEndOffset();
        for (int i = range.getStartOffset(); i < end; ++i) {
            if (text2.charAt(i) != '\n') continue;
            return true;
        }
        return false;
    }

    private static boolean isSemicolon(@Nullable PsiElement e) {
        return PsiUtil.isJavaToken((PsiElement)e, (IElementType)JavaTokenType.SEMICOLON);
    }

    public void visitClassInitializer(PsiClassInitializer initializer) {
        JavaElementArrangementEntry entry = this.createNewEntry((PsiElement)initializer, initializer.getTextRange(), StdArrangementTokens.EntryType.INIT_BLOCK, null, true);
        if (entry == null) {
            return;
        }
        JavaArrangementVisitor.parseModifiers(initializer.getModifierList(), entry);
    }

    @NotNull
    private static TextRange getElementRangeWithoutComments(@NotNull PsiElement element) {
        if (element == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(14);
        }
        PsiElement[] children = element.getChildren();
        assert (children.length > 1 && children[0] instanceof PsiComment);
        int i = 0;
        PsiElement child = children[i];
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment) {
            child = children[++i];
        }
        TextRange textRange = new TextRange(child.getTextRange().getStartOffset(), element.getTextRange().getEndOffset());
        if (textRange == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(15);
        }
        return textRange;
    }

    @NotNull
    private static List<PsiComment> getComments(@NotNull PsiElement element) {
        if (element == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(16);
        }
        PsiElement[] children = element.getChildren();
        ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
        for (PsiElement e : children) {
            if (e instanceof PsiComment) {
                comments.add((PsiComment)e);
                continue;
            }
            if (e instanceof PsiWhiteSpace) continue;
            ArrayList<PsiComment> arrayList = comments;
            if (arrayList == null) {
                JavaArrangementVisitor.$$$reportNull$$$0(17);
            }
            return arrayList;
        }
        ArrayList<PsiComment> arrayList = comments;
        if (arrayList == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMethod(PsiMethod method) {
        ArrangementSettingsToken type2;
        boolean isSectionCommentsDetected = this.registerSectionComments((PsiElement)method);
        TextRange range = isSectionCommentsDetected ? JavaArrangementVisitor.getElementRangeWithoutComments((PsiElement)method) : method.getTextRange();
        JavaElementArrangementEntry entry = this.createNewEntry((PsiElement)method, range, type2 = method.isConstructor() ? StdArrangementTokens.EntryType.CONSTRUCTOR : StdArrangementTokens.EntryType.METHOD, method.getName(), true);
        if (entry == null) {
            return;
        }
        this.processEntry(entry, (PsiModifierListOwner)method, (PsiElement)(this.myCheckDeep ? method.getBody() : null));
        this.parseProperties(method, entry);
        this.myInfo.onMethodEntryCreated(method, entry);
        MethodSignatureBackedByPsiMethod overridden = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
        if (overridden != null) {
            entry.addModifier(StdArrangementTokens.Modifier.OVERRIDDEN);
            this.myInfo.onOverriddenMethod(overridden.getMethod(), method);
        }
        boolean reset = this.myMethodBodyProcessor.setBaseMethod(method);
        try {
            method.accept((PsiElementVisitor)this.myMethodBodyProcessor);
        }
        finally {
            if (reset) {
                this.myMethodBodyProcessor.setBaseMethod(null);
            }
        }
    }

    private boolean registerSectionComments(@NotNull PsiElement element) {
        if (element == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(19);
        }
        List<PsiComment> comments = JavaArrangementVisitor.getComments(element);
        boolean isSectionCommentsDetected = false;
        for (PsiComment comment : comments) {
            if (!this.mySectionDetector.processComment(comment)) continue;
            isSectionCommentsDetected = true;
            this.myProcessedSectionsComments.add(comment);
        }
        return isSectionCommentsDetected;
    }

    private void parseProperties(PsiMethod method, JavaElementArrangementEntry entry) {
        String propertyName = null;
        boolean getter = true;
        if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method)) {
            entry.addModifier(StdArrangementTokens.Modifier.GETTER);
            propertyName = PropertyUtilBase.getPropertyNameByGetter((PsiMethod)method);
        } else if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) {
            entry.addModifier(StdArrangementTokens.Modifier.SETTER);
            propertyName = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)method);
            getter = false;
        }
        if (!this.myGroupingRules.contains(StdArrangementTokens.Grouping.GETTERS_AND_SETTERS) || propertyName == null) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        String className2 = null;
        if (containingClass != null) {
            className2 = containingClass.getQualifiedName();
        }
        if (className2 == null) {
            className2 = NULL_CONTENT;
        }
        if (getter) {
            this.myInfo.registerGetter(propertyName, className2, entry);
        } else {
            this.myInfo.registerSetter(propertyName, className2, entry);
        }
    }

    public void visitEnumConstant(PsiEnumConstant enumConstant) {
    }

    private void processEntry(@Nullable JavaElementArrangementEntry entry, @Nullable PsiModifierListOwner modifier, @Nullable PsiElement nextPsiRoot) {
        if (entry == null) {
            return;
        }
        if (modifier != null) {
            JavaArrangementVisitor.parseModifiers(modifier.getModifierList(), entry);
        }
        if (nextPsiRoot == null) {
            return;
        }
        this.processChildrenWithinEntryScope(entry, () -> nextPsiRoot.acceptChildren((PsiElementVisitor)this));
    }

    private void processChildrenWithinEntryScope(@NotNull JavaElementArrangementEntry entry, @NotNull Runnable childrenProcessing) {
        if (entry == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(20);
        }
        if (childrenProcessing == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(21);
        }
        this.myStack.push((Object)entry);
        try {
            childrenProcessing.run();
        }
        finally {
            this.myStack.pop();
        }
    }

    private void registerEntry(@NotNull PsiElement element, @NotNull JavaElementArrangementEntry entry) {
        if (element == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(22);
        }
        if (entry == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(23);
        }
        this.myEntries.put(element, entry);
        DefaultArrangementEntry current = this.getCurrent();
        if (current == null) {
            this.myInfo.addEntry(entry);
        } else {
            current.addChild((ArrangementEntry)entry);
        }
    }

    @Nullable
    private JavaElementArrangementEntry createNewEntry(@NotNull PsiElement element, @NotNull TextRange range, @NotNull ArrangementSettingsToken type2, @Nullable String name2, boolean canArrange) {
        JavaElementArrangementEntry entry;
        if (element == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(24);
        }
        if (range == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(25);
        }
        if (type2 == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(26);
        }
        if (!this.isWithinBounds(range)) {
            return null;
        }
        DefaultArrangementEntry current = this.getCurrent();
        if (canArrange) {
            TextRange expandedRange = this.myDocument == null ? null : ArrangementUtil.expandToLineIfPossible((TextRange)range, (Document)this.myDocument);
            TextRange rangeToUse = expandedRange == null ? range : expandedRange;
            entry = new JavaElementArrangementEntry((ArrangementEntry)current, rangeToUse, type2, name2, true);
        } else {
            entry = new JavaElementArrangementEntry((ArrangementEntry)current, range, type2, name2, false);
        }
        this.registerEntry(element, entry);
        return entry;
    }

    private boolean isWithinBounds(@NotNull TextRange range) {
        if (range == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(27);
        }
        for (TextRange textRange : this.myRanges) {
            if (!textRange.intersects(range)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private DefaultArrangementEntry getCurrent() {
        return this.myStack.isEmpty() ? null : (DefaultArrangementEntry)this.myStack.peek();
    }

    private static void parseModifiers(@Nullable PsiModifierList modifierList, @NotNull JavaElementArrangementEntry entry) {
        if (entry == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(28);
        }
        if (modifierList == null) {
            return;
        }
        for (String modifier : PsiModifier.MODIFIERS) {
            ArrangementSettingsToken arrangementModifier;
            if (!modifierList.hasModifierProperty(modifier) || (arrangementModifier = MODIFIERS.get(modifier)) == null) continue;
            entry.addModifier(arrangementModifier);
        }
        if (modifierList.hasModifierProperty("packageLocal")) {
            entry.addModifier(StdArrangementTokens.Modifier.PACKAGE_PRIVATE);
        }
    }

    static {
        MODIFIERS.put("public", StdArrangementTokens.Modifier.PUBLIC);
        MODIFIERS.put("protected", StdArrangementTokens.Modifier.PROTECTED);
        MODIFIERS.put("private", StdArrangementTokens.Modifier.PRIVATE);
        MODIFIERS.put("packageLocal", StdArrangementTokens.Modifier.PACKAGE_PRIVATE);
        MODIFIERS.put("static", StdArrangementTokens.Modifier.STATIC);
        MODIFIERS.put("final", StdArrangementTokens.Modifier.FINAL);
        MODIFIERS.put("transient", StdArrangementTokens.Modifier.TRANSIENT);
        MODIFIERS.put("volatile", StdArrangementTokens.Modifier.VOLATILE);
        MODIFIERS.put("synchronized", StdArrangementTokens.Modifier.SYNCHRONIZED);
        MODIFIERS.put("abstract", StdArrangementTokens.Modifier.ABSTRACT);
        ANON_CLASS_PARAMETER_LIST = new ArrangementSettingsToken("Dummy", "not matchable anon class argument list");
        ANONYMOUS_CLASS_BODY = new ArrangementSettingsToken("Dummy", "not matchable anonymous class body");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 20: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenProcessing";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupingRules";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedFields";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementRangeWithoutComments";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getComments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGroupingRules";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAndProcessAnonymousClassBodyEntry";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedFields";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasSameStaticModifier";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expandToCommentIfPossible";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasLineBreak";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getElementRangeWithoutComments";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getComments";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerSectionComments";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processChildrenWithinEntryScope";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "registerEntry";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createNewEntry";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isWithinBounds";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "parseModifiers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MethodBodyProcessor
    extends JavaRecursiveElementVisitor {
        @NotNull
        private final JavaArrangementParseInfo myInfo;
        @Nullable
        private PsiMethod myBaseMethod;

        MethodBodyProcessor(@NotNull JavaArrangementParseInfo info) {
            if (info == null) {
                MethodBodyProcessor.$$$reportNull$$$0(0);
            }
            this.myInfo = info;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression psiMethodCallExpression) {
            PsiReference reference = psiMethodCallExpression.getMethodExpression().getReference();
            if (reference == null) {
                return;
            }
            PsiElement e = reference.resolve();
            if (e instanceof PsiMethod) {
                assert (this.myBaseMethod != null);
                PsiMethod m = (PsiMethod)e;
                if (m.getContainingClass() == this.myBaseMethod.getContainingClass()) {
                    this.myInfo.registerMethodCallDependency(this.myBaseMethod, m);
                }
            }
            super.visitMethodCallExpression(psiMethodCallExpression);
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)expression2.resolve(), PsiMethod.class);
            if (method == null) {
                return;
            }
            assert (this.myBaseMethod != null);
            if (method.getContainingClass() == this.myBaseMethod.getContainingClass()) {
                this.myInfo.registerMethodCallDependency(this.myBaseMethod, method);
            }
        }

        boolean setBaseMethod(@Nullable PsiMethod baseMethod) {
            if (baseMethod == null || this.myBaseMethod == null) {
                this.myBaseMethod = baseMethod;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor$MethodBodyProcessor", "<init>"));
        }
    }
}

