/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplatesFactory;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.intellij.lang.annotations.Language;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteTemplatesFactory
extends ProjectTemplatesFactory {
    private static final Logger LOG = Logger.getInstance(RemoteTemplatesFactory.class);
    private static final String URL = "https://download.jetbrains.com/idea/project_templates/";
    private final ClearableLazyValue<MultiMap<String, ArchivedProjectTemplate>> myTemplates = ClearableLazyValue.create(() -> {
        try {
            return (MultiMap)HttpRequests.request((String)(URL + ApplicationInfo.getInstance().getBuild().getProductCode() + "_templates.xml")).connect(request -> {
                try {
                    return RemoteTemplatesFactory.create(JDOMUtil.load((Reader)request.getReader()));
                }
                catch (JDOMException e) {
                    LOG.error((Throwable)e);
                    return MultiMap.emptyInstance();
                }
            });
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return MultiMap.emptyInstance();
    });

    @NotNull
    public String[] getGroups() {
        this.myTemplates.drop();
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)((MultiMap)this.myTemplates.getValue()).keySet());
        if (stringArray == null) {
            RemoteTemplatesFactory.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @NotNull
    public ProjectTemplate[] createTemplates(@Nullable String group, WizardContext context) {
        Collection templates = ((MultiMap)this.myTemplates.getValue()).get((Object)group);
        ProjectTemplate[] projectTemplateArray = templates.isEmpty() ? ProjectTemplate.EMPTY_ARRAY : templates.toArray(ProjectTemplate.EMPTY_ARRAY);
        if (projectTemplateArray == null) {
            RemoteTemplatesFactory.$$$reportNull$$$0(1);
        }
        return projectTemplateArray;
    }

    @NotNull
    public static MultiMap<String, ArchivedProjectTemplate> createFromText(@NotNull @Language(value="XML") String value2) throws IOException, JDOMException {
        if (value2 == null) {
            RemoteTemplatesFactory.$$$reportNull$$$0(2);
        }
        MultiMap<String, ArchivedProjectTemplate> multiMap = RemoteTemplatesFactory.create(JDOMUtil.load((CharSequence)value2));
        if (multiMap == null) {
            RemoteTemplatesFactory.$$$reportNull$$$0(3);
        }
        return multiMap;
    }

    @NotNull
    private static MultiMap<String, ArchivedProjectTemplate> create(@NotNull Element element) {
        if (element == null) {
            RemoteTemplatesFactory.$$$reportNull$$$0(4);
        }
        MultiMap map2 = MultiMap.create();
        for (ArchivedProjectTemplate template : RemoteTemplatesFactory.createGroupTemplates(element)) {
            map2.putValue((Object)template.getCategory(), (Object)template);
        }
        MultiMap multiMap = map2;
        if (multiMap == null) {
            RemoteTemplatesFactory.$$$reportNull$$$0(5);
        }
        return multiMap;
    }

    private static List<ArchivedProjectTemplate> createGroupTemplates(Element groupElement) {
        List children = groupElement.getChildren("template");
        return ContainerUtil.mapNotNull((Collection)children, (Function)((NullableFunction)element -> {
            if (!RemoteTemplatesFactory.checkRequiredPlugins(element)) {
                return null;
            }
            ModuleType moduleType = ModuleTypeManager.getInstance().findByID(element.getChildText("moduleType"));
            String path = element.getChildText("path");
            String description = element.getChildTextTrim("description");
            String name2 = element.getChildTextTrim("name");
            RemoteProjectTemplate template = new RemoteProjectTemplate(name2, (Element)element, moduleType, path, description);
            template.populateFromElement((Element)element);
            return template;
        }));
    }

    private static boolean checkRequiredPlugins(Element element) {
        for (Element plugin : element.getChildren("requiredPlugin")) {
            if (PluginManager.isPluginInstalled((PluginId)PluginId.getId((String)plugin.getTextTrim()))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/templates/RemoteTemplatesFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroups";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplates";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/templates/RemoteTemplatesFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFromText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoteProjectTemplate
    extends ArchivedProjectTemplate {
        private final ModuleType myModuleType;
        private final String myPath;
        private final String myDescription;

        RemoteProjectTemplate(String name2, Element element, ModuleType moduleType, String path, String description) {
            super(name2, element.getChildTextTrim("category"));
            this.myModuleType = moduleType;
            this.myPath = path;
            this.myDescription = description;
        }

        protected ModuleType getModuleType() {
            return this.myModuleType;
        }

        public <T> T processStream(@NotNull ArchivedProjectTemplate.StreamProcessor<T> consumer) throws IOException {
            if (consumer == null) {
                RemoteProjectTemplate.$$$reportNull$$$0(0);
            }
            return (T)HttpRequests.request((String)(RemoteTemplatesFactory.URL + this.myPath)).connect(request -> RemoteProjectTemplate.consumeZipStream((ArchivedProjectTemplate.StreamProcessor)consumer, (ZipInputStream)new ZipInputStream(request.getInputStream())));
        }

        @Nullable
        public String getDescription() {
            return this.myDescription;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/platform/templates/RemoteTemplatesFactory$RemoteProjectTemplate", "processStream"));
        }
    }
}

