/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ModulePackagingElementBase;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleElementTypeBase<E extends ModulePackagingElementBase>
extends PackagingElementType<E> {
    public ModuleElementTypeBase(String id, String presentableName) {
        super(id, presentableName);
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            ModuleElementTypeBase.$$$reportNull$$$0(0);
        }
        if (artifact == null) {
            ModuleElementTypeBase.$$$reportNull$$$0(1);
        }
        return !this.getSuitableModules(context).isEmpty();
    }

    @NotNull
    public List<? extends PackagingElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            ModuleElementTypeBase.$$$reportNull$$$0(2);
        }
        if (artifact == null) {
            ModuleElementTypeBase.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            ModuleElementTypeBase.$$$reportNull$$$0(4);
        }
        List<Module> suitableModules = this.getSuitableModules(context);
        List selected = context.chooseModules(suitableModules, ProjectBundle.message((String)"dialog.title.packaging.choose.module", (Object[])new Object[0]));
        ArrayList<ModulePackagingElementBase> elements = new ArrayList<ModulePackagingElementBase>();
        ModulePointerManager pointerManager = ModulePointerManager.getInstance((Project)context.getProject());
        for (Module module : selected) {
            elements.add(this.createElement(context.getProject(), pointerManager.create(module)));
        }
        ArrayList<ModulePackagingElementBase> arrayList = elements;
        if (arrayList == null) {
            ModuleElementTypeBase.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    protected abstract ModulePackagingElementBase createElement(@NotNull Project var1, @NotNull ModulePointer var2);

    private List<Module> getSuitableModules(ArtifactEditorContext context) {
        ModulesProvider modulesProvider = context.getModulesProvider();
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module module : modulesProvider.getModules()) {
            if (!this.isSuitableModule(modulesProvider, module)) continue;
            modules.add(module);
        }
        return modules;
    }

    public abstract boolean isSuitableModule(@NotNull ModulesProvider var1, @NotNull Module var2);

    @NotNull
    public abstract String getElementText(@NotNull String var1);

    public Icon getElementIcon(@Nullable Module module) {
        return module != null ? ModuleType.get((Module)module).getIcon() : AllIcons.Modules.Output;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/ModuleElementTypeBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/ModuleElementTypeBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseAndCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canCreate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndCreate";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

