/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LibraryElementType
extends ComplexPackagingElementType<LibraryPackagingElement> {
    public static final LibraryElementType LIBRARY_ELEMENT_TYPE = new LibraryElementType();

    LibraryElementType() {
        super("library", CompilerBundle.message((String)"element.type.name.library.files", (Object[])new Object[0]));
    }

    public Icon getCreateElementIcon() {
        return PlatformIcons.LIBRARY_ICON;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            LibraryElementType.$$$reportNull$$$0(0);
        }
        if (artifact == null) {
            LibraryElementType.$$$reportNull$$$0(1);
        }
        return !LibraryElementType.getAllLibraries(context).isEmpty();
    }

    @NotNull
    public List<? extends LibraryPackagingElement> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            LibraryElementType.$$$reportNull$$$0(2);
        }
        if (artifact == null) {
            LibraryElementType.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            LibraryElementType.$$$reportNull$$$0(4);
        }
        List selected = context.chooseLibraries(ProjectBundle.message((String)"dialog.title.packaging.choose.library", (Object[])new Object[0]));
        ArrayList<LibraryPackagingElement> elements = new ArrayList<LibraryPackagingElement>();
        for (Library library : selected) {
            elements.add(new LibraryPackagingElement(library.getTable().getTableLevel(), library.getName(), null));
        }
        ArrayList<LibraryPackagingElement> arrayList = elements;
        if (arrayList == null) {
            LibraryElementType.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static List<Library> getAllLibraries(ArtifactEditorContext context) {
        ArrayList<Library> libraries2 = new ArrayList<Library>();
        ContainerUtil.addAll(libraries2, (Object[])LibraryTablesRegistrar.getInstance().getLibraryTable().getLibraries());
        ContainerUtil.addAll(libraries2, (Object[])LibraryTablesRegistrar.getInstance().getLibraryTable(context.getProject()).getLibraries());
        return libraries2;
    }

    @NotNull
    public LibraryPackagingElement createEmpty(@NotNull Project project) {
        if (project == null) {
            LibraryElementType.$$$reportNull$$$0(6);
        }
        LibraryPackagingElement libraryPackagingElement = new LibraryPackagingElement();
        if (libraryPackagingElement == null) {
            LibraryElementType.$$$reportNull$$$0(7);
        }
        return libraryPackagingElement;
    }

    public String getShowContentActionText() {
        return "Show Library Files";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/LibraryElementType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/LibraryElementType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseAndCreate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmpty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canCreate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndCreate";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEmpty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

