/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.JarArtifactFromModulesDialog;
import com.intellij.packaging.impl.artifacts.JarArtifactType;
import com.intellij.packaging.impl.artifacts.PlainArtifactType;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.packaging.impl.elements.TestModuleOutputElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class JarFromModulesTemplate
extends ArtifactTemplate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.packaging.impl.artifacts.JarFromModulesTemplate");
    private final PackagingElementResolvingContext myContext;

    public JarFromModulesTemplate(PackagingElementResolvingContext context) {
        this.myContext = context;
    }

    public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
        JarArtifactFromModulesDialog dialog = new JarArtifactFromModulesDialog(this.myContext);
        if (!dialog.showAndGet()) {
            return null;
        }
        return this.doCreateArtifact(dialog.getSelectedModules(), dialog.getMainClassName(), dialog.getDirectoryForManifest(), dialog.isExtractLibrariesToJar(), dialog.isIncludeTests());
    }

    @Nullable
    public ArtifactTemplate.NewArtifactConfiguration doCreateArtifact(Module[] modules, String mainClassName, final String directoryForManifest, boolean extractLibrariesToJar, boolean includeTests) {
        VirtualFile manifestFile = null;
        Project project = this.myContext.getProject();
        if (mainClassName != null && !mainClassName.isEmpty() || !extractLibrariesToJar) {
            VirtualFile directory;
            try {
                directory = (VirtualFile)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

                    public VirtualFile compute() throws IOException {
                        return VfsUtil.createDirectoryIfMissing((String)directoryForManifest);
                    }
                });
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                Messages.showErrorDialog((Project)project, (String)("Cannot create directory '" + directoryForManifest + "': " + e.getMessage()), (String)CommonBundle.getErrorTitle());
                return null;
            }
            if (directory == null) {
                return null;
            }
            manifestFile = ManifestFileUtil.createManifestFile(directory, project);
            if (manifestFile == null) {
                return null;
            }
            ManifestFileUtil.updateManifest(manifestFile, mainClassName, null, true);
        }
        String name2 = modules.length == 1 ? modules[0].getName() : project.getName();
        PackagingElementFactory factory = PackagingElementFactory.getInstance();
        CompositePackagingElement archive = factory.createArchive(ArtifactUtil.suggestArtifactFileName(name2) + ".jar");
        OrderEnumerator orderEnumerator = ProjectRootManager.getInstance((Project)project).orderEntries(Arrays.asList(modules));
        THashSet libraries2 = new THashSet();
        if (!includeTests) {
            orderEnumerator = orderEnumerator.productionOnly();
        }
        ModulesProvider modulesProvider = this.myContext.getModulesProvider();
        OrderEnumerator enumerator = orderEnumerator.using((RootModelProvider)modulesProvider).withoutSdk().runtimeOnly().recursively();
        enumerator.forEachLibrary((Processor)new CommonProcessors.CollectProcessor((Collection)libraries2));
        enumerator.forEachModule(module -> {
            if (ProductionModuleOutputElementType.ELEMENT_TYPE.isSuitableModule(modulesProvider, (Module)module)) {
                archive.addOrFindChild(factory.createModuleOutput(module));
            }
            if (includeTests && TestModuleOutputElementType.ELEMENT_TYPE.isSuitableModule(modulesProvider, (Module)module)) {
                archive.addOrFindChild(factory.createTestModuleOutput(module));
            }
            return true;
        });
        JarArtifactType jarArtifactType = JarArtifactType.getInstance();
        if (manifestFile != null && !manifestFile.equals(ManifestFileUtil.findManifestFile(archive, this.myContext, jarArtifactType))) {
            archive.addFirstChild(factory.createFileCopyWithParentDirectories(manifestFile.getPath(), ManifestFileUtil.MANIFEST_DIR_NAME));
        }
        String artifactName = name2 + ":jar";
        if (extractLibrariesToJar) {
            JarFromModulesTemplate.addExtractedLibrariesToJar(archive, factory, (Set<? extends Library>)libraries2);
            return new ArtifactTemplate.NewArtifactConfiguration(archive, artifactName, (ArtifactType)jarArtifactType);
        }
        ArtifactRootElement root = factory.createArtifactRootElement();
        ArrayList<String> classpath = new ArrayList<String>();
        root.addOrFindChild((PackagingElement)archive);
        this.addLibraries((Set<? extends Library>)libraries2, root, archive, classpath);
        ManifestFileUtil.updateManifest(manifestFile, mainClassName, classpath, true);
        return new ArtifactTemplate.NewArtifactConfiguration((CompositePackagingElement)root, artifactName, (ArtifactType)PlainArtifactType.getInstance());
    }

    private void addLibraries(Set<? extends Library> libraries2, ArtifactRootElement<?> root, CompositePackagingElement<?> archive, List<? super String> classpath) {
        PackagingElementFactory factory = PackagingElementFactory.getInstance();
        for (Library library : libraries2) {
            if (LibraryPackagingElement.getKindForLibrary(library).containsDirectoriesWithClasses()) {
                for (VirtualFile classesRoot : library.getFiles(OrderRootType.CLASSES)) {
                    if (classesRoot.isInLocalFileSystem()) {
                        archive.addOrFindChild(factory.createDirectoryCopyWithParentDirectories(classesRoot.getPath(), "/"));
                        continue;
                    }
                    PackagingElement child = factory.createFileCopyWithParentDirectories(VfsUtil.getLocalFile((VirtualFile)classesRoot).getPath(), "/");
                    root.addOrFindChild(child);
                    classpath.addAll(ManifestFileUtil.getClasspathForElements(Collections.singletonList(child), this.myContext, PlainArtifactType.getInstance()));
                }
                continue;
            }
            List children = factory.createLibraryElements(library);
            classpath.addAll(ManifestFileUtil.getClasspathForElements(children, this.myContext, PlainArtifactType.getInstance()));
            root.addOrFindChildren((Collection)children);
        }
    }

    private static void addExtractedLibrariesToJar(CompositePackagingElement<?> archive, PackagingElementFactory factory, Set<? extends Library> libraries2) {
        for (Library library : libraries2) {
            if (LibraryPackagingElement.getKindForLibrary(library).containsJarFiles()) {
                for (VirtualFile classesRoot : library.getFiles(OrderRootType.CLASSES)) {
                    if (classesRoot.isInLocalFileSystem()) {
                        archive.addOrFindChild(factory.createDirectoryCopyWithParentDirectories(classesRoot.getPath(), "/"));
                        continue;
                    }
                    archive.addOrFindChild(factory.createExtractedDirectory(classesRoot));
                }
                continue;
            }
            archive.addOrFindChildren((Collection)factory.createLibraryElements(library));
        }
    }

    public String getPresentableName() {
        return "From modules with dependencies...";
    }
}

