/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.lang.IdeLanguageCustomization;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import com.intellij.openapi.vcs.checkout.ProjectCheckoutListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectCheckoutListener
implements CheckoutListener {
    private static final Logger LOG = Logger.getInstance(NewProjectCheckoutListener.class);

    public boolean processCheckedOutDirectory(Project project, File directory) {
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(directory);
        LOG.assertTrue(file != null, (Object)("Can't find " + directory));
        String projectKind = IdeLanguageCustomization.getInstance().getPrimaryIdeLanguages().contains(JavaLanguage.INSTANCE) ? ProjectCheckoutListener.getProductNameWithArticle() : "a Java";
        int rc = Messages.showYesNoDialog((Project)project, (String)VcsBundle.message((String)"checkout.create.project.prompt", (Object[])new Object[]{projectKind, directory.getAbsolutePath()}), (String)VcsBundle.message((String)"checkout.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (rc == 0) {
            AddModuleWizard wizard = this.createImportWizard(file);
            if (wizard == null) {
                return false;
            }
            if (wizard.showAndGet()) {
                ImportModuleAction.createFromWizard(null, wizard);
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected AddModuleWizard createImportWizard(@NotNull VirtualFile file) {
        if (file == null) {
            NewProjectCheckoutListener.$$$reportNull$$$0(0);
        }
        return ImportModuleAction.createImportWizard(null, null, file, (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions());
    }

    public void processOpenedProject(Project lastOpenedProject) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/checkout/NewProjectCheckoutListener", "createImportWizard"));
    }
}

