/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectStructureValidator {
    private static final ExtensionPointName<ProjectStructureValidator> EP_NAME = ExtensionPointName.create((String)"com.intellij.projectStructureValidator");

    public static List<ProjectStructureElementUsage> getUsagesInElement(ProjectStructureElement element) {
        for (ProjectStructureValidator validator2 : (ProjectStructureValidator[])EP_NAME.getExtensions()) {
            List<ProjectStructureElementUsage> usages = validator2.getUsagesIn(element);
            if (usages == null) continue;
            return usages;
        }
        return element.getUsagesInElement();
    }

    public static void check(ProjectStructureElement element, ProjectStructureProblemsHolder problemsHolder) {
        for (ProjectStructureValidator validator2 : (ProjectStructureValidator[])EP_NAME.getExtensions()) {
            if (!validator2.checkElement(element, problemsHolder)) continue;
            return;
        }
        element.check(problemsHolder);
    }

    public static void showDialogAndAddLibraryToDependencies(Library library, Project project, boolean allowEmptySelection) {
        for (ProjectStructureValidator validator2 : (ProjectStructureValidator[])EP_NAME.getExtensions()) {
            if (!validator2.addLibraryToDependencies(library, project, allowEmptySelection)) continue;
            return;
        }
        ModuleStructureConfigurable moduleStructureConfigurable = ModuleStructureConfigurable.getInstance(project);
        List<Module> modules = LibraryEditingUtil.getSuitableModules(moduleStructureConfigurable, (LibraryKind)((LibraryEx)library).getKind(), library);
        if (modules.isEmpty()) {
            return;
        }
        ChooseModulesDialog dlg = new ChooseModulesDialog(moduleStructureConfigurable.getProject(), modules, ProjectBundle.message((String)"choose.modules.dialog.title", (Object[])new Object[0]), ProjectBundle.message((String)"choose.modules.dialog.description", (Object[])new Object[]{library.getName()}));
        if (dlg.showAndGet()) {
            List chosenModules = dlg.getChosenElements();
            for (Module module : chosenModules) {
                moduleStructureConfigurable.addLibraryOrderEntry(module, library);
            }
        }
    }

    protected boolean addLibraryToDependencies(Library library, Project project, boolean allowEmptySelection) {
        return false;
    }

    protected boolean checkElement(ProjectStructureElement element, ProjectStructureProblemsHolder problemsHolder) {
        return false;
    }

    @Nullable
    protected List<ProjectStructureElementUsage> getUsagesIn(ProjectStructureElement element) {
        return null;
    }
}

