/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import gnu.trove.THashMap;
import java.util.EventListener;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureConfigurableContext
implements Disposable,
LibraryEditorListener {
    private final ProjectStructureDaemonAnalyzer myDaemonAnalyzer;
    public final ModulesConfigurator myModulesConfigurator;
    public final Map<String, LibrariesModifiableModel> myLevel2Providers = new THashMap();
    private final EventDispatcher<LibraryEditorListener> myLibraryEditorListeners = EventDispatcher.create(LibraryEditorListener.class);
    private final Project myProject;

    public StructureConfigurableContext(Project project, ModulesConfigurator modulesConfigurator) {
        this.myProject = project;
        this.myModulesConfigurator = modulesConfigurator;
        Disposer.register((Disposable)project, (Disposable)this);
        this.myDaemonAnalyzer = new ProjectStructureDaemonAnalyzer(this);
    }

    public VirtualFile[] getLibraryFiles(Library library, OrderRootType type2) {
        LibrariesModifiableModel librariesModel;
        LibraryTable.ModifiableModel modifiableModel;
        LibraryTable table = library.getTable();
        if (table != null && (modifiableModel = this.getModifiableLibraryTable(table)) instanceof LibrariesModifiableModel && (librariesModel = (LibrariesModifiableModel)modifiableModel).hasLibraryEditor(library)) {
            return librariesModel.getLibraryEditor(library).getFiles(type2);
        }
        return library.getFiles(type2);
    }

    public Project getProject() {
        return this.myProject;
    }

    public ProjectStructureDaemonAnalyzer getDaemonAnalyzer() {
        return this.myDaemonAnalyzer;
    }

    public void dispose() {
    }

    public ModulesConfigurator getModulesConfigurator() {
        return this.myModulesConfigurator;
    }

    public Module[] getModules() {
        return this.myModulesConfigurator.getModules();
    }

    public String getRealName(Module module) {
        return this.myModulesConfigurator.getModuleModel().getActualName(module);
    }

    public void resetLibraries() {
        LibraryTablesRegistrar tablesRegistrar = LibraryTablesRegistrar.getInstance();
        this.myLevel2Providers.clear();
        this.myLevel2Providers.put("application", new LibrariesModifiableModel(tablesRegistrar.getLibraryTable(), this.myProject, this));
        this.myLevel2Providers.put("project", new LibrariesModifiableModel(tablesRegistrar.getLibraryTable(this.myProject), this.myProject, this));
        for (LibraryTable table : tablesRegistrar.getCustomLibraryTables()) {
            this.myLevel2Providers.put(table.getTableLevel(), new LibrariesModifiableModel(table, this.myProject, this));
        }
    }

    public void addLibraryEditorListener(LibraryEditorListener listener) {
        this.myLibraryEditorListeners.addListener((EventListener)listener);
    }

    public void addLibraryEditorListener(@NotNull LibraryEditorListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            StructureConfigurableContext.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            StructureConfigurableContext.$$$reportNull$$$0(1);
        }
        this.myLibraryEditorListeners.addListener((EventListener)listener, parentDisposable);
    }

    @Override
    public void libraryRenamed(@NotNull Library library, String oldName, String newName) {
        if (library == null) {
            StructureConfigurableContext.$$$reportNull$$$0(2);
        }
        ((LibraryEditorListener)this.myLibraryEditorListeners.getMulticaster()).libraryRenamed(library, oldName, newName);
    }

    @NotNull
    public StructureLibraryTableModifiableModelProvider getGlobalLibrariesProvider() {
        StructureLibraryTableModifiableModelProvider structureLibraryTableModifiableModelProvider = this.createModifiableModelProvider("application");
        if (structureLibraryTableModifiableModelProvider == null) {
            StructureConfigurableContext.$$$reportNull$$$0(3);
        }
        return structureLibraryTableModifiableModelProvider;
    }

    @NotNull
    public StructureLibraryTableModifiableModelProvider createModifiableModelProvider(@NotNull String level) {
        if (level == null) {
            StructureConfigurableContext.$$$reportNull$$$0(4);
        }
        StructureLibraryTableModifiableModelProvider structureLibraryTableModifiableModelProvider = new StructureLibraryTableModifiableModelProvider(level, this);
        if (structureLibraryTableModifiableModelProvider == null) {
            StructureConfigurableContext.$$$reportNull$$$0(5);
        }
        return structureLibraryTableModifiableModelProvider;
    }

    @NotNull
    public StructureLibraryTableModifiableModelProvider getProjectLibrariesProvider() {
        StructureLibraryTableModifiableModelProvider structureLibraryTableModifiableModelProvider = this.createModifiableModelProvider("project");
        if (structureLibraryTableModifiableModelProvider == null) {
            StructureConfigurableContext.$$$reportNull$$$0(6);
        }
        return structureLibraryTableModifiableModelProvider;
    }

    public LibraryTable.ModifiableModel getModifiableLibraryTable(@NotNull LibraryTable table) {
        String tableLevel;
        if (table == null) {
            StructureConfigurableContext.$$$reportNull$$$0(7);
        }
        if ((tableLevel = table.getTableLevel()).equals("module")) {
            return table.getModifiableModel();
        }
        return this.myLevel2Providers.get(tableLevel);
    }

    @Nullable
    public Library getLibrary(String libraryName, @NotNull String libraryLevel) {
        LibrariesModifiableModel model;
        if (libraryLevel == null) {
            StructureConfigurableContext.$$$reportNull$$$0(8);
        }
        return (model = this.myLevel2Providers.get(libraryLevel)) == null ? null : StructureConfigurableContext.findLibraryModel(libraryName, model);
    }

    @Nullable
    private static Library findLibraryModel(@NotNull String libraryName, @NotNull LibrariesModifiableModel model) {
        if (libraryName == null) {
            StructureConfigurableContext.$$$reportNull$$$0(9);
        }
        if (model == null) {
            StructureConfigurableContext.$$$reportNull$$$0(10);
        }
        for (Library library : model.getLibraries()) {
            Library libraryModel = StructureConfigurableContext.findLibraryModel(library, model);
            if (libraryModel == null || !libraryName.equals(libraryModel.getName())) continue;
            return libraryModel;
        }
        return null;
    }

    @Nullable
    public Library getLibraryModel(@NotNull Library library) {
        LibraryTable libraryTable;
        if (library == null) {
            StructureConfigurableContext.$$$reportNull$$$0(11);
        }
        if ((libraryTable = library.getTable()) != null) {
            return StructureConfigurableContext.findLibraryModel(library, this.myLevel2Providers.get(libraryTable.getTableLevel()));
        }
        return library;
    }

    @Nullable
    private static Library findLibraryModel(Library library, LibrariesModifiableModel tableModel) {
        if (tableModel == null) {
            return library;
        }
        if (tableModel.wasLibraryRemoved(library)) {
            return null;
        }
        return tableModel.hasLibraryEditor(library) ? (Library)tableModel.getLibraryEditor(library).getModel() : library;
    }

    public void reset() {
        this.resetLibraries();
        this.myModulesConfigurator.resetModuleEditors();
        this.myDaemonAnalyzer.reset();
    }

    public void clear() {
        this.myLevel2Providers.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryLevel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalLibrariesProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModifiableModelProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectLibrariesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryEditorListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "libraryRenamed";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModifiableModelProvider";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableLibraryTable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLibrary";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryModel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

