/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibrariesContainerFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory");
    private static final Library[] EMPTY_LIBRARIES_ARRAY = Library.EMPTY_ARRAY;

    private LibrariesContainerFactory() {
    }

    @NotNull
    public static LibrariesContainer createContainer(@Nullable Project project) {
        LibrariesContainerImpl librariesContainerImpl = new LibrariesContainerImpl(project, null, null);
        if (librariesContainerImpl == null) {
            LibrariesContainerFactory.$$$reportNull$$$0(0);
        }
        return librariesContainerImpl;
    }

    @NotNull
    public static LibrariesContainer createContainer(@NotNull Module module) {
        if (module == null) {
            LibrariesContainerFactory.$$$reportNull$$$0(1);
        }
        LibrariesContainerImpl librariesContainerImpl = new LibrariesContainerImpl(module.getProject(), module, null);
        if (librariesContainerImpl == null) {
            LibrariesContainerFactory.$$$reportNull$$$0(2);
        }
        return librariesContainerImpl;
    }

    @NotNull
    public static LibrariesContainer createContainer(@NotNull ModifiableRootModel rootModel) {
        if (rootModel == null) {
            LibrariesContainerFactory.$$$reportNull$$$0(3);
        }
        Module module = rootModel.getModule();
        LibrariesContainerImpl librariesContainerImpl = new LibrariesContainerImpl(module.getProject(), module, rootModel);
        if (librariesContainerImpl == null) {
            LibrariesContainerFactory.$$$reportNull$$$0(4);
        }
        return librariesContainerImpl;
    }

    public static LibrariesContainer createContainer(StructureConfigurableContext context) {
        return new StructureConfigurableLibrariesContainer(context);
    }

    public static Library createLibrary(@Nullable LibrariesContainer container1, @NotNull LibrariesContainer container2, @NotNull @NonNls NewLibraryEditor editor, @NotNull LibrariesContainer.LibraryLevel level) {
        if (container2 == null) {
            LibrariesContainerFactory.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            LibrariesContainerFactory.$$$reportNull$$$0(6);
        }
        if (level == null) {
            LibrariesContainerFactory.$$$reportNull$$$0(7);
        }
        if (container1 != null && container1.canCreateLibrary(level)) {
            return container1.createLibrary(editor, level);
        }
        return container2.createLibrary(editor, level);
    }

    @NotNull
    private static Library createLibraryInTable(@NotNull NewLibraryEditor editor, LibraryTable table) {
        if (editor == null) {
            LibrariesContainerFactory.$$$reportNull$$$0(8);
        }
        LibraryTable.ModifiableModel modifiableModel = table.getModifiableModel();
        String name2 = StringUtil.isEmpty((String)editor.getName()) ? null : LibrariesContainerFactory.getUniqueLibraryName(editor.getName(), modifiableModel);
        LibraryType<?> type2 = editor.getType();
        Library library = modifiableModel.createLibrary(name2, type2 == null ? null : type2.getKind());
        LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        editor.applyTo(model);
        model.commit();
        modifiableModel.commit();
        Library library2 = library;
        if (library2 == null) {
            LibrariesContainerFactory.$$$reportNull$$$0(9);
        }
        return library2;
    }

    private static String getUniqueLibraryName(String baseName, LibraryTable.ModifiableModel model) {
        return UniqueNameGenerator.generateUniqueName((String)baseName, (String)"", (String)"", (String)" (", (String)")", s -> model.getLibraryByName(s) == null);
    }

    @NotNull
    public static LibrariesContainer createContainer(@NotNull WizardContext context, @NotNull ModulesProvider modulesProvider) {
        LibrariesContainer container;
        if (context == null) {
            LibrariesContainerFactory.$$$reportNull$$$0(10);
        }
        if (modulesProvider == null) {
            LibrariesContainerFactory.$$$reportNull$$$0(11);
        }
        if (modulesProvider instanceof ModulesConfigurator) {
            ModulesConfigurator configurator = (ModulesConfigurator)modulesProvider;
            container = LibrariesContainerFactory.createContainer(configurator.getContext());
        } else {
            container = LibrariesContainerFactory.createContainer(context.getProject());
        }
        LibrariesContainer librariesContainer = container;
        if (librariesContainer == null) {
            LibrariesContainerFactory.$$$reportNull$$$0(12);
        }
        return librariesContainer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container2";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createContainer";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryInTable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createContainer";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLibrary";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryInTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StructureConfigurableLibrariesContainer
    extends LibrariesContainerBase {
        private final StructureConfigurableContext myContext;

        StructureConfigurableLibrariesContainer(StructureConfigurableContext context) {
            this.myContext = context;
        }

        @Override
        public Library createLibrary(@NotNull NewLibraryEditor libraryEditor, @NotNull LibrariesContainer.LibraryLevel level) {
            LibraryTableModifiableModelProvider provider;
            if (libraryEditor == null) {
                StructureConfigurableLibrariesContainer.$$$reportNull$$$0(0);
            }
            if (level == null) {
                StructureConfigurableLibrariesContainer.$$$reportNull$$$0(1);
            }
            if ((provider = this.getProvider(level)) == null) {
                LOG.error("cannot create module library in this context");
            }
            LibraryTable.ModifiableModel model = provider.getModifiableModel();
            LibraryType<?> type2 = libraryEditor.getType();
            Library library = model.createLibrary(LibrariesContainerFactory.getUniqueLibraryName(libraryEditor.getName(), model), type2 == null ? null : type2.getKind());
            ExistingLibraryEditor createdLibraryEditor = ((LibrariesModifiableModel)model).getLibraryEditor(library);
            createdLibraryEditor.setProperties(libraryEditor.getProperties());
            libraryEditor.applyTo(createdLibraryEditor);
            return library;
        }

        @Override
        public ExistingLibraryEditor getLibraryEditor(@NotNull Library library) {
            LibraryTable table;
            if (library == null) {
                StructureConfigurableLibrariesContainer.$$$reportNull$$$0(2);
            }
            if ((table = library.getTable()) == null) {
                return null;
            }
            LibraryTable.ModifiableModel model = this.myContext.getModifiableLibraryTable(table);
            if (model instanceof LibrariesModifiableModel) {
                return ((LibrariesModifiableModel)model).getLibraryEditor(library);
            }
            return null;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.myContext.getProject();
        }

        @Override
        @NotNull
        public Library[] getLibraries(@NotNull LibrariesContainer.LibraryLevel libraryLevel) {
            LibraryTableModifiableModelProvider provider;
            if (libraryLevel == null) {
                StructureConfigurableLibrariesContainer.$$$reportNull$$$0(3);
            }
            Library[] libraryArray = (provider = this.getProvider(libraryLevel)) != null ? provider.getModifiableModel().getLibraries() : EMPTY_LIBRARIES_ARRAY;
            if (libraryArray == null) {
                StructureConfigurableLibrariesContainer.$$$reportNull$$$0(4);
            }
            return libraryArray;
        }

        @Nullable
        private LibraryTableModifiableModelProvider getProvider(LibrariesContainer.LibraryLevel libraryLevel) {
            if (libraryLevel == LibrariesContainer.LibraryLevel.PROJECT) {
                return this.myContext.getProjectLibrariesProvider();
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.GLOBAL) {
                return this.myContext.getGlobalLibrariesProvider();
            }
            return null;
        }

        @Override
        public boolean canCreateLibrary(@NotNull LibrariesContainer.LibraryLevel level) {
            if (level == null) {
                StructureConfigurableLibrariesContainer.$$$reportNull$$$0(5);
            }
            return level == LibrariesContainer.LibraryLevel.GLOBAL || level == LibrariesContainer.LibraryLevel.PROJECT;
        }

        @Override
        @NotNull
        public VirtualFile[] getLibraryFiles(@NotNull Library library, @NotNull OrderRootType rootType) {
            LibrariesModifiableModel projectLibrariesModel;
            if (library == null) {
                StructureConfigurableLibrariesContainer.$$$reportNull$$$0(6);
            }
            if (rootType == null) {
                StructureConfigurableLibrariesContainer.$$$reportNull$$$0(7);
            }
            if ((projectLibrariesModel = this.myContext.getProjectLibrariesProvider().getModifiableModel()).hasLibraryEditor(library)) {
                ExistingLibraryEditor libraryEditor = projectLibrariesModel.getLibraryEditor(library);
                VirtualFile[] virtualFileArray = libraryEditor.getFiles(rootType);
                if (virtualFileArray == null) {
                    StructureConfigurableLibrariesContainer.$$$reportNull$$$0(8);
                }
                return virtualFileArray;
            }
            LibrariesModifiableModel globalLibraries = this.myContext.getGlobalLibrariesProvider().getModifiableModel();
            if (globalLibraries.hasLibraryEditor(library)) {
                ExistingLibraryEditor libraryEditor = globalLibraries.getLibraryEditor(library);
                VirtualFile[] virtualFileArray = libraryEditor.getFiles(rootType);
                if (virtualFileArray == null) {
                    StructureConfigurableLibrariesContainer.$$$reportNull$$$0(9);
                }
                return virtualFileArray;
            }
            VirtualFile[] virtualFileArray = library.getFiles(rootType);
            if (virtualFileArray == null) {
                StructureConfigurableLibrariesContainer.$$$reportNull$$$0(10);
            }
            return virtualFileArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryEditor";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryLevel";
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraries";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createLibrary";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraries";
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "canCreateLibrary";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryFiles";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LibrariesContainerImpl
    extends LibrariesContainerBase {
        @Nullable
        private final Project myProject;
        @Nullable
        private final Module myModule;
        @Nullable
        private final ModifiableRootModel myRootModel;

        private LibrariesContainerImpl(@Nullable Project project, @Nullable Module module, @Nullable ModifiableRootModel rootModel) {
            this.myProject = project;
            this.myModule = module;
            this.myRootModel = rootModel;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @Override
        @NotNull
        public Library[] getLibraries(@NotNull LibrariesContainer.LibraryLevel libraryLevel) {
            if (libraryLevel == null) {
                LibrariesContainerImpl.$$$reportNull$$$0(0);
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.MODULE && this.myModule != null) {
                Library[] libraryArray = this.getModuleLibraries();
                if (libraryArray == null) {
                    LibrariesContainerImpl.$$$reportNull$$$0(1);
                }
                return libraryArray;
            }
            LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
            if (libraryLevel == LibrariesContainer.LibraryLevel.GLOBAL) {
                Library[] libraryArray = registrar.getLibraryTable().getLibraries();
                if (libraryArray == null) {
                    LibrariesContainerImpl.$$$reportNull$$$0(2);
                }
                return libraryArray;
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.PROJECT && this.myProject != null) {
                Library[] libraryArray = registrar.getLibraryTable(this.myProject).getLibraries();
                if (libraryArray == null) {
                    LibrariesContainerImpl.$$$reportNull$$$0(3);
                }
                return libraryArray;
            }
            Library[] libraryArray = EMPTY_LIBRARIES_ARRAY;
            if (libraryArray == null) {
                LibrariesContainerImpl.$$$reportNull$$$0(4);
            }
            return libraryArray;
        }

        private Library[] getModuleLibraries() {
            if (this.myRootModel != null) {
                return this.myRootModel.getModuleLibraryTable().getLibraries();
            }
            List libraries2 = OrderEntryUtil.getModuleLibraries((ModuleRootModel)ModuleRootManager.getInstance((Module)this.myModule));
            return libraries2.toArray(Library.EMPTY_ARRAY);
        }

        @Override
        @NotNull
        public VirtualFile[] getLibraryFiles(@NotNull Library library, @NotNull OrderRootType rootType) {
            if (library == null) {
                LibrariesContainerImpl.$$$reportNull$$$0(5);
            }
            if (rootType == null) {
                LibrariesContainerImpl.$$$reportNull$$$0(6);
            }
            VirtualFile[] virtualFileArray = library.getFiles(rootType);
            if (virtualFileArray == null) {
                LibrariesContainerImpl.$$$reportNull$$$0(7);
            }
            return virtualFileArray;
        }

        @Override
        public boolean canCreateLibrary(@NotNull LibrariesContainer.LibraryLevel level) {
            if (level == null) {
                LibrariesContainerImpl.$$$reportNull$$$0(8);
            }
            if (level == LibrariesContainer.LibraryLevel.MODULE) {
                return this.myRootModel != null;
            }
            return level == LibrariesContainer.LibraryLevel.GLOBAL || this.myProject != null;
        }

        @Override
        public Library createLibrary(@NotNull NewLibraryEditor libraryEditor, @NotNull LibrariesContainer.LibraryLevel level) {
            LibraryTable table;
            if (libraryEditor == null) {
                LibrariesContainerImpl.$$$reportNull$$$0(9);
            }
            if (level == null) {
                LibrariesContainerImpl.$$$reportNull$$$0(10);
            }
            if (level == LibrariesContainer.LibraryLevel.MODULE && this.myRootModel != null) {
                return LibrariesContainerFactory.createLibraryInTable(libraryEditor, this.myRootModel.getModuleLibraryTable());
            }
            LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
            if (level == LibrariesContainer.LibraryLevel.GLOBAL) {
                table = registrar.getLibraryTable();
            } else if (level == LibrariesContainer.LibraryLevel.PROJECT && this.myProject != null) {
                table = registrar.getLibraryTable(this.myProject);
            } else {
                return null;
            }
            return LibrariesContainerFactory.createLibraryInTable(libraryEditor, table);
        }

        @Override
        public ExistingLibraryEditor getLibraryEditor(@NotNull Library library) {
            if (library == null) {
                LibrariesContainerImpl.$$$reportNull$$$0(11);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryLevel";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl";
                    break;
                }
                case 5: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraries";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraries";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryFiles";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "canCreateLibrary";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createLibrary";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryEditor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class LibrariesContainerBase
    implements LibrariesContainer {
        private UniqueNameGenerator myNameGenerator;

        private LibrariesContainerBase() {
        }

        @Override
        public Library createLibrary(@NotNull @NonNls String name2, @NotNull LibrariesContainer.LibraryLevel level, @NotNull VirtualFile[] classRoots, @NotNull VirtualFile[] sourceRoots) {
            if (name2 == null) {
                LibrariesContainerBase.$$$reportNull$$$0(0);
            }
            if (level == null) {
                LibrariesContainerBase.$$$reportNull$$$0(1);
            }
            if (classRoots == null) {
                LibrariesContainerBase.$$$reportNull$$$0(2);
            }
            if (sourceRoots == null) {
                LibrariesContainerBase.$$$reportNull$$$0(3);
            }
            NewLibraryEditor editor = new NewLibraryEditor();
            editor.setName(name2);
            for (VirtualFile classRoot : classRoots) {
                editor.addRoot(classRoot, OrderRootType.CLASSES);
            }
            for (VirtualFile sourceRoot : sourceRoots) {
                editor.addRoot(sourceRoot, OrderRootType.SOURCES);
            }
            return this.createLibrary(editor, level);
        }

        @Override
        public Library createLibrary(@NotNull @NonNls String name2, @NotNull LibrariesContainer.LibraryLevel level, @NotNull Collection<? extends OrderRoot> roots) {
            if (name2 == null) {
                LibrariesContainerBase.$$$reportNull$$$0(4);
            }
            if (level == null) {
                LibrariesContainerBase.$$$reportNull$$$0(5);
            }
            if (roots == null) {
                LibrariesContainerBase.$$$reportNull$$$0(6);
            }
            NewLibraryEditor editor = new NewLibraryEditor();
            editor.setName(name2);
            editor.addRoots(roots);
            return this.createLibrary(editor, level);
        }

        @Override
        @NotNull
        public Library[] getAllLibraries() {
            Object[] moduleLibraries;
            Object[] libraries2 = this.getLibraries(LibrariesContainer.LibraryLevel.GLOBAL);
            Object[] projectLibraries = this.getLibraries(LibrariesContainer.LibraryLevel.PROJECT);
            if (projectLibraries.length > 0) {
                libraries2 = (Library[])ArrayUtil.mergeArrays((Object[])libraries2, (Object[])projectLibraries);
            }
            if ((moduleLibraries = this.getLibraries(LibrariesContainer.LibraryLevel.MODULE)).length > 0) {
                libraries2 = (Library[])ArrayUtil.mergeArrays((Object[])libraries2, (Object[])moduleLibraries);
            }
            if (libraries2 == null) {
                LibrariesContainerBase.$$$reportNull$$$0(7);
            }
            return libraries2;
        }

        @Override
        @NotNull
        public List<LibrariesContainer.LibraryLevel> getAvailableLevels() {
            ArrayList<LibrariesContainer.LibraryLevel> levels = new ArrayList<LibrariesContainer.LibraryLevel>();
            for (LibrariesContainer.LibraryLevel level : LibrariesContainer.LibraryLevel.values()) {
                if (!this.canCreateLibrary(level)) continue;
                levels.add(level);
            }
            ArrayList<LibrariesContainer.LibraryLevel> arrayList = levels;
            if (arrayList == null) {
                LibrariesContainerBase.$$$reportNull$$$0(8);
            }
            return arrayList;
        }

        @Override
        @NotNull
        public String suggestUniqueLibraryName(@NotNull String baseName) {
            if (baseName == null) {
                LibrariesContainerBase.$$$reportNull$$$0(9);
            }
            if (this.myNameGenerator == null) {
                this.myNameGenerator = new UniqueNameGenerator(Arrays.asList(this.getAllLibraries()), o -> o.getName());
            }
            String string = this.myNameGenerator.generateUniqueName(baseName, "", "", " (", ")");
            if (string == null) {
                LibrariesContainerBase.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classRoots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRoots";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllLibraries";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAvailableLevels";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestUniqueLibraryName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createLibrary";
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "suggestUniqueLibraryName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

