/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ui.FormBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryNameAndLevelPanel {
    private final JTextField myLibraryNameField;
    private final JComboBox<LibrariesContainer.LibraryLevel> myLevelComboBox;
    private String myDefaultLibraryName;

    public LibraryNameAndLevelPanel(@NotNull FormBuilder formBuilder, @NotNull String libraryName, @Nullable LibrariesContainer.LibraryLevel level) {
        if (formBuilder == null) {
            LibraryNameAndLevelPanel.$$$reportNull$$$0(0);
        }
        if (libraryName == null) {
            LibraryNameAndLevelPanel.$$$reportNull$$$0(1);
        }
        this(formBuilder, libraryName, Arrays.asList(LibrariesContainer.LibraryLevel.values()), level);
    }

    public LibraryNameAndLevelPanel(@NotNull FormBuilder formBuilder, @NotNull String libraryName, @NotNull List<LibrariesContainer.LibraryLevel> availableLevels, @Nullable LibrariesContainer.LibraryLevel level) {
        if (formBuilder == null) {
            LibraryNameAndLevelPanel.$$$reportNull$$$0(2);
        }
        if (libraryName == null) {
            LibraryNameAndLevelPanel.$$$reportNull$$$0(3);
        }
        if (availableLevels == null) {
            LibraryNameAndLevelPanel.$$$reportNull$$$0(4);
        }
        this.myLibraryNameField = new JTextField(25);
        formBuilder.addLabeledComponent("&Name:", (JComponent)this.myLibraryNameField);
        this.myLibraryNameField.setText(libraryName);
        this.myLevelComboBox = new ComboBox();
        if (level != null && !availableLevels.isEmpty()) {
            formBuilder.addLabeledComponent("&Level:", this.myLevelComboBox);
            HashMap<LibrariesContainer.LibraryLevel, String> levels = new HashMap<LibrariesContainer.LibraryLevel, String>();
            levels.put(LibrariesContainer.LibraryLevel.GLOBAL, ProjectBundle.message((String)"combobox.item.global.library", (Object[])new Object[0]));
            levels.put(LibrariesContainer.LibraryLevel.PROJECT, ProjectBundle.message((String)"combobox.item.project.library", (Object[])new Object[0]));
            levels.put(LibrariesContainer.LibraryLevel.MODULE, ProjectBundle.message((String)"combobox.item.module.library", (Object[])new Object[0]));
            this.myLevelComboBox.setRenderer((ListCellRenderer<LibrariesContainer.LibraryLevel>)SimpleListCellRenderer.create((String)"", levels::get));
            this.myLevelComboBox.setModel((ComboBoxModel<LibrariesContainer.LibraryLevel>)new CollectionComboBoxModel(availableLevels, (Object)level));
        }
    }

    public String getLibraryName() {
        return this.myLibraryNameField.getText();
    }

    public LibrariesContainer.LibraryLevel getLibraryLevel() {
        return (LibrariesContainer.LibraryLevel)((Object)this.myLevelComboBox.getSelectedItem());
    }

    public JTextField getLibraryNameField() {
        return this.myLibraryNameField;
    }

    public JComboBox getLevelComboBox() {
        return this.myLevelComboBox;
    }

    public void setDefaultName(@NotNull String defaultLibraryName) {
        if (defaultLibraryName == null) {
            LibraryNameAndLevelPanel.$$$reportNull$$$0(5);
        }
        if (this.myDefaultLibraryName != null && this.myDefaultLibraryName.equals(this.getLibraryName())) {
            this.myLibraryNameField.setText(defaultLibraryName);
        }
        this.myDefaultLibraryName = defaultLibraryName;
    }

    public static FormBuilder createFormBuilder() {
        return FormBuilder.createFormBuilder();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formBuilder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableLevels";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLibraryName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryNameAndLevelPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setDefaultName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

