/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconUtilEx;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeContentElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.OrderRootTypeElement;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.util.PlatformIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class ItemElement
extends LibraryTableTreeContentElement<ItemElement> {
    protected final String myUrl;
    private final OrderRootType myRootType;

    ItemElement(@NotNull OrderRootTypeElement parent, @NotNull String url, @NotNull OrderRootType rootType, boolean isJarDirectory, boolean isValid) {
        if (parent == null) {
            ItemElement.$$$reportNull$$$0(0);
        }
        if (url == null) {
            ItemElement.$$$reportNull$$$0(1);
        }
        if (rootType == null) {
            ItemElement.$$$reportNull$$$0(2);
        }
        super(parent);
        this.myUrl = url;
        this.myName = ItemElement.getPresentablePath(url).replace('/', File.separatorChar);
        this.myColor = ItemElement.getForegroundColor(isValid);
        this.setIcon(ItemElement.getIconForUrl(url, isValid, isJarDirectory));
        this.myRootType = rootType;
    }

    private static Icon getIconForUrl(String url, boolean isValid, boolean isJarDirectory) {
        VirtualFile presentableFile;
        Icon icon = isValid ? ((presentableFile = ItemElement.isJarFileRoot(url) ? LocalFileSystem.getInstance().findFileByPath(ItemElement.getPresentablePath(url)) : VirtualFileManager.getInstance().findFileByUrl(url)) != null && presentableFile.isValid() ? (presentableFile.getFileSystem() instanceof HttpFileSystem ? PlatformIcons.WEB_ICON : (presentableFile.isDirectory() ? (isJarDirectory ? AllIcons.Nodes.JarDirectory : PlatformIcons.FOLDER_ICON) : IconUtilEx.getIcon((Object)presentableFile, (int)0, null))) : AllIcons.Nodes.PpInvalid) : AllIcons.Nodes.PpInvalid;
        return icon;
    }

    public static String getPresentablePath(String url) {
        String presentablePath = VirtualFileManager.extractPath((String)url);
        if (ItemElement.isJarFileRoot(url)) {
            presentablePath = presentablePath.substring(0, presentablePath.length() - "!/".length());
        }
        return presentablePath;
    }

    private static boolean isJarFileRoot(String url) {
        return VirtualFileManager.extractPath((String)url).endsWith("!/");
    }

    public OrderRootTypeElement getParent() {
        return (OrderRootTypeElement)this.getParentDescriptor();
    }

    @NotNull
    public OrderRootType getRootType() {
        OrderRootType orderRootType = this.myRootType;
        if (orderRootType == null) {
            ItemElement.$$$reportNull$$$0(3);
        }
        return orderRootType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemElement)) {
            return false;
        }
        ItemElement itemElement = (ItemElement)((Object)o);
        if (!this.getParent().equals((Object)itemElement.getParent())) {
            return false;
        }
        if (!this.myRootType.equals((Object)itemElement.myRootType)) {
            return false;
        }
        return this.myUrl.equals(itemElement.myUrl);
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            ItemElement.$$$reportNull$$$0(4);
        }
        return string;
    }

    public int hashCode() {
        int result = this.getParent().hashCode();
        result = 29 * result + this.myUrl.hashCode();
        result = 29 * result + this.myRootType.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/ItemElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/ItemElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

