/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.NativeLibraryOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.DescendentBasedRootFilter;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.JavadocQuarantineStatusCleaner;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLibraryRootsComponentDescriptor
extends LibraryRootsComponentDescriptor {
    private static final Set<String> NATIVE_LIBRARY_EXTENSIONS = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY, (Object[])new String[]{"dll", "so", "dylib"});
    public static final Condition<VirtualFile> LIBRARY_ROOT_CONDITION = file -> FileElement.isArchive((VirtualFile)file) || DefaultLibraryRootsComponentDescriptor.isNativeLibrary(file);

    public OrderRootTypePresentation getRootTypePresentation(@NotNull OrderRootType type2) {
        if (type2 == null) {
            DefaultLibraryRootsComponentDescriptor.$$$reportNull$$$0(0);
        }
        return DefaultLibraryRootsComponentDescriptor.getDefaultPresentation(type2);
    }

    @NotNull
    public List<? extends AttachRootButtonDescriptor> createAttachButtons() {
        List<AttachUrlJavadocDescriptor> list = Collections.singletonList(new AttachUrlJavadocDescriptor());
        if (list == null) {
            DefaultLibraryRootsComponentDescriptor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<? extends RootDetector> getRootDetectors() {
        ArrayList<Object> results = new ArrayList<Object>();
        results.add(new DescendentBasedRootFilter(OrderRootType.CLASSES, false, "classes", file -> StdFileTypes.CLASS.equals(file.getFileType()) || file.getFileSystem() instanceof JarFileSystem && DefaultLibraryRootsComponentDescriptor.isNativeLibrary(file)));
        results.add(DescendentBasedRootFilter.createFileTypeBasedFilter((OrderRootType)OrderRootType.CLASSES, (boolean)true, (FileType)StdFileTypes.CLASS, (String)"jar directory"));
        ContainerUtil.addAll(results, (Iterable)LibrarySourceRootDetectorUtil.JAVA_SOURCE_ROOT_DETECTOR.getExtensionList());
        results.add(DescendentBasedRootFilter.createFileTypeBasedFilter((OrderRootType)OrderRootType.SOURCES, (boolean)true, (FileType)StdFileTypes.JAVA, (String)"source archive directory"));
        results.add((Object)new JavadocRootDetector());
        results.add(new DescendentBasedRootFilter(AnnotationOrderRootType.getInstance(), false, "external annotations", file -> "annotations.xml".equals(file.getName())));
        results.add((Object)new NativeLibraryRootFilter());
        ArrayList<Object> arrayList = results;
        if (arrayList == null) {
            DefaultLibraryRootsComponentDescriptor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static boolean isNativeLibrary(VirtualFile file) {
        String extension = file.getExtension();
        return extension != null && NATIVE_LIBRARY_EXTENSIONS.contains(extension);
    }

    @NotNull
    public FileChooserDescriptor createAttachFilesChooserDescriptor(@Nullable String libraryName) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, false, true, true).withFileFilter(LIBRARY_ROOT_CONDITION);
        descriptor.setTitle(StringUtil.isEmpty((String)libraryName) ? ProjectBundle.message((String)"library.attach.files.action", (Object[])new Object[0]) : ProjectBundle.message((String)"library.attach.files.to.library.action", (Object[])new Object[]{libraryName}));
        descriptor.setDescription(ProjectBundle.message((String)"library.java.attach.files.description", (Object[])new Object[0]));
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            DefaultLibraryRootsComponentDescriptor.$$$reportNull$$$0(3);
        }
        return fileChooserDescriptor;
    }

    public static OrderRootTypePresentation getDefaultPresentation(OrderRootType type2) {
        OrderRootTypeUIFactory factory = (OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)type2);
        return new OrderRootTypePresentation(factory.getNodeText(), factory.getIcon());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachButtons";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDetectors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachFilesChooserDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootTypePresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AttachUrlJavadocDescriptor
    extends AttachRootButtonDescriptor {
        private AttachUrlJavadocDescriptor() {
            super(JavadocOrderRootType.getInstance(), IconUtil.getAddLinkIcon(), ProjectBundle.message((String)"module.libraries.javadoc.url.button", (Object[])new Object[0]));
        }

        public VirtualFile[] selectFiles(@NotNull JComponent parent, @Nullable VirtualFile initialSelection, @Nullable Module contextModule, @NotNull LibraryEditor libraryEditor) {
            VirtualFile[] virtualFileArray;
            VirtualFile vFile;
            if (parent == null) {
                AttachUrlJavadocDescriptor.$$$reportNull$$$0(0);
            }
            if (libraryEditor == null) {
                AttachUrlJavadocDescriptor.$$$reportNull$$$0(1);
            }
            if ((vFile = Util.showSpecifyJavadocUrlDialog((JComponent)parent)) != null) {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = vFile;
            } else {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
            }
            return virtualFileArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "libraryEditor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$AttachUrlJavadocDescriptor";
            objectArray[2] = "selectFiles";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NativeLibraryRootFilter
    extends RootDetector {
        private NativeLibraryRootFilter() {
            super(NativeLibraryOrderRootType.getInstance(), false, "native library location");
        }

        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
            if (rootCandidate == null) {
                NativeLibraryRootFilter.$$$reportNull$$$0(0);
            }
            if (progressIndicator == null) {
                NativeLibraryRootFilter.$$$reportNull$$$0(1);
            }
            if (rootCandidate.isInLocalFileSystem()) {
                if (rootCandidate.isDirectory()) {
                    for (VirtualFile file : rootCandidate.getChildren()) {
                        if (!DefaultLibraryRootsComponentDescriptor.isNativeLibrary(file)) continue;
                        Set<VirtualFile> set = Collections.singleton(rootCandidate);
                        if (set == null) {
                            NativeLibraryRootFilter.$$$reportNull$$$0(2);
                        }
                        return set;
                    }
                } else if (DefaultLibraryRootsComponentDescriptor.isNativeLibrary(rootCandidate)) {
                    Set<VirtualFile> set = Collections.singleton(rootCandidate.getParent());
                    if (set == null) {
                        NativeLibraryRootFilter.$$$reportNull$$$0(3);
                    }
                    return set;
                }
            }
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                NativeLibraryRootFilter.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootCandidate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$NativeLibraryRootFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$NativeLibraryRootFilter";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "detectRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "detectRoots";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class JavadocRootDetector
    extends RootDetector {
        private JavadocRootDetector() {
            super(JavadocOrderRootType.getInstance(), false, "JavaDocs");
        }

        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
            if (rootCandidate == null) {
                JavadocRootDetector.$$$reportNull$$$0(0);
            }
            if (progressIndicator == null) {
                JavadocRootDetector.$$$reportNull$$$0(1);
            }
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
            JavadocRootDetector.collectJavadocRoots(rootCandidate, result, progressIndicator);
            JavadocQuarantineStatusCleaner.cleanIfNeeded(VfsUtilCore.toVirtualFileArray(result));
            ArrayList<VirtualFile> arrayList = result;
            if (arrayList == null) {
                JavadocRootDetector.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        private static void collectJavadocRoots(VirtualFile file, final List<? super VirtualFile> result, final ProgressIndicator progressIndicator) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    progressIndicator.checkCanceled();
                    if (file.isDirectory() && file.findChild("allclasses-frame.html") != null && file.findChild("allclasses-noframe.html") != null) {
                        result.add(file);
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector$1", "visitFile"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootCandidate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "detectRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "detectRoots";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

