/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import java.lang.reflect.Proxy;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class InlineModuleDependencyAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(InlineModuleDependencyAction.class);
    private final ClasspathPanelImpl myClasspathPanel;

    public InlineModuleDependencyAction(ClasspathPanelImpl classpathPanel) {
        super("Inline Module Dependency", "Replace dependency on a module without source roots by the list of its dependencies", null);
        this.myClasspathPanel = classpathPanel;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            InlineModuleDependencyAction.$$$reportNull$$$0(0);
        }
        OrderEntry selectedEntry = this.myClasspathPanel.getSelectedEntry();
        InlineModuleDependencyAction.inlineEntry(this.myClasspathPanel, selectedEntry, depEntry -> depEntry instanceof LibraryOrderEntry || depEntry instanceof ModuleOrderEntry);
    }

    static void inlineEntry(ClasspathPanel classpathPanel, OrderEntry entry, Predicate<? super OrderEntry> dependencyEntryFilter) {
        if (!(entry instanceof ModuleOrderEntry)) {
            return;
        }
        ModuleOrderEntry entryToInline = (ModuleOrderEntry)entry;
        Module module = entryToInline.getModule();
        if (module == null) {
            return;
        }
        ModifiableRootModel model = classpathPanel.getRootModel();
        int toInlineIndex = InlineModuleDependencyAction.findModuleEntryIndex(model, module);
        if (toInlineIndex == -1) {
            return;
        }
        model.removeOrderEntry((OrderEntry)entryToInline);
        RootModelImpl modelImpl = Proxy.isProxyClass(model.getClass()) ? (RootModelImpl)((ModuleEditor.ProxyDelegateAccessor)((Object)Proxy.getInvocationHandler(model))).getDelegate() : (RootModelImpl)model;
        int addedCount = 0;
        ModuleRootModel otherModel = classpathPanel.getModuleConfigurationState().getModulesProvider().getRootModel(module);
        ProjectRootManagerImpl rootManager = ProjectRootManagerImpl.getInstanceImpl((Project)classpathPanel.getProject());
        VirtualFilePointerManager virtualFilePointerManager = VirtualFilePointerManager.getInstance();
        for (OrderEntry depEntry : otherModel.getOrderEntries()) {
            if (!dependencyEntryFilter.test((OrderEntry)depEntry)) continue;
            LOG.assertTrue(depEntry instanceof ClonableOrderEntry, (Object)depEntry);
            ExportableOrderEntry entryToCopy = (ExportableOrderEntry)depEntry;
            ExportableOrderEntry cloned = (ExportableOrderEntry)((ClonableOrderEntry)depEntry).cloneEntry(modelImpl, rootManager, virtualFilePointerManager);
            cloned.setExported(entryToInline.isExported() && entryToCopy.isExported());
            cloned.setScope(OrderEntryUtil.intersectScopes((DependencyScope)entryToInline.getScope(), (DependencyScope)entryToCopy.getScope()));
            model.addOrderEntry((OrderEntry)cloned);
            ++addedCount;
        }
        OrderEntry[] oldEntries = model.getOrderEntries();
        OrderEntry[] newEntries = new OrderEntry[oldEntries.length];
        System.arraycopy(oldEntries, 0, newEntries, 0, toInlineIndex);
        System.arraycopy(oldEntries, oldEntries.length - addedCount, newEntries, toInlineIndex, addedCount);
        System.arraycopy(oldEntries, toInlineIndex, newEntries, toInlineIndex + addedCount, oldEntries.length - toInlineIndex - addedCount);
        model.rearrangeOrderEntries(newEntries);
        StructureConfigurableContext context = ProjectStructureConfigurable.getInstance(classpathPanel.getProject()).getContext();
        context.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(context, module));
    }

    private static int findModuleEntryIndex(ModifiableRootModel model, Module module) {
        OrderEntry[] entries = model.getOrderEntries();
        for (int i = 0; i < entries.length; ++i) {
            OrderEntry entry = entries[i];
            if (!(entry instanceof ModuleOrderEntry) || !module.equals(((ModuleOrderEntry)entry).getModule())) continue;
            return i;
        }
        return -1;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            InlineModuleDependencyAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(this.isEnabled());
    }

    private boolean isEnabled() {
        OrderEntry entry = this.myClasspathPanel.getSelectedEntry();
        if (!(entry instanceof ModuleOrderEntry)) {
            return false;
        }
        Module module = ((ModuleOrderEntry)entry).getModule();
        if (module == null) {
            return false;
        }
        ModuleRootModel model = this.myClasspathPanel.getModuleConfigurationState().getModulesProvider().getRootModel(module);
        return model.getSourceRootUrls().length == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/InlineModuleDependencyAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

