/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathElementChooser;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateModuleLibraryChooser
implements ClasspathElementChooser<Library> {
    private final JComponent myParentComponent;
    private final Module myModule;
    private final LibraryTable.ModifiableModel myModuleLibrariesModel;
    @Nullable
    private final Function<? super LibraryType, ? extends LibraryProperties> myDefaultPropertiesFactory;
    private final HashMap<LibraryRootsComponentDescriptor, LibraryType> myLibraryTypes;
    private final DefaultLibraryRootsComponentDescriptor myDefaultDescriptor;

    public CreateModuleLibraryChooser(ClasspathPanel classpathPanel, LibraryTable.ModifiableModel moduleLibraryModel) {
        this(LibraryEditingUtil.getSuitableTypes(classpathPanel), classpathPanel.getComponent(), classpathPanel.getRootModel().getModule(), moduleLibraryModel, null);
    }

    public CreateModuleLibraryChooser(List<? extends LibraryType> libraryTypes, JComponent parentComponent, Module module, LibraryTable.ModifiableModel moduleLibrariesModel, @Nullable Function<? super LibraryType, ? extends LibraryProperties> defaultPropertiesFactory) {
        this.myParentComponent = parentComponent;
        this.myModule = module;
        this.myModuleLibrariesModel = moduleLibrariesModel;
        this.myDefaultPropertiesFactory = defaultPropertiesFactory;
        this.myLibraryTypes = new HashMap();
        this.myDefaultDescriptor = new DefaultLibraryRootsComponentDescriptor();
        for (LibraryType libraryType : libraryTypes) {
            LibraryRootsComponentDescriptor descriptor = null;
            if (libraryType != null) {
                descriptor = libraryType.createLibraryRootsComponentDescriptor();
            }
            if (descriptor == null) {
                descriptor = this.myDefaultDescriptor;
            }
            if (this.myLibraryTypes.containsKey(descriptor)) continue;
            this.myLibraryTypes.put(descriptor, libraryType);
        }
    }

    private static Library createLibraryFromRoots(@NotNull List<? extends OrderRoot> roots, @Nullable LibraryType libraryType, @NotNull LibraryTable.ModifiableModel moduleLibrariesModel, @Nullable Function<? super LibraryType, ? extends LibraryProperties> defaultPropertiesFactory) {
        if (roots == null) {
            CreateModuleLibraryChooser.$$$reportNull$$$0(0);
        }
        if (moduleLibrariesModel == null) {
            CreateModuleLibraryChooser.$$$reportNull$$$0(1);
        }
        PersistentLibraryKind kind2 = libraryType == null ? null : libraryType.getKind();
        Library library = moduleLibrariesModel.createLibrary(null, kind2);
        LibraryEx.ModifiableModelEx libModel = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        if (defaultPropertiesFactory != null) {
            libModel.setProperties((LibraryProperties)defaultPropertiesFactory.fun((Object)libraryType));
        }
        for (OrderRoot orderRoot : roots) {
            if (orderRoot.isJarDirectory()) {
                libModel.addJarDirectory(orderRoot.getFile(), false, orderRoot.getType());
                continue;
            }
            libModel.addRoot(orderRoot.getFile(), orderRoot.getType());
        }
        libModel.commit();
        return library;
    }

    private static List<OrderRoot> filterAlreadyAdded(List<? extends OrderRoot> roots, LibraryTable.ModifiableModel moduleLibrariesModel) {
        if (roots == null || roots.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OrderRoot> result = new ArrayList<OrderRoot>();
        Library[] libraries2 = moduleLibrariesModel.getLibraries();
        for (OrderRoot orderRoot : roots) {
            if (!Arrays.stream(libraries2).noneMatch(library -> ArrayUtil.contains((Object)root.getFile(), (Object[])library.getFiles(root.getType())))) continue;
            result.add(orderRoot);
        }
        return result;
    }

    @Override
    @NotNull
    public List<Library> chooseElements() {
        DefaultLibraryRootsComponentDescriptor rootsComponentDescriptor;
        final ArrayList<Pair> descriptors = new ArrayList<Pair>();
        for (LibraryRootsComponentDescriptor componentDescriptor : this.myLibraryTypes.keySet()) {
            descriptors.add(Pair.create((Object)componentDescriptor, (Object)componentDescriptor.createAttachFilesChooserDescriptor(null)));
        }
        FileChooserDescriptor chooserDescriptor = descriptors.size() == 1 ? (FileChooserDescriptor)((Pair)descriptors.get(0)).getSecond() : new FileChooserDescriptor(true, true, true, false, true, false){

            public boolean isFileSelectable(VirtualFile file) {
                for (Pair pair2 : descriptors) {
                    if (!((FileChooserDescriptor)pair2.getSecond()).isFileSelectable(file)) continue;
                    return true;
                }
                return false;
            }

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                for (Pair pair2 : descriptors) {
                    if (!((FileChooserDescriptor)pair2.getSecond()).isFileVisible(file, showHiddenFiles)) continue;
                    return true;
                }
                return false;
            }
        };
        chooserDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)this.myModule);
        Project project = this.myModule.getProject();
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor, (Component)this.myParentComponent, (Project)project, (VirtualFile)project.getBaseDir());
        if (files.length == 0) {
            List<Library> list = Collections.emptyList();
            if (list == null) {
                CreateModuleLibraryChooser.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<Object> suitableDescriptors = new ArrayList<Object>();
        for (Pair pair2 : descriptors) {
            if (!CreateModuleLibraryChooser.acceptAll((FileChooserDescriptor)pair2.getSecond(), files)) continue;
            suitableDescriptors.add(pair2.getFirst());
        }
        LibraryType libraryType = null;
        if (suitableDescriptors.size() == 1) {
            rootsComponentDescriptor = (LibraryRootsComponentDescriptor)suitableDescriptors.get(0);
            libraryType = this.myLibraryTypes.get((Object)rootsComponentDescriptor);
        } else {
            rootsComponentDescriptor = this.myDefaultDescriptor;
        }
        List chosenRoots = RootDetectionUtil.detectRoots(Arrays.asList(files), (Component)this.myParentComponent, (Project)project, (LibraryRootsComponentDescriptor)rootsComponentDescriptor);
        List<Library> list = CreateModuleLibraryChooser.createLibrariesFromRoots(chosenRoots, libraryType, this.myModuleLibrariesModel, this.myDefaultPropertiesFactory);
        if (list == null) {
            CreateModuleLibraryChooser.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static List<Library> createLibrariesFromRoots(List<? extends OrderRoot> chosenRoots, LibraryTable.ModifiableModel moduleLibrariesModel) {
        List<Library> list = CreateModuleLibraryChooser.createLibrariesFromRoots(chosenRoots, null, moduleLibrariesModel, null);
        if (list == null) {
            CreateModuleLibraryChooser.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static List<Library> createLibrariesFromRoots(@NotNull List<? extends OrderRoot> chosenRoots, @Nullable LibraryType libraryType, @NotNull LibraryTable.ModifiableModel moduleLibrariesModel, @Nullable Function<? super LibraryType, ? extends LibraryProperties> defaultPropertiesFactory) {
        List<OrderRoot> roots;
        if (chosenRoots == null) {
            CreateModuleLibraryChooser.$$$reportNull$$$0(5);
        }
        if (moduleLibrariesModel == null) {
            CreateModuleLibraryChooser.$$$reportNull$$$0(6);
        }
        if ((roots = CreateModuleLibraryChooser.filterAlreadyAdded(chosenRoots, moduleLibrariesModel)).isEmpty()) {
            List<Library> list = Collections.emptyList();
            if (list == null) {
                CreateModuleLibraryChooser.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList<Library> addedLibraries = new ArrayList<Library>();
        Map byFile = roots.stream().collect(Collectors.groupingBy(OrderRoot::getFile, LinkedHashMap::new, Collectors.toList()));
        Predicate<List> containsClasses = it -> it.stream().anyMatch(root -> root.getType().equals((Object)OrderRootType.CLASSES));
        if (byFile.values().stream().allMatch(containsClasses)) {
            for (List rootsForFile : byFile.values()) {
                addedLibraries.add(CreateModuleLibraryChooser.createLibraryFromRoots(rootsForFile, libraryType, moduleLibrariesModel, defaultPropertiesFactory));
            }
        } else {
            addedLibraries.add(CreateModuleLibraryChooser.createLibraryFromRoots(roots, libraryType, moduleLibrariesModel, defaultPropertiesFactory));
        }
        ArrayList<Library> arrayList = addedLibraries;
        if (arrayList == null) {
            CreateModuleLibraryChooser.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static boolean acceptAll(FileChooserDescriptor descriptor, VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (descriptor.isFileSelectable(file) && descriptor.isFileVisible(file, true)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleLibrariesModel";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/classpath/CreateModuleLibraryChooser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/CreateModuleLibraryChooser";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseElements";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrariesFromRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryFromRoots";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLibrariesFromRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

