/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ArtifactsTreeNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemNode;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemFilter;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SourceItemNodeBase
extends ArtifactsTreeNode {
    private Artifact myArtifact;
    private final ArtifactEditorEx myArtifactEditor;

    public SourceItemNodeBase(ArtifactEditorContext context, NodeDescriptor parentDescriptor, TreeNodePresentation presentation, ArtifactEditorEx artifactEditor) {
        super(context, parentDescriptor, presentation);
        this.myArtifact = artifactEditor.getArtifact();
        this.myArtifactEditor = artifactEditor;
    }

    protected ArtifactEditorEx getArtifactEditor() {
        return this.myArtifactEditor;
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        Artifact artifact;
        if (presentation == null) {
            SourceItemNodeBase.$$$reportNull$$$0(0);
        }
        if (!this.myArtifact.equals(artifact = this.myArtifactEditor.getArtifact())) {
            this.myArtifact = artifact;
        }
        super.update(presentation);
    }

    protected SimpleNode[] buildChildren() {
        PackagingSourceItemsProvider[] providers2 = (PackagingSourceItemsProvider[])PackagingSourceItemsProvider.EP_NAME.getExtensions();
        PackagingSourceItemFilter[] filters = (PackagingSourceItemFilter[])PackagingSourceItemFilter.EP_NAME.getExtensions();
        ArrayList<SourceItemNode> children = new ArrayList<SourceItemNode>();
        for (PackagingSourceItemsProvider provider : providers2) {
            Collection items = provider.getSourceItems(this.myContext, this.myArtifact, this.getSourceItem());
            for (PackagingSourceItem item : items) {
                if (!this.myArtifact.getArtifactType().isSuitableItem(item) || !SourceItemNodeBase.isAvailable(item, this.myContext, filters)) continue;
                children.add(new SourceItemNode(this.myContext, (NodeDescriptor)this, item, this.myArtifactEditor));
            }
        }
        return children.isEmpty() ? NO_CHILDREN : children.toArray(new SimpleNode[0]);
    }

    private static boolean isAvailable(@NotNull PackagingSourceItem item, @NotNull ArtifactEditorContext context, @NotNull PackagingSourceItemFilter[] filters) {
        if (item == null) {
            SourceItemNodeBase.$$$reportNull$$$0(1);
        }
        if (context == null) {
            SourceItemNodeBase.$$$reportNull$$$0(2);
        }
        if (filters == null) {
            SourceItemNodeBase.$$$reportNull$$$0(3);
        }
        for (PackagingSourceItemFilter filter : filters) {
            if (filter.isAvailable(item, context)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    protected abstract PackagingSourceItem getSourceItem();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/SourceItemNodeBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

