/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProblemDescription;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ArtifactsTreeNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingNodeSource;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingElementNode<E extends PackagingElement<?>>
extends ArtifactsTreeNode {
    private final List<E> myPackagingElements;
    private final Map<PackagingElement<?>, CompositePackagingElement<?>> myParentElements;
    private final MultiValuesMap<PackagingElement<?>, PackagingNodeSource> myNodeSources;
    private final CompositePackagingElementNode myParentNode;

    public PackagingElementNode(@NotNull E packagingElement, ArtifactEditorContext context, @Nullable CompositePackagingElementNode parentNode, @Nullable CompositePackagingElement<?> parentElement, @NotNull Collection<PackagingNodeSource> nodeSources) {
        if (packagingElement == null) {
            PackagingElementNode.$$$reportNull$$$0(0);
        }
        if (nodeSources == null) {
            PackagingElementNode.$$$reportNull$$$0(1);
        }
        super(context, (NodeDescriptor)parentNode, (TreeNodePresentation)packagingElement.createPresentation(context));
        this.myParentElements = new HashMap(1);
        this.myNodeSources = new MultiValuesMap();
        this.myParentNode = parentNode;
        this.myParentElements.put((PackagingElement<?>)packagingElement, parentElement);
        this.myNodeSources.putAll(packagingElement, nodeSources);
        this.myPackagingElements = new SmartList();
        this.doAddElement(packagingElement);
    }

    private void doAddElement(E packagingElement) {
        this.myPackagingElements.add(packagingElement);
    }

    @Nullable
    public CompositePackagingElement<?> getParentElement(PackagingElement<?> element) {
        return this.myParentElements.get(element);
    }

    @Nullable
    public CompositePackagingElementNode getParentNode() {
        return this.myParentNode;
    }

    public List<E> getPackagingElements() {
        return this.myPackagingElements;
    }

    @Nullable
    public E getElementIfSingle() {
        return (E)(this.myPackagingElements.size() == 1 ? (PackagingElement)this.myPackagingElements.get(0) : null);
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = ArrayUtil.toObjectArray(this.myPackagingElements);
        if (objectArray == null) {
            PackagingElementNode.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    protected SimpleNode[] buildChildren() {
        return NO_CHILDREN;
    }

    public E getFirstElement() {
        return (E)((PackagingElement)this.myPackagingElements.get(0));
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        Collection<ArtifactProblemDescription> problems;
        if (presentation == null) {
            PackagingElementNode.$$$reportNull$$$0(3);
        }
        if ((problems = ((ArtifactEditorImpl)this.myContext.getThisArtifactEditor()).getValidationManager().getProblems(this)) == null || problems.isEmpty()) {
            super.update(presentation);
            return;
        }
        StringBuilder buffer = new StringBuilder();
        boolean isError = false;
        for (ArtifactProblemDescription problem : problems) {
            isError |= problem.getSeverity() == ProjectStructureProblemType.Severity.ERROR;
            buffer.append(problem.getMessage(false)).append("<br>");
        }
        String tooltip = XmlStringUtil.wrapInHtml((CharSequence)buffer);
        this.getElementPresentation().render(presentation, PackagingElementNode.addErrorHighlighting(isError, SimpleTextAttributes.REGULAR_ATTRIBUTES), PackagingElementNode.addErrorHighlighting(isError, SimpleTextAttributes.GRAY_ATTRIBUTES));
        presentation.setTooltip(tooltip);
    }

    private static SimpleTextAttributes addErrorHighlighting(boolean error, SimpleTextAttributes attributes) {
        TextAttributes textAttributes = attributes.toTextAttributes();
        textAttributes.setEffectType(EffectType.WAVE_UNDERSCORE);
        textAttributes.setEffectColor((Color)(error ? JBColor.RED : JBColor.GRAY));
        return SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
    }

    void addElement(PackagingElement<?> element, CompositePackagingElement parentElement, Collection<? extends PackagingNodeSource> nodeSource) {
        this.doAddElement(element);
        this.myParentElements.put(element, parentElement);
        this.myNodeSources.putAll(element, nodeSource);
    }

    @NotNull
    public Collection<PackagingNodeSource> getNodeSources() {
        Collection collection = this.myNodeSources.values();
        if (collection == null) {
            PackagingElementNode.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Collection<PackagingNodeSource> getNodeSource(@NotNull PackagingElement<?> element) {
        List<PackagingNodeSource> nodeSources;
        if (element == null) {
            PackagingElementNode.$$$reportNull$$$0(5);
        }
        List<PackagingNodeSource> list = (nodeSources = this.myNodeSources.get(element)) != null ? nodeSources : Collections.emptyList();
        if (list == null) {
            PackagingElementNode.$$$reportNull$$$0(6);
        }
        return list;
    }

    public ArtifactEditorContext getContext() {
        return this.myContext;
    }

    @Nullable
    public CompositePackagingElementNode findCompositeChild(@NotNull String name2) {
        SimpleNode[] children;
        if (name2 == null) {
            PackagingElementNode.$$$reportNull$$$0(7);
        }
        for (SimpleNode child : children = this.getChildren()) {
            CompositePackagingElementNode composite;
            if (!(child instanceof CompositePackagingElementNode) || !name2.equals(((CompositePackagingElement)(composite = (CompositePackagingElementNode)child).getFirstElement()).getName())) continue;
            return composite;
        }
        return null;
    }

    public List<PackagingElementNode<?>> getNodesByPath(List<? extends PackagingElement<?>> pathToPlace) {
        SimpleNode[] children;
        ArrayList result = new ArrayList();
        PackagingElementNode current = this;
        result.add(current);
        for (int i = 0; current != null && i < pathToPlace.size() && (children = current.getCached()) != null; ++i) {
            PackagingElementNode next = null;
            PackagingElement<?> element = pathToPlace.get(i);
            block1: for (SimpleNode child : children) {
                if (!(child instanceof PackagingElementNode)) continue;
                PackagingElementNode childNode = (PackagingElementNode)child;
                for (PackagingElement childElement : childNode.getPackagingElements()) {
                    if (!childElement.isEqualTo(element)) continue;
                    next = childNode;
                    break block1;
                }
                for (PackagingNodeSource nodeSource : childNode.getNodeSources()) {
                    if (!nodeSource.getSourceElement().isEqualTo(element)) continue;
                    next = current;
                    break block1;
                }
            }
            if ((current = next) == null) continue;
            result.add(current);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagingElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeSources";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingElementNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingElementNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeSources";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNodeSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findCompositeChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

