/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.facet.Facet;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.ManifestFileProvider;
import com.intellij.packaging.impl.ui.ChooseArtifactsDialog;
import com.intellij.packaging.ui.ArtifactEditor;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import com.intellij.util.ui.classpath.ChooseLibrariesFromTablesDialog;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArtifactEditorContextImpl
implements ArtifactEditorContext {
    private final ArtifactsStructureConfigurableContext myParent;
    private final ArtifactEditorEx myEditor;

    public ArtifactEditorContextImpl(ArtifactsStructureConfigurableContext parent, ArtifactEditorEx editor) {
        this.myParent = parent;
        this.myEditor = editor;
    }

    @NotNull
    public ModifiableArtifactModel getOrCreateModifiableArtifactModel() {
        ModifiableArtifactModel modifiableArtifactModel = this.myParent.getOrCreateModifiableArtifactModel();
        if (modifiableArtifactModel == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(0);
        }
        return modifiableArtifactModel;
    }

    public ModifiableModuleModel getModifiableModuleModel() {
        return this.myParent.getModifiableModuleModel();
    }

    @NotNull
    public ModifiableRootModel getOrCreateModifiableRootModel(@NotNull Module module) {
        if (module == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(1);
        }
        ModifiableRootModel modifiableRootModel = this.myParent.getOrCreateModifiableRootModel(module);
        if (modifiableRootModel == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(2);
        }
        return modifiableRootModel;
    }

    public ManifestFileConfiguration getManifestFile(CompositePackagingElement<?> element, ArtifactType artifactType) {
        return this.myParent.getManifestFile(element, artifactType);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myParent.getProject();
        if (project == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(3);
        }
        return project;
    }

    public CompositePackagingElement<?> getRootElement(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(4);
        }
        return this.myParent.getRootElement(artifact);
    }

    public void editLayout(@NotNull Artifact artifact, Runnable runnable) {
        if (artifact == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(5);
        }
        this.myParent.editLayout(artifact, runnable);
    }

    public ArtifactEditor getOrCreateEditor(Artifact artifact) {
        return this.myParent.getOrCreateEditor(artifact);
    }

    public ArtifactEditor getThisArtifactEditor() {
        return this.myEditor;
    }

    public void selectArtifact(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(6);
        }
        ProjectStructureConfigurable.getInstance(this.getProject()).select(artifact, true);
    }

    public void selectFacet(@NotNull Facet<?> facet) {
        if (facet == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(7);
        }
        ProjectStructureConfigurable.getInstance(this.getProject()).select(facet, true);
    }

    public void selectModule(@NotNull Module module) {
        if (module == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(8);
        }
        ProjectStructureConfigurable.getInstance(this.getProject()).select(module.getName(), null, true);
    }

    public void selectLibrary(@NotNull Library library) {
        LibraryTable table;
        if (library == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(9);
        }
        if ((table = library.getTable()) != null) {
            ProjectStructureConfigurable.getInstance(this.getProject()).selectProjectOrGlobalLibrary(library, true);
        } else {
            Module module = ((LibraryImpl)library).getModule();
            if (module != null) {
                ModuleRootModel rootModel = this.myParent.getModulesProvider().getRootModel(module);
                String libraryName = library.getName();
                for (OrderEntry entry : rootModel.getOrderEntries()) {
                    if (!(entry instanceof LibraryOrderEntry) || !OrderEntryUtil.isModuleLibraryOrderEntry((OrderEntry)entry)) continue;
                    LibraryOrderEntry libraryEntry = (LibraryOrderEntry)entry;
                    if ((libraryName == null || !libraryName.equals(libraryEntry.getLibraryName())) && (libraryName != null || !library.equals(libraryEntry.getLibrary()))) continue;
                    ProjectStructureConfigurable.getInstance(this.getProject()).selectOrderEntry(module, (OrderEntry)libraryEntry);
                    return;
                }
            }
        }
    }

    public List<Artifact> chooseArtifacts(List<? extends Artifact> artifacts, String title) {
        ChooseArtifactsDialog dialog = new ChooseArtifactsDialog(this.getProject(), artifacts, title, null);
        return dialog.showAndGet() ? dialog.getChosenElements() : Collections.emptyList();
    }

    @NotNull
    public ArtifactModel getArtifactModel() {
        ArtifactModel artifactModel = this.myParent.getArtifactModel();
        if (artifactModel == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(10);
        }
        return artifactModel;
    }

    @NotNull
    public ModulesProvider getModulesProvider() {
        ModulesProvider modulesProvider = this.myParent.getModulesProvider();
        if (modulesProvider == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(11);
        }
        return modulesProvider;
    }

    @NotNull
    public FacetsProvider getFacetsProvider() {
        FacetsProvider facetsProvider = this.myParent.getFacetsProvider();
        if (facetsProvider == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(12);
        }
        return facetsProvider;
    }

    public Library findLibrary(@NotNull String level, @NotNull String libraryName) {
        if (level == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(13);
        }
        if (libraryName == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(14);
        }
        return this.myParent.findLibrary(level, libraryName);
    }

    @NotNull
    public ManifestFileProvider getManifestFileProvider() {
        ManifestFileProvider manifestFileProvider = this.myParent.getManifestFileProvider();
        if (manifestFileProvider == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(15);
        }
        return manifestFileProvider;
    }

    public void queueValidation() {
        this.myParent.queueValidation(this.getArtifact());
    }

    @NotNull
    public ArtifactType getArtifactType() {
        ArtifactType artifactType = this.myEditor.getArtifact().getArtifactType();
        if (artifactType == null) {
            ArtifactEditorContextImpl.$$$reportNull$$$0(16);
        }
        return artifactType;
    }

    public List<Module> chooseModules(List<? extends Module> modules, String title) {
        return new ChooseModulesDialog(this.getProject(), modules, title, null).showAndGetResult();
    }

    public List<Library> chooseLibraries(String title) {
        ChooseLibrariesFromTablesDialog dialog = ChooseLibrariesFromTablesDialog.createDialog(title, this.getProject(), false);
        return dialog.showAndGet() ? dialog.getSelectedLibraries() : Collections.emptyList();
    }

    public Artifact getArtifact() {
        return this.myEditor.getArtifact();
    }

    public ArtifactsStructureConfigurableContext getParent() {
        return this.myParent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateModifiableArtifactModel";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateModifiableRootModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesProvider";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetsProvider";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getManifestFileProvider";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateModifiableRootModel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRootElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "editLayout";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectArtifact";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectFacet";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectModule";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selectLibrary";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

