/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.PathUtilRt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/actions/ChangeModuleNamesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.java.ui"})
public final class ChangeModuleNamesAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setVisible(project != null && ModuleGrouperKt.isQualifiedModuleNamesEnabled((Project)project) && e.getData(LangDataKeys.MODIFIABLE_MODULE_MODEL) != null);
        Module[] modules = (Module[])e.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled(modules != null && modules.length > 1);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        boolean bl;
        String commonPrefix;
        int n;
        ModifiableModuleModel model;
        Module[] modules;
        block6: {
            void $this$fold$iv;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Module[] moduleArray = (Module[])e.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
            if (moduleArray == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"e.getData(LangDataKeys.M\u2026_CONTEXT_ARRAY) ?: return");
            modules = moduleArray;
            ModifiableModuleModel modifiableModuleModel = (ModifiableModuleModel)e.getData(LangDataKeys.MODIFIABLE_MODULE_MODEL);
            if (modifiableModuleModel == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)modifiableModuleModel, (String)"e.getData(LangDataKeys.M\u2026E_MODULE_MODEL) ?: return");
            model = modifiableModuleModel;
            Function1<Module, String> $fun$getGroupName$1 = new Function1<Module, String>(model){
                final /* synthetic */ ModifiableModuleModel $model;

                @NotNull
                public final String invoke(@NotNull Module module) {
                    Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                    StringBuilder stringBuilder = new StringBuilder();
                    String string = this.$model.getActualName(module);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"model.getActualName(module)");
                    return stringBuilder.append(StringsKt.substringBeforeLast$default((String)string, (char)'.', null, (int)2, null)).append(".").toString();
                }
                {
                    this.$model = modifiableModuleModel;
                    super(1);
                }
            };
            Module[] moduleArray2 = modules;
            Module module = modules[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"modules[0]");
            Module[] initial$iv = $fun$getGroupName$1.invoke(module);
            boolean $i$f$fold = false;
            Object accumulator$iv = initial$iv;
            void var10_11 = $this$fold$iv;
            n = ((void)var10_11).length;
            for (int i = 0; i < n; ++i) {
                void m;
                void element$iv;
                void var14_20 = element$iv = var10_11[i];
                Module[] prefix = accumulator$iv;
                boolean bl2 = false;
                CharSequence charSequence = (CharSequence)prefix;
                void v4 = m;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"m");
                accumulator$iv = StringsKt.commonPrefixWith$default((CharSequence)charSequence, (CharSequence)$fun$getGroupName$1.invoke((Module)v4), (boolean)false, (int)2, null);
            }
            commonPrefix = StringsKt.substringBeforeLast((String)accumulator$iv, (char)'.', (String)"");
            Module[] $this$any$iv = modules;
            boolean $i$f$any = false;
            accumulator$iv = $this$any$iv;
            int n2 = ((Module[])accumulator$iv).length;
            for (n = 0; n < n2; ++n) {
                Module element$iv;
                Module it = element$iv = accumulator$iv[n];
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)model.getActualName(it), (Object)commonPrefix)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        boolean isPrefixEqualToModuleName = bl;
        InputValidatorEx validator2 = new InputValidatorEx(isPrefixEqualToModuleName){
            final /* synthetic */ boolean $isPrefixEqualToModuleName;

            @Nullable
            public String getErrorText(@NotNull String inputString) {
                Intrinsics.checkParameterIsNotNull((Object)inputString, (String)"inputString");
                CharSequence charSequence = inputString;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    boolean bl2;
                    block8: {
                        Iterable $this$any$iv = StringsKt.split$default((CharSequence)inputString, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl3 = false;
                                CharSequence charSequence2 = it;
                                boolean bl4 = false;
                                if (!(charSequence2.length() == 0)) continue;
                                bl2 = true;
                                break block8;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        return ProjectBundle.message((String)"error.message.module.name.prefix.contains.empty.string", (Object[])new Object[0]);
                    }
                }
                if (this.$isPrefixEqualToModuleName) {
                    charSequence = inputString;
                    bl = false;
                    if (charSequence.length() == 0) {
                        return ProjectBundle.message((String)"error.message.module.name.cannot.be.empty", (Object[])new Object[0]);
                    }
                }
                if (!PathUtilRt.isValidFileName((String)(inputString + ".iml"), (boolean)true)) {
                    return ProjectBundle.message((String)"error.message.module.name.prefix.contains.invalid.chars", (Object[])new Object[0]);
                }
                return null;
            }

            public boolean checkInput(@NotNull String inputString) {
                Intrinsics.checkParameterIsNotNull((Object)inputString, (String)"inputString");
                return this.getErrorText(inputString) == null;
            }

            public boolean canClose(@NotNull String inputString) {
                Intrinsics.checkParameterIsNotNull((Object)inputString, (String)"inputString");
                return this.getErrorText(inputString) == null;
            }
            {
                this.$isPrefixEqualToModuleName = $captured_local_variable$0;
            }
        };
        String newPrefix = Messages.showInputDialog((Project)e.getProject(), (String)ProjectBundle.message((String)"dialog.text.enter.common.prefix", (Object[])new Object[]{modules.length}), (String)ProjectBundle.message((String)"dialog.title.change.module.names", (Object[])new Object[0]), null, (String)commonPrefix, (InputValidator)((InputValidator)validator2), (TextRange)TextRange.allOf((String)commonPrefix), (String)ProjectBundle.message((String)"dialog.text.enter.common.prefix.comment", (Object[])new Object[0]));
        if (newPrefix == null) {
            return;
        }
        CharSequence charSequence = commonPrefix;
        n = 0;
        String prefixToRemove = charSequence.length() == 0 ? "" : commonPrefix + '.';
        CharSequence charSequence2 = newPrefix;
        boolean element$iv = false;
        String prefixToPrepend = charSequence2.length() == 0 || StringsKt.endsWith$default((CharSequence)newPrefix, (char)'.', (boolean)false, (int)2, null) ? newPrefix : newPrefix + '.';
        Module[] $this$forEach$iv = modules;
        boolean $i$f$forEach = false;
        Module[] moduleArray = $this$forEach$iv;
        int n3 = moduleArray.length;
        for (int i = 0; i < n3; ++i) {
            String oldName;
            Module element$iv2;
            Module it = element$iv2 = moduleArray[i];
            boolean bl4 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)model.getActualName(it), (String)"model.getActualName(it)");
            String newName = Intrinsics.areEqual((Object)oldName, (Object)commonPrefix) ? newPrefix : prefixToPrepend + StringsKt.removePrefix((String)oldName, (CharSequence)prefixToRemove);
            model.renameModule(it, newName);
        }
        ProjectSettingsService.getInstance((Project)e.getProject()).processModulesMoved(modules, null);
    }

    public ChangeModuleNamesAction() {
        super(ProjectBundle.message((String)"action.text.change.module.names", (Object[])new Object[0]), ProjectBundle.message((String)"action.description.change.module.names", (Object[])new Object[0]), null);
    }
}

