/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVfsSourceRootDetectionUtil {
    private JavaVfsSourceRootDetectionUtil() {
    }

    @NotNull
    public static List<VirtualFile> suggestRoots(@NotNull VirtualFile dir, final @NotNull ProgressIndicator progressIndicator) {
        if (dir == null) {
            JavaVfsSourceRootDetectionUtil.$$$reportNull$$$0(0);
        }
        if (progressIndicator == null) {
            JavaVfsSourceRootDetectionUtil.$$$reportNull$$$0(1);
        }
        if (!dir.isDirectory()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JavaVfsSourceRootDetectionUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        final FileTypeManager typeManager = FileTypeManager.getInstance();
        final ArrayList<VirtualFile> foundDirectories = new ArrayList<VirtualFile>();
        try {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    progressIndicator.checkCanceled();
                    if (file.isDirectory()) {
                        if (typeManager.isFileIgnored(file) || StringUtil.startsWithIgnoreCase((String)file.getName(), (String)"testData")) {
                            VirtualFileVisitor.Result result = SKIP_CHILDREN;
                            if (result == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return result;
                        }
                    } else {
                        VirtualFile root;
                        FileType type2 = typeManager.getFileTypeByFileName(file.getNameSequence());
                        if (StdFileTypes.JAVA == type2 && (root = JavaVfsSourceRootDetectionUtil.suggestRootForJavaFile(file)) != null) {
                            foundDirectories.add(root);
                            VirtualFileVisitor.Result result = 1.skipTo((VirtualFile)root);
                            if (result == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return result;
                        }
                    }
                    VirtualFileVisitor.Result result = CONTINUE;
                    if (result == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return result;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JavaVfsSourceRootDetectionUtil$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JavaVfsSourceRootDetectionUtil$1";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visitFileEx";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visitFileEx";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        ArrayList<VirtualFile> arrayList = foundDirectories;
        if (arrayList == null) {
            JavaVfsSourceRootDetectionUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    private static VirtualFile suggestRootForJavaFile(VirtualFile javaFile) {
        if (javaFile.isDirectory()) {
            return null;
        }
        CharSequence chars = LoadTextUtil.loadText((VirtualFile)javaFile);
        String packageName = JavaSourceRootDetectionUtil.getPackageName(chars);
        if (packageName != null) {
            VirtualFile root = javaFile.getParent();
            int index = packageName.length();
            while (index > 0) {
                boolean equalsToToken;
                int index1 = packageName.lastIndexOf(46, index - 1);
                String token = packageName.substring(index1 + 1, index);
                String dirName = root.getName();
                boolean bl = equalsToToken = SystemInfo.isFileSystemCaseSensitive ? dirName.equals(token) : dirName.equalsIgnoreCase(token);
                if (!equalsToToken) {
                    return null;
                }
                if ((root = root.getParent()) == null) {
                    return null;
                }
                index = index1;
            }
            return root;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JavaVfsSourceRootDetectionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JavaVfsSourceRootDetectionUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestRoots";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

