/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.codeInsight.daemon.impl.quickfix.LocateLibraryDialog;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryAttachDialog;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class IdeaProjectModelModifier
extends JavaProjectModelModifier {
    private static final Logger LOG = Logger.getInstance(IdeaProjectModelModifier.class);
    private final Project myProject;

    public IdeaProjectModelModifier(Project project) {
        this.myProject = project;
    }

    @Override
    public Promise<Void> addModuleDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope, boolean exported) {
        if (from == null) {
            IdeaProjectModelModifier.$$$reportNull$$$0(0);
        }
        if (to == null) {
            IdeaProjectModelModifier.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            IdeaProjectModelModifier.$$$reportNull$$$0(2);
        }
        ModuleRootModificationUtil.addDependency((Module)from, (Module)to, (DependencyScope)scope, (boolean)exported);
        return Promises.resolvedPromise(null);
    }

    @Override
    public Promise<Void> addLibraryDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope, boolean exported) {
        if (from == null) {
            IdeaProjectModelModifier.$$$reportNull$$$0(3);
        }
        if (library == null) {
            IdeaProjectModelModifier.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            IdeaProjectModelModifier.$$$reportNull$$$0(5);
        }
        WriteAction.run(() -> OrderEntryUtil.addLibraryToRoots((Module)from, (Library)library, (DependencyScope)scope, (boolean)exported));
        return Promises.resolvedPromise(null);
    }

    @Override
    public Promise<Void> addExternalLibraryDependency(@NotNull Collection<? extends Module> modules, @NotNull ExternalLibraryDescriptor descriptor, @NotNull DependencyScope scope) {
        List<String> classesRoots;
        if (modules == null) {
            IdeaProjectModelModifier.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            IdeaProjectModelModifier.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            IdeaProjectModelModifier.$$$reportNull$$$0(8);
        }
        List<String> defaultRoots = descriptor.getLibraryClassesRoots();
        Module firstModule = (Module)ContainerUtil.getFirstItem(modules);
        if (!defaultRoots.isEmpty()) {
            LOG.assertTrue(firstModule != null);
            classesRoots = new LocateLibraryDialog(firstModule, defaultRoots, descriptor.getPresentableName()).showAndGetResult();
        } else {
            String version = descriptor.getPreferredVersion();
            String mavenCoordinates = descriptor.getLibraryGroupId() + ":" + descriptor.getLibraryArtifactId() + ":" + (version != null ? version : "RELEASE");
            RepositoryAttachDialog dialog = new RepositoryAttachDialog(this.myProject, mavenCoordinates, RepositoryAttachDialog.Mode.DOWNLOAD);
            if (!dialog.showAndGet()) {
                return Promises.rejectedPromise();
            }
            RepositoryLibraryProperties libraryProperties = new RepositoryLibraryProperties(dialog.getSelectedLibraryDescriptor());
            Collection<OrderRoot> roots = JarRepositoryManager.loadDependenciesModal(this.myProject, libraryProperties, dialog.getAttachSources(), dialog.getAttachJavaDoc(), dialog.getDirectoryPath(), null);
            if (roots.isEmpty()) {
                Messages.showErrorDialog((Project)this.myProject, (String)(descriptor.getPresentableName() + " was not loaded."), (String)"Failed to Download Library");
                return Promises.rejectedPromise();
            }
            classesRoots = roots.stream().filter(root -> root.getType() == OrderRootType.CLASSES).map(root -> PathUtil.getLocalPath((VirtualFile)root.getFile())).collect(Collectors.toList());
        }
        if (!classesRoots.isEmpty()) {
            String libraryName = classesRoots.size() > 1 ? descriptor.getPresentableName() : null;
            List<String> urls = OrderEntryFix.refreshAndConvertToUrls(classesRoots);
            if (modules.size() == 1) {
                ModuleRootModificationUtil.addModuleLibrary((Module)firstModule, (String)libraryName, urls, Collections.emptyList(), (DependencyScope)scope);
            } else {
                WriteAction.run(() -> {
                    Library library = LibraryUtil.createLibrary((LibraryTable)LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject), (String)descriptor.getPresentableName());
                    Library.ModifiableModel model = library.getModifiableModel();
                    for (String url : urls) {
                        model.addRoot(url, OrderRootType.CLASSES);
                    }
                    model.commit();
                    for (Module module : modules) {
                        ModuleRootModificationUtil.addDependency((Module)module, (Library)library, (DependencyScope)scope, (boolean)false);
                    }
                });
            }
        }
        return Promises.resolvedPromise(null);
    }

    @Override
    public Promise<Void> changeLanguageLevel(@NotNull Module module, @NotNull LanguageLevel level) {
        LanguageLevel moduleLevel;
        if (module == null) {
            IdeaProjectModelModifier.$$$reportNull$$$0(9);
        }
        if (level == null) {
            IdeaProjectModelModifier.$$$reportNull$$$0(10);
        }
        if ((moduleLevel = LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel()) != null && JavaSdkUtil.isLanguageLevelAcceptable(this.myProject, module, level)) {
            ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            ((LanguageLevelModuleExtension)rootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(level);
            rootModel.commit();
        } else {
            LanguageLevelProjectExtension.getInstance((Project)this.myProject).setLanguageLevel(level);
            ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.INSTANCE, false, true);
        }
        return Promises.resolvedPromise(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/impl/IdeaProjectModelModifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addModuleDependency";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addLibraryDependency";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addExternalLibraryDependency";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "changeLanguageLevel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

