/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ProjectJdksConfigurable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ProjectJdksEditor
extends DialogWrapper {
    private ProjectJdksConfigurable myConfigurable;
    private Sdk myProjectJdk;

    public ProjectJdksEditor(Sdk jdk, Project project, Component parent) {
        this(jdk, parent, new ProjectJdksConfigurable(project));
    }

    public ProjectJdksEditor(Sdk jdk, Component parent, ProjectJdksConfigurable configurable) {
        super(parent, true);
        this.myConfigurable = configurable;
        SwingUtilities.invokeLater(() -> this.myConfigurable.selectNodeInTree(jdk != null ? jdk.getName() : null));
        this.setTitle(ProjectBundle.message((String)"sdk.configure.title", (Object[])new Object[0]));
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                if (ProjectJdksEditor.this.myConfigurable != null) {
                    ProjectJdksEditor.this.myConfigurable.disposeUIResources();
                    ProjectJdksEditor.this.myConfigurable = null;
                }
            }
        });
        this.init();
    }

    public ProjectJdksEditor(Sdk jdk, Component parent) {
        this(jdk, (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext()), parent);
    }

    protected JComponent createCenterPanel() {
        this.myConfigurable.reset();
        return this.myConfigurable.createComponent();
    }

    protected void doOKAction() {
        try {
            this.myProjectJdk = this.myConfigurable.getSelectedJdk();
            this.myConfigurable.apply();
            super.doOKAction();
        }
        catch (ConfigurationException e) {
            Messages.showMessageDialog((Component)this.getContentPane(), (String)e.getMessage(), (String)ProjectBundle.message((String)"sdk.configure.save.settings.error", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.openapi.projectRoots.ui.ProjectJdksEditor";
    }

    public Sdk getSelectedJdk() {
        return this.myProjectJdk;
    }
}

