/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.wizard;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.settings.AbstractImportFromExternalSystemControl;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectDataSelectorDialog;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalProjectImportBuilder<C extends AbstractImportFromExternalSystemControl>
extends ProjectImportBuilder<DataNode<ProjectData>> {
    private static final Logger LOG = Logger.getInstance(AbstractExternalProjectImportBuilder.class);
    @NotNull
    private final ProjectDataManager myProjectDataManager;
    @NotNull
    private final NotNullLazyValue<C> myControlValue;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    private DataNode<ProjectData> myExternalProjectNode;

    @Deprecated
    public AbstractExternalProjectImportBuilder(@NotNull com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager projectDataManager, @NotNull C control, @NotNull ProjectSystemId externalSystemId) {
        if (projectDataManager == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(0);
        }
        if (control == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(1);
        }
        if (externalSystemId == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(2);
        }
        this((ProjectDataManager)projectDataManager, control, externalSystemId);
    }

    @Deprecated
    public AbstractExternalProjectImportBuilder(@NotNull ProjectDataManager projectDataManager, @NotNull C control, @NotNull ProjectSystemId externalSystemId) {
        if (projectDataManager == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(3);
        }
        if (control == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(4);
        }
        if (externalSystemId == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(5);
        }
        this.myProjectDataManager = projectDataManager;
        this.myControlValue = NotNullLazyValue.createValue(() -> control);
        this.myExternalSystemId = externalSystemId;
    }

    public AbstractExternalProjectImportBuilder(@NotNull ProjectDataManager projectDataManager, @NotNull NotNullFactory<? extends C> controlFactory, @NotNull ProjectSystemId externalSystemId) {
        if (projectDataManager == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(6);
        }
        if (controlFactory == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(7);
        }
        if (externalSystemId == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(8);
        }
        this.myProjectDataManager = projectDataManager;
        this.myControlValue = NotNullLazyValue.createValue(controlFactory);
        this.myExternalSystemId = externalSystemId;
    }

    @Override
    public List<DataNode<ProjectData>> getList() {
        return Collections.singletonList(this.myExternalProjectNode);
    }

    @Override
    public boolean isMarked(DataNode<ProjectData> element) {
        return true;
    }

    @Override
    public void setList(List<DataNode<ProjectData>> externalSystemProjects) {
    }

    @Override
    public void setOpenProjectSettingsAfter(boolean on) {
    }

    @NotNull
    public C getControl(@Nullable Project currentProject) {
        C control = this.getControl();
        ((AbstractImportFromExternalSystemControl)((Object)control)).setCurrentProject(currentProject);
        C c = control;
        if (c == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(9);
        }
        return c;
    }

    public void prepare(@NotNull WizardContext context) {
        if (context == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(10);
        }
        if (context.getProjectJdk() == null) {
            context.setProjectJdk(this.resolveProjectJdk(context));
        }
        C control = this.getControl();
        ((AbstractImportFromExternalSystemControl)((Object)control)).setShowProjectFormatPanel(context.isCreatingNewProject());
        ((AbstractImportFromExternalSystemControl)((Object)control)).reset(context, null);
        String pathToUse = this.getFileToImport();
        ((AbstractImportFromExternalSystemControl)((Object)control)).setLinkedProjectPath(pathToUse);
        this.doPrepare(context);
    }

    @Nullable
    protected Sdk resolveProjectJdk(@NotNull WizardContext context) {
        if (context == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(11);
        }
        Project project = context.getProject() != null ? context.getProject() : ProjectManager.getInstance().getDefaultProject();
        Pair sdkPair = ExternalSystemJdkUtil.getAvailableJdk((Project)project);
        if (!"#JAVA_INTERNAL".equals(sdkPair.first)) {
            return (Sdk)sdkPair.second;
        }
        return null;
    }

    protected abstract void doPrepare(@NotNull WizardContext var1);

    @Override
    public List<Module> commit(Project project, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        DataNode<ProjectData> externalProjectNode = this.getExternalProjectNode();
        if (externalProjectNode != null) {
            this.beforeCommit(externalProjectNode, project);
        }
        boolean isFromUI = model != null;
        final List modules = ContainerUtil.newSmartList();
        final IdentityHashMap moduleMap = ContainerUtil.newIdentityHashMap();
        IdeUIModifiableModelsProvider modelsProvider = isFromUI ? new IdeUIModifiableModelsProvider(project, model, (ModulesConfigurator)modulesProvider, artifactModel){

            @Override
            protected ModifiableRootModel doGetModifiableRootModel(Module module) {
                ModifiableRootModel modifiableRootModel = super.doGetModifiableRootModel(module);
                moduleMap.put(modifiableRootModel, module);
                return modifiableRootModel;
            }

            @Override
            public void commit() {
                super.commit();
                for (Map.Entry moduleEntry : moduleMap.entrySet()) {
                    modules.add(moduleEntry.getValue());
                }
            }
        } : new IdeModifiableModelsProviderImpl(project){

            @NotNull
            protected ModifiableRootModel doGetModifiableRootModel(@NotNull Module module) {
                if (module == null) {
                    2.$$$reportNull$$$0(0);
                }
                ModifiableRootModel modifiableRootModel = super.doGetModifiableRootModel(module);
                moduleMap.put(modifiableRootModel, module);
                ModifiableRootModel modifiableRootModel2 = modifiableRootModel;
                if (modifiableRootModel2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return modifiableRootModel2;
            }

            public void commit() {
                super.commit();
                for (Map.Entry moduleEntry : moduleMap.entrySet()) {
                    if (((ModifiableRootModel)moduleEntry.getKey()).isWritable()) continue;
                    modules.add(moduleEntry.getValue());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doGetModifiableRootModel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doGetModifiableRootModel";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)this.myExternalSystemId);
        ExternalProjectSettings projectSettings = this.getCurrentExternalProjectSettings();
        HashSet projects = ContainerUtilRt.newHashSet((Iterable)systemSettings.getLinkedProjectsSettings());
        projects.remove(projectSettings);
        projects.add(projectSettings);
        systemSettings.copyFrom(((AbstractImportFromExternalSystemControl)((Object)this.getControl())).getSystemSettings());
        systemSettings.setLinkedProjectsSettings((Collection)projects);
        if (externalProjectNode != null) {
            if (systemSettings.showSelectiveImportDialogOnInitialImport() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
                ExternalProjectDataSelectorDialog dialog = new ExternalProjectDataSelectorDialog(project, (ExternalProjectInfo)new InternalExternalProjectInfo(this.myExternalSystemId, projectSettings.getExternalProjectPath(), externalProjectNode));
                if (dialog.hasMultipleDataToSelect()) {
                    dialog.showAndGet();
                } else {
                    Disposer.dispose((Disposable)dialog.getDisposable());
                }
            }
            if (!project.isInitialized()) {
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> this.lambda$commit$1(project, externalProjectNode, isFromUI, modules, (IdeModifiableModelsProvider)modelsProvider, projectSettings));
            } else {
                this.finishImport(project, externalProjectNode, isFromUI, modules, (IdeModifiableModelsProvider)modelsProvider, projectSettings);
            }
        }
        return modules;
    }

    protected void finishImport(Project project, DataNode<ProjectData> externalProjectNode, boolean isFromUI, List<Module> modules, IdeModifiableModelsProvider modelsProvider, ExternalProjectSettings projectSettings) {
        this.myProjectDataManager.importData(externalProjectNode, project, modelsProvider, true);
        this.myExternalProjectNode = null;
        Runnable resolveDependenciesTask = () -> ExternalSystemUtil.refreshProject((Project)project, (ProjectSystemId)this.myExternalSystemId, (String)projectSettings.getExternalProjectPath(), (ExternalProjectRefreshCallback)this.createFinalImportCallback(project, projectSettings), (boolean)false, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC, (boolean)true);
        if (!isFromUI) {
            resolveDependenciesTask.run();
        } else {
            ExternalSystemUtil.invokeLater((Project)project, (ModalityState)ModalityState.NON_MODAL, () -> {
                Module[] committedModules = ModuleManager.getInstance((Project)project).getModules();
                if (Arrays.asList(committedModules).containsAll(modules)) {
                    resolveDependenciesTask.run();
                }
            });
        }
    }

    protected ExternalProjectRefreshCallback createFinalImportCallback(final @NotNull Project project, @NotNull ExternalProjectSettings projectSettings) {
        if (project == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(12);
        }
        if (projectSettings == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(13);
        }
        return new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    return;
                }
                ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, project, false);
            }
        };
    }

    @NotNull
    private ExternalProjectSettings getCurrentExternalProjectSettings() {
        ExternalProjectSettings result = ((AbstractImportFromExternalSystemControl)((Object)this.getControl())).getProjectSettings().clone();
        File externalProjectConfigFile = this.getExternalProjectConfigToUse(new File(result.getExternalProjectPath()));
        String linkedProjectPath = FileUtil.toCanonicalPath((String)externalProjectConfigFile.getPath());
        assert (linkedProjectPath != null);
        result.setExternalProjectPath(linkedProjectPath);
        ExternalProjectSettings externalProjectSettings = result;
        if (externalProjectSettings == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(14);
        }
        return externalProjectSettings;
    }

    protected abstract void beforeCommit(@NotNull DataNode<ProjectData> var1, @NotNull Project var2);

    @Nullable
    private File getProjectFile() {
        String path = ((AbstractImportFromExternalSystemControl)((Object)this.getControl())).getProjectSettings().getExternalProjectPath();
        return path == null ? null : new File(path);
    }

    public void ensureProjectIsDefined(@NotNull WizardContext wizardContext) throws ConfigurationException {
        if (wizardContext == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(15);
        }
        String externalSystemName = this.myExternalSystemId.getReadableName();
        File projectFile = this.getProjectFile();
        if (projectFile == null) {
            throw new ConfigurationException(ExternalSystemBundle.message((String)"error.project.undefined", (Object[])new Object[0]));
        }
        projectFile = this.getExternalProjectConfigToUse(projectFile);
        final Ref error = new Ref();
        ExternalProjectRefreshCallback callback = new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                AbstractExternalProjectImportBuilder.this.myExternalProjectNode = externalProject;
            }

            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!StringUtil.isEmpty((String)errorDetails)) {
                    LOG.warn(errorDetails);
                }
                error.set((Object)new ConfigurationException(ExternalSystemBundle.message((String)"error.resolve.with.log_link", (Object[])new Object[]{errorMessage, PathManager.getLogPath()}), ExternalSystemBundle.message((String)"error.resolve.generic", (Object[])new Object[0])));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder$4", "onFailure"));
            }
        };
        Project project = this.getProject(wizardContext);
        File finalProjectFile = projectFile;
        String externalProjectPath = FileUtil.toCanonicalPath((String)finalProjectFile.getAbsolutePath());
        Ref exRef = new Ref();
        this.executeAndRestoreDefaultProjectSettings(project, () -> {
            try {
                ExternalSystemUtil.refreshProject((Project)project, (ProjectSystemId)this.myExternalSystemId, (String)externalProjectPath, (ExternalProjectRefreshCallback)callback, (boolean)true, (ProgressExecutionMode)ProgressExecutionMode.MODAL_SYNC);
            }
            catch (IllegalArgumentException e) {
                exRef.set((Object)new ConfigurationException(e.getMessage(), ExternalSystemBundle.message((String)"error.cannot.parse.project", (Object[])new Object[]{externalSystemName})));
            }
        });
        ConfigurationException ex = (ConfigurationException)((Object)exRef.get());
        if (ex != null) {
            throw ex;
        }
        if (this.myExternalProjectNode == null) {
            ConfigurationException exception = (ConfigurationException)((Object)error.get());
            if (exception != null) {
                throw exception;
            }
        } else {
            this.applyProjectSettings(wizardContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndRestoreDefaultProjectSettings(@NotNull Project project, @NotNull Runnable task) {
        if (project == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(16);
        }
        if (task == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(17);
        }
        AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)this.myExternalSystemId);
        Object systemStateToRestore = null;
        if (systemSettings instanceof PersistentStateComponent) {
            systemStateToRestore = ((PersistentStateComponent)systemSettings).getState();
        }
        systemSettings.copyFrom(((AbstractImportFromExternalSystemControl)((Object)this.getControl())).getSystemSettings());
        Collection projectSettingsToRestore = systemSettings.getLinkedProjectsSettings();
        HashSet projects = ContainerUtilRt.newHashSet((Iterable)systemSettings.getLinkedProjectsSettings());
        projects.add(this.getCurrentExternalProjectSettings());
        systemSettings.setLinkedProjectsSettings((Collection)projects);
        try {
            task.run();
        }
        finally {
            if (systemStateToRestore != null) {
                ((PersistentStateComponent)systemSettings).loadState(systemStateToRestore);
            } else {
                systemSettings.setLinkedProjectsSettings(projectSettingsToRestore);
            }
        }
    }

    @NotNull
    protected abstract File getExternalProjectConfigToUse(@NotNull File var1);

    @Nullable
    public DataNode<ProjectData> getExternalProjectNode() {
        return this.myExternalProjectNode;
    }

    public void applyProjectSettings(@NotNull WizardContext context) {
        if (context == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(18);
        }
        if (this.myExternalProjectNode == null) {
            assert (false);
            return;
        }
        context.setProjectName(((ProjectData)this.myExternalProjectNode.getData()).getInternalName());
        context.setProjectFileDirectory(((ProjectData)this.myExternalProjectNode.getData()).getIdeProjectFileDirectoryPath());
        this.applyExtraSettings(context);
    }

    protected abstract void applyExtraSettings(@NotNull WizardContext var1);

    @NotNull
    public Project getProject(@NotNull WizardContext wizardContext) {
        Project result;
        if (wizardContext == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(19);
        }
        if ((result = wizardContext.getProject()) == null) {
            result = ProjectManager.getInstance().getDefaultProject();
        }
        Project project = result;
        if (project == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(20);
        }
        return project;
    }

    @Nullable
    public Project createProject(String name2, String path) {
        Project project = super.createProject(name2, path);
        if (project != null) {
            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
        }
        return project;
    }

    @NotNull
    private C getControl() {
        AbstractImportFromExternalSystemControl abstractImportFromExternalSystemControl = (AbstractImportFromExternalSystemControl)((Object)this.myControlValue.getValue());
        if (abstractImportFromExternalSystemControl == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(21);
        }
        return (C)((Object)abstractImportFromExternalSystemControl);
    }

    private /* synthetic */ void lambda$commit$1(Project project, DataNode externalProjectNode, boolean isFromUI, List modules, IdeModifiableModelsProvider modelsProvider, ExternalProjectSettings projectSettings) {
        this.finishImport(project, (DataNode<ProjectData>)externalProjectNode, isFromUI, modules, modelsProvider, projectSettings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 14: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 14: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataManager";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFactory";
                break;
            }
            case 9: 
            case 14: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder";
                break;
            }
            case 10: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder";
                break;
            }
            case 9: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getControl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentExternalProjectSettings";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 14: 
            case 20: 
            case 21: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectJdk";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFinalImportCallback";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "ensureProjectIsDefined";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "executeAndRestoreDefaultProjectSettings";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "applyProjectSettings";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 14: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

