/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.CommonBundle;
import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.RepositoryAttachDialog;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.jarRepository.services.MavenRepositoryServicesManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import gnu.trove.THashMap;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JComponent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.version.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.aether.ArtifactDependencyNode;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class JarRepositoryManager {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler");
    private static final String MAVEN_REPOSITORY_MACRO = "$MAVEN_REPOSITORY$";
    private static final String DEFAULT_REPOSITORY_PATH = ".m2/repository";
    private static final AtomicInteger ourTasksInProgress = new AtomicInteger();
    private static final Map<String, OrderRootType> ourClassifierToRootType = new HashMap<String, OrderRootType>();
    private static volatile File ourLocalRepositoryPath;

    public static boolean hasRunningTasks() {
        return ourTasksInProgress.get() > 0;
    }

    @Nullable
    public static NewLibraryConfiguration chooseLibraryAndDownload(@NotNull Project project, @Nullable String initialFilter, JComponent parentComponent) {
        NewLibraryConfiguration config;
        RepositoryAttachDialog dialog;
        if (project == null) {
            JarRepositoryManager.$$$reportNull$$$0(0);
        }
        if (!(dialog = new RepositoryAttachDialog(project, initialFilter, RepositoryAttachDialog.Mode.DOWNLOAD)).showAndGet()) {
            return null;
        }
        boolean attachSources = dialog.getAttachSources();
        boolean attachJavaDoc = dialog.getAttachJavaDoc();
        boolean attachAnnotations = dialog.getAttachExternalAnnotations();
        String copyTo = dialog.getDirectoryPath();
        JpsMavenRepositoryLibraryDescriptor libraryDescriptor = dialog.getSelectedLibraryDescriptor();
        EnumSet artifactKinds = ArtifactKind.kindsOf((boolean)attachSources, (boolean)attachJavaDoc, (String[])new String[]{libraryDescriptor.getPackaging()});
        if (attachAnnotations) {
            artifactKinds.add(ArtifactKind.ANNOTATIONS);
        }
        if ((config = JarRepositoryManager.resolveAndDownload(project, libraryDescriptor, artifactKinds, copyTo, RemoteRepositoriesConfiguration.getInstance(project).getRepositories())) == null) {
            Messages.showErrorDialog((Component)parentComponent, (String)("No files were downloaded for " + libraryDescriptor.getMavenId()), (String)CommonBundle.getErrorTitle());
        }
        return config;
    }

    @Nullable
    public static NewLibraryConfiguration resolveAndDownload(@NotNull Project project, @NotNull JpsMavenRepositoryLibraryDescriptor descriptor, Set<ArtifactKind> kinds, String copyTo, Collection<RemoteRepositoryDescription> repositories) {
        if (project == null) {
            JarRepositoryManager.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            JarRepositoryManager.$$$reportNull$$$0(2);
        }
        ArrayList<OrderRoot> roots = new ArrayList<OrderRoot>();
        if (descriptor.getMavenId() != null) {
            roots.addAll(JarRepositoryManager.loadDependenciesModal(project, descriptor, kinds, repositories, copyTo));
        }
        if (!roots.isEmpty()) {
            JarRepositoryManager.notifyArtifactsDownloaded(project, roots);
            return JarRepositoryManager.createNewLibraryConfiguration(new RepositoryLibraryProperties(descriptor), roots);
        }
        return null;
    }

    @Nullable
    public static NewLibraryConfiguration resolveAndDownload(@NotNull Project project, String coord, boolean attachSources, boolean attachJavaDoc, boolean includeTransitiveDependencies, String copyTo, Collection<RemoteRepositoryDescription> repositories) {
        if (project == null) {
            JarRepositoryManager.$$$reportNull$$$0(3);
        }
        JpsMavenRepositoryLibraryDescriptor libraryDescriptor = new JpsMavenRepositoryLibraryDescriptor(coord, includeTransitiveDependencies, Collections.emptyList());
        return JarRepositoryManager.resolveAndDownload(project, libraryDescriptor, ArtifactKind.kindsOf((boolean)attachSources, (boolean)attachJavaDoc, (String[])new String[]{libraryDescriptor.getPackaging()}), copyTo, repositories);
    }

    @NotNull
    protected static NewLibraryConfiguration createNewLibraryConfiguration(RepositoryLibraryProperties props, final Collection<? extends OrderRoot> roots) {
        NewLibraryConfiguration newLibraryConfiguration = new NewLibraryConfiguration(RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)props).getDisplayName(props.getVersion()), RepositoryLibraryType.getInstance(), (LibraryProperties)props){

            public void addRoots(@NotNull LibraryEditor editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                editor.addRoots(roots);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/jarRepository/JarRepositoryManager$1", "addRoots"));
            }
        };
        if (newLibraryConfiguration == null) {
            JarRepositoryManager.$$$reportNull$$$0(4);
        }
        return newLibraryConfiguration;
    }

    @NotNull
    public static File getLocalRepositoryPath() {
        File repoPath = ourLocalRepositoryPath;
        if (repoPath != null) {
            File file = repoPath;
            if (file == null) {
                JarRepositoryManager.$$$reportNull$$$0(5);
            }
            return file;
        }
        String expanded = PathMacroManager.getInstance((ComponentManager)ApplicationManager.getApplication()).expandPath(MAVEN_REPOSITORY_MACRO);
        if (!MAVEN_REPOSITORY_MACRO.equals(expanded) && (repoPath = new File(expanded)).exists()) {
            try {
                repoPath = repoPath.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ourLocalRepositoryPath = repoPath;
            File file = repoPath;
            if (file == null) {
                JarRepositoryManager.$$$reportNull$$$0(6);
            }
            return file;
        }
        String userHome = System.getProperty("user.home", null);
        ourLocalRepositoryPath = repoPath = userHome != null ? new File(userHome, DEFAULT_REPOSITORY_PATH) : new File(DEFAULT_REPOSITORY_PATH);
        File file = repoPath;
        if (file == null) {
            JarRepositoryManager.$$$reportNull$$$0(7);
        }
        return file;
    }

    static void setLocalRepositoryPath(File localRepo) {
        ourLocalRepositoryPath = localRepo;
    }

    public static Collection<OrderRoot> loadDependenciesModal(@NotNull Project project, @NotNull RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable String copyTo, @Nullable Collection<RemoteRepositoryDescription> repositories) {
        JpsMavenRepositoryLibraryDescriptor libDescriptor;
        if (project == null) {
            JarRepositoryManager.$$$reportNull$$$0(8);
        }
        if (libraryProps == null) {
            JarRepositoryManager.$$$reportNull$$$0(9);
        }
        if ((libDescriptor = libraryProps.getRepositoryLibraryDescriptor()).getMavenId() != null) {
            EnumSet kinds = ArtifactKind.kindsOf((boolean)loadSources, (boolean)loadJavadoc, (String[])new String[]{libraryProps.getPackaging()});
            return JarRepositoryManager.loadDependenciesModal(project, libDescriptor, kinds, repositories, copyTo);
        }
        return Collections.emptyList();
    }

    public static Collection<OrderRoot> loadDependenciesModal(@NotNull Project project, @NotNull JpsMavenRepositoryLibraryDescriptor desc, Set<ArtifactKind> artifactKinds, @Nullable Collection<RemoteRepositoryDescription> repositories, @Nullable String copyTo) {
        if (project == null) {
            JarRepositoryManager.$$$reportNull$$$0(10);
        }
        if (desc == null) {
            JarRepositoryManager.$$$reportNull$$$0(11);
        }
        Collection<RemoteRepositoryDescription> effectiveRepos = JarRepositoryManager.addDefaultsIfEmpty(project, repositories);
        return JarRepositoryManager.submitModalJob(project, "Resolving Maven dependencies...", JarRepositoryManager.newOrderRootResolveJob(desc, artifactKinds, effectiveRepos, copyTo));
    }

    public static Promise<List<OrderRoot>> loadDependenciesAsync(@NotNull Project project, RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo) {
        if (project == null) {
            JarRepositoryManager.$$$reportNull$$$0(12);
        }
        EnumSet kinds = ArtifactKind.kindsOf((boolean)loadSources, (boolean)loadJavadoc, (String[])new String[]{libraryProps.getPackaging()});
        return JarRepositoryManager.loadDependenciesAsync(project, libraryProps.getRepositoryLibraryDescriptor(), kinds, repos, copyTo);
    }

    public static Promise<List<OrderRoot>> loadDependenciesAsync(@NotNull Project project, JpsMavenRepositoryLibraryDescriptor desc, Set<ArtifactKind> artifactKinds, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo) {
        if (project == null) {
            JarRepositoryManager.$$$reportNull$$$0(13);
        }
        Collection<RemoteRepositoryDescription> effectiveRepos = JarRepositoryManager.addDefaultsIfEmpty(project, repos);
        return JarRepositoryManager.submitBackgroundJob(JarRepositoryManager.newOrderRootResolveJob(desc, artifactKinds, effectiveRepos, copyTo));
    }

    @Nullable
    public static List<OrderRoot> loadDependenciesSync(@NotNull Project project, JpsMavenRepositoryLibraryDescriptor desc, Set<ArtifactKind> artifactKinds, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo) {
        if (project == null) {
            JarRepositoryManager.$$$reportNull$$$0(14);
        }
        Collection<RemoteRepositoryDescription> effectiveRepos = JarRepositoryManager.addDefaultsIfEmpty(project, repos);
        return JarRepositoryManager.submitSyncJob(JarRepositoryManager.newOrderRootResolveJob(desc, artifactKinds, effectiveRepos, copyTo));
    }

    @NotNull
    protected static Collection<RemoteRepositoryDescription> addDefaultsIfEmpty(@NotNull Project project, @Nullable Collection<RemoteRepositoryDescription> repositories) {
        if (project == null) {
            JarRepositoryManager.$$$reportNull$$$0(15);
        }
        if (repositories == null || repositories.isEmpty()) {
            repositories = RemoteRepositoriesConfiguration.getInstance(project).getRepositories();
        }
        Collection<RemoteRepositoryDescription> collection = repositories;
        if (collection == null) {
            JarRepositoryManager.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    public static Promise<Collection<String>> getAvailableVersions(@NotNull Project project, @NotNull RepositoryLibraryDescription libraryDescription) {
        if (project == null) {
            JarRepositoryManager.$$$reportNull$$$0(17);
        }
        if (libraryDescription == null) {
            JarRepositoryManager.$$$reportNull$$$0(18);
        }
        List<RemoteRepositoryDescription> repos = RemoteRepositoriesConfiguration.getInstance(project).getRepositories();
        Promise<Collection<String>> promise = JarRepositoryManager.submitBackgroundJob(new VersionResolveJob(libraryDescription, repos));
        if (promise == null) {
            JarRepositoryManager.$$$reportNull$$$0(19);
        }
        return promise;
    }

    @Nullable
    public static ArtifactDependencyNode loadDependenciesTree(final @NotNull RepositoryLibraryDescription description, final @NotNull String version, Project project) {
        if (description == null) {
            JarRepositoryManager.$$$reportNull$$$0(20);
        }
        if (version == null) {
            JarRepositoryManager.$$$reportNull$$$0(21);
        }
        List<RemoteRepositoryDescription> repositories = RemoteRepositoriesConfiguration.getInstance(project).getRepositories();
        return JarRepositoryManager.submitModalJob(project, "Resolving Maven Dependencies", new AetherJob<ArtifactDependencyNode>(repositories){

            @Override
            protected String getProgressText() {
                return "Loading dependencies of " + description.getMavenCoordinates(version);
            }

            @Override
            protected ArtifactDependencyNode perform(ProgressIndicator progress, @NotNull ArtifactRepositoryManager manager) throws Exception {
                if (manager == null) {
                    2.$$$reportNull$$$0(0);
                }
                return manager.collectDependencies(description.getGroupId(), description.getArtifactId(), version);
            }

            @Override
            protected ArtifactDependencyNode getDefaultResult() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/jarRepository/JarRepositoryManager$2", "perform"));
            }
        });
    }

    private static void notifyArtifactsDownloaded(Project project, Collection<OrderRoot> roots) {
        StringBuilder sb = new StringBuilder();
        String title = "The following files were downloaded:";
        for (OrderRoot root : roots) {
            sb.append("<p/>");
            sb.append(root.getFile().getName());
        }
        Notifications.Bus.notify((Notification)new Notification("Repository", "The following files were downloaded:", sb.toString(), NotificationType.INFORMATION), (Project)project);
    }

    public static void searchArtifacts(Project project, String coord, Consumer<? super Collection<Pair<RepositoryArtifactDescription, RemoteRepositoryDescription>>> resultProcessor) {
        JarRepositoryManager.searchArtifacts(project, coord, "jar", resultProcessor);
    }

    public static void searchArtifacts(final Project project, String coord, String packaging, final Consumer<? super Collection<Pair<RepositoryArtifactDescription, RemoteRepositoryDescription>>> resultProcessor) {
        if (coord == null || coord.length() == 0) {
            return;
        }
        final RepositoryArtifactDescription template = coord.indexOf(58) == -1 && Character.isUpperCase(coord.charAt(0)) ? new RepositoryArtifactDescription(null, null, null, packaging, null, coord, null) : new RepositoryArtifactDescription(new RepositoryLibraryProperties(coord, packaging, true), null);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Maven", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                ArrayList<Pair> resultList = new ArrayList<Pair>();
                try {
                    for (String serviceUrl : MavenRepositoryServicesManager.getServiceUrls(project)) {
                        try {
                            List<RepositoryArtifactDescription> artifacts = MavenRepositoryServicesManager.findArtifacts(template, serviceUrl);
                            if (artifacts.isEmpty()) continue;
                            List<RemoteRepositoryDescription> repositories = MavenRepositoryServicesManager.getRepositories(serviceUrl);
                            THashMap map2 = new THashMap();
                            for (RemoteRepositoryDescription repository : repositories) {
                                map2.put(repository.getId(), repository);
                            }
                            for (RepositoryArtifactDescription artifact : artifacts) {
                                RemoteRepositoryDescription repository = (RemoteRepositoryDescription)map2.get(artifact.getRepositoryId());
                                if (repository == null) continue;
                                resultList.add(Pair.create((Object)artifact, (Object)repository));
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> resultProcessor.accept(resultList));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$3", "run"));
            }
        });
    }

    public static void searchRepositories(Project project, final Collection<String> serviceUrls, final Processor<? super Collection<RemoteRepositoryDescription>> resultProcessor) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Maven", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                Ref result = Ref.create(Collections.emptyList());
                try {
                    ArrayList<RemoteRepositoryDescription> repoList = new ArrayList<RemoteRepositoryDescription>();
                    for (String url : serviceUrls) {
                        List<RemoteRepositoryDescription> repositories;
                        try {
                            repositories = MavenRepositoryServicesManager.getRepositories(url);
                        }
                        catch (Exception ex) {
                            LOG.warn("Accessing Service at: " + url, (Throwable)ex);
                            continue;
                        }
                        repoList.addAll(repositories);
                    }
                    result.set(repoList);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> resultProcessor.process(result.get()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$4", "run"));
            }
        });
    }

    @Nullable
    private static <T> T submitSyncJob(@NotNull Function<? super ProgressIndicator, ? extends T> job) {
        if (job == null) {
            JarRepositoryManager.$$$reportNull$$$0(22);
        }
        try {
            ourTasksInProgress.incrementAndGet();
            EmptyProgressIndicator indicator = new EmptyProgressIndicator(ModalityState.defaultModalityState());
            Object object = ProgressManager.getInstance().runProcess(() -> JarRepositoryManager.lambda$submitSyncJob$0(job, (ProgressIndicator)indicator), (ProgressIndicator)indicator);
            return (T)object;
        }
        finally {
            ourTasksInProgress.decrementAndGet();
        }
    }

    @Nullable
    private static <T> T submitModalJob(@Nullable Project project, String title, final Function<? super ProgressIndicator, ? extends T> job) {
        final Ref result = Ref.create(null);
        new Task.Modal(project, title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                try {
                    ourTasksInProgress.incrementAndGet();
                    result.set(job.apply(indicator));
                }
                finally {
                    ourTasksInProgress.decrementAndGet();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$5", "run"));
            }
        }.queue();
        return (T)result.get();
    }

    @NotNull
    private static <T> Promise<T> submitBackgroundJob(@NotNull Function<? super ProgressIndicator, ? extends T> job) {
        if (job == null) {
            JarRepositoryManager.$$$reportNull$$$0(23);
        }
        ModalityState startModality = ModalityState.defaultModalityState();
        AsyncPromise promise = new AsyncPromise();
        JobExecutor.INSTANCE.submit(() -> {
            try {
                ourTasksInProgress.incrementAndGet();
                EmptyProgressIndicator indicator = new EmptyProgressIndicator(startModality);
                Object result = ProgressManager.getInstance().runProcess(() -> JarRepositoryManager.lambda$null$1(job, (ProgressIndicator)indicator), (ProgressIndicator)indicator);
                promise.setResult(result);
            }
            catch (ProcessCanceledException ignored) {
                promise.cancel();
            }
            catch (Throwable e) {
                LOG.info(e);
                promise.setError(e);
            }
            finally {
                ourTasksInProgress.decrementAndGet();
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            JarRepositoryManager.$$$reportNull$$$0(24);
        }
        return asyncPromise;
    }

    @NotNull
    private static Collection<String> lookupVersionsImpl(String groupId, String artifactId, @NotNull ArtifactRepositoryManager manager) throws Exception {
        ArrayList<String> arrayList;
        if (manager == null) {
            JarRepositoryManager.$$$reportNull$$$0(25);
        }
        try {
            ArrayList versions = new ArrayList(manager.getAvailableVersions(groupId, artifactId, "[0,)", ArtifactKind.ARTIFACT));
            ArrayList<String> strings = new ArrayList<String>(versions.size());
            for (int i = versions.size() - 1; i >= 0; --i) {
                strings.add(((Version)versions.get(i)).toString());
            }
            arrayList = strings;
        }
        catch (TransferCancelledException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
        if (arrayList == null) {
            JarRepositoryManager.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    private static Function<ProgressIndicator, List<OrderRoot>> newOrderRootResolveJob(@NotNull JpsMavenRepositoryLibraryDescriptor desc, @NotNull Set<ArtifactKind> kinds, @NotNull Collection<RemoteRepositoryDescription> repositories, @Nullable String copyTo) {
        if (desc == null) {
            JarRepositoryManager.$$$reportNull$$$0(27);
        }
        if (kinds == null) {
            JarRepositoryManager.$$$reportNull$$$0(28);
        }
        if (repositories == null) {
            JarRepositoryManager.$$$reportNull$$$0(29);
        }
        return new LibraryResolveJob(desc, kinds, repositories).andThen(resolved -> resolved.isEmpty() ? Collections.emptyList() : (List)WriteAction.computeAndWait(() -> JarRepositoryManager.createRoots(resolved, copyTo)));
    }

    private static List<OrderRoot> createRoots(@NotNull Collection<? extends Artifact> artifacts, @Nullable String copyTo) {
        if (artifacts == null) {
            JarRepositoryManager.$$$reportNull$$$0(30);
        }
        ArrayList<OrderRoot> result = new ArrayList<OrderRoot>();
        VirtualFileManager manager = VirtualFileManager.getInstance();
        for (Artifact artifact : artifacts) {
            try {
                File repoFile;
                File toFile = repoFile = artifact.getFile();
                if (copyTo != null) {
                    toFile = new File(copyTo, repoFile.getName());
                    if (repoFile.exists()) {
                        FileUtil.copy((File)repoFile, (File)toFile);
                    }
                }
                manager.refreshAndFindFileByUrl(VfsUtilCore.pathToUrl((String)toFile.getPath()));
                String url = VfsUtil.getUrlForLibraryRoot((File)toFile);
                VirtualFile file = manager.refreshAndFindFileByUrl(url);
                if (file == null) continue;
                OrderRootType rootType = ourClassifierToRootType.getOrDefault(artifact.getClassifier(), OrderRootType.CLASSES);
                result.add(new OrderRoot(file, rootType));
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        return result;
    }

    private static /* synthetic */ Object lambda$null$1(Function job, ProgressIndicator indicator) {
        return job.apply(indicator);
    }

    private static /* synthetic */ Object lambda$submitSyncJob$0(Function job, ProgressIndicator indicator) {
        return job.apply(indicator);
    }

    static {
        ourClassifierToRootType.put(ArtifactKind.ARTIFACT.getClassifier(), OrderRootType.CLASSES);
        ourClassifierToRootType.put(ArtifactKind.JAVADOC.getClassifier(), JavadocOrderRootType.getInstance());
        ourClassifierToRootType.put(ArtifactKind.SOURCES.getClassifier(), OrderRootType.SOURCES);
        ourClassifierToRootType.put(ArtifactKind.ANNOTATIONS.getClassifier(), AnnotationOrderRootType.getInstance());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 19: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 19: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 19: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/JarRepositoryManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryProps";
                break;
            }
            case 11: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDescription";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/JarRepositoryManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewLibraryConfiguration";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRepositoryPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addDefaultsIfEmpty";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableVersions";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "submitBackgroundJob";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupVersionsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "chooseLibraryAndDownload";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndDownload";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 19: 
            case 24: 
            case 26: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesModal";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesAsync";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesSync";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultsIfEmpty";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableVersions";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesTree";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "submitSyncJob";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "submitBackgroundJob";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lookupVersionsImpl";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "newOrderRootResolveJob";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 19: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VersionResolveJob
    extends AetherJob<Collection<String>> {
        @NotNull
        private final RepositoryLibraryDescription myDescription;

        VersionResolveJob(@NotNull RepositoryLibraryDescription repositoryLibraryDescription, @NotNull List<RemoteRepositoryDescription> repositories) {
            if (repositoryLibraryDescription == null) {
                VersionResolveJob.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                VersionResolveJob.$$$reportNull$$$0(1);
            }
            super(repositories);
            this.myDescription = repositoryLibraryDescription;
        }

        @Override
        protected String getProgressText() {
            return "Loading " + this.myDescription.getDisplayName() + " versions";
        }

        @Override
        protected Collection<String> perform(ProgressIndicator progress, @NotNull ArtifactRepositoryManager manager) throws Exception {
            if (manager == null) {
                VersionResolveJob.$$$reportNull$$$0(2);
            }
            return JarRepositoryManager.lookupVersionsImpl(this.myDescription.getGroupId(), this.myDescription.getArtifactId(), manager);
        }

        @Override
        protected Collection<String> getDefaultResult() {
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositoryLibraryDescription";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jarRepository/JarRepositoryManager$VersionResolveJob";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LibraryResolveJob
    extends AetherJob<Collection<Artifact>> {
        @NotNull
        private final JpsMavenRepositoryLibraryDescriptor myDesc;
        @NotNull
        private final Set<ArtifactKind> myKinds;

        LibraryResolveJob(@NotNull JpsMavenRepositoryLibraryDescriptor desc, @NotNull Set<ArtifactKind> kinds, @NotNull Collection<RemoteRepositoryDescription> repositories) {
            if (desc == null) {
                LibraryResolveJob.$$$reportNull$$$0(0);
            }
            if (kinds == null) {
                LibraryResolveJob.$$$reportNull$$$0(1);
            }
            if (repositories == null) {
                LibraryResolveJob.$$$reportNull$$$0(2);
            }
            super(repositories);
            this.myDesc = desc;
            this.myKinds = kinds;
        }

        @Override
        protected boolean canStart() {
            return super.canStart() && this.myDesc.getMavenId() != null;
        }

        @Override
        protected String getProgressText() {
            return "Loading " + RepositoryLibraryDescription.findDescription((JpsMavenRepositoryLibraryDescriptor)this.myDesc).getDisplayName();
        }

        @Override
        protected Collection<Artifact> getDefaultResult() {
            return Collections.emptyList();
        }

        @Override
        protected Collection<Artifact> perform(ProgressIndicator progress, @NotNull ArtifactRepositoryManager manager) throws Exception {
            if (manager == null) {
                LibraryResolveJob.$$$reportNull$$$0(3);
            }
            String version = this.myDesc.getVersion();
            try {
                return manager.resolveDependencyAsArtifact(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), version, this.myKinds, this.myDesc.isIncludeTransitiveDependencies(), this.myDesc.getExcludedDependencies());
            }
            catch (TransferCancelledException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (RepositoryOfflineException e) {
                throw e;
            }
            catch (Exception e) {
                String resolvedVersion = this.resolveVersion(manager, version);
                if (Comparing.equal((String)version, (String)resolvedVersion)) {
                    throw e;
                }
                try {
                    return manager.resolveDependencyAsArtifact(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), resolvedVersion, this.myKinds, this.myDesc.isIncludeTransitiveDependencies(), this.myDesc.getExcludedDependencies());
                }
                catch (TransferCancelledException e1) {
                    throw new ProcessCanceledException((Throwable)e1);
                }
            }
        }

        @Nullable
        private String resolveVersion(ArtifactRepositoryManager manager, String version) throws Exception {
            boolean isLatest = "LATEST".equals(version);
            boolean isRelease = "RELEASE".equals(version);
            if (isLatest || isRelease) {
                try {
                    for (String ver : JarRepositoryManager.lookupVersionsImpl(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), manager)) {
                        if (isRelease && ver.endsWith("-SNAPSHOT")) continue;
                        return ver;
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error("Got unexpected exception while resolving artifact versions", (Throwable)e);
                }
            }
            return version;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kinds";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jarRepository/JarRepositoryManager$LibraryResolveJob";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class AetherJob<T>
    implements Function<ProgressIndicator, T> {
        @NotNull
        private final Collection<? extends RemoteRepositoryDescription> myRepositories;

        AetherJob(@NotNull Collection<? extends RemoteRepositoryDescription> repositories) {
            if (repositories == null) {
                AetherJob.$$$reportNull$$$0(0);
            }
            this.myRepositories = repositories;
        }

        protected boolean canStart() {
            return !this.myRepositories.isEmpty();
        }

        @Override
        public final T apply(final ProgressIndicator indicator) {
            if (this.canStart()) {
                indicator.setText(this.getProgressText());
                indicator.setIndeterminate(true);
                ArrayList<RemoteRepository> remotes = new ArrayList<RemoteRepository>();
                for (RemoteRepositoryDescription remoteRepositoryDescription : this.myRepositories) {
                    remotes.add(ArtifactRepositoryManager.createRemoteRepository((String)remoteRepositoryDescription.getId(), (String)remoteRepositoryDescription.getUrl()));
                }
                try {
                    return this.perform(indicator, new ArtifactRepositoryManager(JarRepositoryManager.getLocalRepositoryPath(), remotes, new ProgressConsumer(){

                        public void consume(String message2) {
                            indicator.setText(message2);
                        }

                        public boolean isCanceled() {
                            return indicator.isCanceled();
                        }
                    }));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }
            return this.getDefaultResult();
        }

        protected abstract String getProgressText();

        protected abstract T perform(ProgressIndicator var1, @NotNull ArtifactRepositoryManager var2) throws Exception;

        protected abstract T getDefaultResult();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/jarRepository/JarRepositoryManager$AetherJob", "<init>"));
        }
    }

    private static class JobExecutor {
        static final ExecutorService INSTANCE = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"RemoteLibraryDownloader");

        private JobExecutor() {
        }
    }
}

