/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;

public class NamePathComponent
extends JPanel {
    private static final Logger LOG = Logger.getInstance(NamePathComponent.class);
    private final JTextField myTfName = new JTextField();
    private final JTextField myTfPath;
    private final JLabel myNameLabel;
    private final FieldPanel myPathPanel;
    private boolean myIsNameChangedByUser = false;
    private boolean myIsPathChangedByUser = false;
    private boolean myIsPathNameSyncEnabled = true;
    private boolean myIsNamePathSyncEnabled = true;
    private boolean myShouldBeAbsolute;

    public NamePathComponent(String nameLabelText, String pathLabelText, String pathChooserTitle, String pathChooserDescription) {
        this(nameLabelText, pathLabelText, pathChooserTitle, pathChooserDescription, true);
    }

    public NamePathComponent(String nameLabelText, String pathLabelText, String pathChooserTitle, String pathChooserDescription, boolean hideIgnored) {
        this(nameLabelText, pathLabelText, pathChooserTitle, pathChooserDescription, hideIgnored, true);
    }

    public NamePathComponent(String nameLabelText, String pathLabelText, String pathChooserTitle, String pathChooserDescription, boolean hideIgnored, boolean bold) {
        super(new GridBagLayout());
        this.myTfName.setDocument(new NameFieldDocument());
        this.myTfName.setPreferredSize(new Dimension(200, this.myTfName.getPreferredSize().height));
        this.myTfPath = new JTextField();
        this.myTfPath.setDocument(new PathFieldDocument());
        this.myTfPath.setPreferredSize(new Dimension(200, this.myTfPath.getPreferredSize().height));
        this.myNameLabel = new JLabel(nameLabelText);
        if (bold) {
            this.myNameLabel.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
        }
        this.myNameLabel.setLabelFor(this.myTfName);
        FileChooserDescriptor chooserDescriptor = (FileChooserDescriptor)BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR.clone();
        chooserDescriptor.setHideIgnored(hideIgnored);
        BrowseFilesListener browseButtonActionListener = new BrowseFilesListener(this.myTfPath, pathChooserTitle, pathChooserDescription, chooserDescriptor){

            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                NamePathComponent.this.myIsPathChangedByUser = true;
            }
        };
        this.myPathPanel = new FieldPanel(this.myTfPath, null, null, (ActionListener)browseButtonActionListener, null);
        JLabel pathLabel = new JLabel(pathLabelText);
        if (bold) {
            pathLabel.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
        }
        pathLabel.setLabelFor(this.myTfPath);
        this.add((Component)this.myNameLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)0, (int)0, (int)5, (int)4), 0, 0));
        this.add((Component)this.myTfName, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsBottom((int)5), 0, 0));
        this.add((Component)pathLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)0, (int)0, (int)5, (int)4), 0, 0));
        this.add((Component)this.myPathPanel, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsBottom((int)5), 0, 0));
    }

    public static NamePathComponent initNamePathComponent(WizardContext context) {
        NamePathComponent component = new NamePathComponent(IdeBundle.message((String)"label.project.name", (Object[])new Object[0]), IdeBundle.message((String)"label.project.files.location", (Object[])new Object[0]), IdeBundle.message((String)"title.select.project.file.directory", (Object[])new Object[]{IdeBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0])}), IdeBundle.message((String)"description.select.project.file.directory", (Object[])new Object[]{StringUtil.capitalize((String)IdeBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0]))}), true, false);
        String baseDir = context.getProjectFileDirectory();
        String projectName = context.getProjectName();
        String initialProjectName = projectName != null ? projectName : ProjectWizardUtil.findNonExistingFileName(baseDir, "untitled", "");
        component.setPath(projectName == null ? baseDir + File.separator + initialProjectName : baseDir);
        component.setNameValue(initialProjectName);
        component.getNameComponent().select(0, initialProjectName.length());
        return component;
    }

    public boolean validateNameAndPath(WizardContext context, boolean defaultFormat) throws ConfigurationException {
        String name2 = this.getNameValue();
        if (StringUtil.isEmptyOrSpaces((String)name2)) {
            ApplicationNamesInfo info = ApplicationNamesInfo.getInstance();
            throw new ConfigurationException(IdeBundle.message((String)"prompt.new.project.file.name", (Object[])new Object[]{info.getFullProductName(), context.getPresentationName()}));
        }
        String projectDirectory = this.getPath();
        if (StringUtil.isEmptyOrSpaces((String)projectDirectory)) {
            throw new ConfigurationException(IdeBundle.message((String)"prompt.enter.project.file.location", (Object[])new Object[]{context.getPresentationName()}));
        }
        if (this.myShouldBeAbsolute && !new File(projectDirectory).isAbsolute()) {
            throw new ConfigurationException(StringUtil.capitalize((String)IdeBundle.message((String)"file.location.should.be.absolute", (Object[])new Object[]{context.getPresentationName()})));
        }
        boolean shouldPromptCreation = this.isPathChangedByUser();
        String message2 = IdeBundle.message((String)"directory.project.file.directory", (Object[])new Object[]{context.getPresentationName()});
        if (!ProjectWizardUtil.createDirectoryIfNotExists(message2, projectDirectory, shouldPromptCreation)) {
            return false;
        }
        File file = new File(projectDirectory);
        if (file.exists() && !file.canWrite()) {
            throw new ConfigurationException(IdeBundle.message((String)"project.directory.is.not.writable", (Object[])new Object[]{projectDirectory}));
        }
        for (Project p : ProjectManager.getInstance().getOpenProjects()) {
            if (!ProjectUtil.isSameProject((String)projectDirectory, (Project)p)) continue;
            throw new ConfigurationException(IdeBundle.message((String)"project.directory.is.already.taken", (Object[])new Object[]{projectDirectory, p.getName()}));
        }
        boolean shouldContinue = true;
        String[] children = file.list();
        if (children == null) {
            throw new ConfigurationException(IdeBundle.message((String)"project.directory.is.not.directory", (Object[])new Object[]{projectDirectory}));
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && children.length > 0) {
            message2 = IdeBundle.message((String)"prompt.overwrite.project", (Object[])new Object[]{context.getPresentationName()});
            int answer = Messages.showYesNoDialog((String)message2, (String)IdeBundle.message((String)"title.folder.not.empty", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            shouldContinue = answer == 0;
        }
        return shouldContinue;
    }

    public String getNameValue() {
        return this.myTfName.getText().trim();
    }

    public void setNameValue(String name2) {
        boolean isNameChangedByUser = this.myIsNameChangedByUser;
        this.myIsNamePathSyncEnabled = false;
        try {
            this.myTfName.setText(name2);
        }
        finally {
            this.myIsNameChangedByUser = isNameChangedByUser;
            this.myIsNamePathSyncEnabled = true;
        }
    }

    public String getPath() {
        String text2 = this.myTfPath.getText().trim();
        return FileUtil.toCanonicalPath((String)FileUtil.expandUserHome((String)text2));
    }

    public void setPath(String path) {
        boolean isPathChangedByUser = this.myIsPathChangedByUser;
        this.myIsPathNameSyncEnabled = false;
        try {
            this.myTfPath.setText(FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)path)));
        }
        finally {
            this.myIsPathChangedByUser = isPathChangedByUser;
            this.myIsPathNameSyncEnabled = true;
        }
    }

    @NotNull
    public JTextField getNameComponent() {
        JTextField jTextField = this.myTfName;
        if (jTextField == null) {
            NamePathComponent.$$$reportNull$$$0(0);
        }
        return jTextField;
    }

    public void setNameComponentVisible(boolean visible) {
        this.myTfName.setVisible(visible);
        this.myNameLabel.setVisible(visible);
    }

    @NotNull
    public JTextField getPathComponent() {
        JTextField jTextField = this.myTfPath;
        if (jTextField == null) {
            NamePathComponent.$$$reportNull$$$0(1);
        }
        return jTextField;
    }

    @NotNull
    public FieldPanel getPathPanel() {
        FieldPanel fieldPanel = this.myPathPanel;
        if (fieldPanel == null) {
            NamePathComponent.$$$reportNull$$$0(2);
        }
        return fieldPanel;
    }

    public boolean isNameChangedByUser() {
        return this.myIsNameChangedByUser;
    }

    public boolean isPathChangedByUser() {
        return this.myIsPathChangedByUser;
    }

    public void addChangeListener(final Runnable callback) {
        DocumentAdapter adapter = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                callback.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/projectWizard/NamePathComponent$2", "textChanged"));
            }
        };
        this.myTfName.getDocument().addDocumentListener((DocumentListener)adapter);
        this.myTfPath.getDocument().addDocumentListener((DocumentListener)adapter);
    }

    public void setShouldBeAbsolute(boolean shouldBeAbsolute) {
        this.myShouldBeAbsolute = shouldBeAbsolute;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/util/projectWizard/NamePathComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathPanel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class PathFieldDocument
    extends PlainDocument {
        PathFieldDocument() {
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void textChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    NamePathComponent.this.myIsPathChangedByUser = true;
                    PathFieldDocument.this.syncPathAndName();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/projectWizard/NamePathComponent$PathFieldDocument$1", "textChanged"));
                }
            });
        }

        private void syncPathAndName() {
            if (NamePathComponent.this.myIsPathNameSyncEnabled && !NamePathComponent.this.isNameChangedByUser()) {
                try {
                    NamePathComponent.this.myIsNamePathSyncEnabled = false;
                    String path = this.getText(0, this.getLength());
                    int lastSeparatorIndex = path.lastIndexOf(File.separator);
                    if (lastSeparatorIndex >= 0 && lastSeparatorIndex + 1 < path.length()) {
                        NamePathComponent.this.setNameValue(path.substring(lastSeparatorIndex + 1));
                    }
                }
                catch (BadLocationException e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    NamePathComponent.this.myIsNamePathSyncEnabled = true;
                }
            }
        }
    }

    private class NameFieldDocument
    extends PlainDocument {
        NameFieldDocument() {
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void textChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    NamePathComponent.this.myIsNameChangedByUser = true;
                    NameFieldDocument.this.syncNameAndPath();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/projectWizard/NamePathComponent$NameFieldDocument$1", "textChanged"));
                }
            });
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            boolean ok = true;
            for (int idx = 0; idx < str.length() && ok; ++idx) {
                char ch = str.charAt(idx);
                ok = ch != File.separatorChar && ch != '\\' && ch != '/' && ch != '|' && ch != ':';
            }
            if (ok) {
                super.insertString(offs, str, a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void syncNameAndPath() {
            if (NamePathComponent.this.myIsNamePathSyncEnabled && !NamePathComponent.this.isPathChangedByUser()) {
                try {
                    NamePathComponent.this.myIsPathNameSyncEnabled = false;
                    String name2 = this.getText(0, this.getLength());
                    String path = NamePathComponent.this.myTfPath.getText().trim();
                    int lastSeparatorIndex = path.lastIndexOf(File.separator);
                    if (lastSeparatorIndex >= 0) {
                        NamePathComponent.this.setPath(path.substring(0, lastSeparatorIndex + 1) + name2);
                    } else if (!path.isEmpty()) {
                        NamePathComponent.this.setPath(path + File.separatorChar + name2);
                    }
                }
                catch (BadLocationException e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    NamePathComponent.this.myIsPathNameSyncEnabled = true;
                }
            }
        }
    }
}

