/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinder;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.projectRoots.ui.ProjectJdksEditor;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.StatusText;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkChooserPanel
extends JPanel {
    @Nullable
    private final Project myProject;
    private final DefaultListModel<Sdk> myListModel;
    private final JBList<Sdk> myList;
    private final LoadingDecorator myLoadingDecorator;
    private Sdk myCurrentJdk;
    private SdkType[] myAllowedJdkTypes = null;

    public JdkChooserPanel(@Nullable Project project) {
        super(new BorderLayout());
        this.myProject = project;
        this.myListModel = new DefaultListModel();
        this.myList = new JBList(this.myListModel);
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<Sdk>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Sdk> list, Sdk value2, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                OrderEntryAppearanceService.getInstance().forJdk(value2, false, selected, true).customize((SimpleColoredComponent)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/util/projectWizard/JdkChooserPanel$1", "customizeCellRenderer"));
            }
        });
        this.myList.addListSelectionListener(e -> {
            this.myCurrentJdk = (Sdk)this.myList.getSelectedValue();
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (JdkChooserPanel.this.myProject == null) {
                    JdkChooserPanel.this.editJdkTable();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/projectWizard/JdkChooserPanel$2", "onClick"));
            }
        }.installOn(this.myList);
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.height = Math.max(size.height, JdkChooserPanel.this.myList.getVisibleRowCount() * JdkChooserPanel.this.myList.getFixedCellHeight());
                return size;
            }
        };
        panel.add((Component)ScrollPaneFactory.createScrollPane(this.myList), "Center");
        this.myLoadingDecorator = new LoadingDecorator((JComponent)panel, (Disposable)project, 0, true);
        this.myLoadingDecorator.setLoadingText("Looking for JDKs...");
        this.add((Component)this.myLoadingDecorator.getComponent(), "Center");
        if (this.myListModel.getSize() > 0) {
            this.myList.setSelectedIndex(0);
        }
    }

    public void setAllowedJdkTypes(@Nullable SdkType[] allowedJdkTypes) {
        this.myAllowedJdkTypes = allowedJdkTypes;
    }

    public Sdk getChosenJdk() {
        return this.myCurrentJdk;
    }

    public Object[] getAllJdks() {
        return this.myListModel.toArray();
    }

    public void editJdkTable() {
        ProjectJdksEditor editor = new ProjectJdksEditor((Sdk)this.myList.getSelectedValue(), this.myProject != null ? this.myProject : ProjectManager.getInstance().getDefaultProject(), (Component)this.myList);
        if (editor.showAndGet()) {
            Sdk selectedJdk = editor.getSelectedJdk();
            this.updateList(selectedJdk, null);
        }
    }

    public void updateList(Sdk selectedJdk, @Nullable SdkType type2) {
        this.updateList(selectedJdk, type2, null);
    }

    public void updateList(Sdk selectedJdk, @Nullable SdkType type2, @Nullable Sdk[] globalSdks) {
        int[] selectedIndices = this.myList.getSelectedIndices();
        this.fillList(type2, globalSdks);
        if (selectedJdk != null) {
            TIntArrayList list = new TIntArrayList();
            for (int i = 0; i < this.myListModel.size(); ++i) {
                Sdk jdk = this.myListModel.getElementAt(i);
                if (!Comparing.strEqual((String)jdk.getName(), (String)selectedJdk.getName())) continue;
                list.add(i);
            }
            int[] indicesToSelect = list.toNativeArray();
            if (indicesToSelect.length > 0) {
                this.myList.setSelectedIndices(indicesToSelect);
            } else if (this.myList.getModel().getSize() > 0) {
                this.myList.setSelectedIndex(0);
            }
        } else if (selectedIndices.length > 0) {
            this.myList.setSelectedIndices(selectedIndices);
        } else {
            this.myList.setSelectedIndex(0);
        }
        this.myCurrentJdk = (Sdk)this.myList.getSelectedValue();
    }

    public JList getPreferredFocusedComponent() {
        return this.myList;
    }

    public void fillList(@Nullable SdkType type2, @Nullable Sdk[] globalSdks) {
        Object allJdks;
        ArrayList<Sdk> knownJdks = new ArrayList<Sdk>();
        if (this.myProject == null || this.myProject.isDefault()) {
            allJdks = globalSdks != null ? globalSdks : ProjectJdkTable.getInstance().getAllJdks();
            knownJdks.addAll(this.getCompatibleJdks(type2, Arrays.asList(allJdks)));
        } else {
            ProjectSdksModel projectJdksModel = ProjectStructureConfigurable.getInstance(this.myProject).getProjectJdksModel();
            if (!projectJdksModel.isInitialized()) {
                projectJdksModel.reset(this.myProject);
            }
            Collection collection = projectJdksModel.getProjectSdks().values();
            knownJdks.addAll(this.getCompatibleJdks(type2, collection));
        }
        allJdks = new ArrayList(knownJdks);
        if (Registry.is((String)"autodetect.all.jdks") && (type2 == null || type2 instanceof JavaSdkType)) {
            this.myList.getEmptyText().setText("");
            this.myLoadingDecorator.startLoading(false);
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.lambda$fillList$3(knownJdks, (ArrayList)allJdks));
        } else {
            this.updateListModel((ArrayList<? extends Sdk>)allJdks, knownJdks);
        }
    }

    private void updateListModel(ArrayList<? extends Sdk> allJdks, ArrayList<? extends Sdk> knownJdks) {
        Sdk oldSelection = (Sdk)this.myList.getSelectedValue();
        this.myListModel.clear();
        Collections.sort(allJdks, (o1, o2) -> {
            String v2;
            boolean unknown2;
            boolean unknown1 = !knownJdks.contains(o1);
            boolean bl = unknown2 = !knownJdks.contains(o2);
            if (unknown1 != unknown2) {
                return unknown1 ? 1 : -1;
            }
            String v1 = o1.getVersionString();
            if (v1 != null & (v2 = o2.getVersionString()) != null) {
                try {
                    return -JavaVersion.parse((String)v1).compareTo(JavaVersion.parse((String)v2));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return -o1.getName().compareToIgnoreCase(o2.getName());
        });
        for (Sdk sdk : allJdks) {
            this.myListModel.addElement(sdk);
        }
        if (oldSelection != null) {
            ScrollingUtil.selectItem(this.myList, (Object)oldSelection);
        }
    }

    private List<Sdk> getCompatibleJdks(@Nullable SdkType type2, Collection<? extends Sdk> collection) {
        HashSet<Sdk> compatibleJdks = new HashSet<Sdk>();
        for (Sdk sdk : collection) {
            if (!this.isCompatibleJdk(sdk, type2)) continue;
            compatibleJdks.add(sdk);
        }
        return new ArrayList<Sdk>(compatibleJdks);
    }

    private boolean isCompatibleJdk(Sdk projectJdk, @Nullable SdkType type2) {
        if (type2 != null) {
            return projectJdk.getSdkType() == type2;
        }
        if (this.myAllowedJdkTypes != null) {
            return ArrayUtil.indexOf((Object[])this.myAllowedJdkTypes, (Object)projectJdk.getSdkType()) >= 0;
        }
        return true;
    }

    public JComponent getDefaultFocusedComponent() {
        return this.myList;
    }

    public void selectJdk(@Nullable Sdk defaultJdk) {
        if (defaultJdk != null) {
            ScrollingUtil.selectItem(this.myList, (Object)defaultJdk);
        }
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this.myList.addListSelectionListener(listener);
    }

    private static Sdk showDialog(Project project, String title, Component parent, Sdk jdkToSelect) {
        JdkChooserPanel jdkChooserPanel = new JdkChooserPanel(project);
        jdkChooserPanel.fillList(null, null);
        JdkChooserPanel jdkChooserPanel2 = jdkChooserPanel;
        jdkChooserPanel2.getClass();
        final MyDialog dialog = jdkChooserPanel2.new MyDialog(parent);
        if (title != null) {
            dialog.setTitle(title);
        }
        if (jdkToSelect != null) {
            jdkChooserPanel.selectJdk(jdkToSelect);
        } else {
            ScrollingUtil.ensureSelectionExists(jdkChooserPanel.myList);
        }
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                dialog.clickDefaultButton();
                return true;
            }
        }.installOn(jdkChooserPanel.myList);
        return dialog.showAndGet() ? jdkChooserPanel.getChosenJdk() : null;
    }

    public static Sdk chooseAndSetJDK(Project project) {
        String path;
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Sdk jdk = JdkChooserPanel.showDialog(project, ProjectBundle.message((String)"module.libraries.target.jdk.select.title", (Object[])new Object[0]), (Component)WindowManagerEx.getInstanceEx().getFrame(project), projectJdk);
        String string = path = jdk != null ? jdk.getHomePath() : null;
        if (path == null) {
            return null;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ProjectJdkTable table = ProjectJdkTable.getInstance();
            List sdks = table.getSdksOfType(jdk.getSdkType());
            if (ContainerUtil.find((Iterable)sdks, sdk -> path.equals(sdk.getHomePath())) == null) {
                table.addJdk(jdk);
            }
            ProjectRootManager.getInstance((Project)project).setProjectSdk(jdk);
        });
        return jdk;
    }

    private /* synthetic */ void lambda$fillList$3(ArrayList knownJdks, ArrayList allJdks) {
        List<String> suggestedPaths = JavaHomeFinder.suggestHomePaths();
        suggestedPaths.removeAll(ContainerUtil.map((Collection)knownJdks, sdk -> sdk.getHomePath()));
        ApplicationManager.getApplication().invokeLater(() -> {
            for (String homePath : suggestedPaths) {
                JavaSdk sdkType;
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(homePath);
                if (virtualFile == null) continue;
                JavaVersion version = JavaVersion.tryParse((String)(sdkType = JavaSdk.getInstance()).getVersionString(homePath));
                String suggestedName = version != null ? version.toString() : "";
                Sdk jdk = sdkType.createJdk(suggestedName, homePath, false);
                if (jdk instanceof ProjectJdkImpl) {
                    ProjectJdkImpl tmp = SdkConfigurationUtil.createSdk((Sdk[])allJdks.toArray(new Sdk[0]), (VirtualFile)virtualFile, (SdkType)sdkType, null, (String)suggestedName);
                    String improvedName = tmp.getName();
                    ((ProjectJdkImpl)jdk).setName(improvedName);
                }
                allJdks.add(jdk);
            }
            this.updateListModel(allJdks, knownJdks);
            this.myLoadingDecorator.stopLoading();
            this.myList.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
        }, ModalityState.any());
    }

    public class MyDialog
    extends DialogWrapper
    implements ListSelectionListener {
        public MyDialog(Component parent) {
            super(parent, true);
            this.setTitle(IdeBundle.message((String)"title.select.jdk", (Object[])new Object[0]));
            this.init();
            JdkChooserPanel.this.myList.addListSelectionListener((ListSelectionListener)this);
            this.updateOkButton();
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.ide.util.projectWizard.JdkChooserPanel.MyDialog";
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateOkButton();
        }

        private void updateOkButton() {
            this.setOKActionEnabled(JdkChooserPanel.this.myList.getSelectedValue() != null);
        }

        public void dispose() {
            JdkChooserPanel.this.myList.removeListSelectionListener((ListSelectionListener)this);
            super.dispose();
        }

        protected JComponent createCenterPanel() {
            return JdkChooserPanel.this;
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{new ConfigureAction(), this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                MyDialog.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        public JComponent getPreferredFocusedComponent() {
            return JdkChooserPanel.this.myList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/JdkChooserPanel$MyDialog", "createActions"));
        }

        private final class ConfigureAction
        extends AbstractAction {
            ConfigureAction() {
                super(IdeBundle.message((String)"button.configure.e", (Object[])new Object[0]));
                this.putValue("MnemonicKey", new Integer(69));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JdkChooserPanel.this.editJdkTable();
            }
        }
    }
}

