/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ProjectLayoutPanel;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LibrariesLayoutPanel
extends ProjectLayoutPanel<LibraryDescriptor> {
    public LibrariesLayoutPanel(ModuleInsight insight) {
        super(insight);
    }

    @Override
    protected String getElementName(LibraryDescriptor entry) {
        return entry.getName();
    }

    @Override
    protected void setElementName(LibraryDescriptor entry, String name2) {
        entry.setName(name2);
    }

    @Override
    protected List<LibraryDescriptor> getEntries() {
        List<LibraryDescriptor> libs = this.getInsight().getSuggestedLibraries();
        return libs != null ? libs : Collections.emptyList();
    }

    @Override
    protected Collection getDependencies(LibraryDescriptor entry) {
        return entry.getJars();
    }

    @Override
    protected LibraryDescriptor merge(List<? extends LibraryDescriptor> entries) {
        ModuleInsight insight = this.getInsight();
        LibraryDescriptor mainLib = null;
        for (LibraryDescriptor libraryDescriptor : entries) {
            if (mainLib == null) {
                mainLib = libraryDescriptor;
                continue;
            }
            Collection<File> files = libraryDescriptor.getJars();
            insight.moveJarsToLibrary(libraryDescriptor, files, mainLib);
        }
        return mainLib;
    }

    @Override
    protected LibraryDescriptor split(LibraryDescriptor entry, String newEntryName, Collection<? extends File> extractedData) {
        return this.getInsight().splitLibrary(entry, newEntryName, extractedData);
    }

    @Override
    protected Collection<File> getContent(LibraryDescriptor entry) {
        return entry.getJars();
    }

    @Override
    protected String getEntriesChooserTitle() {
        return "Libraries";
    }

    @Override
    protected String getDependenciesTitle() {
        return "Library contents";
    }

    @Override
    protected String getElementTypeName() {
        return "library";
    }

    @Override
    protected String getSplitDialogChooseFilesPrompt() {
        return "&Select jars to extract to the new library:";
    }

    @Override
    protected String getNameAlreadyUsedMessage(String name2) {
        return "library with name " + name2 + " already exists";
    }

    @Override
    protected String getStepDescriptionText() {
        return "Please review libraries found. At this stage you can set library names that will be used in the project,\nexclude particular libraries from the project, or move individual files between the libraries.";
    }
}

