/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.CompoundProjectViewNodeDecorator;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageElementNode
extends ProjectViewNode<PackageElement>
implements ValidateableNode {
    public PackageElementNode(@NotNull Project project, @NotNull PackageElement value2, ViewSettings viewSettings) {
        if (project == null) {
            PackageElementNode.$$$reportNull$$$0(0);
        }
        if (value2 == null) {
            PackageElementNode.$$$reportNull$$$0(1);
        }
        super(project, (Object)value2, viewSettings);
    }

    public boolean contains(@NotNull VirtualFile file) {
        PsiDirectory[] directories;
        if (file == null) {
            PackageElementNode.$$$reportNull$$$0(2);
        }
        if (!this.isUnderContent(file) || this.getValue() == null) {
            return false;
        }
        for (PsiDirectory directory : directories = ((PackageElement)this.getValue()).getPackage().getDirectories()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)directory.getVirtualFile(), (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private boolean isUnderContent(VirtualFile file) {
        Module module;
        PackageElement element = (PackageElement)this.getValue();
        Module module2 = module = element == null ? null : element.getModule();
        if (module == null) {
            return ModuleUtilCore.projectContainsFile((Project)this.getProject(), (VirtualFile)file, (boolean)this.isLibraryElement());
        }
        return ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)file, (boolean)this.isLibraryElement());
    }

    private boolean isLibraryElement() {
        return this.getValue() != null && ((PackageElement)this.getValue()).isLibraryElement();
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        PsiFile[] packageChildren;
        PackageElement value2 = (PackageElement)this.getValue();
        if (value2 == null) {
            List<AbstractTreeNode> list = Collections.emptyList();
            if (list == null) {
                PackageElementNode.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        Module module = value2.getModule();
        PsiPackage aPackage = value2.getPackage();
        if (!this.getSettings().isFlattenPackages()) {
            PsiPackage[] subpackages;
            for (PsiPackage subpackage : subpackages = PackageUtil.getSubpackages(aPackage, module, this.isLibraryElement())) {
                PackageUtil.addPackageAsChild(children, subpackage, module, this.getSettings(), this.isLibraryElement());
            }
        }
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(aPackage.getProject(), module, this.isLibraryElement());
        for (PsiFile file : packageChildren = aPackage.getFiles(scopeToShow)) {
            if (file.getVirtualFile() == null) continue;
            children.add((AbstractTreeNode)new PsiFileNode(this.getProject(), file, this.getSettings()));
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            PackageElementNode.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public boolean validate() {
        return super.validate() && this.isValid();
    }

    public boolean isValid() {
        PackageElement value2 = (PackageElement)this.getValue();
        if (value2 != null && value2.getPackage().isValid()) {
            Module module = value2.getModule();
            return module == null || !module.isDisposed();
        }
        return false;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            PackageElementNode.$$$reportNull$$$0(5);
        }
        try {
            if (this.isValid()) {
                this.updateValidData(presentation, (PackageElement)this.getValue());
                return;
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        this.setValue(null);
    }

    private void updateValidData(PresentationData presentation, PackageElement value2) {
        PsiPackage aPackage = value2.getPackage();
        if (!this.getSettings().isFlattenPackages() && this.getSettings().isHideEmptyMiddlePackages() && PackageUtil.isPackageEmpty(aPackage, value2.getModule(), true, this.isLibraryElement())) {
            this.setValue(null);
            return;
        }
        PsiPackage parentPackage = this.getParentPackage();
        String qName = aPackage.getQualifiedName();
        String name2 = PackageUtil.getNodeName(this.getSettings(), aPackage, parentPackage, qName, this.showFQName(aPackage));
        presentation.setPresentableText(name2);
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
        if (this.myProject != null) {
            CompoundProjectViewNodeDecorator.get((Project)this.myProject).decorate((ProjectViewNode)this, presentation);
        }
    }

    private boolean showFQName(PsiPackage aPackage) {
        return this.getSettings().isFlattenPackages() && !aPackage.getQualifiedName().isEmpty();
    }

    public String getTestPresentation() {
        PresentationData presentation = new PresentationData();
        this.update(presentation);
        return "PsiPackage: " + presentation.getPresentableText();
    }

    public boolean valueIsCut() {
        return this.getValue() != null && CopyPasteManager.getInstance().isCutElement((Object)((PackageElement)this.getValue()).getPackage());
    }

    @NotNull
    public VirtualFile[] getVirtualFiles() {
        PackageElement value2 = (PackageElement)this.getValue();
        if (value2 == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                PackageElementNode.$$$reportNull$$$0(6);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        PsiDirectory[] directories = PackageUtil.getDirectories(value2.getPackage(), value2.getModule(), this.isLibraryElement());
        VirtualFile[] result = new VirtualFile[directories.length];
        for (int i = 0; i < directories.length; ++i) {
            PsiDirectory directory = directories[i];
            result[i] = directory.getVirtualFile();
        }
        if (result == null) {
            PackageElementNode.$$$reportNull$$$0(7);
        }
        return result;
    }

    public boolean canRepresent(Object element) {
        VirtualFile file;
        String aPackage;
        PackageElement packageElement;
        String otherPackage;
        if (super.canRepresent(element)) {
            return true;
        }
        PackageElement value2 = (PackageElement)this.getValue();
        if (value2 == null) {
            return true;
        }
        if (element instanceof PackageElement && (otherPackage = (packageElement = (PackageElement)element).getPackage().getQualifiedName()).equals(aPackage = value2.getPackage().getQualifiedName())) {
            return true;
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            return this.isPackageUnderDirectory(value2, directory.getVirtualFile());
        }
        if (element instanceof VirtualFile && (file = (VirtualFile)element).isDirectory()) {
            return this.isPackageUnderDirectory(value2, file);
        }
        return false;
    }

    private boolean isPackageUnderDirectory(@NotNull PackageElement element, @NotNull VirtualFile file) {
        if (element == null) {
            PackageElementNode.$$$reportNull$$$0(8);
        }
        if (file == null) {
            PackageElementNode.$$$reportNull$$$0(9);
        }
        PsiPackage parent = this.getParentPackage();
        for (PsiPackage p = element.getPackage(); p != null && !p.equals(parent); p = p.getParentPackage()) {
            for (PsiDirectory directory : p.getDirectories()) {
                if (!directory.getVirtualFile().equals(file)) continue;
                return true;
            }
        }
        return false;
    }

    private PsiPackage getParentPackage() {
        Object value2 = this.getParentValue();
        return value2 instanceof PackageElement ? ((PackageElement)value2).getPackage() : null;
    }

    public int getWeight() {
        return 0;
    }

    public String getTitle() {
        PackageElement packageElement = (PackageElement)this.getValue();
        if (packageElement == null) {
            return super.getTitle();
        }
        return packageElement.getPackage().getQualifiedName();
    }

    @Nullable
    public String getQualifiedNameSortKey() {
        PackageElement packageElement = (PackageElement)this.getValue();
        if (packageElement != null) {
            return packageElement.getPackage().getQualifiedName();
        }
        return null;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 4;
    }

    public boolean isAlwaysShowPlus() {
        for (VirtualFile dir : this.getVirtualFiles()) {
            if (dir.getChildren().length <= 0) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/PackageElementNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/PackageElementNode";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPackageUnderDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

