/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;

public class PackagesPaneSelectInTarget
extends ProjectViewSelectInTarget {
    public PackagesPaneSelectInTarget(Project project) {
        super(project);
    }

    public String toString() {
        return SelectInManager.PACKAGES;
    }

    public boolean canSelect(PsiFileSystemItem file) {
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        if ((vFile = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)vFile)) == null || !vFile.isValid()) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        return fileIndex.isInSourceContent(vFile) || this.isInLibraryContentOnly(vFile);
    }

    public boolean isSubIdSelectable(String subId, SelectInContext context) {
        return this.canSelect(context);
    }

    private boolean isInLibraryContentOnly(VirtualFile vFile) {
        if (vFile == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        return projectFileIndex.isInLibrary(vFile) && !projectFileIndex.isInSourceContent(vFile);
    }

    public String getMinorViewId() {
        return "PackagesPane";
    }

    public float getWeight() {
        return 2.0f;
    }
}

