/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectUtil {
    private static final Logger LOG = Logger.getInstance(NewProjectUtil.class);

    private NewProjectUtil() {
    }

    public static void createNewProject(@Nullable Project projectToClose, @NotNull AbstractProjectWizard wizard) {
        if (wizard == null) {
            NewProjectUtil.$$$reportNull$$$0(0);
        }
        String title = ProjectBundle.message((String)"project.new.wizard.progress.title", (Object[])new Object[0]);
        Runnable warmUp = () -> ProjectManager.getInstance().getDefaultProject();
        boolean proceed = ProgressManager.getInstance().runProcessWithProgressSynchronously(warmUp, title, true, null);
        if (proceed && wizard.showAndGet()) {
            NewProjectUtil.createFromWizard(wizard, projectToClose);
        }
    }

    public static Project createFromWizard(@NotNull AbstractProjectWizard wizard, @Nullable Project projectToClose) {
        if (wizard == null) {
            NewProjectUtil.$$$reportNull$$$0(1);
        }
        try {
            return NewProjectUtil.doCreate(wizard, projectToClose);
        }
        catch (IOException e) {
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((String)e.getMessage(), (String)"Project Initialization Failed"));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Project doCreate(AbstractProjectWizard wizard, @Nullable Project projectToClose) throws IOException {
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        String projectFilePath = wizard.getNewProjectFilePath();
        for (Project p : ProjectManager.getInstance().getOpenProjects()) {
            if (!ProjectUtil.isSameProject((String)projectFilePath, (Project)p)) continue;
            ProjectUtil.focusProjectWindow((Project)p, (boolean)false);
            return null;
        }
        ProjectBuilder projectBuilder = wizard.getProjectBuilder();
        LOG.debug("builder " + projectBuilder);
        try {
            Project newProject;
            String name2;
            File directoryToCreate = new File(projectFilePath);
            if (wizard.getStorageScheme() == StorageScheme.DEFAULT) {
                if ((directoryToCreate = directoryToCreate.getParentFile()) == null) {
                    throw new IOException("Cannot create project in '" + projectFilePath + "': no parent file exists");
                }
            } else if (wizard.getStorageScheme() == StorageScheme.DIRECTORY_BASED) {
                directoryToCreate = new File(projectFilePath, ".idea");
            }
            FileUtil.ensureExists((File)directoryToCreate);
            if (projectBuilder == null || !projectBuilder.isUpdate()) {
                name2 = wizard.getProjectName();
                newProject = projectBuilder == null ? projectManager.newProject(name2, projectFilePath, true, false) : projectBuilder.createProject(name2, projectFilePath);
            } else {
                newProject = projectToClose;
            }
            if (newProject == null) {
                name2 = projectToClose;
                return name2;
            }
            Sdk jdk = wizard.getNewProjectJdk();
            if (jdk != null) {
                CommandProcessor.getInstance().executeCommand(newProject, () -> ApplicationManager.getApplication().runWriteAction(() -> NewProjectUtil.applyJdkToProject(newProject, jdk)), null, null);
            }
            String compileOutput = wizard.getNewCompileOutput();
            CommandProcessor.getInstance().executeCommand(newProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                CompilerProjectExtension extension = CompilerProjectExtension.getInstance((Project)newProject);
                if (extension != null) {
                    String canonicalPath = compileOutput;
                    try {
                        canonicalPath = FileUtil.resolveShortWindowsName((String)compileOutput);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    extension.setCompilerOutputUrl(VfsUtilCore.pathToUrl((String)canonicalPath));
                }
            }), null, null);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                newProject.save();
            }
            if (projectBuilder != null && !projectBuilder.validate(projectToClose, newProject)) {
                Project project = projectToClose;
                return project;
            }
            if (newProject != projectToClose && !ApplicationManager.getApplication().isUnitTestMode()) {
                NewProjectUtil.closePreviousProject(projectToClose);
            }
            if (projectBuilder != null) {
                projectBuilder.commit(newProject, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
            }
            boolean need2OpenProjectStructure = projectBuilder == null || projectBuilder.isOpenProjectSettingsAfter();
            StartupManager.getInstance((Project)newProject).registerPostStartupActivity(() -> ApplicationManager.getApplication().invokeLater(() -> {
                if (newProject.isDisposed() || ApplicationManager.getApplication().isUnitTestMode()) {
                    return;
                }
                if (need2OpenProjectStructure) {
                    ModulesConfigurator.showDialog(newProject, null, null);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (newProject.isDisposed()) {
                        return;
                    }
                    ToolWindow toolWindow = ToolWindowManager.getInstance((Project)newProject).getToolWindow(ToolWindowId.PROJECT_VIEW);
                    if (toolWindow != null) {
                        toolWindow.activate(null);
                    }
                }, ModalityState.NON_MODAL);
            }, ModalityState.NON_MODAL));
            if (newProject != projectToClose) {
                boolean fullScreen;
                IdeFocusManager instance;
                IdeFrame lastFocusedFrame;
                ProjectUtil.updateLastProjectLocation((String)projectFilePath);
                if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && (lastFocusedFrame = (instance = IdeFocusManager.findInstance()).getLastFocusedFrame()) instanceof IdeFrameEx && (fullScreen = ((IdeFrameEx)lastFocusedFrame).isInFullScreen())) {
                    newProject.putUserData(IdeFrameImpl.SHOULD_OPEN_IN_FULL_SCREEN, (Object)Boolean.TRUE);
                }
                projectManager.openProject(newProject);
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                newProject.save();
            }
            Project project = newProject;
            return project;
        }
        finally {
            if (projectBuilder != null) {
                projectBuilder.cleanup();
            }
        }
    }

    public static void applyJdkToProject(@NotNull Project project, @NotNull Sdk jdk) {
        if (project == null) {
            NewProjectUtil.$$$reportNull$$$0(2);
        }
        if (jdk == null) {
            NewProjectUtil.$$$reportNull$$$0(3);
        }
        ProjectRootManagerEx rootManager = ProjectRootManagerEx.getInstanceEx((Project)project);
        rootManager.setProjectSdk(jdk);
        JavaSdkVersion version = JavaSdk.getInstance().getVersion(jdk);
        if (version != null) {
            LanguageLevel maxLevel = version.getMaxLanguageLevel();
            LanguageLevelProjectExtension extension = LanguageLevelProjectExtension.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
            LanguageLevelProjectExtension ext = LanguageLevelProjectExtension.getInstance((Project)project);
            if (extension.isDefault() || maxLevel.compareTo((Enum)ext.getLanguageLevel()) < 0) {
                ext.setLanguageLevel(maxLevel);
            }
        }
    }

    public static void closePreviousProject(Project projectToClose) {
        int exitCode;
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length > 0 && (exitCode = ProjectUtil.confirmOpenNewProject((boolean)true)) == 1) {
            Project project = projectToClose != null ? projectToClose : openProjects[openProjects.length - 1];
            ProjectManagerEx.getInstanceEx().closeAndDispose(project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/impl/NewProjectUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createFromWizard";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "applyJdkToProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

