/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.TypeHierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class SupertypesHierarchyTreeStructure
extends HierarchyTreeStructure {
    public SupertypesHierarchyTreeStructure(Project project, PsiClass aClass) {
        super(project, (HierarchyNodeDescriptor)new TypeHierarchyNodeDescriptor(project, null, (PsiElement)aClass, true));
    }

    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        PsiClass functionalInterfaceClass;
        PsiElement element;
        if (descriptor == null) {
            SupertypesHierarchyTreeStructure.$$$reportNull$$$0(0);
        }
        if ((element = ((TypeHierarchyNodeDescriptor)descriptor).getPsiClass()) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            PsiClass[] supers = SupertypesHierarchyTreeStructure.getSupers(psiClass);
            ArrayList<TypeHierarchyNodeDescriptor> descriptors = new ArrayList<TypeHierarchyNodeDescriptor>();
            PsiClass objectClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass("java.lang.Object", psiClass.getResolveScope());
            for (PsiClass aSuper : supers) {
                if (psiClass.isInterface() && aSuper.equals(objectClass)) continue;
                descriptors.add(new TypeHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)aSuper, false));
            }
            Object[] objectArray = descriptors.toArray(new HierarchyNodeDescriptor[0]);
            if (objectArray == null) {
                SupertypesHierarchyTreeStructure.$$$reportNull$$$0(1);
            }
            return objectArray;
        }
        if (element instanceof PsiFunctionalExpression && (functionalInterfaceClass = LambdaUtil.resolveFunctionalInterfaceClass((PsiFunctionalExpression)((PsiFunctionalExpression)element))) != null) {
            Object[] objectArray = new HierarchyNodeDescriptor[]{new TypeHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)functionalInterfaceClass, false)};
            if (objectArray == null) {
                SupertypesHierarchyTreeStructure.$$$reportNull$$$0(2);
            }
            return objectArray;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            SupertypesHierarchyTreeStructure.$$$reportNull$$$0(3);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    private static PsiClass[] getSupers(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SupertypesHierarchyTreeStructure.$$$reportNull$$$0(4);
        }
        if (psiClass.isAnnotationType()) {
            PsiClass[] psiClassArray = SupertypesHierarchyTreeStructure.getMetaAnnotations(psiClass);
            if (psiClassArray == null) {
                SupertypesHierarchyTreeStructure.$$$reportNull$$$0(5);
            }
            return psiClassArray;
        }
        PsiClass[] psiClassArray = psiClass.getSupers();
        if (psiClassArray == null) {
            SupertypesHierarchyTreeStructure.$$$reportNull$$$0(6);
        }
        return psiClassArray;
    }

    @NotNull
    private static PsiClass[] getMetaAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SupertypesHierarchyTreeStructure.$$$reportNull$$$0(7);
        }
        HashSet<PsiClass> supers = new HashSet<PsiClass>();
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList != null) {
            for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                PsiClass aClass;
                PsiAnnotation.TargetType target;
                PsiElement annotationType;
                PsiJavaCodeReferenceElement ref;
                if (SupertypesHierarchyTreeStructure.isJavaLangAnnotation(annotation) || (ref = annotation.getNameReferenceElement()) == null || !((annotationType = ref.resolve()) instanceof PsiClass) || (target = AnnotationTargetUtil.findAnnotationTarget((PsiClass)(aClass = (PsiClass)annotationType), (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.ANNOTATION_TYPE})) == null || target == PsiAnnotation.TargetType.UNKNOWN) continue;
                supers.add(aClass);
            }
        }
        PsiClass[] psiClassArray = supers.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            SupertypesHierarchyTreeStructure.$$$reportNull$$$0(8);
        }
        return psiClassArray;
    }

    private static boolean isJavaLangAnnotation(@NotNull PsiAnnotation annotation) {
        String qualifiedName;
        if (annotation == null) {
            SupertypesHierarchyTreeStructure.$$$reportNull$$$0(9);
        }
        return (qualifiedName = annotation.getQualifiedName()) != null && qualifiedName.startsWith("java.lang.annotation");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/type/SupertypesHierarchyTreeStructure";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/type/SupertypesHierarchyTreeStructure";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSupers";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMetaAnnotations";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isJavaLangAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

