/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.method;

import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.method.MethodHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.method.MethodHierarchyUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodHierarchyTreeStructure
extends HierarchyTreeStructure {
    private final SmartPsiElementPointer myMethod;
    private final String myScopeType;

    public MethodHierarchyTreeStructure(@NotNull Project project, @NotNull PsiMethod method, String type2) {
        if (project == null) {
            MethodHierarchyTreeStructure.$$$reportNull$$$0(0);
        }
        if (method == null) {
            MethodHierarchyTreeStructure.$$$reportNull$$$0(1);
        }
        super(project, null);
        this.myScopeType = type2;
        this.myBaseDescriptor = this.buildHierarchyElement(project, method);
        ((MethodHierarchyNodeDescriptor)this.myBaseDescriptor).setTreeStructure(this);
        this.myMethod = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)method);
        this.setBaseElement(this.myBaseDescriptor);
    }

    private HierarchyNodeDescriptor buildHierarchyElement(Project project, PsiMethod method) {
        PsiClass psiClass;
        PsiClass suitableBaseClass = MethodHierarchyTreeStructure.findSuitableBaseClass(method);
        ArrayList<PsiClass> superClasses = MethodHierarchyTreeStructure.createSuperClasses(suitableBaseClass);
        if (!suitableBaseClass.equals(method.getContainingClass())) {
            superClasses.add(0, suitableBaseClass);
        }
        for (int i = superClasses.size() - 1; i >= 0 && MethodHierarchyUtil.findBaseMethodInClass(method, psiClass = superClasses.get(i), false) == null; --i) {
            superClasses.remove(i);
        }
        MethodHierarchyNodeDescriptor descriptor = null;
        for (int i = superClasses.size() - 1; i >= 0; --i) {
            PsiClass superClass = superClasses.get(i);
            MethodHierarchyNodeDescriptor newDescriptor = new MethodHierarchyNodeDescriptor(project, descriptor, (PsiElement)superClass, false, this);
            if (descriptor != null) {
                descriptor.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
            }
            descriptor = newDescriptor;
        }
        MethodHierarchyNodeDescriptor newDescriptor = new MethodHierarchyNodeDescriptor(project, descriptor, (PsiElement)method.getContainingClass(), true, this);
        if (descriptor != null) {
            descriptor.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
        }
        return newDescriptor;
    }

    private static ArrayList<PsiClass> createSuperClasses(PsiClass aClass) {
        if (!aClass.isValid()) {
            return new ArrayList<PsiClass>();
        }
        ArrayList<PsiClass> superClasses = new ArrayList<PsiClass>();
        while (!MethodHierarchyTreeStructure.isJavaLangObject(aClass)) {
            PsiClass aClass1 = aClass;
            PsiClass[] superTypes = aClass1.getSupers();
            PsiClass superType = null;
            for (PsiClass type2 : superTypes) {
                if (type2.isInterface() || MethodHierarchyTreeStructure.isJavaLangObject(type2)) continue;
                superType = type2;
                break;
            }
            if (superType == null) {
                for (PsiClass type2 : superTypes) {
                    if (MethodHierarchyTreeStructure.isJavaLangObject(type2)) continue;
                    superType = type2;
                    break;
                }
            }
            if (superType == null || superClasses.contains(superType)) break;
            superClasses.add(superType);
            aClass = superType;
        }
        return superClasses;
    }

    private static boolean isJavaLangObject(PsiClass aClass) {
        return "java.lang.Object".equals(aClass.getQualifiedName());
    }

    private static PsiClass findSuitableBaseClass(PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass instanceof PsiAnonymousClass) {
            return containingClass;
        }
        PsiClass superClass = containingClass.getSuperClass();
        if (superClass == null) {
            return containingClass;
        }
        if (MethodHierarchyUtil.findBaseMethodInClass(method, superClass, true) == null) {
            for (PsiClass anInterface : containingClass.getInterfaces()) {
                if (MethodHierarchyUtil.findBaseMethodInClass(method, anInterface, true) == null) continue;
                return anInterface;
            }
        }
        return containingClass;
    }

    @Nullable
    public final PsiMethod getBaseMethod() {
        PsiElement element = this.myMethod.getElement();
        return element instanceof PsiMethod ? (PsiMethod)element : null;
    }

    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        PsiElement psiElement;
        if (descriptor == null) {
            MethodHierarchyTreeStructure.$$$reportNull$$$0(2);
        }
        if (!((psiElement = ((MethodHierarchyNodeDescriptor)descriptor).getPsiClass()) instanceof PsiClass)) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                MethodHierarchyTreeStructure.$$$reportNull$$$0(3);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        PsiClass psiClass = (PsiClass)psiElement;
        Collection<PsiClass> subclasses = this.getSubclasses(psiClass);
        ArrayList<MethodHierarchyNodeDescriptor> descriptors = new ArrayList<MethodHierarchyNodeDescriptor>(subclasses.size());
        for (PsiClass aClass : subclasses) {
            if (HierarchyBrowserManager.getInstance((Project)this.myProject).getState().HIDE_CLASSES_WHERE_METHOD_NOT_IMPLEMENTED && this.shouldHideClass(aClass)) continue;
            MethodHierarchyNodeDescriptor d = new MethodHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)aClass, false, this);
            descriptors.add(d);
        }
        PsiMethod existingMethod = ((MethodHierarchyNodeDescriptor)descriptor).getMethod(psiClass, false);
        if (existingMethod != null) {
            FunctionalExpressionSearch.search((PsiMethod)existingMethod).forEach(expression2 -> {
                descriptors.add(new MethodHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)expression2, false, this));
                return true;
            });
        }
        Object[] objectArray = descriptors.toArray(new HierarchyNodeDescriptor[0]);
        if (objectArray == null) {
            MethodHierarchyTreeStructure.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    private Collection<PsiClass> getSubclasses(PsiClass psiClass) {
        if (psiClass instanceof PsiAnonymousClass || psiClass.hasModifierProperty("final")) {
            return Collections.emptyList();
        }
        SearchScope searchScope = this.getSearchScope(this.myScopeType, (PsiElement)psiClass);
        return ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)searchScope, (boolean)false).findAll();
    }

    private boolean shouldHideClass(PsiClass psiClass) {
        if (this.getMethod(psiClass, false) != null || this.isSuperClassForBaseClass(psiClass)) {
            return false;
        }
        if (this.hasBaseClassMethod(psiClass) || this.isAbstract((PsiModifierListOwner)psiClass)) {
            for (PsiClass subclass : this.getSubclasses(psiClass)) {
                if (this.shouldHideClass(subclass)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isAbstract(PsiModifierListOwner owner2) {
        return owner2.hasModifierProperty("abstract");
    }

    private boolean hasBaseClassMethod(PsiClass psiClass) {
        PsiMethod baseClassMethod = this.getMethod(psiClass, true);
        return baseClassMethod != null && !this.isAbstract((PsiModifierListOwner)baseClassMethod);
    }

    private PsiMethod getMethod(PsiClass aClass, boolean checkBases) {
        return MethodHierarchyUtil.findBaseMethodInClass(this.getBaseMethod(), aClass, checkBases);
    }

    boolean isSuperClassForBaseClass(PsiClass aClass) {
        PsiMethod baseMethod = this.getBaseMethod();
        if (baseMethod == null) {
            return false;
        }
        PsiClass baseClass = baseMethod.getContainingClass();
        if (baseClass == null) {
            return false;
        }
        return baseClass.isInheritor(aClass, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/method/MethodHierarchyTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/method/MethodHierarchyTreeStructure";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

