/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.NewActionGroup;
import com.intellij.ide.actions.NewProjectOrModuleAction;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.projectWizard.NewProjectWizard;
import com.intellij.lang.IdeLanguageCustomization;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import org.jetbrains.annotations.NotNull;

public class NewProjectAction
extends AnAction
implements DumbAware,
NewProjectOrModuleAction {
    public boolean startInTransaction() {
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            NewProjectAction.$$$reportNull$$$0(0);
        }
        NewProjectWizard wizard = new NewProjectWizard(null, ModulesProvider.EMPTY_MODULES_PROVIDER, null);
        Project eventProject = NewProjectAction.getEventProject((AnActionEvent)e);
        NewProjectUtil.createNewProject(eventProject, wizard);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            NewProjectAction.$$$reportNull$$$0(1);
        }
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            e.getPresentation().setIcon(AllIcons.Welcome.CreateNewProject);
        }
        NewProjectAction.updateActionText(this, e);
    }

    @Override
    @NotNull
    public String getActionText(boolean isInNewSubmenu, boolean isInJavaIde) {
        String string = ProjectBundle.message((String)"new.project.action.text", (Object[])new Object[]{isInNewSubmenu ? 1 : 0, isInJavaIde ? 1 : 0});
        if (string == null) {
            NewProjectAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static <T extends AnAction> void updateActionText(@NotNull T action, @NotNull AnActionEvent e) {
        String actionText;
        if (action == null) {
            NewProjectAction.$$$reportNull$$$0(3);
        }
        if (e == null) {
            NewProjectAction.$$$reportNull$$$0(4);
        }
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            actionText = action.getTemplateText();
        } else {
            boolean inJavaIde = IdeLanguageCustomization.getInstance().getPrimaryIdeLanguages().contains(JavaLanguage.INSTANCE);
            boolean fromNewSubMenu = NewProjectAction.isInvokedFromNewSubMenu(action, e);
            actionText = ((NewProjectOrModuleAction)action).getActionText(fromNewSubMenu, inJavaIde);
        }
        e.getPresentation().setText(actionText);
    }

    private static boolean isInvokedFromNewSubMenu(@NotNull AnAction action, @NotNull AnActionEvent e) {
        if (action == null) {
            NewProjectAction.$$$reportNull$$$0(5);
        }
        if (e == null) {
            NewProjectAction.$$$reportNull$$$0(6);
        }
        return NewActionGroup.isActionInNewPopupMenu((AnAction)action) && ("MainMenu".equals(e.getPlace()) || ActionPlaces.isPopupPlace((String)e.getPlace()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/NewProjectAction";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/NewProjectAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateActionText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInvokedFromNewSubMenu";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

