/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.NewProjectAction;
import com.intellij.ide.actions.NewProjectOrModuleAction;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ui.configuration.actions.NewModuleAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.DeprecatedProjectBuilderForImport;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportModuleAction
extends AnAction
implements NewProjectOrModuleAction {
    private static final String LAST_IMPORTED_LOCATION = "last.imported.location";

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportModuleAction.$$$reportNull$$$0(0);
        }
        ImportModuleAction.doImport(ImportModuleAction.getEventProject((AnActionEvent)e));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportModuleAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(ImportModuleAction.getEventProject((AnActionEvent)e) != null);
        NewProjectAction.updateActionText(this, e);
    }

    @Override
    @NotNull
    public String getActionText(boolean isInNewSubmenu, boolean isInJavaIde) {
        String string = ProjectBundle.message((String)"import.module.action.text", (Object[])new Object[]{isInNewSubmenu ? 1 : 0, isInJavaIde ? 1 : 0});
        if (string == null) {
            ImportModuleAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isDumbAware() {
        return true;
    }

    public static List<Module> doImport(@Nullable Project project) {
        AddModuleWizard wizard = ImportModuleAction.selectFileAndCreateWizard(project, null);
        if (wizard == null || wizard.getStepCount() > 0 && !wizard.showAndGet()) {
            return Collections.emptyList();
        }
        return ImportModuleAction.createFromWizard(project, wizard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Module> createFromWizard(@Nullable Project project, AbstractProjectWizard wizard) {
        try {
            Ref result = Ref.create();
            TransactionGuard.getInstance().submitTransactionAndWait(() -> result.set(ImportModuleAction.doCreateFromWizard(project, wizard)));
            List list = (List)result.get();
            return list;
        }
        finally {
            wizard.disposeIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Module> doCreateFromWizard(@Nullable Project project, AbstractProjectWizard wizard) {
        ProjectBuilder projectBuilder = wizard.getProjectBuilder();
        if (project == null) {
            Project newProject = projectBuilder instanceof DeprecatedProjectBuilderForImport ? ProjectUtil.openOrImport((String)wizard.getNewProjectFilePath(), null, (boolean)false) : NewProjectUtil.createFromWizard(wizard, null);
            return newProject == null ? Collections.emptyList() : Arrays.asList(ModuleManager.getInstance((Project)newProject).getModules());
        }
        try {
            if (wizard.getStepCount() > 0) {
                Module module = new NewModuleAction().createModuleFromWizard(project, null, wizard);
                List<Module> list = Collections.singletonList(module);
                return list;
            }
            if (!projectBuilder.validate(project, project)) {
                List<Module> list = Collections.emptyList();
                return list;
            }
            List list = projectBuilder.commit(project);
            return list;
        }
        finally {
            if (projectBuilder != null) {
                projectBuilder.cleanup();
            }
        }
    }

    @Nullable
    public static AddModuleWizard selectFileAndCreateWizard(@Nullable Project project, @Nullable Component dialogParent) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        descriptor.setHideIgnored(false);
        descriptor.setTitle("Select File or Directory to Import");
        List<ProjectImportProvider> providers2 = ImportModuleAction.getProviders(project);
        String description = ImportModuleAction.getFileChooserDescription(providers2);
        descriptor.setDescription(description);
        return ImportModuleAction.selectFileAndCreateWizard(project, dialogParent, descriptor, providers2.toArray(new ProjectImportProvider[0]));
    }

    @Nullable
    public static AddModuleWizard selectFileAndCreateWizard(@Nullable Project project, @Nullable Component dialogParent, @NotNull FileChooserDescriptor descriptor, ProjectImportProvider[] providers2) {
        VirtualFile[] files;
        if (descriptor == null) {
            ImportModuleAction.$$$reportNull$$$0(3);
        }
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, project, dialogParent);
        VirtualFile toSelect = null;
        String lastLocation = PropertiesComponent.getInstance().getValue(LAST_IMPORTED_LOCATION);
        if (lastLocation != null) {
            toSelect = LocalFileSystem.getInstance().refreshAndFindFileByPath(lastLocation);
        }
        if ((files = chooser.choose(project, new VirtualFile[]{toSelect})).length == 0) {
            return null;
        }
        VirtualFile file = files[0];
        if (project == null) {
            for (Project p : ProjectManager.getInstance().getOpenProjects()) {
                if (!ProjectUtil.isSameProject((String)file.getPath(), (Project)p)) continue;
                ProjectUtil.focusProjectWindow((Project)p, (boolean)false);
                return null;
            }
        }
        PropertiesComponent.getInstance().setValue(LAST_IMPORTED_LOCATION, file.getPath());
        return ImportModuleAction.createImportWizard(project, dialogParent, file, providers2);
    }

    private static String getFileChooserDescription(List<ProjectImportProvider> providers2) {
        StringBuilder builder = new StringBuilder("<html>Select ");
        boolean first = true;
        if (providers2.size() > 0) {
            for (ProjectImportProvider provider : providers2) {
                String sample = provider.getFileSample();
                if (sample == null) continue;
                if (!first) {
                    builder.append(", <br>");
                } else {
                    first = false;
                }
                builder.append(sample);
            }
        }
        builder.append(".</html>");
        return builder.toString();
    }

    @NotNull
    public static List<ProjectImportProvider> getProviders(@Nullable Project project) {
        Object[] providers2 = (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions();
        List list = ContainerUtil.filter((Object[])providers2, provider -> project == null ? provider.canCreateNewProject() : provider.canImportModule());
        if (list == null) {
            ImportModuleAction.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public static AddModuleWizard createImportWizard(@Nullable Project project, @Nullable Component dialogParent, @NotNull VirtualFile file, ProjectImportProvider ... providers2) {
        List available;
        if (file == null) {
            ImportModuleAction.$$$reportNull$$$0(5);
        }
        if ((available = ContainerUtil.filter((Object[])providers2, provider -> provider.canImport(file, project))).isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)("Cannot import anything from " + file.getPath()), (String)"Cannot Import");
            return null;
        }
        String path = available.size() == 1 ? ((ProjectImportProvider)available.get(0)).getPathToBeImported(file) : ProjectImportProvider.getDefaultPath(file);
        ProjectImportProvider[] availableProviders = available.toArray(new ProjectImportProvider[0]);
        return dialogParent == null ? new AddModuleWizard(project, path, availableProviders) : new AddModuleWizard(project, dialogParent, path, availableProviders);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ImportModuleAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ImportModuleAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "selectFileAndCreateWizard";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createImportWizard";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

