/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesDialog;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.ImplicitToStringSearch;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class FindMethodUsagesDialog
extends JavaFindUsagesDialog<JavaMethodFindUsagesOptions> {
    private StateRestoringCheckBox myCbUsages;
    private StateRestoringCheckBox myCbImplementingMethods;
    private StateRestoringCheckBox myCbOverridingMethods;
    private StateRestoringCheckBox myCbImplicitToString;
    private boolean myHasFindWhatPanel;

    public FindMethodUsagesDialog(PsiElement element, Project project, FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler) {
        super(element, project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler);
    }

    @Nullable
    public JComponent getPreferredFocusedControl() {
        return this.myHasFindWhatPanel ? this.myCbUsages : null;
    }

    @Override
    public void calcFindUsagesOptions(JavaMethodFindUsagesOptions options) {
        super.calcFindUsagesOptions(options);
        boolean bl = options.isUsages = FindMethodUsagesDialog.isSelected((JCheckBox)this.myCbUsages) || !this.myHasFindWhatPanel;
        if (FindMethodUsagesDialog.isToChange((JCheckBox)this.myCbOverridingMethods)) {
            options.isOverridingMethods = FindMethodUsagesDialog.isSelected((JCheckBox)this.myCbOverridingMethods);
        }
        if (FindMethodUsagesDialog.isToChange((JCheckBox)this.myCbImplementingMethods)) {
            options.isImplementingMethods = FindMethodUsagesDialog.isSelected((JCheckBox)this.myCbImplementingMethods);
        }
        if (FindMethodUsagesDialog.isToChange((JCheckBox)this.myCbImplicitToString)) {
            options.isImplicitToString = FindMethodUsagesDialog.isSelected((JCheckBox)this.myCbImplicitToString);
        }
        options.isCheckDeepInheritance = true;
        FUStateUsagesLogger.logStateEvent((EventLogGroup)this.myEventLogGroup, (String)"FindMethodUsages", (FeatureUsageData)this.createFeatureUsageData(options));
    }

    @Override
    protected FeatureUsageData createFeatureUsageData(JavaMethodFindUsagesOptions options) {
        FeatureUsageData data = super.createFeatureUsageData(options);
        data.addData("overridingMethods", options.isOverridingMethods);
        data.addData("implementingMethods", options.isImplementingMethods);
        data.addData("includeInherited", options.isIncludeInherited);
        data.addData("includeOverload", options.isIncludeOverloadUsages);
        data.addData("implicitCalls", options.isImplicitToString);
        return data;
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = new JPanel();
        findWhatPanel.setBorder(IdeBorderFactory.createTitledBorder((String)FindBundle.message((String)"find.what.group", (Object[])new Object[0])));
        findWhatPanel.setLayout(new BoxLayout(findWhatPanel, 1));
        this.myCbUsages = this.addCheckboxToPanel(FindBundle.message((String)"find.what.usages.checkbox", (Object[])new Object[0]), ((JavaMethodFindUsagesOptions)((Object)this.getFindUsagesOptions())).isUsages, findWhatPanel, true);
        PsiMethod method = (PsiMethod)this.getPsiElement();
        PsiClass aClass = method.getContainingClass();
        if (method.isConstructor() || method.hasModifierProperty("static") || method.hasModifierProperty("final") || method.hasModifierProperty("private") || aClass == null || aClass instanceof PsiAnonymousClass || aClass.hasModifierProperty("final")) {
            this.myHasFindWhatPanel = false;
            return null;
        }
        if (method.hasModifierProperty("abstract")) {
            this.myCbImplementingMethods = this.addCheckboxToPanel(FindBundle.message((String)"find.what.implementing.methods.checkbox", (Object[])new Object[0]), ((JavaMethodFindUsagesOptions)((Object)this.getFindUsagesOptions())).isImplementingMethods, findWhatPanel, true);
        } else {
            this.myCbOverridingMethods = this.addCheckboxToPanel(FindBundle.message((String)"find.what.overriding.methods.checkbox", (Object[])new Object[0]), ((JavaMethodFindUsagesOptions)((Object)this.getFindUsagesOptions())).isOverridingMethods, findWhatPanel, true);
        }
        if (ImplicitToStringSearch.isToStringMethod((PsiElement)method)) {
            this.myCbImplicitToString = this.addCheckboxToPanel(FindBundle.message((String)"find.what.implicit.to.string.checkbox", (Object[])new Object[0]), ((JavaMethodFindUsagesOptions)((Object)this.getFindUsagesOptions())).isImplicitToString, findWhatPanel, true);
        }
        this.myHasFindWhatPanel = true;
        return findWhatPanel;
    }

    protected void update() {
        if (!this.myHasFindWhatPanel) {
            this.setOKActionEnabled(true);
        } else {
            boolean hasSelected = FindMethodUsagesDialog.isSelected((JCheckBox)this.myCbUsages) || FindMethodUsagesDialog.isSelected((JCheckBox)this.myCbImplementingMethods) || FindMethodUsagesDialog.isSelected((JCheckBox)this.myCbOverridingMethods) || FindMethodUsagesDialog.isSelected((JCheckBox)this.myCbImplicitToString);
            this.setOKActionEnabled(hasSelected);
        }
    }
}

