/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.PathUtilEx;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaParametersUtil {
    private JavaParametersUtil() {
    }

    public static void configureConfiguration(SimpleJavaParameters parameters2, CommonJavaRunConfigurationParameters configuration) {
        String vmParameters;
        ProgramParametersUtil.configureConfiguration((SimpleProgramParameters)parameters2, (CommonProgramRunConfigurationParameters)configuration);
        Project project = configuration.getProject();
        Module module = ProgramParametersUtil.getModule((CommonProgramRunConfigurationParameters)configuration);
        String alternativeJrePath = configuration.getAlternativeJrePath();
        if (alternativeJrePath != null) {
            configuration.setAlternativeJrePath(ProgramParametersUtil.expandPath((String)alternativeJrePath, null, (Project)project));
        }
        if ((vmParameters = configuration.getVMParameters()) != null) {
            vmParameters = ProgramParametersUtil.expandPath((String)vmParameters, (Module)module, (Project)project);
            for (Map.Entry each : parameters2.getEnv().entrySet()) {
                vmParameters = StringUtil.replace((String)vmParameters, (String)("$" + (String)each.getKey() + "$"), (String)((String)each.getValue()), (boolean)false);
            }
            vmParameters = ProgramParametersConfigurator.expandMacros((String)vmParameters);
        }
        parameters2.getVMParametersList().addParametersString(vmParameters);
    }

    public static int getClasspathType(RunConfigurationModule configurationModule, String mainClassName, boolean classMustHaveSource) throws CantRunException {
        return JavaParametersUtil.getClasspathType(configurationModule, mainClassName, classMustHaveSource, false);
    }

    public static int getClasspathType(RunConfigurationModule configurationModule, String mainClassName, boolean classMustHaveSource, boolean includeProvidedDependencies) throws CantRunException {
        Module module = configurationModule.getModule();
        if (module == null) {
            throw CantRunException.noModuleConfigured((String)configurationModule.getModuleName());
        }
        Boolean inProduction = JavaParametersUtil.isClassInProductionSources(mainClassName, module);
        if (inProduction == null) {
            if (!classMustHaveSource) {
                return 7;
            }
            throw CantRunException.classNotFound((String)mainClassName, (Module)module);
        }
        return inProduction.booleanValue() ? (includeProvidedDependencies ? 11 : 3) : 7;
    }

    @Nullable(value="null if class not found")
    public static Boolean isClassInProductionSources(@NotNull String mainClassName, @NotNull Module module) {
        ModuleFileIndex fileIndex;
        Module classModule;
        PsiClass psiClass;
        if (mainClassName == null) {
            JavaParametersUtil.$$$reportNull$$$0(0);
        }
        if (module == null) {
            JavaParametersUtil.$$$reportNull$$$0(1);
        }
        if ((psiClass = JavaExecutionUtil.findMainClass((Module)module, (String)mainClassName)) == null) {
            return null;
        }
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Module module2 = classModule = psiClass.isValid() ? ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass) : null;
        if (classModule == null) {
            classModule = module;
        }
        if ((fileIndex = ModuleRootManager.getInstance((Module)classModule).getFileIndex()).isInSourceContent(virtualFile)) {
            return !fileIndex.isInTestSourceContent(virtualFile);
        }
        List entriesForFile = fileIndex.getOrderEntriesForFile(virtualFile);
        for (OrderEntry entry : entriesForFile) {
            if (!(entry instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entry).getScope() != DependencyScope.TEST) continue;
            return false;
        }
        return true;
    }

    public static void configureModule(RunConfigurationModule runConfigurationModule, JavaParameters parameters2, int classPathType, @Nullable String jreHome) throws CantRunException {
        Module module = runConfigurationModule.getModule();
        if (module == null) {
            throw CantRunException.noModuleConfigured((String)runConfigurationModule.getModuleName());
        }
        JavaParametersUtil.configureModule(module, parameters2, classPathType, jreHome);
    }

    public static void configureModule(Module module, JavaParameters parameters2, int classPathType, @Nullable String jreHome) throws CantRunException {
        parameters2.configureByModule(module, classPathType, JavaParametersUtil.createModuleJdk(module, (classPathType & 4) == 0, jreHome));
    }

    public static void configureProject(Project project, JavaParameters parameters2, int classPathType, @Nullable String jreHome) throws CantRunException {
        parameters2.configureByProject(project, classPathType, JavaParametersUtil.createProjectJdk(project, jreHome));
    }

    public static Sdk createModuleJdk(Module module, boolean productionOnly, @Nullable String jreHome) throws CantRunException {
        return jreHome == null ? JavaParameters.getValidJdkToRunModule((Module)module, (boolean)productionOnly) : JavaParametersUtil.createAlternativeJdk(jreHome);
    }

    public static Sdk createProjectJdk(Project project, @Nullable String jreHome) throws CantRunException {
        return jreHome == null ? JavaParametersUtil.createProjectJdk(project) : JavaParametersUtil.createAlternativeJdk(jreHome);
    }

    private static Sdk createProjectJdk(Project project) throws CantRunException {
        Sdk jdk = PathUtilEx.getAnyJdk((Project)project);
        if (jdk == null) {
            throw CantRunException.noJdkConfigured();
        }
        return jdk;
    }

    private static Sdk createAlternativeJdk(@NotNull String jreHome) throws CantRunException {
        Sdk configuredJdk;
        if (jreHome == null) {
            JavaParametersUtil.$$$reportNull$$$0(2);
        }
        if ((configuredJdk = ProjectJdkTable.getInstance().findJdk(jreHome)) != null) {
            return configuredJdk;
        }
        if (!JdkUtil.checkForJre((String)jreHome)) {
            throw new CantRunException(ExecutionBundle.message((String)"jre.path.is.not.valid.jre.home.error.message", (Object[])new Object[]{jreHome}));
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        return javaSdk.createJdk((String)ObjectUtils.notNull((Object)javaSdk.getVersionString(jreHome), (Object)""), jreHome);
    }

    public static void checkAlternativeJRE(@NotNull CommonJavaRunConfigurationParameters configuration) throws RuntimeConfigurationWarning {
        if (configuration == null) {
            JavaParametersUtil.$$$reportNull$$$0(3);
        }
        if (configuration.isAlternativeJrePathEnabled()) {
            JavaParametersUtil.checkAlternativeJRE(configuration.getAlternativeJrePath());
        }
    }

    public static void checkAlternativeJRE(@Nullable String jrePath) throws RuntimeConfigurationWarning {
        if (StringUtil.isEmptyOrSpaces((String)jrePath) || ProjectJdkTable.getInstance().findJdk(jrePath) == null && !JdkUtil.checkForJre((String)jrePath)) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"jre.path.is.not.valid.jre.home.error.message", (Object[])new Object[]{jrePath}));
        }
    }

    @NotNull
    public static DefaultJDOMExternalizer.JDOMFilter getFilter(final @NotNull CommonJavaRunConfigurationParameters parameters2) {
        if (parameters2 == null) {
            JavaParametersUtil.$$$reportNull$$$0(4);
        }
        DefaultJDOMExternalizer.JDOMFilter jDOMFilter = new DefaultJDOMExternalizer.JDOMFilter(){

            public boolean isAccept(@NotNull Field field) {
                String name2;
                if (field == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (!(name2 = field.getName()).equals("ALTERNATIVE_JRE_PATH_ENABLED") || parameters2.isAlternativeJrePathEnabled()) && (!name2.equals("ALTERNATIVE_JRE_PATH") || !StringUtil.isEmpty((String)parameters2.getAlternativeJrePath()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/execution/util/JavaParametersUtil$1", "isAccept"));
            }
        };
        if (jDOMFilter == null) {
            JavaParametersUtil.$$$reportNull$$$0(5);
        }
        return jDOMFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jreHome";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/util/JavaParametersUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/util/JavaParametersUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isClassInProductionSources";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAlternativeJdk";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkAlternativeJRE";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFilter";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

