/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.actions;

import com.intellij.execution.Location;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.ide.SelectInEditorManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInModule;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TestMethodUsage
implements Usage,
UsageInFile,
UsageInModule,
PsiElementUsage,
DataProvider {
    @NotNull
    private final SmartPsiElementPointer<? extends PsiMethod> myTestMethodPointer;
    @Nullable
    private final SmartPsiElementPointer<? extends PsiClass> myTestClassPointer;

    TestMethodUsage(@NotNull SmartPsiElementPointer<? extends PsiMethod> testMethod, @NotNull SmartPsiElementPointer<? extends PsiClass> testClass, @NotNull Collection<String> parameters2) {
        if (testMethod == null) {
            TestMethodUsage.$$$reportNull$$$0(0);
        }
        if (testClass == null) {
            TestMethodUsage.$$$reportNull$$$0(1);
        }
        if (parameters2 == null) {
            TestMethodUsage.$$$reportNull$$$0(2);
        }
        this.myTestMethodPointer = testMethod;
        this.myTestClassPointer = parameters2.isEmpty() ? null : testClass;
    }

    @Nullable
    public Location<PsiMethod> calculateLocation() {
        PsiClass c;
        PsiMethod m = (PsiMethod)this.myTestMethodPointer.getElement();
        if (m == null) {
            return null;
        }
        PsiClass psiClass = c = this.myTestClassPointer == null ? m.getContainingClass() : (PsiClass)this.myTestClassPointer.getElement();
        if (c == null) {
            return null;
        }
        return MethodLocation.elementInClass(m, c);
    }

    public VirtualFile getFile() {
        return this.getPointer().getVirtualFile();
    }

    public Module getModule() {
        return ModuleUtilCore.findModuleForFile((PsiFile)this.getPointer().getContainingFile());
    }

    @NotNull
    public UsagePresentation getPresentation() {
        UsagePresentation usagePresentation = new UsagePresentation(){

            @NotNull
            public TextChunk[] getText() {
                TextChunk[] textChunkArray = new TextChunk[]{new TextChunk(SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes(), this.getPlainText())};
                if (textChunkArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return textChunkArray;
            }

            @NotNull
            public String getPlainText() {
                String string = StringUtil.notNullize((String)Objects.requireNonNull(TestMethodUsage.this.getElement()).getName());
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public Icon getIcon() {
                return Objects.requireNonNull(TestMethodUsage.this.getElement()).getIcon(0);
            }

            public String getTooltipText() {
                return this.getPlainText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/execution/testDiscovery/actions/TestMethodUsage$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPlainText";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (usagePresentation == null) {
            TestMethodUsage.$$$reportNull$$$0(3);
        }
        return usagePresentation;
    }

    public boolean isValid() {
        return this.getPointer().getElement() != null;
    }

    public boolean isReadOnly() {
        return true;
    }

    @Nullable
    public FileEditorLocation getLocation() {
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            return null;
        }
        Project project = this.getPointer().getProject();
        FileEditor editor = FileEditorManager.getInstance((Project)project).getSelectedEditor(virtualFile);
        if (!(editor instanceof TextEditor)) {
            return null;
        }
        Segment segment = this.getPointer().getPsiRange();
        if (segment == null) {
            return null;
        }
        return new TextEditorLocation(segment.getStartOffset(), (TextEditor)editor);
    }

    public void selectInEditor() {
        this.navigate(true);
    }

    public void highlightInEditor() {
        PsiMember element = this.getElement();
        if (element != null) {
            Project project = this.getPointer().getProject();
            TextRange range = element.getTextRange();
            SelectInEditorManager.getInstance((Project)project).selectInEditor(this.getFile(), range.getStartOffset(), range.getEndOffset(), false, false);
        }
    }

    public void navigate(boolean requestFocus) {
        PsiMember element = this.getElement();
        if (element != null) {
            ((Navigatable)element).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @Nullable
    public PsiMember getElement() {
        return (PsiMember)this.getPointer().getElement();
    }

    @NotNull
    private SmartPsiElementPointer<? extends PsiMember> getPointer() {
        Object object = this.myTestClassPointer != null ? this.myTestClassPointer : this.myTestMethodPointer;
        if (object == null) {
            TestMethodUsage.$$$reportNull$$$0(4);
        }
        return object;
    }

    public boolean isNonCodeUsage() {
        return false;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            TestMethodUsage.$$$reportNull$$$0(5);
        }
        if (!UsageView.USAGE_INFO_LIST_KEY.is(dataId)) {
            return null;
        }
        PsiMember psi = this.getElement();
        return psi == null ? null : Collections.singletonList(new UsageInfo((PsiElement)psi));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/actions/TestMethodUsage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/actions/TestMethodUsage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

