/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JUnitRecognizer;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitUtil {
    public static final String TEST_CASE_CLASS = "junit.framework.TestCase";
    private static final String TEST_INTERFACE = "junit.framework.Test";
    private static final String TEST_SUITE_CLASS = "junit.framework.TestSuite";
    public static final String TEST_ANNOTATION = "org.junit.Test";
    public static final String TEST5_PACKAGE_FQN = "org.junit.jupiter.api";
    public static final String TEST5_ANNOTATION = "org.junit.jupiter.api.Test";
    public static final String CUSTOM_TESTABLE_ANNOTATION = "org.junit.platform.commons.annotation.Testable";
    public static final String TEST5_FACTORY_ANNOTATION = "org.junit.jupiter.api.TestFactory";
    public static final String IGNORE_ANNOTATION = "org.junit.Ignore";
    public static final String RUN_WITH = "org.junit.runner.RunWith";
    public static final String DATA_POINT = "org.junit.experimental.theories.DataPoint";
    public static final String SUITE_METHOD_NAME = "suite";
    public static final String BEFORE_ANNOTATION_NAME = "org.junit.Before";
    public static final String AFTER_ANNOTATION_NAME = "org.junit.After";
    public static final String BEFORE_EACH_ANNOTATION_NAME = "org.junit.jupiter.api.BeforeEach";
    public static final String AFTER_EACH_ANNOTATION_NAME = "org.junit.jupiter.api.AfterEach";
    public static final String PARAMETRIZED_PARAMETERS_ANNOTATION_NAME = "org.junit.runners.Parameterized.Parameters";
    public static final String PARAMETRIZED_PARAMETER_ANNOTATION_NAME = "org.junit.runners.Parameterized.Parameter";
    public static final String AFTER_CLASS_ANNOTATION_NAME = "org.junit.AfterClass";
    public static final String BEFORE_CLASS_ANNOTATION_NAME = "org.junit.BeforeClass";
    public static final Collection<String> TEST5_CONFIG_METHODS = ContainerUtil.immutableList((Object[])new String[]{"org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.AfterEach"});
    public static final String BEFORE_ALL_ANNOTATION_NAME = "org.junit.jupiter.api.BeforeAll";
    public static final String AFTER_ALL_ANNOTATION_NAME = "org.junit.jupiter.api.AfterAll";
    public static final Collection<String> TEST5_STATIC_CONFIG_METHODS = ContainerUtil.immutableList((Object[])new String[]{"org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll"});
    public static final Collection<String> TEST5_ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"org.junit.jupiter.api.Test", "org.junit.jupiter.api.TestFactory", "org.junit.platform.commons.annotation.Testable"});
    public static final Collection<String> TEST5_JUPITER_ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"org.junit.jupiter.api.Test", "org.junit.jupiter.api.TestFactory"});
    private static final List<String> INSTANCE_CONFIGS = Arrays.asList("org.junit.Before", "org.junit.After");
    private static final List<String> INSTANCE_5_CONFIGS = Arrays.asList("org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.AfterEach");
    private static final List<String> STATIC_CONFIGS = Arrays.asList("org.junit.BeforeClass", "org.junit.AfterClass", "org.junit.runners.Parameterized.Parameters");
    private static final List<String> STATIC_5_CONFIGS = Arrays.asList("org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll");
    private static final Collection<String> CONFIGURATIONS_ANNOTATION_NAME = ContainerUtil.immutableList((Object[])new String[]{"org.junit.experimental.theories.DataPoint", "org.junit.After", "org.junit.Before", "org.junit.AfterClass", "org.junit.BeforeClass", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll"});
    public static final String PARAMETERIZED_CLASS_NAME = "org.junit.runners.Parameterized";
    public static final String SUITE_CLASS_NAME = "org.junit.runners.Suite";
    public static final String JUNIT5_NESTED = "org.junit.jupiter.api.Nested";
    private static final String[] RUNNERS_UNAWARE_OF_INNER_CLASSES = new String[]{"org.junit.runners.Parameterized", "org.junit.runners.BlockJUnit4ClassRunner", "org.junit.runners.JUnit4", "org.junit.internal.runners.JUnit38ClassRunner", "org.junit.internal.runners.JUnit4ClassRunner", "org.junit.runners.Suite"};
    private static final String[] RUNNERS_REQUIRE_ANNOTATION_ON_TEST_METHOD = new String[]{"org.junit.runners.Parameterized", "org.junit.runners.BlockJUnit4ClassRunner", "org.junit.runners.JUnit4", "org.junit.internal.runners.JUnit4ClassRunner"};

    public static boolean isSuiteMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            JUnitUtil.$$$reportNull$$$0(0);
        }
        if (!psiMethod.hasModifierProperty("public")) {
            return false;
        }
        if (!psiMethod.hasModifierProperty("static")) {
            return false;
        }
        if (psiMethod.isConstructor()) {
            return false;
        }
        if (!psiMethod.getParameterList().isEmpty()) {
            return false;
        }
        PsiType returnType = psiMethod.getReturnType();
        if (returnType == null || returnType instanceof PsiPrimitiveType) {
            return false;
        }
        return returnType.equalsToText(TEST_INTERFACE) || returnType.equalsToText(TEST_SUITE_CLASS) || InheritanceUtil.isInheritor((PsiType)returnType, (String)TEST_INTERFACE);
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location) {
        return JUnitUtil.isTestMethod(location, true);
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location, boolean checkAbstract) {
        return JUnitUtil.isTestMethod(location, checkAbstract, true);
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location, boolean checkAbstract, boolean checkRunWith) {
        return JUnitUtil.isTestMethod(location, checkAbstract, checkRunWith, true);
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location, boolean checkAbstract, boolean checkRunWith, boolean checkClass2) {
        PsiClass testCaseClass;
        PsiAnnotation annotation;
        PsiClass aClass;
        PsiMethod psiMethod = (PsiMethod)location.getPsiElement();
        PsiClass psiClass = aClass = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : psiMethod.getContainingClass();
        if (checkClass2 && (aClass == null || !JUnitUtil.isTestClass(aClass, checkAbstract, true))) {
            return false;
        }
        if (JUnitUtil.isTestAnnotated(psiMethod, false)) {
            return !psiMethod.hasModifierProperty("static");
        }
        if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiMethod, Collections.singletonList(CUSTOM_TESTABLE_ANNOTATION))) {
            return true;
        }
        if (psiMethod.isConstructor()) {
            return false;
        }
        if (!psiMethod.hasModifierProperty("public")) {
            return false;
        }
        if (psiMethod.hasModifierProperty("abstract")) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, CONFIGURATIONS_ANNOTATION_NAME, (int)0)) {
            return false;
        }
        if (checkClass2 && checkRunWith && (annotation = JUnitUtil.getRunWithAnnotation(aClass)) != null) {
            return !JUnitUtil.isOneOf(annotation, RUNNERS_REQUIRE_ANNOTATION_ON_TEST_METHOD);
        }
        if (!psiMethod.getParameterList().isEmpty()) {
            return false;
        }
        if (psiMethod.hasModifierProperty("static")) {
            return false;
        }
        if (!psiMethod.getName().startsWith("test")) {
            return false;
        }
        if (checkClass2 && ((testCaseClass = JUnitUtil.getTestCaseClassOrNull(aClass)) == null || !psiMethod.getContainingClass().isInheritor(testCaseClass, true))) {
            return false;
        }
        return PsiType.VOID.equals((Object)psiMethod.getReturnType());
    }

    public static boolean isTestCaseInheritor(PsiClass aClass) {
        if (!aClass.isValid()) {
            return false;
        }
        PsiClass testCaseClass = JUnitUtil.getTestCaseClassOrNull(aClass);
        return testCaseClass != null && aClass.isInheritor(testCaseClass, true);
    }

    public static boolean isTestClass(PsiClass psiClass) {
        return JUnitUtil.isTestClass(psiClass, true, true);
    }

    public static boolean isTestClass(@NotNull PsiClass psiClass, boolean checkAbstract, boolean checkForTestCaseInheritance) {
        PsiAnnotation annotation;
        if (psiClass == null) {
            JUnitUtil.$$$reportNull$$$0(1);
        }
        if (psiClass.getQualifiedName() == null) {
            return false;
        }
        if (JUnitUtil.isJUnit5((PsiElement)psiClass) ? JUnitUtil.isJUnit5TestClass(psiClass, checkAbstract) : MetaAnnotationUtil.isMetaAnnotatedInHierarchy((PsiModifierListOwner)psiClass, Collections.singleton(CUSTOM_TESTABLE_ANNOTATION))) {
            return true;
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true, (boolean)checkAbstract)) {
            return false;
        }
        PsiClass topLevelClass = JUnitUtil.getTopmostClass(psiClass);
        if (topLevelClass != null && (annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)topLevelClass, Collections.singleton(RUN_WITH))) != null) {
            if (topLevelClass == psiClass) {
                return true;
            }
            if (!JUnitUtil.isInheritorOrSelfRunner(annotation, RUNNERS_UNAWARE_OF_INNER_CLASSES)) {
                return true;
            }
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)RUN_WITH, (int)1)) {
            return true;
        }
        if (checkForTestCaseInheritance && JUnitUtil.isTestCaseInheritor(psiClass)) {
            return true;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create((Object)JUnitUtil.hasTestOrSuiteMethods(psiClass), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT}));
    }

    private static boolean hasTestOrSuiteMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JUnitUtil.$$$reportNull$$$0(2);
        }
        for (PsiMethod psiMethod : psiClass.getAllMethods()) {
            if (JUnitUtil.isSuiteMethod(psiMethod)) {
                return true;
            }
            if (!JUnitUtil.isTestAnnotated(psiMethod)) continue;
            return true;
        }
        if (JUnitUtil.isJUnit5((PsiElement)psiClass)) {
            for (PsiMethod psiMethod : psiClass.getInnerClasses()) {
                for (PsiMethod method : psiMethod.getAllMethods()) {
                    if (!JUnitUtil.isTestAnnotated(method)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isJUnit3TestClass(PsiClass clazz) {
        return JUnitUtil.isTestCaseInheritor(clazz);
    }

    public static boolean isJUnit4TestClass(PsiClass psiClass) {
        return JUnitUtil.isJUnit4TestClass(psiClass, true);
    }

    public static boolean isJUnit4TestClass(PsiClass psiClass, boolean checkAbstract) {
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        if (psiClass.getQualifiedName() == null) {
            return false;
        }
        PsiClass topLevelClass = JUnitUtil.getTopmostClass(psiClass);
        if (topLevelClass != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)topLevelClass, (String)RUN_WITH, (int)1)) {
            PsiAnnotation annotation = JUnitUtil.getRunWithAnnotation(topLevelClass);
            if (topLevelClass == psiClass) {
                return true;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)RUN_WITH, (int)1)) {
                return true;
            }
            if (annotation != null && !JUnitUtil.isInheritorOrSelfRunner(annotation, RUNNERS_UNAWARE_OF_INNER_CLASSES)) {
                return true;
            }
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true, (boolean)checkAbstract)) {
            return false;
        }
        for (PsiMethod method : psiClass.getAllMethods()) {
            ProgressManager.checkCanceled();
            if (!JUnitUtil.isJUnit4TestAnnotated(method)) continue;
            return true;
        }
        return false;
    }

    private static PsiClass getTopmostClass(PsiClass psiClass) {
        PsiClass topLevelClass;
        for (topLevelClass = psiClass; topLevelClass != null && topLevelClass.getContainingClass() != null; topLevelClass = topLevelClass.getContainingClass()) {
        }
        return topLevelClass;
    }

    public static boolean isJUnit5TestClass(@NotNull PsiClass psiClass, boolean checkAbstract) {
        PsiModifierList modifierList;
        if (psiClass == null) {
            JUnitUtil.$$$reportNull$$$0(3);
        }
        if ((modifierList = psiClass.getModifierList()) == null) {
            return false;
        }
        if (psiClass.isAnnotationType()) {
            return false;
        }
        if (psiClass.getContainingClass() != null && MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiClass, Collections.singleton(JUNIT5_NESTED))) {
            return true;
        }
        if (MetaAnnotationUtil.isMetaAnnotatedInHierarchy((PsiModifierListOwner)psiClass, Collections.singleton(CUSTOM_TESTABLE_ANNOTATION))) {
            return true;
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)false, (boolean)checkAbstract)) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            boolean hasAnnotation = false;
            for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                ProgressManager.checkCanceled();
                if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiMethod, TEST5_ANNOTATIONS)) continue;
                hasAnnotation = true;
                break;
            }
            if (!hasAnnotation) {
                for (PsiMethod psiMethod : psiClass.getAllInnerClasses()) {
                    if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiMethod, Collections.singleton(JUNIT5_NESTED))) continue;
                    hasAnnotation = true;
                    break;
                }
            }
            return CachedValueProvider.Result.create((Object)hasAnnotation, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    public static boolean isJUnit5(@NotNull PsiElement element) {
        if (element == null) {
            JUnitUtil.$$$reportNull$$$0(4);
        }
        return JUnitUtil.isJUnit5(element.getResolveScope(), element.getProject());
    }

    public static boolean isJUnit5(GlobalSearchScope scope, Project project) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        Condition foundCondition = aPackageName -> {
            PsiPackage aPackage = facade.findPackage(aPackageName);
            return aPackage != null && aPackage.getDirectories(scope).length > 0;
        };
        return (Boolean)ReadAction.compute(() -> foundCondition.value((Object)TEST5_PACKAGE_FQN));
    }

    public static boolean isTestAnnotated(PsiMethod method) {
        return JUnitUtil.isTestAnnotated(method, true);
    }

    public static boolean isTestAnnotated(PsiMethod method, boolean includeCustom) {
        if (JUnitUtil.isJUnit4TestAnnotated(method)) {
            return true;
        }
        return MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)method, includeCustom ? TEST5_ANNOTATIONS : TEST5_JUPITER_ANNOTATIONS);
    }

    public static boolean isJUnit4TestAnnotated(PsiMethod method) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)TEST_ANNOTATION, (int)1) || JUnitRecognizer.willBeAnnotatedAfterCompilation((PsiMethod)method);
    }

    @Nullable
    private static PsiClass getTestCaseClassOrNull(PsiClass psiClass) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true);
        return JUnitUtil.getTestCaseClassOrNull(scope, module.getProject());
    }

    public static PsiClass getTestCaseClass(Module module) throws NoJUnitException {
        if (module == null) {
            throw new NoJUnitException();
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true);
        return JUnitUtil.getTestCaseClass(scope, module.getProject());
    }

    public static PsiClass getTestCaseClass(SourceScope scope) throws NoJUnitException {
        if (scope == null) {
            throw new NoJUnitException();
        }
        return JUnitUtil.getTestCaseClass(scope.getLibrariesScope(), scope.getProject());
    }

    public static void checkTestCase(SourceScope scope, Project project) throws NoJUnitException {
        if (scope == null) {
            throw new NoJUnitException();
        }
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage("junit.framework");
        if (aPackage == null || aPackage.getDirectories(scope.getLibrariesScope()).length == 0) {
            throw new NoJUnitException();
        }
    }

    private static PsiClass getTestCaseClass(GlobalSearchScope scope, Project project) throws NoJUnitException {
        PsiClass testCaseClass = JUnitUtil.getTestCaseClassOrNull(scope, project);
        if (testCaseClass == null) {
            throw new NoJUnitException(scope.getDisplayName());
        }
        return testCaseClass;
    }

    @Nullable
    private static PsiClass getTestCaseClassOrNull(GlobalSearchScope scope, Project project) {
        return JavaPsiFacade.getInstance((Project)project).findClass(TEST_CASE_CLASS, scope);
    }

    public static boolean isTestMethodOrConfig(@NotNull PsiMethod psiMethod) {
        PsiClass containingClass;
        if (psiMethod == null) {
            JUnitUtil.$$$reportNull$$$0(5);
        }
        if ((containingClass = psiMethod.getContainingClass()) == null) {
            return false;
        }
        if (JUnitUtil.isTestMethod((Location<? extends PsiMethod>)PsiLocation.fromPsiElement((PsiElement)psiMethod), false)) {
            if (containingClass.hasModifierProperty("abstract")) {
                boolean[] foundNonAbstractInheritor = new boolean[1];
                ClassInheritorsSearch.search((PsiClass)containingClass).forEach(psiClass -> {
                    if (!psiClass.hasModifierProperty("abstract")) {
                        foundNonAbstractInheritor[0] = true;
                        return false;
                    }
                    return true;
                });
                if (foundNonAbstractInheritor[0]) {
                    return true;
                }
            } else {
                return true;
            }
        }
        String name2 = psiMethod.getName();
        boolean isPublic = psiMethod.hasModifierProperty("public");
        if (!psiMethod.hasModifierProperty("abstract")) {
            if (isPublic && (SUITE_METHOD_NAME.equals(name2) || "setUp".equals(name2) || "tearDown".equals(name2))) {
                return true;
            }
            if (psiMethod.hasModifierProperty("static")) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, STATIC_CONFIGS, (int)0)) {
                    return isPublic;
                }
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, STATIC_5_CONFIGS, (int)0)) {
                    return true;
                }
            } else {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, INSTANCE_CONFIGS, (int)0)) {
                    return isPublic;
                }
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, INSTANCE_5_CONFIGS, (int)0)) {
                    return true;
                }
                if (TestUtils.testInstancePerClass(containingClass) && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, STATIC_5_CONFIGS, (int)0)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static PsiMethod findFirstTestMethod(PsiClass clazz) {
        PsiMethod testMethod = null;
        for (PsiMethod method : clazz.getMethods()) {
            if (!JUnitUtil.isTestMethod(MethodLocation.elementInClass(method, clazz)) && !JUnitUtil.isSuiteMethod(method)) continue;
            testMethod = method;
            break;
        }
        return testMethod;
    }

    @Nullable
    public static PsiMethod findSuiteMethod(PsiClass clazz) {
        PsiMethod[] suiteMethods;
        for (PsiMethod method : suiteMethods = clazz.findMethodsByName(SUITE_METHOD_NAME, false)) {
            if (!JUnitUtil.isSuiteMethod(method)) continue;
            return method;
        }
        return null;
    }

    public static PsiAnnotation getRunWithAnnotation(PsiClass aClass) {
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)aClass, Collections.singleton(RUN_WITH));
    }

    public static boolean isParameterized(PsiAnnotation annotation) {
        return JUnitUtil.isOneOf(annotation, PARAMETERIZED_CLASS_NAME);
    }

    public static boolean isInheritorOrSelfRunner(PsiAnnotation annotation, String ... runners) {
        PsiAnnotationMemberValue value2;
        PsiNameValuePair attribute = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"value");
        PsiAnnotationMemberValue psiAnnotationMemberValue = value2 = attribute != null ? attribute.getDetachedValue() : null;
        if (value2 instanceof PsiClassObjectAccessExpression) {
            PsiTypeElement operand2 = ((PsiClassObjectAccessExpression)value2).getOperand();
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)operand2.getType());
            return psiClass != null && Arrays.stream(runners).anyMatch(runner -> InheritanceUtil.isInheritor((PsiClass)psiClass, (String)runner));
        }
        return false;
    }

    public static boolean isOneOf(PsiAnnotation annotation, String ... runners) {
        String qualifiedName;
        PsiTypeElement operand2;
        PsiClass psiClass;
        PsiAnnotationMemberValue value2;
        PsiNameValuePair attribute = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"value");
        PsiAnnotationMemberValue psiAnnotationMemberValue = value2 = attribute != null ? attribute.getDetachedValue() : null;
        return value2 instanceof PsiClassObjectAccessExpression && (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)(operand2 = ((PsiClassObjectAccessExpression)value2).getOperand()).getType())) != null && (qualifiedName = psiClass.getQualifiedName()) != null && ArrayUtil.find((Object[])runners, (Object)qualifiedName) > -1;
    }

    public static PsiClass findPsiClass(String qualifiedName, Module module, Project project) {
        GlobalSearchScope scope = module == null ? GlobalSearchScope.projectScope((Project)project) : GlobalSearchScope.moduleWithDependenciesScope((Module)module);
        return JavaPsiFacade.getInstance((Project)project).findClass(qualifiedName, scope);
    }

    public static PsiPackage getContainingPackage(@NotNull PsiClass psiClass) {
        PsiDirectory directory;
        if (psiClass == null) {
            JUnitUtil.$$$reportNull$$$0(6);
        }
        return (directory = psiClass.getContainingFile().getContainingDirectory()) == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
    }

    public static PsiClass getTestClass(PsiElement element) {
        return JUnitUtil.getTestClass(PsiLocation.fromPsiElement((PsiElement)element));
    }

    public static PsiClass getTestClass(Location<?> location) {
        PsiClass[] classes2;
        Iterator iterator = location.getAncestors(PsiClass.class, false);
        while (iterator.hasNext()) {
            Location classLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestClass((PsiClass)classLocation.getPsiElement(), false, true)) continue;
            return (PsiClass)classLocation.getPsiElement();
        }
        PsiElement element = location.getPsiElement();
        if (element instanceof PsiClassOwner && (classes2 = ((PsiClassOwner)element).getClasses()).length == 1 && JUnitUtil.isTestClass(classes2[0], false, true)) {
            return classes2[0];
        }
        return null;
    }

    public static PsiMethod getTestMethod(PsiElement element) {
        return JUnitUtil.getTestMethod(element, true);
    }

    public static PsiMethod getTestMethod(PsiElement element, boolean checkAbstract) {
        return JUnitUtil.getTestMethod(element, checkAbstract, true);
    }

    public static PsiMethod getTestMethod(PsiElement element, boolean checkAbstract, boolean checkRunWith) {
        PsiManager manager = element.getManager();
        if (element instanceof PsiMethod) {
            Location location = PsiLocation.fromPsiElement((Project)manager.getProject(), (PsiElement)((PsiMethod)element));
            return JUnitUtil.isTestMethod((Location<? extends PsiMethod>)location, checkAbstract, checkRunWith) ? (PsiMethod)element : null;
        }
        Location location = PsiLocation.fromPsiElement((Project)manager.getProject(), (PsiElement)element);
        Iterator iterator = location.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            Location methodLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestMethod((Location<? extends PsiMethod>)methodLocation, checkAbstract, checkRunWith)) continue;
            return (PsiMethod)methodLocation.getPsiElement();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/junit/JUnitUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuiteMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasTestOrSuiteMethods";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isJUnit5TestClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isJUnit5";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestMethodOrConfig";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getContainingPackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class NoJUnitException
    extends CantRunException {
        public NoJUnitException() {
            super(ExecutionBundle.message((String)"no.junit.error.message", (Object[])new Object[0]));
        }

        public NoJUnitException(String message2) {
            super(ExecutionBundle.message((String)"no.junit.in.scope.error.message", (Object[])new Object[]{message2}));
        }
    }

    public static class TestMethodFilter
    implements Condition<PsiMethod> {
        private final PsiClass myClass;
        private final JavaTestFramework framework;

        public TestMethodFilter(PsiClass aClass) {
            this.myClass = aClass;
            TestFramework framework = TestFrameworks.detectFramework((PsiClass)aClass);
            this.framework = framework instanceof JavaTestFramework ? (JavaTestFramework)framework : null;
        }

        public boolean value(PsiMethod method) {
            return this.framework != null ? this.framework.isTestMethod(method, this.myClass) : JUnitUtil.isTestMethod(MethodLocation.elementInClass(method, this.myClass));
        }
    }
}

