/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.jshell.JShellDiagnostic;
import com.intellij.execution.jshell.JShellHandler;
import com.intellij.execution.jshell.JShellRootType;
import com.intellij.execution.jshell.SnippetEditorDecorator;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class LaunchJShellConsoleAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            LaunchJShellConsoleAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        VirtualFile contentFile = ConsoleHistoryController.getContentFile((ConsoleRootType)JShellRootType.getInstance(), (String)"jshell_console", (ScratchFileService.Option)ScratchFileService.Option.create_new_always);
        assert (contentFile != null);
        try {
            FileEditor[] editors = FileEditorManager.getInstance((Project)project).openFile(contentFile, true);
            Sdk alternateSdk = null;
            Module module = null;
            for (FileEditor editor : editors) {
                SnippetEditorDecorator.ConfigurationPane config = SnippetEditorDecorator.getJShellConfiguration(editor);
                if (config == null) continue;
                alternateSdk = config.getRuntimeSdk();
                module = config.getContextModule();
                break;
            }
            JShellHandler.create(project, contentFile, module, alternateSdk);
        }
        catch (Exception ex) {
            JShellDiagnostic.notifyError(ex, project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/jshell/LaunchJShellConsoleAction", "actionPerformed"));
    }
}

