/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/execution/application/JavaApplicationRunConfigurationImporter;", "Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationImporter;", "()V", "canImport", "", "typeName", "", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "process", "", "project", "Lcom/intellij/openapi/project/Project;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "cfg", "", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "Companion", "intellij.java.execution.impl"})
public final class JavaApplicationRunConfigurationImporter
implements RunConfigurationImporter {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    public void process(@NotNull Project project, @NotNull RunConfiguration runConfiguration, @NotNull Map<String, ?> cfg, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkParameterIsNotNull(cfg, (String)"cfg");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        if (!(runConfiguration instanceof ApplicationConfiguration)) {
            throw (Throwable)new IllegalArgumentException("Unexpected type of run configuration: " + runConfiguration.getClass());
        }
        ObjectUtils.consumeIfCast(cfg.get("moduleName"), String.class, (Consumer)new Consumer<T>(modelsProvider, runConfiguration){
            final /* synthetic */ IdeModifiableModelsProvider $modelsProvider;
            final /* synthetic */ RunConfiguration $runConfiguration;

            public final void consume(String it) {
                Module module = this.$modelsProvider.getModifiableModuleModel().findModuleByName(it);
                if (module != null) {
                    ((ApplicationConfiguration)this.$runConfiguration).setModule(module);
                }
            }
            {
                this.$modelsProvider = ideModifiableModelsProvider;
                this.$runConfiguration = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("mainClass"), String.class, (Consumer)new Consumer<T>(runConfiguration){
            final /* synthetic */ RunConfiguration $runConfiguration;

            public final void consume(String it) {
                ((ApplicationConfiguration)this.$runConfiguration).setMainClassName(it);
            }
            {
                this.$runConfiguration = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("jvmArgs"), String.class, (Consumer)new Consumer<T>(runConfiguration){
            final /* synthetic */ RunConfiguration $runConfiguration;

            public final void consume(String it) {
                ((ApplicationConfiguration)this.$runConfiguration).setVMParameters(it);
            }
            {
                this.$runConfiguration = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("programParameters"), String.class, (Consumer)new Consumer<T>(runConfiguration){
            final /* synthetic */ RunConfiguration $runConfiguration;

            public final void consume(String it) {
                ((ApplicationConfiguration)this.$runConfiguration).setProgramParameters(it);
            }
            {
                this.$runConfiguration = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("envs"), Map.class, (Consumer)new Consumer<T>(runConfiguration){
            final /* synthetic */ RunConfiguration $runConfiguration;

            public final void consume(Map<?, ?> it) {
                Map<?, ?> map2 = it;
                if (map2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
                }
                ((ApplicationConfiguration)this.$runConfiguration).setEnvs(TypeIntrinsics.asMutableMap(map2));
            }
            {
                this.$runConfiguration = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("workingDirectory"), String.class, (Consumer)new Consumer<T>(runConfiguration){
            final /* synthetic */ RunConfiguration $runConfiguration;

            public final void consume(String it) {
                ((ApplicationConfiguration)this.$runConfiguration).setWorkingDirectory(it);
            }
            {
                this.$runConfiguration = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("shortenCommandLine"), String.class, (Consumer)new Consumer<T>(runConfiguration){
            final /* synthetic */ RunConfiguration $runConfiguration;

            public final void consume(String it) {
                try {
                    ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)this.$runConfiguration;
                    String string = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    applicationConfiguration.setShortenCommandLine(ShortenCommandLine.valueOf((String)string));
                }
                catch (IllegalArgumentException e) {
                    JavaApplicationRunConfigurationImporter.Companion.getLOG().warn("Illegal value of 'shortenCommandLine': " + it, (Throwable)e);
                }
            }
            {
                this.$runConfiguration = runConfiguration;
            }
        });
    }

    public boolean canImport(@NotNull String typeName) {
        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
        return Intrinsics.areEqual((Object)typeName, (Object)"application");
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = ((ApplicationConfigurationType)ConfigurationTypeUtil.findConfigurationType(ApplicationConfigurationType.class)).getConfigurationFactories()[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationFactory, (String)"ConfigurationTypeUtil.fi\u2026configurationFactories[0]");
        return configurationFactory;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(JavaApplicationRunConfigurationImporter.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(JavaA\u2026tionImporter::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/execution/application/JavaApplicationRunConfigurationImporter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.java.execution.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

