/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.application.BaseJavaApplicationCommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.filters.ArgumentFileFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.util.PathsList;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class ApplicationCommandLineState<T extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element> & ConfigurationWithCommandLineShortener>
extends BaseJavaApplicationCommandLineState<T> {
    public ApplicationCommandLineState(@NotNull T configuration, ExecutionEnvironment environment) {
        if (configuration == null) {
            ApplicationCommandLineState.$$$reportNull$$$0(0);
        }
        super(environment, configuration);
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        String jreHome;
        JavaParameters params = new JavaParameters();
        ModuleBasedConfiguration configuration = (ModuleBasedConfiguration)this.getConfiguration();
        params.setMainClass(((CommonJavaRunConfigurationParameters)((ModuleBasedConfiguration)this.myConfiguration)).getRunClass());
        this.setupJavaParameters(params);
        JavaRunConfigurationModule module = (JavaRunConfigurationModule)((ModuleBasedConfiguration)this.myConfiguration).getConfigurationModule();
        String string = jreHome = ((CommonJavaRunConfigurationParameters)((ModuleBasedConfiguration)this.myConfiguration)).isAlternativeJrePathEnabled() ? ((CommonJavaRunConfigurationParameters)((ModuleBasedConfiguration)this.myConfiguration)).getAlternativeJrePath() : null;
        if (module.getModule() != null) {
            DumbService.getInstance((Project)module.getProject()).runWithAlternativeResolveEnabled(() -> {
                int classPathType = JavaParametersUtil.getClasspathType((RunConfigurationModule)module, ((CommonJavaRunConfigurationParameters)((ModuleBasedConfiguration)this.myConfiguration)).getRunClass(), false, this.isProvidedScopeIncluded());
                JavaParametersUtil.configureModule((RunConfigurationModule)module, params, classPathType, jreHome);
            });
        } else {
            JavaParametersUtil.configureProject(module.getProject(), params, 7, jreHome);
        }
        ApplicationCommandLineState.setupModulePath(params, module);
        params.setShortenCommandLine(((ConfigurationWithCommandLineShortener)configuration).getShortenCommandLine(), configuration.getProject());
        return params;
    }

    @Override
    protected GeneralCommandLine createCommandLine() throws ExecutionException {
        GeneralCommandLine line = super.createCommandLine();
        Map content = (Map)line.getUserData(JdkUtil.COMMAND_LINE_CONTENT);
        if (content != null) {
            content.forEach((key2, value2) -> this.addConsoleFilters(new Filter[]{new ArgumentFileFilter(key2, value2)}));
        }
        return line;
    }

    @Override
    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        OSProcessHandler processHandler = super.startProcess();
        if (processHandler instanceof KillableProcessHandler && DebuggerSettings.getInstance().KILL_PROCESS_IMMEDIATELY) {
            ((KillableProcessHandler)processHandler).setShouldKillProcessSoftly(false);
        }
        OSProcessHandler oSProcessHandler = processHandler;
        if (oSProcessHandler == null) {
            ApplicationCommandLineState.$$$reportNull$$$0(1);
        }
        return oSProcessHandler;
    }

    private static void setupModulePath(JavaParameters params, JavaRunConfigurationModule module) {
        PsiJavaModule mainModule;
        if (JavaSdkUtil.isJdkAtLeast(params.getJdk(), JavaSdkVersion.JDK_1_9) && (mainModule = (PsiJavaModule)DumbService.getInstance((Project)module.getProject()).computeWithAlternativeResolveEnabled(() -> JavaModuleGraphUtil.findDescriptorByElement((PsiElement)module.findClass(params.getMainClass())))) != null) {
            boolean inLibrary;
            boolean bl = inLibrary = mainModule instanceof PsiCompiledElement || mainModule instanceof LightJavaModule;
            if (!inLibrary || JavaModuleGraphUtil.findDescriptorByModule(module.getModule(), false) != null) {
                params.setModuleName(mainModule.getName());
                PathsList classPath = params.getClassPath();
                PathsList modulePath = params.getModulePath();
                modulePath.addAll(classPath.getPathList());
                classPath.clear();
            }
        }
    }

    protected abstract boolean isProvidedScopeIncluded();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/application/ApplicationCommandLineState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/application/ApplicationCommandLineState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

