/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.model;

import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.ICaption;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.StaticDecorator;
import com.intellij.designer.designSurface.tools.DragTracker;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.designer.model.RadLayout;
import com.intellij.designer.model.RadLayoutData;
import com.intellij.designer.propertyTable.PropertyTable;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RadComponent
extends PropertiesContainer {
    private static final String ERROR_KEY = "Inspection.Errors";
    protected MetaModel myMetaModel;
    private RadComponent myParent;
    private RadLayout myLayout;
    private final Map<Object, Object> myClientProperties = new HashMap<Object, Object>();

    public MetaModel getMetaModel() {
        return this.myMetaModel;
    }

    public MetaModel getMetaModelForProperties() throws Exception {
        return this.myMetaModel;
    }

    public void setMetaModel(MetaModel metaModel) {
        this.myMetaModel = metaModel;
    }

    public RadComponent getRoot() {
        return this.myParent == null ? this : this.myParent.getRoot();
    }

    public final RadComponent getParent() {
        return this.myParent;
    }

    public final <T extends RadComponent> T getParent(Class<T> clazz) {
        return (T)((Object)this.myParent);
    }

    public final void setParent(RadComponent parent) {
        this.myParent = parent;
    }

    public List<RadComponent> getChildren() {
        return Collections.emptyList();
    }

    public Object[] getTreeChildren() {
        return this.getChildren().toArray();
    }

    public void add(@NotNull RadComponent component, @Nullable RadComponent insertBefore) {
        int index;
        if (component == null) {
            RadComponent.$$$reportNull$$$0(0);
        }
        component.setParent(this);
        List<RadComponent> children = this.getChildren();
        if (insertBefore == null) {
            index = children.size();
            children.add(component);
        } else {
            index = children.indexOf((Object)insertBefore);
            children.add(index, component);
        }
        if (this.myLayout != null) {
            this.myLayout.addComponentToContainer(component, index);
        }
    }

    public void remove(@NotNull RadComponent component) {
        if (component == null) {
            RadComponent.$$$reportNull$$$0(1);
        }
        this.getChildren().remove((Object)component);
        if (this.myLayout != null) {
            this.myLayout.removeComponentFromContainer(component);
        }
        component.setParent(null);
    }

    public void removeFromParent() {
        this.getParent().remove(this);
    }

    public boolean isBackground() {
        return false;
    }

    public boolean isSameType(@NotNull RadComponent other) {
        if (other == null) {
            RadComponent.$$$reportNull$$$0(2);
        }
        return ((Object)((Object)other)).getClass() == ((Object)((Object)this)).getClass();
    }

    public Rectangle getBounds() {
        return null;
    }

    public Rectangle getBounds(Component relativeTo) {
        return null;
    }

    public Rectangle fromModel(@NotNull Component target, @NotNull Rectangle rectangle) {
        if (target == null) {
            RadComponent.$$$reportNull$$$0(3);
        }
        if (rectangle == null) {
            RadComponent.$$$reportNull$$$0(4);
        }
        return null;
    }

    public Rectangle toModel(@NotNull Component source, @NotNull Rectangle rectangle) {
        if (source == null) {
            RadComponent.$$$reportNull$$$0(5);
        }
        if (rectangle == null) {
            RadComponent.$$$reportNull$$$0(6);
        }
        return null;
    }

    public Point fromModel(@NotNull Component target, @NotNull Point point) {
        if (target == null) {
            RadComponent.$$$reportNull$$$0(7);
        }
        if (point == null) {
            RadComponent.$$$reportNull$$$0(8);
        }
        return null;
    }

    public Point toModel(@NotNull Component source, @NotNull Point point) {
        if (source == null) {
            RadComponent.$$$reportNull$$$0(9);
        }
        if (point == null) {
            RadComponent.$$$reportNull$$$0(10);
        }
        return null;
    }

    public Dimension fromModel(@NotNull Component target, @NotNull Dimension size) {
        if (target == null) {
            RadComponent.$$$reportNull$$$0(11);
        }
        if (size == null) {
            RadComponent.$$$reportNull$$$0(12);
        }
        return null;
    }

    public Dimension toModel(@NotNull Component source, @NotNull Dimension size) {
        if (source == null) {
            RadComponent.$$$reportNull$$$0(13);
        }
        if (size == null) {
            RadComponent.$$$reportNull$$$0(14);
        }
        return null;
    }

    public Point convertPoint(Component relativeFrom, int x, int y) {
        return null;
    }

    public InputTool getDragTracker(Point location, InputEvent event, boolean isTree) {
        return new DragTracker(this);
    }

    public void processDropOperation(OperationContext context) {
    }

    public void addStaticDecorators(List<StaticDecorator> decorators, List<RadComponent> selection) {
    }

    public void addSelectionActions(DesignerEditorPanel designer, DefaultActionGroup actionGroup, JComponent shortcuts, List<RadComponent> selection) {
    }

    @Nullable
    public ICaption getCaption() {
        return null;
    }

    public RadLayout getLayout() {
        return this.myLayout;
    }

    public void setLayout(@Nullable RadLayout layout) {
        this.myLayout = layout;
        if (this.myLayout != null) {
            this.myLayout.setContainer(this);
        }
    }

    @Nullable
    public RadLayoutData getLayoutData() {
        return null;
    }

    public List<Property> getProperties() {
        return Collections.emptyList();
    }

    public List<Property> getProperties(String key2) {
        return Collections.emptyList();
    }

    @Nullable
    public String getPropertyValue(String name2) {
        if (this.getProperties() == null) {
            throw new NullPointerException("Component " + (Object)((Object)this) + ", " + this.myLayout + ", " + this.myMetaModel.getTag() + ", " + this.myMetaModel.getTarget() + " without properties");
        }
        Property property = PropertyTable.findProperty(this.getProperties(), (String)name2);
        if (property != null) {
            try {
                return String.valueOf(property.getValue((PropertiesContainer)this));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public List<Property> getInplaceProperties() throws Exception {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (this.myMetaModel != null) {
            List<Property> allProperties = this.getProperties();
            for (String name2 : this.myMetaModel.getInplaceProperties()) {
                Property property = PropertyTable.findProperty(allProperties, (String)name2);
                if (property == null) continue;
                properties.add(property);
            }
        }
        return properties;
    }

    public final <T> T getClientProperty(@NotNull String key2) {
        if (key2 == null) {
            RadComponent.$$$reportNull$$$0(15);
        }
        return (T)this.myClientProperties.get(key2);
    }

    public final <T> T extractClientProperty(@NotNull String key2) {
        if (key2 == null) {
            RadComponent.$$$reportNull$$$0(16);
        }
        return (T)this.myClientProperties.remove(key2);
    }

    public final void setClientProperty(@NotNull Object key2, Object value2) {
        if (key2 == null) {
            RadComponent.$$$reportNull$$$0(17);
        }
        this.myClientProperties.put(key2, value2);
    }

    public void accept(RadComponentVisitor visitor, boolean forward) {
        if (visitor.visit(this)) {
            this.acceptChildren(visitor, forward);
            visitor.endVisit(this);
        }
    }

    public void acceptChildren(RadComponentVisitor visitor, boolean forward) {
        List<RadComponent> children = this.getChildrenForAccept(visitor);
        if (forward) {
            for (RadComponent child : children) {
                child.accept(visitor, forward);
            }
        } else {
            int size = children.size();
            for (int i = size - 1; i >= 0; --i) {
                children.get(i).accept(visitor, forward);
            }
        }
    }

    protected List<RadComponent> getChildrenForAccept(RadComponentVisitor visitor) {
        return this.getChildren();
    }

    public boolean canDelete() {
        return this.myMetaModel == null || this.myMetaModel.canDelete();
    }

    public void delete() throws Exception {
    }

    public void copyTo(Element parentElement) throws Exception {
    }

    @Nullable
    public RadComponent morphingTo(MetaModel target) throws Exception {
        return null;
    }

    @Nullable
    public RadComponent wrapIn(MetaModel target) throws Exception {
        return null;
    }

    public static List<ErrorInfo> getError(RadComponent component) {
        List errorInfos = (List)component.getClientProperty(ERROR_KEY);
        return errorInfos == null ? Collections.emptyList() : errorInfos;
    }

    public static void addError(RadComponent component, ErrorInfo errorInfo) {
        ArrayList<ErrorInfo> errorInfos = (ArrayList<ErrorInfo>)component.getClientProperty(ERROR_KEY);
        if (errorInfos == null) {
            errorInfos = new ArrayList<ErrorInfo>();
            component.setClientProperty(ERROR_KEY, errorInfos);
        }
        errorInfos.add(errorInfo);
    }

    public static void clearErrors(RadComponent component) {
        component.accept(new RadComponentVisitor(){

            @Override
            public void endVisit(RadComponent component) {
                component.extractClientProperty(RadComponent.ERROR_KEY);
            }
        }, true);
    }

    @NotNull
    public static Map<RadComponent, List<RadComponent>> groupSiblings(@NotNull List<? extends RadComponent> components) {
        if (components == null) {
            RadComponent.$$$reportNull$$$0(18);
        }
        HashMap<RadComponent, List<RadComponent>> siblingLists = new HashMap<RadComponent, List<RadComponent>>();
        if (components.isEmpty()) {
            HashMap<RadComponent, List<RadComponent>> hashMap = siblingLists;
            if (hashMap == null) {
                RadComponent.$$$reportNull$$$0(19);
            }
            return hashMap;
        }
        if (components.size() == 1) {
            RadComponent component = components.get(0);
            siblingLists.put(component.getParent(), Collections.singletonList(component));
            HashMap<RadComponent, List<RadComponent>> hashMap = siblingLists;
            if (hashMap == null) {
                RadComponent.$$$reportNull$$$0(20);
            }
            return hashMap;
        }
        for (RadComponent radComponent : components) {
            RadComponent parent = radComponent.getParent();
            ArrayList<RadComponent> children = (ArrayList<RadComponent>)siblingLists.get((Object)parent);
            if (children == null) {
                children = new ArrayList<RadComponent>();
                siblingLists.put(parent, children);
            }
            children.add(radComponent);
        }
        HashMap<RadComponent, List<RadComponent>> hashMap = siblingLists;
        if (hashMap == null) {
            RadComponent.$$$reportNull$$$0(21);
        }
        return hashMap;
    }

    public static Set<RadComponent> getParents(List<? extends RadComponent> components) {
        HashSet<RadComponent> parents = new HashSet<RadComponent>();
        for (RadComponent radComponent : components) {
            RadComponent parent = radComponent.getParent();
            if (parent == null) continue;
            parents.add(parent);
        }
        return parents;
    }

    public static boolean isParentsContainedIn(List<RadComponent> components, RadComponent component) {
        for (RadComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!components.contains((Object)parent)) continue;
            return true;
        }
        return false;
    }

    public static List<RadComponent> getPureSelection(List<RadComponent> selection) {
        ArrayList<RadComponent> components = new ArrayList<RadComponent>();
        for (RadComponent component : selection) {
            if (RadComponent.isParentsContainedIn(selection, component)) continue;
            components.add(component);
        }
        return components;
    }

    public boolean isAncestorFor(@NotNull RadComponent component, boolean strict) {
        RadComponent parent;
        if (component == null) {
            RadComponent.$$$reportNull$$$0(22);
        }
        RadComponent radComponent = parent = strict ? component.getParent() : component;
        while (parent != null) {
            if (parent == this) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/model/RadComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/model/RadComponent";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "groupSiblings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSameType";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fromModel";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toModel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractClientProperty";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setClientProperty";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "groupSiblings";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAncestorFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

